<?php

/**
 * This PHP file is the webapp auth api calls to check it's KOPANO_WEBAPP cookie
 * and to retrieve tokens
 */

include("zarafa_session.php");
include("../config.php");
include_once('class.webmeetings_auth_simple.php');

if ($_POST && array_key_exists("meetingid", $_POST)) {

	$meetingid = '';
	if ($_POST && array_key_exists("meetingid", $_POST)) {
		$meetingid = $_POST['meetingid'];
	}
	$email = '';
	if ($_POST && array_key_exists("email", $_POST)) {
		$email = $_POST['email'];
	}
	$displayname = '';
	if ($_POST && array_key_exists("displayname", $_POST)) {
		$displayname = $_POST['displayname'];
	}
	$client_id = '';
	if ($_POST && array_key_exists("client_id", $_POST)) {
		$client_id = base64_encode($_POST['client_id']);
	}
	$client_secret = '';
	if ($_POST && array_key_exists("client_secret", $_POST)) {
		$client_secret = base64_encode($_POST['client_secret']);
	}
	
	if ($meetingid != sanitizeValue($meetingid, '', MEETINGID_REGEX)) {
		header('HTTP/1.1 403 Unauthorized');
		echo json_encode(array('success' => false, 'code' => 'failed', 'message' => _('Invalid meeting id. The meeting id contains invalid characters')));
		exit;
	}
	if (!trim($meetingid)) {
		header('HTTP/1.1 403 Unauthorized');
		echo json_encode(array('success' => false, 'code' => 'failed', 'message' => _('The meeting id is not set')));
		exit;
	}
	if ($email != sanitizeValue($email, '', ALLOWED_EMAIL_CHARS_REGEX)) {
		header('HTTP/1.1 403 Unauthorized');
		echo json_encode(array('success' => false, 'code' => 'failed', 'message' => _('Invalid e-mail address. The e-mail address contains invalid characters')));
		exit;
	}
	if (!trim($email)) {
		header('HTTP/1.1 403 Unauthorized');
		echo json_encode(array('success' => false, 'code' => 'failed', 'message' => _('The e-mail address is not set.')));
		exit;
	}
	if ($displayname != htmlspecialchars($displayname)) {
		header('HTTP/1.1 403 Unauthorized');
		echo json_encode(array('success' => false, 'code' => 'failed', 'message' => _('Invalid display name. The display name contains invalid characters')));
		exit;
	}
	if (!trim($displayname)) {
		header('HTTP/1.1 403 Unauthorized');
		echo json_encode(array('success' => false, 'code' => 'failed', 'message' => _('The display name is not set.')));
		exit;
	}
	// TODO: check id meeting valid
	$meetingid_valid = false;
	if (PLUGIN_SPREEDWEBRTC_MEETINGS_AUTH_METHOD == 'simple') {
		$webmeetingsAuthSimple = new WebmeetingsAuthSimple();

		$meetingid_valid = $webmeetingsAuthSimple->checkWebmeetingsAuthSimpleRoomPinValid($meetingid);
	}
	if ($meetingid_valid) {
		$meetingid_in_time_window = $webmeetingsAuthSimple->checkWebmeetingsAuthSimpleRoomPinInTimeWindow($meetingid);
		if ($meetingid_in_time_window) {
			$token_secret = PLUGIN_SPREEDWEBRTC_WEBAUTH_CODE_TOKEN_SECRET;
			$token_name = 'CODE_TOKEN';

			$value = $meetingid . ':' . $email . ':' . $displayname . ':' . $client_id . ':' . $client_secret;
			$time = time() + PLUGIN_SPREEDWEBRTC_WEBAUTH_CODE_TOKEN_EXPIRES;
			$time_value = $time . '|' . $value  . '|';
			$mac = base64_encode(hash_hmac('sha256', $token_name . '|' . $time_value, $token_secret, true));
			$data_mac = $time_value . $mac;
			$code_token = base64_encode($data_mac);

			$token_response = array(
				'success' => true,
				'code' => $code_token
			);

			header("Content-Type: application/json");
			header("Cache-Control: no-store");
			header("Pragma: no-cache");
			echo json_encode($token_response);
			exit;
		} else {
			if ($webmeetingsAuthSimple->checkWebmeetingsAuthSimpleRoomPinTooEarly($meetingid)) {
				header('HTTP/1.1 403 Unauthorized');
				echo json_encode(array('success' => false, 'code' => 'failed', 'message' => _('Too early, please check start time and return later.')));
				exit;
			} else {
				header('HTTP/1.1 403 Unauthorized');
				echo json_encode(array('success' => false, 'code' => 'failed', 'message' => _('Sorry, the meeting took place in the past')));
				exit;
			}
		}
	} else {
		header('HTTP/1.1 403 Unauthorized');
		echo json_encode(array('success' => false, 'code' => 'failed', 'message' => _('Invalid meeting id, please check your invitation URL')));
		exit;
	}
} else {
	header('HTTP/1.1 403 Unauthorized');
	echo json_encode(array('success' => false, 'code' => 'failed', 'message' => _('Missing meeting id, please check your invitation URL')));
	exit;
}

?>
