/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.core.query;

import com.mysql.clusterj.ClusterJDatastoreException;
import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.Query;
import com.mysql.clusterj.Results;
import com.mysql.clusterj.core.SessionImpl;
import com.mysql.clusterj.core.query.BetweenPredicateImpl;
import com.mysql.clusterj.core.query.QueryDomainTypeImpl;
import com.mysql.clusterj.core.query.QueryExecutionContextImpl;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import java.util.List;
import java.util.Map;

public class QueryImpl<E>
implements Query<E> {
    static final I18NHelper local = I18NHelper.getInstance(BetweenPredicateImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(BetweenPredicateImpl.class);
    protected SessionImpl session;
    protected QueryDomainTypeImpl<E> dobj;
    protected QueryExecutionContextImpl context = null;
    protected long skip = 0L;
    protected long limit = Long.MAX_VALUE;
    protected Query.Ordering ordering = null;
    protected String[] orderingFields = null;

    public QueryImpl(SessionImpl sessionImpl, QueryDomainTypeImpl<E> queryDomainTypeImpl) {
        this.session = sessionImpl;
        this.context = new QueryExecutionContextImpl(sessionImpl);
        this.dobj = queryDomainTypeImpl;
    }

    @Override
    public void setLimits(long l, long l2) {
        if (l < 0L || l2 < 0L) {
            throw new ClusterJUserException(local.message("ERR_Invalid_Limits", (Object)l, (Object)l2));
        }
        this.skip = l;
        if (Long.MAX_VALUE - l < l2) {
            l2 = Long.MAX_VALUE;
        } else {
            this.limit = l2 + l;
        }
    }

    @Override
    public void setOrdering(Query.Ordering ordering, String ... stringArray) {
        this.ordering = ordering;
        this.orderingFields = stringArray;
        StringBuilder stringBuilder = new StringBuilder();
        String string = "";
        for (String string2 : stringArray) {
            try {
                this.dobj.get(string2);
            }
            catch (ClusterJUserException clusterJUserException) {
                stringBuilder.append(string);
                stringBuilder.append(string2);
                string = ", ";
            }
        }
        String string3 = stringBuilder.toString();
        if (string3.length() > 0) {
            throw new ClusterJUserException(local.message("ERR_Ordering_Field_Does_Not_Exist", (Object)string3));
        }
    }

    @Override
    public Results<E> execute(Object object) {
        throw new UnsupportedOperationException(local.message("ERR_NotImplemented"));
    }

    @Override
    public Results<E> execute(Object ... objectArray) {
        throw new UnsupportedOperationException(local.message("ERR_NotImplemented"));
    }

    @Override
    public Results<E> execute(Map<String, ?> map) {
        throw new UnsupportedOperationException(local.message("ERR_NotImplemented"));
    }

    @Override
    public void setParameter(String string, Object object) {
        this.context.bindParameterValue(string, object);
    }

    @Override
    public List<E> getResultList() {
        try {
            List<E> list = this.dobj.getResultList(this.context, this.skip, this.limit, this.ordering, this.orderingFields);
            this.context = new QueryExecutionContextImpl(this.context);
            return list;
        }
        catch (ClusterJDatastoreException clusterJDatastoreException) {
            this.session.checkConnection(clusterJDatastoreException);
            throw clusterJDatastoreException;
        }
    }

    @Override
    public int deletePersistentAll() {
        try {
            if (this.skip != 0L || this.limit != Long.MAX_VALUE) {
                throw new ClusterJUserException(local.message("ERR_Invalid_Limits", (Object)this.skip, (Object)this.limit));
            }
            int n = this.dobj.deletePersistentAll(this.context);
            return n;
        }
        catch (ClusterJDatastoreException clusterJDatastoreException) {
            this.session.checkConnection(clusterJDatastoreException);
            throw clusterJDatastoreException;
        }
    }

    @Override
    public Map<String, Object> explain() {
        Map<String, Object> map = this.context.getExplain();
        if (map == null) {
            this.dobj.explain(this.context);
            return this.context.getExplain();
        }
        return map;
    }
}

