/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.junit.Ignore;
import testsuite.clusterj.AbstractClusterJTest;

@Ignore
public class CoordinatedTransactionIdVariableTest
extends AbstractClusterJTest {
    private String newId = "1:0:1:9000000000000099";
    private String badIdTooLong = "123456789012345678901234567890123456789012345";
    private String badIdTooShort = "1:1";
    private String sqlQuery = "select id from t_basic where id = 0";
    private String transactionIdVariableName = "@@ndb_transaction_id";
    private String joinTransactionIdVariableName = "@@ndb_join_transaction_id";

    @Override
    protected void localSetUp() {
        this.createSessionFactory();
        this.closeConnection();
        this.getConnection();
        this.setAutoCommit(connection, false);
    }

    @Override
    protected boolean getDebug() {
        return false;
    }

    public void checkTransactionIdInitialValue() {
        this.getConnection();
        String string = this.getJDBCTransactionId("checkTransactionIdInitialValue");
        this.errorIfNotEqual("Transaction id must default to null.", null, string);
    }

    public void checkJoinTransactionIdInitialValue() {
        this.getConnection();
        String string = this.getJDBCJoinTransactionId("checkJoinTransactionIdInitialValue");
        this.errorIfNotEqual("Join transaction id must default to null.", null, string);
    }

    public void checkSetTransactionId() {
        this.getConnection();
        this.setAutoCommit(connection, false);
        this.setJDBCVariable("checkSetTransactionId", this.transactionIdVariableName, this.newId, 1238);
        this.closeConnection();
    }

    public void checkNewIdResetWithNullString() {
        this.getConnection();
        this.setAutoCommit(connection, false);
        this.setJDBCVariable("checkNewIdResetWithNullString", this.joinTransactionIdVariableName, this.newId, 0);
        String string = this.getJDBCJoinTransactionId("checkNewIdResetWithNullString");
        this.errorIfNotEqual("failed to set coordinated transaction id.", this.newId, string);
        this.setJDBCVariable("checkNewIdResetWithNullString", this.joinTransactionIdVariableName, null, 0);
        string = this.getJDBCJoinTransactionId("checkNewIdResetWithNullString");
        this.errorIfNotEqual("failed to set coordinated transaction id to null.", null, string);
        this.closeConnection();
    }

    public void checkNewIdResetWithEmptyString() {
        this.getConnection();
        this.setAutoCommit(connection, false);
        this.setJDBCVariable("checkNewIdResetWithEmptyString", this.joinTransactionIdVariableName, this.newId, 0);
        String string = this.getJDBCJoinTransactionId("checkNewIdResetWithEmptyString");
        this.errorIfNotEqual("failed to set coordinated transaction id.", this.newId, string);
        this.setJDBCVariable("checkNewIdResetWithEmptyString", this.joinTransactionIdVariableName, "", 0);
        string = this.getJDBCJoinTransactionId("checkNewIdResetWithEmptyString");
        this.errorIfNotEqual("failed to set coordinated transaction id to null.", null, string);
        this.closeConnection();
    }

    public void checkBadIdTooLong() {
        this.getConnection();
        this.setAutoCommit(connection, false);
        this.setJDBCVariable("checkBadIdTooLong", this.joinTransactionIdVariableName, this.badIdTooLong, 1210);
        String string = this.getJDBCJoinTransactionId("checkBadIdTooLong");
        this.errorIfNotEqual("failed to set coordinated transaction id.", null, string);
        this.closeConnection();
    }

    public void checkBadIdTooShort() {
        this.getConnection();
        this.setAutoCommit(connection, false);
        this.setJDBCVariable("checkBadIdTooShort", this.joinTransactionIdVariableName, this.badIdTooShort, 1210);
        String string = this.getJDBCJoinTransactionId("checkBadIdTooShort");
        this.errorIfNotEqual("failed to set coordinated transaction id.", null, string);
        this.closeConnection();
    }

    public void checkIdAfterTransactionStartAndCommit() {
        this.getConnection();
        this.setAutoCommit(connection, false);
        this.executeJDBCQuery("checkIdAfterTransactionStartAndCommit");
        String string = this.getJDBCTransactionId("checkIdAfterTransactionStartAndCommit");
        this.errorIfEqual("Transaction id must not be null after transaction start.", null, string);
        this.commitConnection();
        string = this.getJDBCTransactionId("checkIdAfterTransactionStartAndCommit");
        this.errorIfNotEqual("Transaction id must be null after commit.", null, string);
    }

    public void checkIdAfterTransactionStartAndRollback() {
        this.getConnection();
        this.setAutoCommit(connection, false);
        this.executeJDBCQuery("checkIdAfterTransactionStartAndRollback");
        String string = this.getJDBCTransactionId("checkIdAfterTransactionStartAndRollback");
        this.errorIfEqual("Transaction must not be null after transaction start.", null, string);
        this.rollbackConnection();
        string = this.getJDBCTransactionId("checkIdAfterTransactionStartAndRollback");
        this.errorIfNotEqual("Transaction id must be null after rollback.", null, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeJDBCQuery(String string) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(this.sqlQuery);
            resultSet = preparedStatement.executeQuery();
            boolean bl = resultSet.next();
            if (this.getDebug()) {
                System.out.println(string + " executeJDBCQuery rs.next() returned " + bl);
            }
        }
        catch (SQLException sQLException) {
            this.error(string + " query threw exception ", sQLException);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    this.error(string + " rs.close threw exception " + sQLException.getMessage());
                }
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {
                    this.error(string + " statement.close threw exception ", sQLException);
                }
            }
        }
    }

    protected void setJDBCVariable(String string, String string2, String string3, int n) {
        try {
            String string4 = "set " + string2 + " = ?";
            PreparedStatement preparedStatement = connection.prepareStatement(string4);
            if (string3 == null) {
                preparedStatement.setNull(1, 12);
            } else {
                preparedStatement.setString(1, string3);
            }
            boolean bl = preparedStatement.execute();
            this.errorIfNotEqual(string + " set join transaction id returned true.", false, bl);
            this.errorIfNotEqual(string + " set join transaction id failed to throw expected exception " + n + " for " + string3, n, 0);
        }
        catch (SQLException sQLException) {
            int n2 = sQLException.getErrorCode();
            this.errorIfNotEqual(string + " caught wrong exception on set coordinated transaction id: errorCode: " + n2 + " SQLState: " + sQLException.getSQLState(), n, n2);
        }
    }

    protected String getJDBCJoinTransactionId(String string) {
        String string2 = "select " + this.joinTransactionIdVariableName;
        String string3 = this.executeSelect(string, string2);
        return string3;
    }

    protected String getJDBCTransactionId(String string) {
        String string2 = "select " + this.transactionIdVariableName;
        String string3 = this.executeSelect(string, string2);
        return string3;
    }

    private String executeSelect(String string, String string2) {
        String string3 = null;
        try {
            PreparedStatement preparedStatement = connection.prepareStatement(string2);
            ResultSet resultSet = preparedStatement.executeQuery();
            boolean bl = resultSet.next();
            this.errorIfNotEqual(string + " select " + string2 + " returned false.", true, bl);
            string3 = resultSet.getString(1);
            if (this.getDebug()) {
                System.out.println(string + " " + string2 + " returns " + string3);
            }
        }
        catch (SQLException sQLException) {
            this.error(string + " caught exception on select " + string2 + ".", sQLException);
        }
        return string3;
    }

    protected void commitConnection() {
        try {
            connection.commit();
        }
        catch (SQLException sQLException) {
            this.error("connection.commit threw exception: ", sQLException);
        }
    }

    protected void rollbackConnection() {
        try {
            connection.rollback();
        }
        catch (SQLException sQLException) {
            this.error("connection.rollback threw exception: ", sQLException);
        }
    }
}

