/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import com.mysql.clusterj.ClusterJHelper;
import com.mysql.clusterj.SessionFactory;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import testsuite.clusterj.AbstractClusterJTest;

public class RecvThreadCPUTest
extends AbstractClusterJTest {
    Properties testProperties = new Properties();
    static BindCpuSupport bindCPUsupport = BindCpuSupport.UNDEFINED;

    @Override
    protected void localSetUp() {
        RecvThreadCPUTest.closeAllExistingSessionFactories();
        if (bindCPUsupport != BindCpuSupport.UNDEFINED) {
            return;
        }
        try {
            this.createSessionFactory();
            this.sessionFactory.setRecvThreadCPUids(new short[]{0});
            bindCPUsupport = BindCpuSupport.SUPPORTED;
        }
        catch (Exception exception) {
            if (exception.getMessage().matches("Binding the receiver thread to CPU is not supported in this environment.")) {
                bindCPUsupport = BindCpuSupport.NOT_SUPPORTED;
            }
            throw exception;
        }
        this.destroySessionFactory();
    }

    public void testRecvThreadCpuLockingApis() {
        if (bindCPUsupport == BindCpuSupport.NOT_SUPPORTED) {
            return;
        }
        this.testProperties.put("com.mysql.clusterj.database", "testDb1");
        this.createSessionFactoryAndVerify();
        this.errorIfNotEqual("Failure in getting the default cpu id", new short[]{-1}, this.sessionFactory.getRecvThreadCPUids());
        this.setRecvThreadCPUidsAndVerify(new short[]{0});
        this.setRecvThreadCPUidsAndVerify(new short[]{-1});
        this.setRecvThreadCPUidsAndFail(new short[]{-10}, "The cpuid .* is not valid.*");
        this.setRecvThreadCPUidsAndFail(new short[]{0, 1}, ".*The number of cpu ids must match the connection pool size.");
        this.errorIfNotEqual("Failure in getting default recv thread activation threshold", 8, this.sessionFactory.getRecvThreadActivationThreshold());
        this.setRecvThreadActivationThresholdAndVerify(0);
        this.setRecvThreadActivationThresholdAndVerify(3);
        this.setRecvThreadActivationThresholdAndVerify(8);
        this.setRecvThreadActivationThresholdAndVerify(15);
        this.setRecvThreadActivationThresholdAndVerify(16);
        this.setRecvThreadActivationThresholdAndFail(-1);
        this.destroySessionFactory();
        this.failOnError();
    }

    public void testRecvThreadCpuProperties() {
        if (bindCPUsupport == BindCpuSupport.NOT_SUPPORTED) {
            return;
        }
        this.testProperties.put("com.mysql.clusterj.database", "testDb2");
        this.testProperties.put("com.mysql.clusterj.connection.pool.recv.thread.cpuids", "0");
        this.testProperties.put("com.mysql.clusterj.connection.pool.recv.thread.activation.threshold", (Object)4);
        this.createSessionFactoryAndVerify();
        if (this.sessionFactory != null) {
            this.errorIfNotEqual("Sessionfactory created with wrong properties.", new short[]{0}, this.sessionFactory.getRecvThreadCPUids());
            this.errorIfNotEqual("Sessionfactory created with wrong properties.", 4, this.sessionFactory.getRecvThreadActivationThreshold());
            this.setRecvThreadActivationThresholdAndVerify(3);
            this.setRecvThreadCPUidsAndVerify(new short[]{-1});
        }
        this.destroySessionFactory();
        this.testProperties.put("com.mysql.clusterj.database", "testDb3");
        this.testProperties.put("com.mysql.clusterj.connection.pool.size", (Object)2);
        this.createSessionFactoryAndVerify();
        if (this.sessionFactory != null) {
            this.setRecvThreadCPUidsAndVerify(new short[]{0, -1});
            this.setRecvThreadCPUidsAndFail(new short[]{-1, 999}, "The cpuid .* is not valid.*");
            this.errorIfNotEqual("setRecvThreadCPUids failed to restore CPUids setting on error.", new short[]{0, -1}, this.sessionFactory.getRecvThreadCPUids());
        }
        this.destroySessionFactory();
        this.testProperties.put("com.mysql.clusterj.connection.pool.size", (Object)0);
        this.testProperties.put("com.mysql.clusterj.connection.pool.recv.thread.cpuids", "0");
        this.testProperties.put("com.mysql.clusterj.connection.pool.recv.thread.activation.threshold", (Object)4);
        this.createSessionFactoryAndVerify();
        if (this.sessionFactory != null) {
            this.errorIfNotEqual("Sessionfactory created with wrong properties.", new short[]{0}, this.sessionFactory.getRecvThreadCPUids());
            this.errorIfNotEqual("Sessionfactory created with wrong properties.", 4, this.sessionFactory.getRecvThreadActivationThreshold());
            this.setRecvThreadActivationThresholdAndVerify(3);
            this.setRecvThreadCPUidsAndVerify(new short[]{-1});
        }
        this.destroySessionFactory();
        this.testProperties.put("com.mysql.clusterj.database", "testDb4");
        this.testProperties.put("com.mysql.clusterj.connection.pool.recv.thread.cpuids", "999");
        this.createSessionFactoryAndFail(".*The cpuid .* is not valid.*");
        this.testProperties.put("com.mysql.clusterj.connection.pool.recv.thread.cpuids", "0,0");
        this.createSessionFactoryAndFail(".*The number of cpu ids must match the connection pool size.");
        this.testProperties.put("com.mysql.clusterj.connection.pool.recv.thread.cpuids", "cpu1");
        this.createSessionFactoryAndFail("The cpuids property .* is invalid.*");
        this.destroySessionFactory();
        this.testProperties.put("com.mysql.clusterj.database", "testDb5");
        this.testProperties.put("com.mysql.clusterj.connection.pool.recv.thread.activation.threshold", (Object)-1);
        this.createSessionFactoryAndFail(".*The activation threshold .* is not valid.*");
        this.testProperties.put("com.mysql.clusterj.connection.pool.recv.thread.activation.threshold", "8,8");
        this.createSessionFactoryAndFail("Property .* must be numeric.");
        this.destroySessionFactory();
        this.testProperties.put("com.mysql.clusterj.connection.pool.size", (Object)0);
        this.testProperties.put("com.mysql.clusterj.connection.pool.recv.thread.cpuids", "cpu1");
        this.createSessionFactoryAndFail("The cpuids property .* is invalid.*");
        this.testProperties.put("com.mysql.clusterj.connection.pool.recv.thread.cpuids", "0,0");
        this.createSessionFactoryAndFail("The cpuids property specifies multiple cpu ids .*");
        this.destroySessionFactory();
        this.failOnError();
    }

    private void createSessionFactoryAndVerify() {
        String string = "Error creating session factory with props : " + this.testProperties.toString();
        try {
            this.createSessionFactory();
        }
        catch (Exception exception) {
            this.error(string);
            this.error("Caused by:\n" + exception.getMessage());
        }
        this.errorIfEqual(string, this.sessionFactory, null);
        if (this.sessionFactory != null) {
            this.errorIfNotEqual(string, this.sessionFactory.currentState(), SessionFactory.State.Open);
        }
    }

    @Override
    protected void createSessionFactory() {
        if (this.sessionFactory != null) {
            throw new RuntimeException("Sessionfactory from previous run not cleaned up");
        }
        Properties properties = new Properties();
        this.loadProperties();
        properties.putAll((Map<?, ?>)props);
        properties.putAll((Map<?, ?>)this.testProperties);
        if (this.debug) {
            System.out.println("createSessionFactory props: " + properties);
        }
        this.sessionFactory = ClusterJHelper.getSessionFactory((Map)properties);
    }

    private void destroySessionFactory() {
        if (this.sessionFactory != null) {
            this.sessionFactory.close();
            this.sessionFactory = null;
        }
        this.testProperties.clear();
    }

    private void createSessionFactoryAndFail(String string) {
        Exception exception = null;
        try {
            this.createSessionFactory();
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        this.verifyException("Creating session factory with invalid properties - " + this.testProperties.toString(), exception, string);
    }

    private void setRecvThreadCPUidsAndVerify(short[] sArray) {
        try {
            this.sessionFactory.setRecvThreadCPUids(sArray);
            this.errorIfNotEqual("Failure in binding the recv thread to the cpu ids.", sArray, this.sessionFactory.getRecvThreadCPUids());
        }
        catch (Exception exception) {
            this.error("Failure in binding the recv thread to the cpu ids : " + Arrays.toString(sArray));
            this.error("Caused by:\n" + exception.getMessage());
        }
    }

    private void setRecvThreadCPUidsAndFail(short[] sArray, String string) {
        Exception exception = null;
        try {
            this.sessionFactory.setRecvThreadCPUids(sArray);
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        this.verifyException("Setting invalid cpuids - '" + Arrays.toString(sArray) + "'", exception, string);
    }

    private void setRecvThreadActivationThresholdAndVerify(int n) {
        int n2 = n < 16 ? n : 256;
        try {
            this.sessionFactory.setRecvThreadActivationThreshold(n);
            this.errorIfNotEqual("Error in setting/getting recv thread activation threshold", n2, this.sessionFactory.getRecvThreadActivationThreshold());
        }
        catch (Exception exception) {
            this.error(exception.getMessage());
        }
    }

    private void setRecvThreadActivationThresholdAndFail(int n) {
        Exception exception = null;
        try {
            this.sessionFactory.setRecvThreadActivationThreshold(n);
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        this.verifyException("Setting invalid activation threshold '" + n + "'", exception, "The activation threshold .* is not valid.*");
    }

    private void errorIfNotEqual(String string, short[] sArray, short[] sArray2) {
        if (sArray.length == 0 && sArray2.length == 0) {
            return;
        }
        if (sArray.length != 0 && Arrays.equals(sArray, sArray2)) {
            return;
        }
        this.error(string);
        this.error("Expected: " + Arrays.toString(sArray) + " actual: " + Arrays.toString(sArray2));
    }

    static enum BindCpuSupport {
        UNDEFINED,
        SUPPORTED,
        NOT_SUPPORTED;

    }
}

