/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.ColumnMetadata;
import com.mysql.clusterj.core.CacheManager;
import com.mysql.clusterj.core.metadata.DomainTypeHandlerImpl;
import com.mysql.clusterj.core.metadata.InvocationHandlerImpl;
import com.mysql.clusterj.core.spi.DomainFieldHandler;
import com.mysql.clusterj.core.spi.DomainTypeHandler;
import com.mysql.clusterj.core.spi.SmartValueHandler;
import com.mysql.clusterj.core.spi.ValueHandler;
import com.mysql.clusterj.core.store.ClusterTransaction;
import com.mysql.clusterj.core.store.Db;
import com.mysql.clusterj.core.store.Operation;
import com.mysql.clusterj.core.store.ResultData;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.tie.ClusterTransactionImpl;
import com.mysql.clusterj.tie.DbImpl;
import com.mysql.clusterj.tie.NdbRecordBlobImpl;
import com.mysql.clusterj.tie.NdbRecordOperationImpl;
import com.mysql.clusterj.tie.NdbRecordResultDataImpl;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public class NdbRecordSmartValueHandlerImpl
implements SmartValueHandler {
    static final I18NHelper local = I18NHelper.getInstance(InvocationHandlerImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(InvocationHandlerImpl.class);
    protected NdbRecordOperationImpl operation;
    protected DomainTypeHandlerImpl<?> domainTypeHandler;
    protected DomainFieldHandler[] domainFieldHandlers;
    private int[] fieldNumberToColumnNumberMap;
    private Boolean found = null;
    private int numberOfTransientFields;
    private Object[] transientValues = null;
    private boolean[] transientModified;
    private Object proxy;

    protected void finalize() throws Throwable {
        if (logger.isDetailEnabled()) {
            logger.detail("NdbRecordSmartValueHandler.finalize");
        }
        try {
            this.release();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void release() {
        if (logger.isDetailEnabled()) {
            logger.detail("NdbRecordSmartValueHandler.release");
        }
        if (this.wasReleased()) {
            return;
        }
        this.operation.release();
        this.operation = null;
        this.domainTypeHandler = null;
        this.domainFieldHandlers = null;
        this.fieldNumberToColumnNumberMap = null;
        this.transientValues = null;
        this.proxy = null;
    }

    @Override
    public boolean wasReleased() {
        return this.operation == null;
    }

    void assertNotReleased() {
        if (this.wasReleased()) {
            throw new ClusterJUserException(local.message("ERR_Cannot_Access_Object_After_Release"));
        }
    }

    public NdbRecordSmartValueHandlerImpl(DomainTypeHandlerImpl<?> domainTypeHandlerImpl) {
        this.domainTypeHandler = domainTypeHandlerImpl;
        this.domainFieldHandlers = domainTypeHandlerImpl.getFieldHandlers();
        this.fieldNumberToColumnNumberMap = domainTypeHandlerImpl.getFieldNumberToColumnNumberMap();
        this.numberOfTransientFields = domainTypeHandlerImpl.getNumberOfTransientFields();
        this.transientModified = new boolean[this.numberOfTransientFields];
        if (this.numberOfTransientFields != 0) {
            this.transientValues = this.domainTypeHandler.newTransientValues();
        }
    }

    public NdbRecordSmartValueHandlerImpl(DomainTypeHandlerImpl<?> domainTypeHandlerImpl, Db db) {
        this(domainTypeHandlerImpl);
        this.operation = ((DbImpl)db).newNdbRecordOperationImpl(domainTypeHandlerImpl.getStoreTable());
    }

    public NdbRecordSmartValueHandlerImpl(DomainTypeHandlerImpl<?> domainTypeHandlerImpl, Db db, ResultData resultData) {
        this(domainTypeHandlerImpl);
        this.operation = ((NdbRecordResultDataImpl)resultData).transformOperation();
    }

    @Override
    public Operation insert(ClusterTransaction clusterTransaction) {
        if (logger.isDetailEnabled()) {
            logger.detail("smart insert for type: " + this.domainTypeHandler.getName() + "\n" + this.operation.dumpValues());
        }
        ClusterTransactionImpl clusterTransactionImpl = (ClusterTransactionImpl)clusterTransaction;
        this.operation.insert(clusterTransactionImpl);
        return this.operation;
    }

    @Override
    public Operation delete(ClusterTransaction clusterTransaction) {
        if (logger.isDetailEnabled()) {
            logger.detail("smart delete for type: " + this.domainTypeHandler.getName() + "\n" + this.operation.dumpValues());
        }
        this.operation.delete((ClusterTransactionImpl)clusterTransaction);
        return this.operation;
    }

    @Override
    public Operation update(ClusterTransaction clusterTransaction) {
        if (logger.isDetailEnabled()) {
            logger.detail("smart update for type: " + this.domainTypeHandler.getName() + " record: " + this.operation.dumpValues());
        }
        this.operation.update((ClusterTransactionImpl)clusterTransaction);
        return this.operation;
    }

    @Override
    public Operation write(ClusterTransaction clusterTransaction) {
        if (logger.isDetailEnabled()) {
            logger.detail("smart write for type: " + this.domainTypeHandler.getName() + " record: " + this.operation.dumpValues());
        }
        this.operation.write((ClusterTransactionImpl)clusterTransaction);
        return this.operation;
    }

    @Override
    public Operation load(ClusterTransaction clusterTransaction) {
        Object object;
        if (logger.isDetailEnabled()) {
            logger.detail("smart load for type: " + this.domainTypeHandler.getName() + " record: " + this.operation.dumpValues());
        }
        for (int i = 0; i < this.domainFieldHandlers.length; ++i) {
            object = this.domainFieldHandlers[i];
            int n = this.fieldNumberToColumnNumberMap[i];
            if (!object.isPersistent()) continue;
            if (object.isLob()) {
                this.operation.getBlobHandle(n);
                continue;
            }
            this.operation.columnSet(n);
        }
        this.operation.load((ClusterTransactionImpl)clusterTransaction);
        final NdbRecordSmartValueHandlerImpl ndbRecordSmartValueHandlerImpl = this;
        object = new Runnable(){

            @Override
            public void run() {
                if (NdbRecordSmartValueHandlerImpl.this.operation.getErrorCode() == 0) {
                    ndbRecordSmartValueHandlerImpl.found(Boolean.TRUE);
                    NdbRecordSmartValueHandlerImpl.this.operation.loadBlobValues();
                    NdbRecordSmartValueHandlerImpl.this.domainTypeHandler.objectResetModified(ndbRecordSmartValueHandlerImpl);
                } else {
                    ndbRecordSmartValueHandlerImpl.found(Boolean.FALSE);
                }
            }
        };
        clusterTransaction.postExecuteCallback((Runnable)object);
        return this.operation;
    }

    @Override
    public BigDecimal getBigDecimal(int n) {
        int n2 = this.fieldNumberToColumnNumberMap[n];
        if (n2 >= 0) {
            return this.operation.getDecimal(n2);
        }
        return (BigDecimal)this.transientValues[-1 - n2];
    }

    @Override
    public BigInteger getBigInteger(int n) {
        int n2 = this.fieldNumberToColumnNumberMap[n];
        if (n2 >= 0) {
            return this.operation.getBigInteger(n2);
        }
        return (BigInteger)this.transientValues[-1 - n2];
    }

    @Override
    public boolean getBoolean(int n) {
        int n2 = this.fieldNumberToColumnNumberMap[n];
        if (n2 >= 0) {
            return this.operation.getBoolean(n2);
        }
        Boolean bl = (Boolean)this.transientValues[-1 - n2];
        return bl == null ? false : bl;
    }

    @Override
    public boolean[] getBooleans(int n) {
        throw new ClusterJFatalInternalException(local.message("ERR_Method_Not_Implemented", (Object)"NdbRecordSmartValueHandler.getBooleans(int)"));
    }

    @Override
    public byte getByte(int n) {
        int n2 = this.fieldNumberToColumnNumberMap[n];
        if (n2 >= 0) {
            return this.operation.getByte(n2);
        }
        Byte by = (Byte)this.transientValues[-1 - n2];
        return by == null ? (byte)0 : by;
    }

    @Override
    public byte[] getBytes(int n) {
        int n2 = this.fieldNumberToColumnNumberMap[n];
        if (n2 >= 0) {
            return this.operation.getBytes(n2);
        }
        return (byte[])this.transientValues[-1 - n2];
    }

    @Override
    public double getDouble(int n) {
        int n2 = this.fieldNumberToColumnNumberMap[n];
        if (n2 >= 0) {
            return this.operation.getDouble(n2);
        }
        Double d = (Double)this.transientValues[-1 - n2];
        return d == null ? 0.0 : d;
    }

    @Override
    public float getFloat(int n) {
        int n2 = this.fieldNumberToColumnNumberMap[n];
        if (n2 >= 0) {
            return this.operation.getFloat(n2);
        }
        Float f = (Float)this.transientValues[-1 - n2];
        return f == null ? 0.0f : f.floatValue();
    }

    @Override
    public int getInt(int n) {
        int n2 = this.fieldNumberToColumnNumberMap[n];
        if (n2 >= 0) {
            int n3 = this.operation.getInt(n2);
            return n3;
        }
        Integer n4 = (Integer)this.transientValues[-1 - n2];
        return n4 == null ? 0 : n4;
    }

    @Override
    public Date getJavaSqlDate(int n) {
        int n2 = this.fieldNumberToColumnNumberMap[n];
        if (n2 >= 0) {
            Long l = this.operation.getObjectLong(n2);
            return l == null ? null : new Date(l);
        }
        return (Date)this.transientValues[-1 - n2];
    }

    @Override
    public Time getJavaSqlTime(int n) {
        int n2 = this.fieldNumberToColumnNumberMap[n];
        if (n2 >= 0) {
            Long l = this.operation.getObjectLong(n2);
            return l == null ? null : new Time(l);
        }
        return (Time)this.transientValues[-1 - n2];
    }

    @Override
    public Timestamp getJavaSqlTimestamp(int n) {
        int n2 = this.fieldNumberToColumnNumberMap[n];
        if (n2 >= 0) {
            Long l = this.operation.getObjectLong(n2);
            return l == null ? null : new Timestamp(l);
        }
        return (Timestamp)this.transientValues[-1 - n2];
    }

    @Override
    public java.util.Date getJavaUtilDate(int n) {
        int n2 = this.fieldNumberToColumnNumberMap[n];
        if (n2 >= 0) {
            Long l = this.operation.getObjectLong(n2);
            return l == null ? null : new java.util.Date(l);
        }
        return (java.util.Date)this.transientValues[-1 - n2];
    }

    @Override
    public byte[] getLobBytes(int n) {
        int n2 = this.fieldNumberToColumnNumberMap[n];
        NdbRecordBlobImpl ndbRecordBlobImpl = this.operation.getBlobHandle(n2);
        return ndbRecordBlobImpl.getBytesData();
    }

    @Override
    public String getLobString(int n) {
        int n2 = this.fieldNumberToColumnNumberMap[n];
        NdbRecordBlobImpl ndbRecordBlobImpl = this.operation.getBlobHandle(n2);
        String string = ndbRecordBlobImpl.getStringData();
        return string;
    }

    @Override
    public long getLong(int n) {
        int n2 = this.fieldNumberToColumnNumberMap[n];
        if (n2 >= 0) {
            return this.operation.getLong(n2);
        }
        Long l = (Long)this.transientValues[-1 - n2];
        return l == null ? 0L : l;
    }

    @Override
    public Boolean getObjectBoolean(int n) {
        int n2 = this.fieldNumberToColumnNumberMap[n];
        if (n2 >= 0) {
            return this.operation.getObjectBoolean(n2);
        }
        return (Boolean)this.transientValues[-1 - n2];
    }

    @Override
    public Byte getObjectByte(int n) {
        int n2 = this.fieldNumberToColumnNumberMap[n];
        if (n2 >= 0) {
            return this.operation.getObjectByte(n2);
        }
        return (Byte)this.transientValues[-1 - n2];
    }

    @Override
    public Double getObjectDouble(int n) {
        int n2 = this.fieldNumberToColumnNumberMap[n];
        if (n2 >= 0) {
            return this.operation.getObjectDouble(n2);
        }
        return (Double)this.transientValues[-1 - n2];
    }

    @Override
    public Float getObjectFloat(int n) {
        int n2 = this.fieldNumberToColumnNumberMap[n];
        if (n2 >= 0) {
            return this.operation.getObjectFloat(n2);
        }
        return (Float)this.transientValues[-1 - n2];
    }

    @Override
    public Integer getObjectInt(int n) {
        int n2 = this.fieldNumberToColumnNumberMap[n];
        if (n2 >= 0) {
            return this.operation.getObjectInteger(n2);
        }
        return (Integer)this.transientValues[-1 - n2];
    }

    @Override
    public Long getObjectLong(int n) {
        int n2 = this.fieldNumberToColumnNumberMap[n];
        if (n2 >= 0) {
            return this.operation.getObjectLong(n2);
        }
        return (Long)this.transientValues[-1 - n2];
    }

    @Override
    public Short getObjectShort(int n) {
        int n2 = this.fieldNumberToColumnNumberMap[n];
        if (n2 >= 0) {
            return this.operation.getObjectShort(n2);
        }
        return (Short)this.transientValues[-1 - n2];
    }

    @Override
    public short getShort(int n) {
        int n2 = this.fieldNumberToColumnNumberMap[n];
        if (n2 >= 0) {
            return this.operation.getShort(n2);
        }
        Short s = (Short)this.transientValues[-1 - n2];
        return s == null ? (short)0 : s;
    }

    @Override
    public String getString(int n) {
        int n2 = this.fieldNumberToColumnNumberMap[n];
        if (n2 >= 0) {
            return this.operation.getString(n2);
        }
        return (String)this.transientValues[-1 - n2];
    }

    @Override
    public boolean isModified(int n) {
        int n2 = this.fieldNumberToColumnNumberMap[n];
        if (n2 >= 0) {
            return this.operation.isModified(n2);
        }
        return this.transientModified[-1 - n2];
    }

    @Override
    public boolean isNull(int n) {
        int n2 = this.fieldNumberToColumnNumberMap[n];
        if (n2 >= 0) {
            return this.operation.isNull(n2);
        }
        return this.transientValues[-1 - n2] == null;
    }

    @Override
    public void markModified(int n) {
        int n2 = this.fieldNumberToColumnNumberMap[n];
        if (n2 >= 0) {
            this.operation.markModified(n2);
            return;
        }
        this.transientModified[-1 - n2] = true;
    }

    @Override
    public String pkToString(DomainTypeHandler<?> domainTypeHandler) {
        return null;
    }

    @Override
    public void resetModified() {
        this.operation.resetModified();
        this.transientModified = new boolean[this.numberOfTransientFields];
    }

    @Override
    public void setBigDecimal(int n, BigDecimal bigDecimal) {
        int n2 = this.fieldNumberToColumnNumberMap[n];
        if (n2 >= 0) {
            this.operation.setDecimal(n2, bigDecimal);
        } else {
            this.transientValues[-1 - n2] = bigDecimal;
            this.transientModified[-1 - n2] = true;
        }
    }

    @Override
    public void setBigInteger(int n, BigInteger bigInteger) {
        int n2 = this.fieldNumberToColumnNumberMap[n];
        if (n2 >= 0) {
            this.operation.setBigInteger(n2, bigInteger);
        } else {
            this.transientValues[-1 - n2] = bigInteger;
            this.transientModified[-1 - n2] = true;
        }
    }

    @Override
    public void setBoolean(int n, boolean bl) {
        int n2 = this.fieldNumberToColumnNumberMap[n];
        if (n2 >= 0) {
            this.operation.setBoolean(n2, bl);
        } else {
            this.transientValues[-1 - n2] = bl;
            this.transientModified[-1 - n2] = true;
        }
    }

    @Override
    public void setBooleans(int n, boolean[] blArray) {
        throw new ClusterJFatalInternalException(local.message("ERR_Method_Not_Implemented", (Object)"NdbRecordSmartValueHandler.setBooleans(int, boolean[])"));
    }

    @Override
    public void setByte(int n, byte by) {
        int n2 = this.fieldNumberToColumnNumberMap[n];
        if (n2 >= 0) {
            this.operation.setByte(n2, by);
        } else {
            this.transientModified[-1 - n2] = true;
            this.transientValues[-1 - n2] = by;
        }
    }

    @Override
    public void setBytes(int n, byte[] byArray) {
        int n2 = this.fieldNumberToColumnNumberMap[n];
        if (n2 >= 0) {
            this.operation.setBytes(n2, byArray);
        } else {
            this.transientValues[-1 - n2] = byArray;
            this.transientModified[-1 - n2] = true;
        }
    }

    @Override
    public void setDouble(int n, double d) {
        int n2 = this.fieldNumberToColumnNumberMap[n];
        if (n2 >= 0) {
            this.operation.setDouble(n2, d);
        } else {
            this.transientValues[-1 - n2] = d;
            this.transientModified[-1 - n2] = true;
        }
    }

    @Override
    public void setFloat(int n, float f) {
        int n2 = this.fieldNumberToColumnNumberMap[n];
        if (n2 >= 0) {
            this.operation.setFloat(n2, f);
        } else {
            this.transientValues[-1 - n2] = Float.valueOf(f);
            this.transientModified[-1 - n2] = true;
        }
    }

    @Override
    public void setInt(int n, int n2) {
        int n3 = this.fieldNumberToColumnNumberMap[n];
        if (n3 >= 0) {
            this.operation.setInt(n3, n2);
        } else {
            this.transientValues[-1 - n3] = n2;
            this.transientModified[-1 - n3] = true;
        }
    }

    @Override
    public void setJavaSqlDate(int n, Date date) {
        int n2 = this.fieldNumberToColumnNumberMap[n];
        if (date == null) {
            this.operation.setNull(n2);
        } else {
            this.setLong(n, date.getTime());
        }
    }

    @Override
    public void setJavaSqlTime(int n, Time time) {
        int n2 = this.fieldNumberToColumnNumberMap[n];
        if (time == null) {
            this.operation.setNull(n2);
        } else {
            this.setLong(n, time.getTime());
        }
    }

    @Override
    public void setJavaSqlTimestamp(int n, Timestamp timestamp) {
        int n2 = this.fieldNumberToColumnNumberMap[n];
        if (timestamp == null) {
            this.operation.setNull(n2);
        } else {
            this.setLong(n, timestamp.getTime());
        }
    }

    @Override
    public void setJavaUtilDate(int n, java.util.Date date) {
        int n2 = this.fieldNumberToColumnNumberMap[n];
        if (date == null) {
            this.operation.setNull(n2);
        } else {
            this.setLong(n, date.getTime());
        }
    }

    @Override
    public void setLobBytes(int n, byte[] byArray) {
        int n2 = this.fieldNumberToColumnNumberMap[n];
        NdbRecordBlobImpl ndbRecordBlobImpl = this.operation.getBlobHandle(n2);
        this.operation.columnSet(n2);
        ndbRecordBlobImpl.setData(byArray);
    }

    @Override
    public void setLobString(int n, String string) {
        int n2 = this.fieldNumberToColumnNumberMap[n];
        NdbRecordBlobImpl ndbRecordBlobImpl = this.operation.getBlobHandle(n2);
        this.operation.columnSet(n2);
        ndbRecordBlobImpl.setData(string);
    }

    @Override
    public void setLong(int n, long l) {
        int n2 = this.fieldNumberToColumnNumberMap[n];
        if (n2 >= 0) {
            this.operation.setLong(n2, l);
        } else {
            this.transientValues[-1 - n2] = l;
            this.transientModified[-1 - n2] = true;
        }
    }

    @Override
    public void setObject(int n, Object object) {
        int n2 = this.fieldNumberToColumnNumberMap[n];
        if (n2 >= 0) {
            throw new ClusterJFatalInternalException(local.message("ERR_Method_Not_Implemented", (Object)"NdbRecordSmartValueHandler.setObject(int, Object) for persistent values"));
        }
        this.transientValues[-1 - n2] = object;
        this.transientModified[-1 - n2] = true;
    }

    @Override
    public void setObjectBoolean(int n, Boolean bl) {
        int n2 = this.fieldNumberToColumnNumberMap[n];
        if (n2 >= 0) {
            this.operation.setObjectBoolean(n2, bl);
        } else {
            this.transientValues[-1 - n2] = bl;
            this.transientModified[-1 - n2] = true;
        }
    }

    @Override
    public void setObjectByte(int n, Byte by) {
        int n2 = this.fieldNumberToColumnNumberMap[n];
        if (n2 >= 0) {
            this.operation.setObjectByte(n2, by);
        } else {
            this.transientValues[-1 - n2] = by;
            this.transientModified[-1 - n2] = true;
        }
    }

    @Override
    public void setObjectDouble(int n, Double d) {
        int n2 = this.fieldNumberToColumnNumberMap[n];
        if (n2 >= 0) {
            this.operation.setObjectDouble(n2, d);
        } else {
            this.transientValues[-1 - n2] = d;
            this.transientModified[-1 - n2] = true;
        }
    }

    @Override
    public void setObjectFloat(int n, Float f) {
        int n2 = this.fieldNumberToColumnNumberMap[n];
        if (n2 >= 0) {
            this.operation.setObjectFloat(n2, f);
        } else {
            this.transientValues[-1 - n2] = f;
            this.transientModified[-1 - n2] = true;
        }
    }

    @Override
    public void setObjectInt(int n, Integer n2) {
        int n3 = this.fieldNumberToColumnNumberMap[n];
        if (n3 >= 0) {
            this.operation.setObjectInt(n3, n2);
        } else {
            this.transientValues[-1 - n3] = n2;
            this.transientModified[-1 - n3] = true;
        }
    }

    @Override
    public void setObjectLong(int n, Long l) {
        int n2 = this.fieldNumberToColumnNumberMap[n];
        if (n2 >= 0) {
            this.operation.setObjectLong(n2, l);
        } else {
            this.transientValues[-1 - n2] = l;
            this.transientModified[-1 - n2] = true;
        }
    }

    @Override
    public void setObjectShort(int n, Short s) {
        int n2 = this.fieldNumberToColumnNumberMap[n];
        if (n2 >= 0) {
            this.operation.setObjectShort(n2, s);
        } else {
            this.transientValues[-1 - n2] = s;
            this.transientModified[-1 - n2] = true;
        }
    }

    @Override
    public void setShort(int n, short s) {
        int n2 = this.fieldNumberToColumnNumberMap[n];
        if (n2 >= 0) {
            this.operation.setObjectShort(n2, s);
        } else {
            this.transientValues[-1 - n2] = s;
            this.transientModified[-1 - n2] = true;
        }
    }

    @Override
    public void setString(int n, String string) {
        int n2 = this.fieldNumberToColumnNumberMap[n];
        if (n2 >= 0) {
            this.operation.setString(n2, string);
        } else {
            this.transientValues[-1 - n2] = string;
            this.transientModified[-1 - n2] = true;
        }
    }

    @Override
    public ColumnMetadata[] columnMetadata() {
        return this.domainTypeHandler.columnMetadata();
    }

    @Override
    public Boolean found() {
        return this.found;
    }

    @Override
    public void found(Boolean bl) {
        this.found = bl;
    }

    @Override
    public Object get(int n) {
        this.assertNotReleased();
        int n2 = this.fieldNumberToColumnNumberMap[n];
        if (n2 < 0) {
            return this.transientValues[-1 - n2];
        }
        return this.domainFieldHandlers[n].objectGetValue(this);
    }

    @Override
    public void set(int n, Object object) {
        this.assertNotReleased();
        int n2 = this.fieldNumberToColumnNumberMap[n];
        if (n2 < 0) {
            this.transientValues[-1 - n2] = object;
            this.transientModified[-1 - n2] = true;
        } else {
            this.domainFieldHandlers[n].objectSetValue(object, (ValueHandler)this);
        }
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        String string = method.getName();
        if (logger.isDetailEnabled()) {
            logger.detail("invoke with Method: " + method.getName());
        }
        String string2 = string.substring(3, 4);
        String string3 = string.substring(4);
        String string4 = string2.toLowerCase() + string3;
        this.assertNotReleased();
        if (string.startsWith("get")) {
            int n = this.domainTypeHandler.getFieldNumber(string4);
            Object object2 = this.get(n);
            if (logger.isDetailEnabled()) {
                logger.detail(string + ": Returning field number " + n + " value: " + object2);
            }
            return object2;
        }
        if (string.startsWith("set")) {
            if (logger.isDetailEnabled()) {
                logger.detail("Property name: " + string4 + " value: " + objectArray[0]);
            }
        } else {
            if ("toString".equals(string)) {
                return this.domainTypeHandler.getDomainClass().getName() + this.pkToString(this.domainTypeHandler);
            }
            if ("hashCode".equals(string)) {
                return this.hashCode();
            }
            throw new ClusterJUserException(local.message("ERR_Method_Name", (Object)string));
        }
        int n = this.domainTypeHandler.getFieldNumber(string4);
        this.set(n, objectArray[0]);
        return null;
    }

    @Override
    public void setCacheManager(CacheManager cacheManager) {
    }

    @Override
    public void setProxy(Object object) {
        this.proxy = object;
    }

    @Override
    public Object getProxy() {
        return this.proxy;
    }
}

