/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.ClusterJFatalUserException;
import com.mysql.clusterj.core.store.ClusterConnection;
import com.mysql.clusterj.core.store.ClusterConnectionService;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.tie.ClusterConnectionImpl;
import com.mysql.clusterj.tie.Utility;
import com.mysql.ndbjtie.ndbapi.Ndb;
import com.mysql.ndbjtie.ndbapi.NdbDictionary;
import com.mysql.ndbjtie.ndbapi.NdbOperation;
import com.mysql.ndbjtie.ndbapi.NdbScanOperation;

public class ClusterConnectionServiceImpl
implements ClusterConnectionService {
    static final I18NHelper local = I18NHelper.getInstance(ClusterConnectionServiceImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(ClusterConnectionServiceImpl.class);
    static boolean ndbclientLoaded;
    static int SIZEOF_OPERATION_OPTIONS;
    static int SIZEOF_PARTITION_SPEC;
    static int SIZEOF_RECORD_SPECIFICATION;
    static int SIZEOF_SCAN_OPTIONS;

    protected static void loadSystemLibrary(String string) {
        if (ndbclientLoaded) {
            return;
        }
        try {
            System.loadLibrary(string);
            Utility.getCharsetMap();
            SIZEOF_OPERATION_OPTIONS = NdbOperation.OperationOptions.size();
            SIZEOF_PARTITION_SPEC = Ndb.PartitionSpec.size();
            SIZEOF_RECORD_SPECIFICATION = NdbDictionary.RecordSpecification.size();
            SIZEOF_SCAN_OPTIONS = NdbScanOperation.ScanOptions.size();
            ndbclientLoaded = true;
        }
        catch (Throwable throwable) {
            String string2 = ClusterConnectionServiceImpl.getLoadLibraryPath();
            String string3 = local.message("ERR_Failed_Loading_Library", string, string2, throwable.getClass(), throwable.getLocalizedMessage());
            logger.fatal(string3);
            throw new ClusterJFatalUserException(string3, throwable);
        }
    }

    @Override
    public ClusterConnection create(String string, int n) {
        ClusterConnectionServiceImpl.loadSystemLibrary("ndbclient");
        try {
            return new ClusterConnectionImpl(string, n);
        }
        catch (ClusterJFatalUserException clusterJFatalUserException) {
            throw clusterJFatalUserException;
        }
        catch (Exception exception) {
            String string2 = local.message("ERR_Connect", (Object)string, (Object)n);
            logger.fatal(string2);
            throw new ClusterJFatalUserException(string2, exception);
        }
    }

    private static String getLoadLibraryPath() {
        String string;
        try {
            string = System.getProperty("java.library.path");
        }
        catch (Exception exception) {
            string = "<Exception: " + exception.getMessage() + ">";
        }
        return string;
    }

    static {
        LoggerFactoryService.getFactory().registerLogger("com.mysql.clusterj.tie");
        ndbclientLoaded = false;
    }
}

