/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import com.mysql.clusterj.ClusterJFatalUserException;
import com.mysql.clusterj.ClusterJHelper;
import com.mysql.clusterj.Session;
import com.mysql.clusterj.SessionFactory;
import com.mysql.clusterj.core.SessionFactoryImpl;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.junit.Ignore;
import testsuite.clusterj.AbstractClusterJTest;
import testsuite.clusterj.model.Employee;

@Ignore(value="test requires specific connection pooling setup")
public class ConnectionPoolTest
extends AbstractClusterJTest {
    @Override
    public boolean getDebug() {
        return false;
    }

    protected boolean runSpecificNodeIdTests() {
        return false;
    }

    @Override
    public void localSetUp() {
        this.loadProperties();
        if (this.sessionFactory != null) {
            this.sessionFactory.close();
            this.sessionFactory = null;
        }
    }

    public void testNoPooling() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)props);
        SessionFactory sessionFactory = null;
        SessionFactory sessionFactory2 = null;
        properties.put("com.mysql.clusterj.connection.pool.size", (Object)1);
        sessionFactory = ClusterJHelper.getSessionFactory((Map)properties);
        sessionFactory2 = ClusterJHelper.getSessionFactory((Map)properties);
        sessionFactory.close();
        sessionFactory2.close();
        this.errorIfNotEqual("With connection pooling, SessionFactory1 should be the same object as SessionFactory2", true, sessionFactory == sessionFactory2);
        properties.put("com.mysql.clusterj.connection.pool.size", (Object)0);
        sessionFactory = ClusterJHelper.getSessionFactory((Map)properties);
        sessionFactory2 = ClusterJHelper.getSessionFactory((Map)properties);
        try {
            SessionFactory sessionFactory3 = ClusterJHelper.getSessionFactory((Map)properties);
            sessionFactory3.close();
        }
        catch (ClusterJFatalUserException clusterJFatalUserException) {
            // empty catch block
        }
        sessionFactory.close();
        sessionFactory2.close();
        this.errorIfNotEqual("With no connection pooling, SessionFactory1 should not be the same object as SessionFactory2", false, sessionFactory == sessionFactory2);
        this.failOnError();
    }

    public void testConnectionPoolSize() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)props);
        properties.put("com.mysql.clusterj.connection.pool.size", (Object)2);
        this.checkConnectionPoolSize2("testConnectionPoolSize", properties);
        this.failOnError();
    }

    public void testConnectionPoolSizeAndNodeIds() {
        if (!this.runSpecificNodeIdTests()) {
            return;
        }
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)props);
        properties.put("com.mysql.clusterj.connection.pool.size", (Object)2);
        properties.put("com.mysql.clusterj.connection.pool.nodeids", "4;5");
        this.checkConnectionPoolSize2("testConnectionPoolSizeAndNodeIds", properties);
        this.failOnError();
    }

    public void testConnectionNodeIds() {
        if (!this.runSpecificNodeIdTests()) {
            return;
        }
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)props);
        properties.put("com.mysql.clusterj.connection.pool.nodeids", "4,5");
        this.checkConnectionPoolSize2("testConnectionNodeIds", properties);
        this.failOnError();
    }

    public void testConnectionSingleNodeIdAndConnectionPoolSize() {
        if (!this.runSpecificNodeIdTests()) {
            return;
        }
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)props);
        properties.put("com.mysql.clusterj.connection.pool.size", (Object)2);
        properties.put("com.mysql.clusterj.connection.pool.nodeids", "4");
        this.checkConnectionPoolSize2("testConnectionNodeIds", properties);
        this.failOnError();
    }

    private void checkConnectionPoolSize2(String string, Properties properties) {
        SessionFactory sessionFactory = null;
        SessionFactory sessionFactory2 = null;
        SessionFactory sessionFactory3 = null;
        sessionFactory = ClusterJHelper.getSessionFactory((Map)properties);
        sessionFactory2 = ClusterJHelper.getSessionFactory((Map)properties);
        sessionFactory3 = ClusterJHelper.getSessionFactory((Map)properties);
        this.errorIfNotEqual(string + " SessionFactory1 should be the same object as SessionFactory2", true, sessionFactory == sessionFactory2);
        this.errorIfNotEqual(string + " SessionFactory1 should be the same object as SessionFactory3", true, sessionFactory == sessionFactory3);
        Session session = sessionFactory.getSession();
        Employee employee = (Employee)session.find(Employee.class, (Object)0);
        this.checkSessions(string + " after get session1", sessionFactory, new Integer[]{1, 0});
        Session session2 = sessionFactory.getSession();
        Employee employee2 = (Employee)session2.find(Employee.class, (Object)0);
        this.checkSessions(string + " after get session2", sessionFactory, new Integer[]{1, 1});
        Session session3 = sessionFactory.getSession();
        this.checkSessions(string + " nafter get session3", sessionFactory, new Integer[]{2, 1});
        Session session4 = sessionFactory.getSession();
        this.checkSessions(string + " after get session4", sessionFactory, new Integer[]{2, 2});
        Session session5 = sessionFactory.getSession();
        this.checkSessions(string + " after get session5", sessionFactory, new Integer[]{3, 2});
        Session session6 = sessionFactory.getSession();
        this.checkSessions(string + " after get session6", sessionFactory, new Integer[]{3, 3});
        session.close();
        this.checkSessions(string + " after close session1", sessionFactory, new Integer[]{2, 3});
        session4.close();
        this.checkSessions(string + " after close session4", sessionFactory, new Integer[]{2, 2});
        session5.close();
        this.checkSessions(string + " after close session5", sessionFactory, new Integer[]{1, 2});
        Session session7 = sessionFactory.getSession();
        this.checkSessions(string + " after get session7", sessionFactory, new Integer[]{2, 2});
        session2.close();
        session3.close();
        session6.close();
        session7.close();
        sessionFactory.close();
    }

    public void testNegativeMismatchConnectionPoolSizeAndConnectionPoolNodeids() {
        block3: {
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)props);
            properties.put("com.mysql.clusterj.connection.pool.size", (Object)3);
            properties.put("com.mysql.clusterj.connection.pool.nodeids", "4\t5");
            try {
                ClusterJHelper.getSessionFactory((Map)properties);
            }
            catch (ClusterJFatalUserException clusterJFatalUserException) {
                if (this.getDebug()) {
                    clusterJFatalUserException.printStackTrace();
                }
                String string = "4\t5";
                if (clusterJFatalUserException.getMessage().contains(string)) break block3;
                this.error("Mismatch error message should contain " + string);
            }
        }
        this.failOnError();
    }

    public void testNegativeConnectionPoolNodeidsFormatError() {
        block3: {
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)props);
            properties.put("com.mysql.clusterj.connection.pool.size", (Object)2);
            properties.put("com.mysql.clusterj.connection.pool.nodeids", "7 t");
            try {
                ClusterJHelper.getSessionFactory((Map)properties);
            }
            catch (ClusterJFatalUserException clusterJFatalUserException) {
                if (this.getDebug()) {
                    clusterJFatalUserException.printStackTrace();
                }
                String string = "NumberFormatException";
                if (clusterJFatalUserException.getMessage().contains(string)) break block3;
                this.error("Mismatch error message '" + clusterJFatalUserException.getMessage() + "' should contain '" + string + '\"');
            }
        }
        this.failOnError();
    }

    public void testNegativeConnectionPoolIllegalNodeids() {
        block3: {
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)props);
            properties.put("com.mysql.clusterj.connection.pool.nodeids", "256");
            try {
                ClusterJHelper.getSessionFactory((Map)properties);
            }
            catch (ClusterJFatalUserException clusterJFatalUserException) {
                if (this.getDebug()) {
                    clusterJFatalUserException.printStackTrace();
                }
                String string = "illegal";
                if (clusterJFatalUserException.getMessage().contains(string)) break block3;
                this.error("Mismatch error message '" + clusterJFatalUserException.getMessage() + "' should contain '" + string + '\"');
            }
        }
        this.failOnError();
    }

    public void testNegativeConnectionPoolNoNodeId() {
        block4: {
            if (!this.runSpecificNodeIdTests()) {
                return;
            }
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)props);
            properties.put("com.mysql.clusterj.connection.pool.nodeids", "48");
            try {
                ClusterJHelper.getSessionFactory((Map)properties);
            }
            catch (ClusterJFatalUserException clusterJFatalUserException) {
                if (this.getDebug()) {
                    clusterJFatalUserException.printStackTrace();
                }
                String string = "No node defined";
                if (clusterJFatalUserException.getMessage().contains(string)) break block4;
                this.error("Mismatch error message '" + clusterJFatalUserException.getMessage() + "' should contain '" + string + '\"');
            }
        }
        this.failOnError();
    }

    private void checkSessions(String string, SessionFactory sessionFactory, Integer[] integerArray) {
        SessionFactoryImpl sessionFactoryImpl = (SessionFactoryImpl)sessionFactory;
        List list = sessionFactoryImpl.getConnectionPoolSessionCounts();
        if (integerArray.length != list.size()) {
            this.error(string + " wrong number of connections in pool\n" + "Expected: " + Arrays.toString((Object[])integerArray) + " Actual: " + list);
            return;
        }
        int n = 0;
        for (Integer n2 : list) {
            if (this.getDebug()) {
                System.out.println("Connection " + n + " has " + n2 + " sessions.");
            }
            if (n >= integerArray.length) break;
            this.errorIfNotEqual(string + " wrong count on connection " + n, integerArray[n], n2);
            ++n;
        }
        if (this.getDebug()) {
            System.out.println();
        }
    }
}

