/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.core.store.Column;
import com.mysql.clusterj.core.store.PartitionKey;
import com.mysql.clusterj.core.store.Table;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.tie.ColumnImpl;
import com.mysql.clusterj.tie.PartitionKeyImpl;
import com.mysql.ndbjtie.ndbapi.NdbDictionary;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

class TableImpl
implements Table {
    static final I18NHelper local = I18NHelper.getInstance(TableImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(TableImpl.class);
    private String tableName;
    private String[] columnNames;
    private String[] primaryKeyColumnNames;
    private String[] partitionKeyColumnNames;
    private Map<String, ColumnImpl> columns = new HashMap<String, ColumnImpl>();
    private String[] indexNames;
    private int[] lengths;
    private int[] offsets;
    private int bufferSize;
    private int maximumColumnId;
    private int maximumColumnLength = 0;

    public TableImpl(NdbDictionary.TableConst ndbTable, String[] indexNames) {
        this.tableName = ndbTable.getName();
        ArrayList<String> partitionKeyColumnNameList = new ArrayList<String>();
        ArrayList<String> primaryKeyColumnNameList = new ArrayList<String>();
        int noOfColumns = ndbTable.getNoOfColumns();
        ColumnImpl[] columnImpls = new ColumnImpl[noOfColumns];
        this.columnNames = new String[noOfColumns];
        for (int i = 0; i < noOfColumns; ++i) {
            NdbDictionary.ColumnConst column = ndbTable.getColumn(i);
            if (column.getPartitionKey()) {
                partitionKeyColumnNameList.add(column.getName());
            }
            if (column.getPrimaryKey()) {
                primaryKeyColumnNameList.add(column.getName());
            }
            NdbDictionary.ColumnConst ndbColumn = ndbTable.getColumn(i);
            String columnName = ndbColumn.getName();
            ColumnImpl columnImpl = new ColumnImpl(this.tableName, ndbColumn);
            this.columns.put(columnName, columnImpl);
            columnImpls[i] = columnImpl;
            this.columnNames[i] = columnName;
            int columnId = ndbColumn.getColumnNo();
            if (columnId <= this.maximumColumnId) continue;
            this.maximumColumnId = columnId;
        }
        this.offsets = new int[this.maximumColumnId + 1];
        this.lengths = new int[this.maximumColumnId + 1];
        int offset = 0;
        for (int i = 0; i < noOfColumns; ++i) {
            int columnSpace;
            ColumnImpl columnImpl = columnImpls[i];
            int columnId = columnImpl.getColumnId();
            this.lengths[columnId] = columnSpace = columnImpl.getColumnSpace();
            this.offsets[columnId] = offset;
            offset += columnSpace;
            if (columnSpace <= this.maximumColumnLength) continue;
            this.maximumColumnLength = columnSpace;
        }
        this.bufferSize = offset;
        this.primaryKeyColumnNames = primaryKeyColumnNameList.toArray(new String[primaryKeyColumnNameList.size()]);
        this.partitionKeyColumnNames = partitionKeyColumnNameList.toArray(new String[partitionKeyColumnNameList.size()]);
        this.indexNames = indexNames;
    }

    @Override
    public Column getColumn(String columnName) {
        return this.columns.get(columnName);
    }

    @Override
    public String getName() {
        return this.tableName;
    }

    @Override
    public String[] getPrimaryKeyColumnNames() {
        return this.primaryKeyColumnNames;
    }

    @Override
    public String[] getPartitionKeyColumnNames() {
        return this.partitionKeyColumnNames;
    }

    @Override
    public PartitionKey createPartitionKey() {
        PartitionKeyImpl result = new PartitionKeyImpl();
        result.setTable(this.tableName);
        return result;
    }

    @Override
    public String[] getIndexNames() {
        return this.indexNames;
    }

    @Override
    public String[] getColumnNames() {
        return this.columnNames;
    }

    public int getMaximumColumnId() {
        return this.maximumColumnId;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public int[] getOffsets() {
        return this.offsets;
    }

    public int[] getLengths() {
        return this.lengths;
    }

    public int getMaximumColumnLength() {
        return this.maximumColumnLength;
    }
}

