/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.core.query;

import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.core.query.BetweenPredicateImpl;
import com.mysql.clusterj.core.query.QueryDomainTypeImpl;
import com.mysql.clusterj.core.spi.QueryExecutionContext;
import com.mysql.clusterj.core.spi.SessionSPI;
import com.mysql.clusterj.core.store.ResultData;
import com.mysql.clusterj.core.store.ScanFilter;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.query.QueryDomainType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QueryExecutionContextImpl
implements QueryExecutionContext {
    static final I18NHelper local = I18NHelper.getInstance(BetweenPredicateImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(BetweenPredicateImpl.class);
    protected Map<String, Object> boundParameters = new HashMap<String, Object>();
    protected SessionSPI session;
    private List<ScanFilter> filters = new ArrayList<ScanFilter>();
    protected Map<String, Object> explain = null;

    public QueryExecutionContextImpl(SessionSPI session) {
        if (session == null) {
            throw new ClusterJFatalInternalException(local.message("ERR_Session_Must_Not_Be_Null"));
        }
        this.session = session;
    }

    protected QueryExecutionContextImpl(QueryExecutionContextImpl context) {
        this.session = context.getSession();
        this.explain = context.getExplain();
        this.boundParameters = new HashMap<String, Object>(context.boundParameters);
    }

    public QueryExecutionContextImpl(SessionSPI session, Map<String, Object> parameterMap) {
        this.session = session;
        this.boundParameters = parameterMap;
    }

    public void bindParameterValue(String parameterName, Object value) {
        if (parameterName == null) {
            throw new ClusterJUserException(local.message("ERR_Parameter_Null"));
        }
        this.boundParameters.put(parameterName, value);
        this.explain = null;
    }

    @Override
    public Object getParameterValue(String parameterName) {
        if (!this.isBound(parameterName)) {
            throw new ClusterJUserException(local.message("ERR_Parameter_Not_Bound", (Object)parameterName));
        }
        return this.boundParameters.get(parameterName);
    }

    @Override
    public boolean isBound(String parameterName) {
        return this.boundParameters.containsKey(parameterName);
    }

    @Override
    public SessionSPI getSession() {
        return this.session;
    }

    public ResultData getResultData(QueryDomainType<?> queryDomainType) {
        return ((QueryDomainTypeImpl)queryDomainType).getResultData(this, 0L, Long.MAX_VALUE, null, null);
    }

    @Override
    public void addFilter(ScanFilter scanFilter) {
        this.filters.add(scanFilter);
    }

    @Override
    public void deleteFilters() {
        for (ScanFilter filter : this.filters) {
            filter.delete();
        }
        this.filters.clear();
    }

    @Override
    public void setExplain(Map<String, Object> explain) {
        this.explain = explain;
    }

    public Map<String, Object> getExplain() {
        return this.explain;
    }

    @Override
    public Byte getByte(String index) {
        Object result = this.boundParameters.get(index);
        if (result == null) {
            return null;
        }
        if (result instanceof Byte) {
            return (Byte)result;
        }
        throw new ClusterJUserException(local.message("ERR_Parameter_Wrong_Type", index, result.getClass(), "Byte"));
    }

    @Override
    public BigDecimal getBigDecimal(String index) {
        Object result = this.boundParameters.get(index);
        if (result == null) {
            return null;
        }
        if (result instanceof BigDecimal) {
            return (BigDecimal)result;
        }
        throw new ClusterJUserException(local.message("ERR_Parameter_Wrong_Type", index, result.getClass(), "BigDecimal"));
    }

    @Override
    public BigInteger getBigInteger(String index) {
        Object result = this.boundParameters.get(index);
        if (result == null) {
            return null;
        }
        if (result instanceof BigInteger) {
            return (BigInteger)result;
        }
        throw new ClusterJUserException(local.message("ERR_Parameter_Wrong_Type", index, result.getClass(), "BigInteger"));
    }

    @Override
    public Boolean getBoolean(String index) {
        Object result = this.boundParameters.get(index);
        if (result == null) {
            return null;
        }
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        throw new ClusterJUserException(local.message("ERR_Parameter_Wrong_Type", index, result.getClass(), "Boolean"));
    }

    @Override
    public byte[] getBytes(String index) {
        Object result = this.boundParameters.get(index);
        if (result == null) {
            return null;
        }
        if (result instanceof byte[]) {
            return (byte[])result;
        }
        throw new ClusterJUserException(local.message("ERR_Parameter_Wrong_Type", index, result.getClass(), "byte[]"));
    }

    @Override
    public Double getDouble(String index) {
        Object result = this.boundParameters.get(index);
        if (result == null) {
            return null;
        }
        if (result instanceof Double) {
            return (Double)result;
        }
        throw new ClusterJUserException(local.message("ERR_Parameter_Wrong_Type", index, result.getClass(), "Double"));
    }

    @Override
    public Float getFloat(String index) {
        Object result = this.boundParameters.get(index);
        if (result == null) {
            return null;
        }
        if (result instanceof Float) {
            return (Float)result;
        }
        throw new ClusterJUserException(local.message("ERR_Parameter_Wrong_Type", index, result.getClass(), "Float"));
    }

    @Override
    public Integer getInt(String index) {
        Object result = this.boundParameters.get(index);
        if (result == null) {
            return null;
        }
        if (result instanceof Integer) {
            return (Integer)result;
        }
        throw new ClusterJUserException(local.message("ERR_Parameter_Wrong_Type", index, result.getClass(), "Integer"));
    }

    @Override
    public Date getJavaSqlDate(String index) {
        Object result = this.boundParameters.get(index);
        if (result == null) {
            return null;
        }
        if (result instanceof Date) {
            return (Date)result;
        }
        throw new ClusterJUserException(local.message("ERR_Parameter_Wrong_Type", index, result.getClass(), "java.sql.Date"));
    }

    @Override
    public Time getJavaSqlTime(String index) {
        Object result = this.boundParameters.get(index);
        if (result == null) {
            return null;
        }
        if (result instanceof Time) {
            return (Time)result;
        }
        throw new ClusterJUserException(local.message("ERR_Parameter_Wrong_Type", index, result.getClass(), "java.sql.Time"));
    }

    @Override
    public Timestamp getJavaSqlTimestamp(String index) {
        Object result = this.boundParameters.get(index);
        if (result == null) {
            return null;
        }
        if (result instanceof Timestamp) {
            return (Timestamp)result;
        }
        throw new ClusterJUserException(local.message("ERR_Parameter_Wrong_Type", index, result.getClass(), "java.sql.Timestamp"));
    }

    @Override
    public java.util.Date getJavaUtilDate(String index) {
        Object result = this.boundParameters.get(index);
        if (result == null) {
            return null;
        }
        if (result instanceof java.util.Date) {
            return (java.util.Date)result;
        }
        throw new ClusterJUserException(local.message("ERR_Parameter_Wrong_Type", index, result.getClass(), "java.util.Date"));
    }

    @Override
    public Long getLong(String index) {
        Object result = this.boundParameters.get(index);
        if (result == null) {
            return null;
        }
        if (result instanceof Long) {
            return (Long)result;
        }
        throw new ClusterJUserException(local.message("ERR_Parameter_Wrong_Type", index, result.getClass(), "Long"));
    }

    @Override
    public Short getShort(String index) {
        Object result = this.boundParameters.get(index);
        if (result == null) {
            return null;
        }
        if (result instanceof Short) {
            return (Short)result;
        }
        throw new ClusterJUserException(local.message("ERR_Parameter_Wrong_Type", index, result.getClass(), "Short"));
    }

    @Override
    public String getString(String index) {
        Object result = this.boundParameters.get(index);
        if (result == null) {
            return null;
        }
        if (result instanceof String) {
            return (String)result;
        }
        throw new ClusterJUserException(local.message("ERR_Parameter_Wrong_Type", index, result.getClass(), "String"));
    }

    @Override
    public Object getObject(String index) {
        return this.boundParameters.get(index);
    }

    @Override
    public boolean hasNoNullParameters() {
        for (Object value : this.boundParameters.values()) {
            if (value != null) continue;
            return false;
        }
        return true;
    }
}

