/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.core.metadata;

import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.ColumnMetadata;
import com.mysql.clusterj.DynamicObjectDelegate;
import com.mysql.clusterj.core.CacheManager;
import com.mysql.clusterj.core.StateManager;
import com.mysql.clusterj.core.StoreManager;
import com.mysql.clusterj.core.metadata.DomainTypeHandlerImpl;
import com.mysql.clusterj.core.spi.DomainTypeHandler;
import com.mysql.clusterj.core.spi.ValueHandler;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;

public class InvocationHandlerImpl<T>
implements InvocationHandler,
StateManager,
ValueHandler,
DynamicObjectDelegate {
    static final I18NHelper local = I18NHelper.getInstance(InvocationHandlerImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(InvocationHandlerImpl.class);
    protected Object[] properties;
    protected int numberOfFields;
    protected Map<String, Class<?>> typemap = new HashMap();
    protected DomainTypeHandlerImpl<T> domainTypeHandler;
    BitSet modifiedFields;
    boolean modified = false;
    private Object proxy;
    private CacheManager objectManager;
    private Boolean found = null;

    public InvocationHandlerImpl(DomainTypeHandlerImpl<T> domainTypeHandler) {
        this.domainTypeHandler = domainTypeHandler;
        this.numberOfFields = domainTypeHandler.getNumberOfFields();
        this.properties = new Object[this.numberOfFields];
        this.modifiedFields = new BitSet(this.numberOfFields);
        domainTypeHandler.initializePrimitiveFields(this);
    }

    @Override
    public void setProxy(Object proxy) {
        this.proxy = proxy;
    }

    @Override
    public Object getProxy() {
        return this.proxy;
    }

    @Override
    public void setCacheManager(CacheManager manager) {
        this.objectManager = manager;
        this.resetModified();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        int fieldNumber;
        String methodName = method.getName();
        if (logger.isDetailEnabled()) {
            logger.detail("invoke with Method: " + method.getName());
        }
        String propertyHead = methodName.substring(3, 4);
        String propertyTail = methodName.substring(4);
        String propertyName = propertyHead.toLowerCase() + propertyTail;
        if (methodName.startsWith("get")) {
            if (logger.isDetailEnabled()) {
                logger.detail("Property name: " + propertyName);
            }
            int fieldNumber2 = this.domainTypeHandler.getFieldNumber(propertyName);
            if (logger.isDetailEnabled()) {
                logger.detail(methodName + ": Returning field number " + fieldNumber2 + " value: " + this.properties[fieldNumber2]);
            }
            return this.properties[fieldNumber2];
        }
        if (methodName.startsWith("set")) {
            if (logger.isDetailEnabled()) {
                logger.detail("Property name: " + propertyName);
            }
            fieldNumber = this.domainTypeHandler.getFieldNumber(propertyName);
            if (!this.modified && this.objectManager != null) {
                this.modified = true;
                this.objectManager.markModified(this);
                if (logger.isDetailEnabled()) {
                    logger.detail("modifying " + this);
                }
            }
        } else {
            if ("toString".equals(methodName)) {
                return this.domainTypeHandler.getDomainClass().getName() + this.pkToString(this.domainTypeHandler);
            }
            if ("hashCode".equals(methodName)) {
                return this.hashCode();
            }
            throw new ClusterJUserException(local.message("ERR_Method_Name", (Object)methodName));
        }
        this.modifiedFields.set(fieldNumber);
        this.properties[fieldNumber] = args[0];
        return null;
    }

    @Override
    public void markModified(int fieldNumber) {
        this.modifiedFields.set(fieldNumber);
    }

    @Override
    public String pkToString(DomainTypeHandler<?> domainTypeHandler) {
        StringBuffer sb = new StringBuffer(" key: [");
        int[] keys = domainTypeHandler.getKeyFieldNumbers();
        String separator = "";
        for (int i : keys) {
            sb.append(separator);
            sb.append(this.properties[i]);
            separator = ";";
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void resetModified() {
        this.modified = false;
        this.modifiedFields.clear();
    }

    @Override
    public boolean isNull(int fieldNumber) {
        return this.properties[fieldNumber] == null;
    }

    public BigInteger bigIntegerValue(int fieldNumber) {
        return (BigInteger)this.properties[fieldNumber];
    }

    public boolean booleanValue(int fieldNumber) {
        return (Boolean)this.properties[fieldNumber];
    }

    public boolean[] booleansValue(int fieldNumber) {
        return (boolean[])this.properties[fieldNumber];
    }

    public byte[] bytesValue(int fieldNumber) {
        return (byte[])this.properties[fieldNumber];
    }

    public byte byteValue(int fieldNumber) {
        return (Byte)this.properties[fieldNumber];
    }

    public Byte objectByteValue(int fieldNumber) {
        return (Byte)this.properties[fieldNumber];
    }

    public java.util.Date javaUtilDateValue(int fieldNumber) {
        return (java.util.Date)this.properties[fieldNumber];
    }

    public Date javaSqlDateValue(int fieldNumber) {
        return (Date)this.properties[fieldNumber];
    }

    public Time javaSqlTimeValue(int fieldNumber) {
        return (Time)this.properties[fieldNumber];
    }

    public Timestamp javaSqlTimestampValue(int fieldNumber) {
        return (Timestamp)this.properties[fieldNumber];
    }

    public BigDecimal decimalValue(int fieldNumber) {
        return (BigDecimal)this.properties[fieldNumber];
    }

    public double doubleValue(int fieldNumber) {
        return (Double)this.properties[fieldNumber];
    }

    public float floatValue(int fieldNumber) {
        return ((Float)this.properties[fieldNumber]).floatValue();
    }

    public int intValue(int fieldNumber) {
        if (logger.isDetailEnabled()) {
            logger.detail("intValue: Returning field number " + fieldNumber + " value: " + this.properties[fieldNumber]);
        }
        return (Integer)this.properties[fieldNumber];
    }

    public Integer objectIntValue(int fieldNumber) {
        return (Integer)this.properties[fieldNumber];
    }

    public long longValue(int fieldNumber) {
        return (Long)this.properties[fieldNumber];
    }

    public short shortValue(int fieldNumber) {
        return (Short)this.properties[fieldNumber];
    }

    public String stringValue(int fieldNumber) {
        if (logger.isDetailEnabled()) {
            logger.detail("stringValue: Returning field number " + fieldNumber + " value: " + this.properties[fieldNumber]);
        }
        return (String)this.properties[fieldNumber];
    }

    public void setValue(int fieldNumber, Object value) {
        if (logger.isDetailEnabled()) {
            logger.detail("setValue: Setting field number " + fieldNumber + " to value " + value);
        }
        this.properties[fieldNumber] = value;
    }

    @Override
    public void flush(StoreManager stm) {
    }

    @Override
    public boolean isModified(int fieldNumber) {
        return this.modifiedFields.get(fieldNumber);
    }

    @Override
    public BigInteger getBigInteger(int fieldNumber) {
        return this.bigIntegerValue(fieldNumber);
    }

    @Override
    public boolean getBoolean(int fieldNumber) {
        return this.booleanValue(fieldNumber);
    }

    @Override
    public boolean[] getBooleans(int fieldNumber) {
        return this.booleansValue(fieldNumber);
    }

    @Override
    public Boolean getObjectBoolean(int fieldNumber) {
        return this.booleanValue(fieldNumber);
    }

    @Override
    public byte getByte(int fieldNumber) {
        return this.byteValue(fieldNumber);
    }

    @Override
    public byte[] getBytes(int fieldNumber) {
        return this.bytesValue(fieldNumber);
    }

    @Override
    public short getShort(int fieldNumber) {
        return this.shortValue(fieldNumber);
    }

    @Override
    public int getInt(int fieldNumber) {
        return this.intValue(fieldNumber);
    }

    @Override
    public long getLong(int fieldNumber) {
        return this.longValue(fieldNumber);
    }

    @Override
    public float getFloat(int fieldNumber) {
        return this.floatValue(fieldNumber);
    }

    @Override
    public double getDouble(int fieldNumber) {
        return this.doubleValue(fieldNumber);
    }

    @Override
    public byte[] getLobBytes(int fieldNumber) {
        return this.bytesValue(fieldNumber);
    }

    @Override
    public String getLobString(int fieldNumber) {
        return this.stringValue(fieldNumber);
    }

    @Override
    public Byte getObjectByte(int fieldNumber) {
        return (Byte)this.properties[fieldNumber];
    }

    @Override
    public Short getObjectShort(int fieldNumber) {
        return (Short)this.properties[fieldNumber];
    }

    @Override
    public Integer getObjectInt(int fieldNumber) {
        return (Integer)this.properties[fieldNumber];
    }

    @Override
    public Long getObjectLong(int fieldNumber) {
        return (Long)this.properties[fieldNumber];
    }

    @Override
    public Float getObjectFloat(int fieldNumber) {
        return (Float)this.properties[fieldNumber];
    }

    @Override
    public Double getObjectDouble(int fieldNumber) {
        return (Double)this.properties[fieldNumber];
    }

    @Override
    public BigDecimal getBigDecimal(int fieldNumber) {
        return (BigDecimal)this.properties[fieldNumber];
    }

    @Override
    public String getString(int fieldNumber) {
        return (String)this.properties[fieldNumber];
    }

    @Override
    public Date getJavaSqlDate(int fieldNumber) {
        return (Date)this.properties[fieldNumber];
    }

    @Override
    public java.util.Date getJavaUtilDate(int fieldNumber) {
        return (java.util.Date)this.properties[fieldNumber];
    }

    @Override
    public Time getJavaSqlTime(int fieldNumber) {
        return (Time)this.properties[fieldNumber];
    }

    @Override
    public Timestamp getJavaSqlTimestamp(int fieldNumber) {
        return (Timestamp)this.properties[fieldNumber];
    }

    @Override
    public void setBigInteger(int fieldNumber, BigInteger value) {
        this.properties[fieldNumber] = value;
    }

    @Override
    public void setBoolean(int fieldNumber, boolean b) {
        this.properties[fieldNumber] = b;
    }

    @Override
    public void setBooleans(int fieldNumber, boolean[] b) {
        this.properties[fieldNumber] = b;
    }

    @Override
    public void setByte(int fieldNumber, byte value) {
        this.properties[fieldNumber] = value;
    }

    @Override
    public void setBytes(int fieldNumber, byte[] value) {
        this.properties[fieldNumber] = value;
    }

    @Override
    public void setLobBytes(int fieldNumber, byte[] value) {
        this.properties[fieldNumber] = value;
    }

    @Override
    public void setLobString(int fieldNumber, String value) {
        this.properties[fieldNumber] = value;
    }

    @Override
    public void setShort(int fieldNumber, short value) {
        this.properties[fieldNumber] = value;
    }

    @Override
    public void setInt(int fieldNumber, int value) {
        this.properties[fieldNumber] = value;
    }

    @Override
    public void setLong(int fieldNumber, long value) {
        this.properties[fieldNumber] = value;
    }

    @Override
    public void setFloat(int fieldNumber, float value) {
        this.properties[fieldNumber] = Float.valueOf(value);
    }

    @Override
    public void setDouble(int fieldNumber, double value) {
        this.properties[fieldNumber] = value;
    }

    @Override
    public void setObjectBoolean(int fieldNumber, Boolean value) {
        this.properties[fieldNumber] = value;
    }

    @Override
    public void setObjectByte(int fieldNumber, Byte value) {
        this.properties[fieldNumber] = value;
    }

    @Override
    public void setObjectShort(int fieldNumber, Short value) {
        this.properties[fieldNumber] = value;
    }

    @Override
    public void setObjectInt(int fieldNumber, Integer value) {
        this.properties[fieldNumber] = value;
    }

    @Override
    public void setObjectLong(int fieldNumber, Long value) {
        this.properties[fieldNumber] = value;
    }

    @Override
    public void setObjectFloat(int fieldNumber, Float value) {
        this.properties[fieldNumber] = value;
    }

    @Override
    public void setObjectDouble(int fieldNumber, Double value) {
        this.properties[fieldNumber] = value;
    }

    @Override
    public void setBigDecimal(int fieldNumber, BigDecimal value) {
        this.properties[fieldNumber] = value;
    }

    @Override
    public void setString(int fieldNumber, String value) {
        this.properties[fieldNumber] = value;
    }

    @Override
    public void setObject(int fieldNumber, Object value) {
        this.properties[fieldNumber] = value;
    }

    @Override
    public void setJavaSqlDate(int fieldNumber, Date value) {
        this.properties[fieldNumber] = value;
    }

    @Override
    public void setJavaUtilDate(int fieldNumber, java.util.Date value) {
        this.properties[fieldNumber] = value;
    }

    @Override
    public void setJavaSqlTime(int fieldNumber, Time value) {
        this.properties[fieldNumber] = value;
    }

    @Override
    public void setJavaSqlTimestamp(int fieldNumber, Timestamp value) {
        this.properties[fieldNumber] = value;
    }

    @Override
    public Object get(int columnNumber) {
        return this.properties[columnNumber];
    }

    @Override
    public void set(int columnNumber, Object value) {
        this.modifiedFields.set(columnNumber);
        this.properties[columnNumber] = value;
    }

    @Override
    public ColumnMetadata[] columnMetadata() {
        return this.domainTypeHandler.columnMetadata();
    }

    @Override
    public void found(Boolean found) {
        this.found = found;
    }

    @Override
    public Boolean found() {
        return this.found;
    }
}

