/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import com.mysql.clusterj.ClusterJException;
import testsuite.clusterj.AbstractClusterJModelTest;

public class TransactionStateTest
extends AbstractClusterJModelTest {
    @Override
    public void localSetUp() {
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        this.tx = this.session.currentTransaction();
    }

    public void test() {
        this.beginAfterBegin();
        this.rollbackWithoutBegin();
        this.commitWithoutBegin();
        this.commitWithSetRollbackOnly();
        this.failOnError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beginAfterBegin() {
        try {
            this.tx.begin();
            this.tx.begin();
            this.error("Begin after begin failed to throw exception.");
        }
        catch (ClusterJException ex) {
            this.errorIfNotEqual("Begin after begin should leave transaction active", true, this.tx.isActive());
        }
        finally {
            this.tx.commit();
        }
    }

    private void commitWithSetRollbackOnly() {
        try {
            this.tx.begin();
            this.tx.setRollbackOnly();
            this.tx.commit();
            this.error("Commit after setRollbackOnly failed to throw exception.");
        }
        catch (ClusterJException ex) {
            this.errorIfNotEqual("Commit after setRollbackOnly should leave transaction not active", false, this.tx.isActive());
        }
    }

    private void commitWithoutBegin() {
        try {
            this.tx.commit();
            this.error("Commit without begin failed to throw exception.");
        }
        catch (ClusterJException ex) {
            this.errorIfNotEqual("Commit without begin should leave transaction not active", false, this.tx.isActive());
        }
    }

    private void rollbackWithoutBegin() {
        try {
            this.tx.rollback();
            this.error("Rollback without begin failed to throw exception.");
        }
        catch (ClusterJException ex) {
            this.errorIfNotEqual("Rollback without begin should leave transaction not active", false, this.tx.isActive());
        }
    }
}

