/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import testsuite.clusterj.AbstractClusterJModelTest;
import testsuite.clusterj.model.Employee;

public class SerialTransactionsTest
extends AbstractClusterJModelTest {
    private static final int NUMBER_TO_INSERT = 4;

    protected int numberOfEmployees() {
        return 4;
    }

    @Override
    public void localSetUp() {
        this.createSessionFactory();
        this.createSession();
        this.createEmployeeInstances(4);
        this.addTearDownClasses(Employee.class);
    }

    public void test() {
        this.deleteAll();
        this.createSession();
        this.findAll();
        this.createSession();
        this.createAll();
        this.createSession();
        this.findAll();
        this.createSession();
        this.findAll();
        this.createSession();
        this.updateThenVerifyAll();
        this.failOnError();
    }

    protected void createAll() {
        this.tx.begin();
        this.session.makePersistentAll((Iterable)this.employees);
        this.tx.commit();
    }

    public void findAll() {
        this.tx.begin();
        for (int i = 0; i < 4; ++i) {
            Employee employee = (Employee)this.session.find(Employee.class, (Object)i);
        }
        this.tx.commit();
    }

    public void deleteAll() {
        this.tx.begin();
        for (int i = 0; i < 4; ++i) {
            Employee e = (Employee)this.session.find(Employee.class, (Object)i);
            this.session.deletePersistent((Object)e);
        }
        this.tx.commit();
    }

    public void updateThenVerifyAll() {
        Employee e;
        int i;
        this.tx.begin();
        for (i = 0; i < 4; ++i) {
            e = (Employee)this.session.find(Employee.class, (Object)i);
            e.setAge(4 - i);
            this.session.updatePersistent((Object)e);
        }
        this.tx.commit();
        this.tx.begin();
        for (i = 0; i < 4; ++i) {
            int expected = 4 - i;
            e = (Employee)this.session.find(Employee.class, (Object)i);
            int actual = e.getAge();
            if (expected == actual) continue;
            this.error("Failed update: for employee " + i + " expected age " + expected + " actual age " + actual);
        }
        this.tx.commit();
    }
}

