/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import java.util.ArrayList;
import java.util.List;
import testsuite.clusterj.AbstractClusterJTest;
import testsuite.clusterj.model.DynamicPK;

public class DynamicBinaryPKTest
extends AbstractClusterJTest {
    protected int NUMBER_OF_INSTANCES = 15;
    protected List<DynamicPK> instances = new ArrayList<DynamicPK>();

    @Override
    public void localSetUp() {
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        this.tx = this.session.currentTransaction();
    }

    public void test() {
        this.run(DynamicBinaryPK.class);
        this.run(DynamicVarbinaryPK.class);
        this.run(DynamicLongvarbinaryPK.class);
        this.failOnError();
    }

    public void run(Class<? extends DynamicPK> cls) {
        this.deleteAll(cls);
        this.createInstances(cls);
        this.insert();
        this.find(cls);
        this.update(cls);
        this.delete(cls);
    }

    protected void deleteAll(Class<? extends DynamicPK> cls) {
        try {
            this.tx.begin();
            this.session.deletePersistentAll(cls);
            this.tx.commit();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void insert() {
        this.session.makePersistentAll(this.instances);
    }

    protected void find(Class<? extends DynamicPK> cls) {
        String where = "find " + cls.getName();
        for (int i = 0; i < this.NUMBER_OF_INSTANCES; ++i) {
            byte[] key = this.getPK(i);
            DynamicPK result = (DynamicPK)((Object)this.session.find(cls, (Object)key));
            this.verify(where, result, i, false);
        }
    }

    protected void update(Class<? extends DynamicPK> cls) {
        int i;
        String where = "update before " + cls.getName();
        for (i = 0; i < this.NUMBER_OF_INSTANCES; ++i) {
            if (0 != i % 4) continue;
            DynamicPK instance = this.createInstance(cls, i);
            instance.setName(this.getValue(this.NUMBER_OF_INSTANCES - i));
            this.session.updatePersistent((Object)instance);
            this.verify(where, instance, i, true);
        }
        where = "update after " + cls.getName();
        for (i = 0; i < this.NUMBER_OF_INSTANCES; ++i) {
            if (0 != i % 4) continue;
            byte[] key = this.getPK(i);
            DynamicPK instance = (DynamicPK)((Object)this.session.find(cls, (Object)key));
            this.verify(where, instance, i, true);
        }
    }

    protected void delete(Class<? extends DynamicPK> cls) {
        int i;
        for (i = 0; i < this.NUMBER_OF_INSTANCES; ++i) {
            if (0 != i % 5) continue;
            DynamicPK instance = this.createInstance(cls, i);
            this.session.deletePersistent((Object)instance);
        }
        for (i = 0; i < this.NUMBER_OF_INSTANCES; ++i) {
            if (0 != i % 5) continue;
            byte[] key = this.getPK(i);
            DynamicPK instance = (DynamicPK)((Object)this.session.find(cls, (Object)key));
            this.errorIfNotEqual("Failed to delete instance: " + i, null, (Object)instance);
        }
    }

    protected void createInstances(Class<? extends DynamicPK> cls) {
        this.instances.clear();
        for (int i = 0; i < this.NUMBER_OF_INSTANCES; ++i) {
            DynamicPK instance = this.createInstance(cls, i);
            if (this.getDebug()) {
                System.out.println(this.toString(instance));
            }
            this.instances.add(instance);
        }
    }

    protected DynamicPK createInstance(Class<? extends DynamicPK> cls, int index) {
        DynamicPK instance = (DynamicPK)((Object)this.session.newInstance(cls));
        instance.setId(this.getPK(index));
        instance.setNumber(index);
        instance.setName(this.getValue(index));
        return instance;
    }

    protected String toString(DynamicPK instance) {
        StringBuffer result = new StringBuffer(((Object)((Object)instance)).getClass().getName());
        result.append("[");
        result.append(this.toString(instance.getId()));
        result.append("]: ");
        result.append(instance.getNumber());
        result.append(", \"");
        result.append(instance.getName());
        result.append("\".");
        return result.toString();
    }

    protected byte[] getPK(int index) {
        byte[] result = new byte[255];
        result[1] = (byte)(index / 256);
        result[2] = (byte)(index % 256);
        return result;
    }

    protected String getValue(int index) {
        return "Value " + index;
    }

    protected void verify(String where, DynamicPK instance, int index, boolean updated) {
        this.errorIfNotEqual(where + "id failed", this.toString(this.getPK(index)), this.toString(instance.getId()));
        this.errorIfNotEqual(where + "number failed", index, instance.getNumber());
        if (updated) {
            this.errorIfNotEqual(where + " Value failed", this.getValue(this.NUMBER_OF_INSTANCES - index), instance.getName());
        } else {
            this.errorIfNotEqual(where + " Value failed", this.getValue(index), instance.getName());
        }
    }

    private String toString(byte[] id) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < id.length; ++i) {
            builder.append(String.valueOf(id[i]));
            builder.append('-');
        }
        return builder.toString();
    }

    public static class DynamicLongvarbinaryPK
    extends DynamicPK {
        public String table() {
            return "longvarbinarypk";
        }
    }

    public static class DynamicVarbinaryPK
    extends DynamicPK {
        public String table() {
            return "varbinarypk";
        }
    }

    public static class DynamicBinaryPK
    extends DynamicPK {
        public String table() {
            return "binarypk";
        }
    }
}

