/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import testsuite.clusterj.AbstractClusterJModelTest;
import testsuite.clusterj.model.CharsetBig5;
import testsuite.clusterj.model.CharsetLatin1;
import testsuite.clusterj.model.CharsetModel;
import testsuite.clusterj.model.CharsetSjis;
import testsuite.clusterj.model.CharsetUtf8;

public class CharsetTest
extends AbstractClusterJModelTest {
    protected List<CharsetModel> charsetTypes = new ArrayList<CharsetModel>();

    @Override
    public void localSetUp() {
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        this.setAutoCommit(connection, false);
    }

    public void testLatin1() {
        this.writeJDBCreadJDBC("windows-1252", "charsetlatin1", CharsetLatin1.class, ColumnDescriptor.SMALL);
        this.writeJDBCreadJDBC("windows-1252", "charsetlatin1", CharsetLatin1.class, ColumnDescriptor.MEDIUM);
        this.writeJDBCreadJDBC("windows-1252", "charsetlatin1", CharsetLatin1.class, ColumnDescriptor.LARGE);
        this.writeJDBCreadNDB("windows-1252", "charsetlatin1", CharsetLatin1.class, ColumnDescriptor.SMALL);
        this.writeJDBCreadNDB("windows-1252", "charsetlatin1", CharsetLatin1.class, ColumnDescriptor.MEDIUM);
        this.writeJDBCreadNDB("windows-1252", "charsetlatin1", CharsetLatin1.class, ColumnDescriptor.LARGE);
        this.writeNDBreadJDBC("windows-1252", "charsetlatin1", CharsetLatin1.class, ColumnDescriptor.SMALL);
        this.writeNDBreadJDBC("windows-1252", "charsetlatin1", CharsetLatin1.class, ColumnDescriptor.MEDIUM);
        this.writeNDBreadJDBC("windows-1252", "charsetlatin1", CharsetLatin1.class, ColumnDescriptor.LARGE);
        this.writeNDBreadNDB("windows-1252", "charsetlatin1", CharsetLatin1.class, ColumnDescriptor.SMALL);
        this.writeNDBreadNDB("windows-1252", "charsetlatin1", CharsetLatin1.class, ColumnDescriptor.MEDIUM);
        this.writeNDBreadNDB("windows-1252", "charsetlatin1", CharsetLatin1.class, ColumnDescriptor.LARGE);
        this.failOnError();
    }

    public void testUtf8() {
        this.writeJDBCreadJDBC("UTF-8", "charsetutf8", CharsetUtf8.class, ColumnDescriptor.SMALL);
        this.writeJDBCreadJDBC("UTF-8", "charsetutf8", CharsetUtf8.class, ColumnDescriptor.MEDIUM);
        this.writeJDBCreadJDBC("UTF-8", "charsetutf8", CharsetUtf8.class, ColumnDescriptor.LARGE);
        this.writeJDBCreadNDB("UTF-8", "charsetutf8", CharsetUtf8.class, ColumnDescriptor.SMALL);
        this.writeJDBCreadNDB("UTF-8", "charsetutf8", CharsetUtf8.class, ColumnDescriptor.MEDIUM);
        this.writeJDBCreadNDB("UTF-8", "charsetutf8", CharsetUtf8.class, ColumnDescriptor.LARGE);
        this.writeNDBreadJDBC("UTF-8", "charsetutf8", CharsetUtf8.class, ColumnDescriptor.SMALL);
        this.writeNDBreadJDBC("UTF-8", "charsetutf8", CharsetUtf8.class, ColumnDescriptor.MEDIUM);
        this.writeNDBreadJDBC("UTF-8", "charsetutf8", CharsetUtf8.class, ColumnDescriptor.LARGE);
        this.writeNDBreadNDB("UTF-8", "charsetutf8", CharsetUtf8.class, ColumnDescriptor.SMALL);
        this.writeNDBreadNDB("UTF-8", "charsetutf8", CharsetUtf8.class, ColumnDescriptor.MEDIUM);
        this.writeNDBreadNDB("UTF-8", "charsetutf8", CharsetUtf8.class, ColumnDescriptor.LARGE);
        this.failOnError();
    }

    public void testSjis() {
        this.writeNDBreadJDBC("SJIS", "charsetsjis", CharsetSjis.class, ColumnDescriptor.SMALL);
        this.writeNDBreadJDBC("SJIS", "charsetsjis", CharsetSjis.class, ColumnDescriptor.MEDIUM);
        this.writeNDBreadJDBC("SJIS", "charsetsjis", CharsetSjis.class, ColumnDescriptor.LARGE);
        this.writeNDBreadNDB("SJIS", "charsetsjis", CharsetSjis.class, ColumnDescriptor.SMALL);
        this.writeNDBreadNDB("SJIS", "charsetsjis", CharsetSjis.class, ColumnDescriptor.MEDIUM);
        this.writeNDBreadNDB("SJIS", "charsetsjis", CharsetSjis.class, ColumnDescriptor.LARGE);
        this.failOnError();
    }

    public void testBig5() {
        this.writeJDBCreadJDBC("big5", "charsetbig5", CharsetBig5.class, ColumnDescriptor.SMALL);
        this.writeJDBCreadJDBC("big5", "charsetbig5", CharsetBig5.class, ColumnDescriptor.MEDIUM);
        this.writeJDBCreadJDBC("big5", "charsetbig5", CharsetBig5.class, ColumnDescriptor.LARGE);
        this.writeJDBCreadNDB("big5", "charsetbig5", CharsetBig5.class, ColumnDescriptor.SMALL);
        this.writeJDBCreadNDB("big5", "charsetbig5", CharsetBig5.class, ColumnDescriptor.MEDIUM);
        this.writeJDBCreadNDB("big5", "charsetbig5", CharsetBig5.class, ColumnDescriptor.LARGE);
        this.writeNDBreadJDBC("big5", "charsetbig5", CharsetBig5.class, ColumnDescriptor.SMALL);
        this.writeNDBreadJDBC("big5", "charsetbig5", CharsetBig5.class, ColumnDescriptor.MEDIUM);
        this.writeNDBreadJDBC("big5", "charsetbig5", CharsetBig5.class, ColumnDescriptor.LARGE);
        this.writeNDBreadNDB("big5", "charsetbig5", CharsetBig5.class, ColumnDescriptor.SMALL);
        this.writeNDBreadNDB("big5", "charsetbig5", CharsetBig5.class, ColumnDescriptor.MEDIUM);
        this.writeNDBreadNDB("big5", "charsetbig5", CharsetBig5.class, ColumnDescriptor.LARGE);
        this.failOnError();
    }

    protected void writeJDBCreadJDBC(String charsetName, String tableName, Class<? extends CharsetModel> modelClass, ColumnDescriptor columnDescriptor) {
        this.removeAll(modelClass);
        List<String> result = null;
        List<String> strings = this.generateStrings(columnDescriptor, charsetName);
        List<CharsetModel> instances = this.generateInstances(columnDescriptor, modelClass, strings);
        this.writeToJDBC(columnDescriptor, tableName, instances);
        result = this.readFromJDBC(columnDescriptor, tableName);
        if (this.debug) {
            System.out.println("Returned results of size " + result.size());
        }
        this.verify("writeJDBCreadJDBC ", strings, result, columnDescriptor);
    }

    protected void writeJDBCreadNDB(String charsetName, String tableName, Class<? extends CharsetModel> modelClass, ColumnDescriptor columnDescriptor) {
        this.removeAll(modelClass);
        List<String> result = null;
        List<String> strings = this.generateStrings(columnDescriptor, charsetName);
        List<CharsetModel> instances = this.generateInstances(columnDescriptor, modelClass, strings);
        this.writeToJDBC(columnDescriptor, tableName, instances);
        result = this.readFromNDB(columnDescriptor, modelClass);
        if (this.debug) {
            System.out.println("Returned results of size " + result.size());
        }
        this.verify("writeJDBCreadNDB ", strings, result, columnDescriptor);
    }

    protected void writeNDBreadJDBC(String charsetName, String tableName, Class<? extends CharsetModel> modelClass, ColumnDescriptor columnDescriptor) {
        this.removeAll(modelClass);
        List<String> result = null;
        List<String> strings = this.generateStrings(columnDescriptor, charsetName);
        List<CharsetModel> instances = this.generateInstances(columnDescriptor, modelClass, strings);
        this.writeToNDB(columnDescriptor, instances);
        result = this.readFromJDBC(columnDescriptor, tableName);
        if (this.debug) {
            System.out.println("Returned results of size " + result.size());
        }
        this.verify("writeNDBreadJDBC ", strings, result, columnDescriptor);
    }

    protected void writeNDBreadNDB(String charsetName, String tableName, Class<? extends CharsetModel> modelClass, ColumnDescriptor columnDescriptor) {
        this.removeAll(modelClass);
        List<String> result = null;
        List<String> strings = this.generateStrings(columnDescriptor, charsetName);
        List<CharsetModel> instances = this.generateInstances(columnDescriptor, modelClass, strings);
        this.writeToNDB(columnDescriptor, instances);
        result = this.readFromNDB(columnDescriptor, modelClass);
        if (this.debug) {
            System.out.println("Returned results of size " + result.size());
        }
        this.verify("writeNDBreadNDB ", strings, result, columnDescriptor);
    }

    private void verify(String where, List<String> expecteds, List<String> actuals, ColumnDescriptor columnDescriptor) {
        int maxErrors = 10;
        for (int i = 0; i < expecteds.size(); ++i) {
            String expected = expecteds.get(i);
            String actual = actuals.get(i);
            if (actual == null) {
                this.error(where + columnDescriptor.columnName + " actual column " + i + " was null.");
                continue;
            }
            int expectedLength = expected.length();
            int actualLength = actual.length();
            this.errorIfNotEqual(where + "got failure on size of column data for column width " + columnDescriptor.columnWidth + " at row " + i, expectedLength, actualLength);
            if (expectedLength != actualLength) continue;
            for (int j = 0; j < expected.length(); ++j) {
                if (--maxErrors <= 0) continue;
                this.errorIfNotEqual("Failure to match column data for column width " + columnDescriptor.columnWidth + " at row " + i + " column " + j, expected.codePointAt(j), actual.codePointAt(j));
            }
        }
    }

    protected List<String> generateStrings(ColumnDescriptor columnDescriptor, String charsetName) {
        ArrayList<String> result = new ArrayList<String>();
        Charset charset = Charset.forName(charsetName);
        CharBuffer allChars = CharBuffer.allocate(65536);
        CharsetEncoder encoder = charset.newEncoder();
        int count = 0;
        for (int i = 0; i < 65536; ++i) {
            Character ch = Character.valueOf((char)i);
            if (!encoder.canEncode(ch.charValue())) continue;
            allChars.append(ch.charValue());
            ++count;
        }
        if (this.debug) {
            System.out.print(charsetName + " has " + count + " encodable characters");
        }
        allChars.flip();
        int width = columnDescriptor.getColumnWidth();
        boolean done = false;
        byte[] bytes = new byte[width];
        while (!done) {
            int begin = allChars.position();
            allChars.mark();
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
            CoderResult coderResult = encoder.encode(allChars, byteBuffer, false);
            int end = allChars.position();
            int length = end - begin;
            if (length == 0) {
                done = true;
                continue;
            }
            char[] chars = new char[length];
            allChars.reset();
            allChars.get(chars, 0, length);
            String encodable = String.copyValueOf(chars);
            result.add(encodable);
            if (!coderResult.isUnderflow()) continue;
            done = true;
        }
        if (this.debug) {
            System.out.println(" in " + result.size() + " row(s) of size " + columnDescriptor.columnWidth);
        }
        return result;
    }

    protected List<CharsetModel> generateInstances(ColumnDescriptor columnDescriptor, Class<? extends CharsetModel> modelClass, List<String> strings) {
        ArrayList<CharsetModel> result = new ArrayList<CharsetModel>();
        for (int i = 0; i < strings.size(); ++i) {
            CharsetModel instance = (CharsetModel)this.session.newInstance(modelClass);
            instance.setId(i);
            columnDescriptor.set(instance, strings.get(i));
            result.add(instance);
        }
        if (this.debug) {
            System.out.println("Created " + result.size() + " instances of " + modelClass.getName());
        }
        return result;
    }

    protected void writeToJDBC(ColumnDescriptor columnDescriptor, String tableName, List<CharsetModel> instances) {
        StringBuffer buffer = new StringBuffer("INSERT INTO ");
        buffer.append(tableName);
        buffer.append(" (id, ");
        buffer.append(columnDescriptor.getColumnName());
        buffer.append(") VALUES (?, ?)");
        String statement = buffer.toString();
        if (this.debug) {
            System.out.println(statement);
        }
        PreparedStatement preparedStatement = null;
        int i = 0;
        String value = "";
        try {
            Properties extraProperties = new Properties();
            extraProperties.put("characterEncoding", "utf8");
            this.getConnection(extraProperties);
            this.setAutoCommit(connection, false);
            preparedStatement = connection.prepareStatement(statement);
            if (this.debug) {
                System.out.println(preparedStatement.toString());
            }
            for (i = 0; i < instances.size(); ++i) {
                CharsetModel instance = instances.get(i);
                preparedStatement.setInt(1, instance.getId());
                value = columnDescriptor.get(instance);
                preparedStatement.setString(2, value);
                preparedStatement.execute();
            }
            connection.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to insert " + tableName + " at instance " + i + " errant string: " + CharsetTest.dump(value), e);
        }
    }

    protected void writeToNDB(ColumnDescriptor columnDescriptor, List<CharsetModel> instances) {
        this.session.currentTransaction().begin();
        for (CharsetModel instance : instances) {
            this.session.makePersistent((Object)instance);
        }
        this.session.currentTransaction().commit();
    }

    protected List<String> readFromNDB(ColumnDescriptor columnDescriptor, Class<? extends CharsetModel> modelClass) {
        ArrayList<String> result = new ArrayList<String>();
        this.session.currentTransaction().begin();
        int i = 0;
        boolean done = false;
        while (!done) {
            CharsetModel instance;
            if ((instance = (CharsetModel)this.session.find(modelClass, (Object)i++)) != null) {
                result.add(columnDescriptor.get(instance));
                continue;
            }
            done = true;
        }
        this.session.currentTransaction().commit();
        return result;
    }

    protected List<String> readFromJDBC(ColumnDescriptor columnDescriptor, String tableName) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuffer buffer = new StringBuffer("SELECT id, ");
        buffer.append(columnDescriptor.getColumnName());
        buffer.append(" FROM ");
        buffer.append(tableName);
        buffer.append(" ORDER BY ID");
        String statement = buffer.toString();
        if (this.debug) {
            System.out.println(statement);
        }
        PreparedStatement preparedStatement = null;
        int i = 0;
        try {
            preparedStatement = connection.prepareStatement(statement);
            ResultSet rs = preparedStatement.executeQuery();
            while (rs.next()) {
                String columnData = rs.getString(2);
                result.add(columnData);
                ++i;
            }
            connection.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to read " + tableName + " at instance " + i, e);
        }
        return result;
    }

    protected static enum ColumnDescriptor {
        SMALL(200, "smallcolumn", new InstanceHandler(){

            @Override
            public void set(CharsetModel instance, String value) {
                instance.setSmallColumn(value);
            }

            @Override
            public String get(CharsetModel instance) {
                return instance.getSmallColumn();
            }
        }),
        MEDIUM(500, "mediumcolumn", new InstanceHandler(){

            @Override
            public void set(CharsetModel instance, String value) {
                instance.setMediumColumn(value);
            }

            @Override
            public String get(CharsetModel instance) {
                return instance.getMediumColumn();
            }
        }),
        LARGE(10000, "largecolumn", new InstanceHandler(){

            @Override
            public void set(CharsetModel instance, String value) {
                instance.setLargeColumn(value);
            }

            @Override
            public String get(CharsetModel instance) {
                return instance.getLargeColumn();
            }
        });

        private int columnWidth;
        private String columnName;
        private InstanceHandler instanceHandler;

        public String getColumnName() {
            return this.columnName;
        }

        public String get(CharsetModel instance) {
            return this.instanceHandler.get(instance);
        }

        public void set(CharsetModel instance, String string) {
            this.instanceHandler.set(instance, string);
        }

        public int getColumnWidth() {
            return this.columnWidth;
        }

        private ColumnDescriptor(int width, String name, InstanceHandler instanceHandler) {
            this.columnWidth = width;
            this.columnName = name;
            this.instanceHandler = instanceHandler;
        }

        private static interface InstanceHandler {
            public void set(CharsetModel var1, String var2);

            public String get(CharsetModel var1);
        }
    }
}

