/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import com.mysql.clusterj.Session;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeSet;
import testsuite.clusterj.AbstractClusterJTest;
import testsuite.clusterj.model.AllPrimitives;
import testsuite.clusterj.model.Dn2id;
import testsuite.clusterj.model.Employee;
import testsuite.clusterj.model.IdBase;

public abstract class AbstractClusterJModelTest
extends AbstractClusterJTest {
    protected static TimeZone localSystemTimeZone = TimeZone.getDefault();
    protected static final long ONE_SECOND = 1000L;
    protected static final long ONE_MINUTE = 60000L;
    protected static final long ONE_HOUR = 3600000L;
    protected static final long TEN_HOURS = 36000000L;
    protected static final long ONE_DAY = 86400000L;
    String[] a1values = new String[]{"dc=abc", "dc=prs", "dc=xyz"};
    protected List<Employee> employees;
    protected List<Dn2id> dn2ids;
    protected static Object[] dn2idPK = AbstractClusterJModelTest.setupDn2idPK();
    protected List<IdBase> instances = new ArrayList<IdBase>();
    private List<Object[]> expected = null;
    ColumnDescriptor[] columnDescriptors = this.getColumnDescriptors();
    protected ClassLoader loader;
    protected boolean runTest = true;

    protected static long getMillisFor(int year, int month, int day, int hour, int minute, int second) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, day);
        calendar.set(10, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        calendar.set(14, 0);
        long result = calendar.getTimeInMillis();
        return result;
    }

    protected static long getMillisFor(int year, int month, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, day);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        long result = calendar.getTimeInMillis();
        return result;
    }

    protected static long getMillisFor(int days, int hour, int minute, int second) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(10, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        calendar.set(14, 0);
        long result = calendar.getTimeInMillis();
        return result;
    }

    protected boolean getCleanupAfterTest() {
        return true;
    }

    @Override
    public void localSetUp() {
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        this.setAutoCommit(connection, false);
        try {
            this.session.newInstance(this.getModelClass());
            this.runTest = true;
        }
        catch (Exception e) {
            System.out.println("Ignoring test; no model class " + this.getModelClass().getName());
            this.runTest = false;
        }
        if (this.getModelClass() != null && this.getCleanupAfterTest()) {
            this.addTearDownClasses(this.getModelClass());
        }
    }

    protected static void resetLocalSystemDefaultTimeZone(Connection connection) {
        try {
            PreparedStatement statement = connection.prepareStatement("select @@global.time_zone, @@global.system_time_zone, @@session.time_zone");
            ResultSet rs = statement.executeQuery();
            rs.next();
            String globalTimeZone = rs.getString(1);
            String globalSystemTimeZone = rs.getString(2);
            String sessionTimeZone = rs.getString(3);
            connection.commit();
            globalTimeZone = "SYSTEM".equalsIgnoreCase(globalTimeZone) ? globalSystemTimeZone : "GMT" + globalTimeZone;
            localSystemTimeZone = TimeZone.getTimeZone(globalTimeZone);
            connection.close();
        }
        catch (SQLException e) {
            throw new RuntimeException("setServerTimeZone failed", e);
        }
    }

    @Override
    protected void setAutoCommit(Connection connection, boolean b) {
        try {
            connection.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new RuntimeException("setAutoCommit failed", e);
        }
    }

    protected void createEmployeeInstances(int count) {
        this.employees = new ArrayList<Employee>(count);
        for (int i = 0; i < count; ++i) {
            Employee emp = (Employee)this.session.newInstance(Employee.class);
            emp.setId(i);
            emp.setName("Employee number " + i);
            emp.setAge(i);
            emp.setMagic(i);
            this.employees.add(emp);
        }
    }

    protected void consistencyCheck(Employee emp) {
        int actualMagic;
        int actualAge;
        String actualName;
        int id = emp.getId();
        String expectedName = "Employee number " + id;
        if (!expectedName.equals(actualName = emp.getName())) {
            this.error("Employee " + id + " name mismatch; expected length: " + expectedName.length() + "'" + expectedName + "'; actual length: " + actualName.length() + "'" + actualName + "'");
        }
        if ((actualAge = emp.getAge().intValue()) != id) {
            this.error("Employee " + id + " age mismatch; expected " + id + "'; actual '" + actualAge);
        }
        if ((actualMagic = emp.getMagic()) != id) {
            this.error("Employee " + id + " magic mismatch; expected " + id + "'; actual '" + actualMagic);
        }
    }

    protected <T> void consistencyCheck(Iterable<T> instances) {
        for (T instance : instances) {
            if (instance instanceof Employee) {
                this.consistencyCheck((Employee)instance);
                continue;
            }
            if (!(instance instanceof Dn2id)) continue;
            this.consistencyCheck((Dn2id)instance);
        }
    }

    protected void createDn2idInstances(int number) {
        this.dn2ids = new ArrayList<Dn2id>();
        for (int i = 0; i < number; ++i) {
            Dn2id d = (Dn2id)this.session.newInstance(Dn2id.class);
            d.setEid(i);
            d.setObjectClasses("testObject");
            d.setA0("dc=com");
            d.setA1(this.getA1for(number, i));
            d.setA2("ou=people");
            d.setA3(this.getA3for(i));
            d.setA4("");
            d.setA5("");
            d.setA6("");
            d.setA7("");
            d.setA8("");
            d.setA9("");
            d.setA10("");
            d.setA11("");
            d.setA12("");
            d.setA13("");
            d.setA14("");
            d.setA15("");
            this.dn2ids.add(d);
        }
    }

    protected void consistencyCheck(Dn2id dn2id) {
        String actual;
        long eid = dn2id.getEid();
        String expected = this.getA3for(eid);
        if (!expected.equals(actual = dn2id.getA3())) {
            this.error("Dn2id " + eid + " a3 mismatch; expected '" + expected + "'; actual '" + actual + "'");
        }
    }

    protected List<Object[]> getExpected() {
        return this.expected;
    }

    protected String getTableName() {
        return null;
    }

    protected int getNumberOfInstances() {
        return 0;
    }

    protected ColumnDescriptor[] getColumnDescriptors() {
        return null;
    }

    Class<? extends IdBase> getModelClass() {
        return null;
    }

    protected Object getColumnValue(int i, int j) {
        return null;
    }

    protected Object convertToKey(int i) {
        return i;
    }

    protected void writeJDBCreadNDB() {
        if (!this.runTest) {
            return;
        }
        this.generateInstances(this.getColumnDescriptors());
        this.removeAll(this.getModelClass());
        List<Object[]> result = null;
        this.writeToJDBC(this.columnDescriptors, this.instances);
        result = this.readFromNDB(this.columnDescriptors);
        this.verify("writeJDBCreadNDB", this.getExpected(), result);
    }

    protected void writeJDBCreadJDBC() {
        if (!this.runTest) {
            return;
        }
        this.generateInstances(this.getColumnDescriptors());
        this.removeAll(this.getModelClass());
        List<Object[]> result = null;
        this.writeToJDBC(this.columnDescriptors, this.instances);
        result = this.readFromJDBC(this.columnDescriptors);
        this.verify("writeJDBCreadJDBC", this.getExpected(), result);
    }

    protected void writeNDBreadNDB() {
        if (!this.runTest) {
            return;
        }
        this.generateInstances(this.getColumnDescriptors());
        this.removeAll(this.getModelClass());
        List<Object[]> result = null;
        this.writeToNDB(this.columnDescriptors, this.instances);
        result = this.readFromNDB(this.columnDescriptors);
        this.verify("writeNDBreadNDB", this.getExpected(), result);
    }

    protected void writeNDBreadJDBC() {
        if (!this.runTest) {
            return;
        }
        this.generateInstances(this.getColumnDescriptors());
        this.removeAll(this.getModelClass());
        List<Object[]> result = null;
        this.writeToNDB(this.columnDescriptors, this.instances);
        result = this.readFromJDBC(this.columnDescriptors);
        this.verify("writeNDBreadJDBC", this.getExpected(), result);
    }

    private String dumpListOfObjectArray(List<Object[]> results) {
        StringBuffer result = new StringBuffer(results.size() + " rows\n");
        for (Object[] row : results) {
            result.append("Id: ");
            for (Object column : row) {
                result.append(column);
                result.append(' ');
            }
            result.append('\n');
        }
        return result.toString();
    }

    protected void queryAndVerifyResults(String where, ColumnDescriptor[] columnDescriptors, String conditions, Object[] parameters, int ... objectIds) {
        List<Object[]> results = this.queryJDBC(columnDescriptors, conditions, parameters);
        this.verifyQueryResults(where, results, objectIds);
    }

    protected List<Object[]> queryJDBC(ColumnDescriptor[] columnDescriptors, String conditions, Object[] parameters) {
        this.getConnection();
        String tableName = this.getTableName();
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        StringBuffer buffer = new StringBuffer("SELECT id");
        for (ColumnDescriptor columnDescriptor : columnDescriptors) {
            buffer.append(", ");
            buffer.append(columnDescriptor.getColumnName());
        }
        buffer.append(" FROM ");
        buffer.append(tableName);
        buffer.append(" WHERE ");
        buffer.append(conditions);
        String statement = buffer.toString();
        if (this.debug) {
            System.out.println(statement);
        }
        PreparedStatement preparedStatement = null;
        try {
            int p = 1;
            preparedStatement = connection.prepareStatement(statement);
            for (Object parameter : parameters) {
                preparedStatement.setObject(p++, parameter);
            }
            ResultSet rs = preparedStatement.executeQuery();
            while (rs.next()) {
                Object[] row = new Object[columnDescriptors.length + 1];
                int j = 1;
                row[0] = rs.getInt(1);
                for (ColumnDescriptor columnDescriptor : columnDescriptors) {
                    row[j] = columnDescriptor.getResultSetValue(rs, j + 1);
                    ++j;
                }
                result.add(row);
            }
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to read " + tableName, e);
        }
        if (this.debug) {
            System.out.println("readFromJDBC: " + this.dumpObjectArray(result));
        }
        return result;
    }

    private String dumpObjectArray(List<Object[]> results) {
        StringBuffer result = new StringBuffer(results.size() + " rows\n");
        for (Object[] row : results) {
            result.append("Id: ");
            for (Object column : row) {
                result.append(column);
                result.append(' ');
            }
            result.append('\n');
        }
        return result.toString();
    }

    protected void verifyQueryResults(String where, List<Object[]> results, int ... objectIds) {
        this.errorIfNotEqual(where + " mismatch in number of results.", objectIds.length, results.size());
        for (Object[] result : results) {
            int id = (Integer)result[0];
            if (Arrays.binarySearch(objectIds, id) >= 0) continue;
            this.error(where + " result " + id + " not expected.");
        }
    }

    protected void verify(String where, List<Object[]> expecteds, List<Object[]> actuals) {
        if (expecteds.size() != actuals.size()) {
            this.error(where + " failure on size of results: expected: " + expecteds.size() + " actual: " + actuals.size());
            return;
        }
        for (int i = 0; i < expecteds.size(); ++i) {
            Object[] expected = expecteds.get(i);
            Object[] actual = actuals.get(i);
            this.errorIfNotEqual(where + " got failure on id for row " + i, i, actual[0]);
            for (int j = 1; j < expected.length; ++j) {
                this.errorIfNotEqual(where + " got failure to match column data for row " + i + " column " + j, expected[j], actual[j]);
            }
        }
    }

    protected void generateInstances(ColumnDescriptor[] columnDescriptors) {
        Class<? extends IdBase> modelClass = this.getModelClass();
        this.expected = new ArrayList<Object[]>();
        this.instances = new ArrayList<IdBase>();
        IdBase instance = null;
        int numberOfInstances = this.getNumberOfInstances();
        for (int i = 0; i < numberOfInstances; ++i) {
            instance = this.getNewInstance(modelClass);
            instance.setId(i);
            int j = 0;
            for (ColumnDescriptor columnDescriptor : columnDescriptors) {
                Object value = this.getColumnValue(i, j);
                if (this.debug) {
                    System.out.println("generateInstances set field " + columnDescriptor.getColumnName() + " to value " + value);
                }
                columnDescriptor.setFieldValue(instance, value);
                Object actual = columnDescriptor.getFieldValue(instance);
                this.errorIfNotEqual("generateInstances value mismatch for " + columnDescriptor.getColumnName(), AbstractClusterJModelTest.dump(value), AbstractClusterJModelTest.dump(actual));
                ++j;
            }
            this.instances.add(instance);
            Object[] expectedRow = this.createRow(columnDescriptors, instance);
            this.expected.add(expectedRow);
        }
        if (this.debug) {
            System.out.println("Created " + this.instances.size() + " instances of " + modelClass.getName());
        }
    }

    protected IdBase getNewInstance(Class<? extends IdBase> modelClass) {
        IdBase instance = (IdBase)this.session.newInstance(modelClass);
        return instance;
    }

    protected void writeToJDBC(ColumnDescriptor[] columnDescriptors, List<IdBase> instances) {
        String tableName = this.getTableName();
        StringBuffer buffer = new StringBuffer("INSERT INTO ");
        buffer.append(tableName);
        buffer.append(" (id");
        for (ColumnDescriptor columnDescriptor : columnDescriptors) {
            buffer.append(", ");
            buffer.append(columnDescriptor.getColumnName());
        }
        buffer.append(") VALUES (?");
        for (ColumnDescriptor columnDescriptor : columnDescriptors) {
            buffer.append(", ?");
        }
        buffer.append(")");
        String statement = buffer.toString();
        if (this.debug) {
            System.out.println(statement);
        }
        PreparedStatement preparedStatement = null;
        int i = 0;
        try {
            preparedStatement = connection.prepareStatement(statement);
            if (this.debug) {
                System.out.println(preparedStatement.toString());
            }
            for (i = 0; i < instances.size(); ++i) {
                IdBase instance = instances.get(i);
                preparedStatement.setInt(1, instance.getId());
                int j = 2;
                for (ColumnDescriptor columnDescriptor : columnDescriptors) {
                    Object value = columnDescriptor.getFieldValue(instance);
                    columnDescriptor.setPreparedStatementValue(preparedStatement, j++, value);
                    if (!this.debug) continue;
                    System.out.println("writeToJDBC set column: " + columnDescriptor.getColumnName() + " to value: " + value);
                }
                preparedStatement.execute();
            }
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to insert " + tableName + " at instance " + i, e);
        }
    }

    protected void writeToNDB(ColumnDescriptor[] columnDescriptors, List<IdBase> instances) {
        this.session.currentTransaction().begin();
        this.session.makePersistentAll(instances);
        this.session.currentTransaction().commit();
    }

    protected List<Object[]> readFromNDB(ColumnDescriptor[] columnDescriptors) {
        Class<? extends IdBase> modelClass = this.getModelClass();
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        this.session.currentTransaction().begin();
        for (int i = 0; i < this.getNumberOfInstances(); ++i) {
            IdBase instance = (IdBase)this.session.find(modelClass, this.convertToKey(i));
            if (instance == null) continue;
            Object[] row = this.createRow(columnDescriptors, instance);
            result.add(row);
        }
        this.session.currentTransaction().commit();
        if (this.debug) {
            System.out.println("readFromNDB: " + this.dumpListOfObjectArray(result));
        }
        return result;
    }

    private Object[] createRow(ColumnDescriptor[] columnDescriptors, IdBase instance) {
        Object[] row = new Object[columnDescriptors.length + 1];
        row[0] = instance.getId();
        int j = 1;
        for (ColumnDescriptor columnDescriptor : columnDescriptors) {
            row[j++] = columnDescriptor.getFieldValue(instance);
        }
        return row;
    }

    protected List<Object[]> readFromJDBC(ColumnDescriptor[] columnDescriptors) {
        String tableName = this.getTableName();
        ArrayList<Object[]> result = new ArrayList();
        TreeSet<Object[]> rows = new TreeSet<Object[]>(new Comparator<Object[]>(){

            @Override
            public int compare(Object[] me, Object[] other) {
                return (Integer)me[0] - (Integer)other[0];
            }
        });
        StringBuffer buffer = new StringBuffer("SELECT id");
        for (ColumnDescriptor columnDescriptor : columnDescriptors) {
            buffer.append(", ");
            buffer.append(columnDescriptor.getColumnName());
        }
        buffer.append(" FROM ");
        buffer.append(tableName);
        String statement = buffer.toString();
        if (this.debug) {
            System.out.println(statement);
        }
        PreparedStatement preparedStatement = null;
        int i = 0;
        try {
            preparedStatement = connection.prepareStatement(statement);
            ResultSet rs = preparedStatement.executeQuery();
            while (rs.next()) {
                Object[] row = new Object[columnDescriptors.length + 1];
                int j = 1;
                row[0] = rs.getInt(1);
                for (ColumnDescriptor columnDescriptor : columnDescriptors) {
                    row[j] = columnDescriptor.getResultSetValue(rs, j + 1);
                    ++j;
                }
                ++i;
                rows.add(row);
            }
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to read " + tableName + " at instance " + i, e);
        }
        result = new ArrayList<Object[]>(rows);
        if (this.debug) {
            System.out.println("readFromJDBC: " + this.dumpListOfObjectArray(result));
        }
        return result;
    }

    protected <T> T proxyFor(Class<T> cls) {
        InvocationHandler handler = new InvocationHandler(){
            private Map<String, Object> values = new HashMap<String, Object>();

            @Override
            public Object invoke(Object instance, Method method, Object[] args) throws Throwable {
                String methodName = method.getName();
                String propertyName = methodName.substring(3);
                String methodPrefix = methodName.substring(0, 3);
                if ("get".equals(methodPrefix)) {
                    return this.values.get(propertyName);
                }
                if ("set".equals(methodPrefix)) {
                    this.values.put(propertyName, args[0]);
                    return null;
                }
                throw new RuntimeException("Not a get/set method: " + methodName);
            }
        };
        Object proxy = Proxy.newProxyInstance(this.loader, new Class[]{cls}, handler);
        return (T)proxy;
    }

    protected String getA1for(int number, int index) {
        int a1factor = 1 + number / this.a1values.length;
        return this.a1values[index / a1factor];
    }

    protected String getA3for(long i) {
        return "employeenumber=100000" + i;
    }

    protected void createAllPrimitivesInstances(int number) {
        this.createAllPrimitivesInstances(this.session, number);
    }

    protected void createAllPrimitivesInstances(Session session, int number) {
        for (int i = 0; i < number; ++i) {
            AllPrimitives instance = this.createAllPrimitiveInstance(session, i);
            this.instances.add(instance);
        }
    }

    protected AllPrimitives createAllPrimitiveInstance(Session session, int i) {
        AllPrimitives instance = (AllPrimitives)session.newInstance(AllPrimitives.class, (Object)i);
        this.initialize(instance, i);
        return instance;
    }

    protected void initialize(AllPrimitives instance, int i) {
        instance.setInt_not_null_hash(i);
        instance.setInt_not_null_btree(i);
        instance.setInt_not_null_both(i);
        instance.setInt_not_null_none(i);
        instance.setInt_null_hash(i);
        instance.setInt_null_btree(i);
        instance.setInt_null_both(i);
        instance.setInt_null_none(i);
        instance.setLong_not_null_hash(i);
        instance.setLong_not_null_btree(i);
        instance.setLong_not_null_both(i);
        instance.setLong_not_null_none(i);
        instance.setLong_null_hash(Long.valueOf(i));
        instance.setLong_null_btree(Long.valueOf(i));
        instance.setLong_null_both(Long.valueOf(i));
        instance.setLong_null_none(Long.valueOf(i));
        instance.setByte_not_null_hash((byte)i);
        instance.setByte_not_null_btree((byte)i);
        instance.setByte_not_null_both((byte)i);
        instance.setByte_not_null_none((byte)i);
        instance.setByte_null_hash((byte)i);
        instance.setByte_null_btree((byte)i);
        instance.setByte_null_both((byte)i);
        instance.setByte_null_none((byte)i);
        instance.setShort_not_null_hash((short)i);
        instance.setShort_not_null_btree((short)i);
        instance.setShort_not_null_both((short)i);
        instance.setShort_not_null_none((short)i);
        instance.setShort_null_hash((short)i);
        instance.setShort_null_btree((short)i);
        instance.setShort_null_both((short)i);
        instance.setShort_null_none((short)i);
    }

    protected static Object[] setupDn2idPK() {
        Object[] result = new Object[16];
        result[0] = "dc=com";
        result[1] = "dc=example";
        result[2] = "ou=people";
        result[4] = "";
        result[5] = "";
        result[6] = "";
        result[7] = "";
        result[8] = "";
        result[9] = "";
        result[10] = "";
        result[11] = "";
        result[12] = "";
        result[13] = "";
        result[14] = "";
        result[15] = "";
        return result;
    }

    protected static interface InstanceHandler {
        public void setFieldValue(IdBase var1, Object var2);

        public Object getResultSetValue(ResultSet var1, int var2) throws SQLException;

        public Object getFieldValue(IdBase var1);

        public void setPreparedStatementValue(PreparedStatement var1, int var2, Object var3) throws SQLException;
    }

    protected static class ColumnDescriptor {
        private String columnName;
        protected InstanceHandler instanceHandler;

        public String getColumnName() {
            return this.columnName;
        }

        public Object getResultSetValue(ResultSet rs, int j) throws SQLException {
            return this.instanceHandler.getResultSetValue(rs, j);
        }

        public Object getFieldValue(IdBase instance) {
            return this.instanceHandler.getFieldValue(instance);
        }

        public void setFieldValue(IdBase instance, Object value) {
            this.instanceHandler.setFieldValue(instance, value);
        }

        public void setPreparedStatementValue(PreparedStatement preparedStatement, int j, Object value) throws SQLException {
            this.instanceHandler.setPreparedStatementValue(preparedStatement, j, value);
        }

        public ColumnDescriptor(String name, InstanceHandler instanceHandler) {
            this.columnName = name;
            this.instanceHandler = instanceHandler;
        }
    }
}

