/*
 * Decompiled with CFR 0.152.
 */
package junit.framework;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import org.junit.Ignore;

public class TestSuite
implements Test {
    public final String name;
    public final List<String> testClasses = new ArrayList<String>();
    public final List<TestCase> tests = new ArrayList<TestCase>();

    public TestSuite(String name) {
        this.name = name;
    }

    public TestSuite(Class<?> cls) {
        this.name = cls.getName();
        if (!TestCase.class.isAssignableFrom(cls)) {
            throw new RuntimeException("TestSuite<init>: " + cls.getName());
        }
        this.addTestSuite(cls);
    }

    public void addTestSuite(Class<? extends TestCase> testClass) {
        Ignore ignoreTypeAnnotation = null;
        String ignoreTypeReason = null;
        for (Class<? extends TestCase> cls = testClass; cls != null; cls = cls.getSuperclass()) {
            ignoreTypeAnnotation = cls.getAnnotation(Ignore.class);
            if (ignoreTypeAnnotation == null) continue;
            ignoreTypeReason = ignoreTypeAnnotation.value();
            break;
        }
        this.testClasses.add(testClass.getName());
        Method[] methods = testClass.getMethods();
        Ignore ignoreMethodAnnotation = null;
        String ignoreMethodReason = null;
        for (Method m : methods) {
            ignoreMethodAnnotation = m.getAnnotation(Ignore.class);
            String string = ignoreTypeAnnotation != null ? ignoreTypeReason : (ignoreMethodReason = ignoreMethodAnnotation == null ? null : ignoreMethodAnnotation.value());
            if (!m.getName().startsWith("test") || m.getParameterTypes().length != 0 || !m.getReturnType().equals(Void.TYPE) || !Modifier.isPublic(m.getModifiers())) continue;
            try {
                if (ignoreMethodReason != null) {
                    System.out.println(testClass.getName() + ":" + m.getName() + " @Ignored because: " + ignoreMethodReason);
                    continue;
                }
                TestCase t = testClass.newInstance();
                t.name = testClass.getSimpleName() + "." + m.getName();
                t.method = m;
                this.tests.add(t);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public int testCount() {
        return this.tests.size();
    }

    public int countTestCases() {
        return this.tests.size();
    }

    @Override
    public void run(TestResult result) {
        for (TestCase test : this.tests) {
            test.run(result);
        }
    }
}

