/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.core.store.Blob;
import com.mysql.clusterj.core.store.Column;
import com.mysql.clusterj.core.store.Operation;
import com.mysql.clusterj.core.store.ResultData;
import com.mysql.clusterj.core.store.Table;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.tie.BlobImpl;
import com.mysql.clusterj.tie.ClusterTransactionImpl;
import com.mysql.clusterj.tie.DbImpl;
import com.mysql.clusterj.tie.ResultDataImpl;
import com.mysql.clusterj.tie.TableImpl;
import com.mysql.clusterj.tie.Utility;
import com.mysql.ndbjtie.ndbapi.NdbBlob;
import com.mysql.ndbjtie.ndbapi.NdbOperation;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class OperationImpl
implements Operation {
    static final I18NHelper local = I18NHelper.getInstance(OperationImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(OperationImpl.class);
    private NdbOperation ndbOperation;
    protected List<Column> storeColumns = new ArrayList<Column>();
    protected ClusterTransactionImpl clusterTransaction;
    protected int bufferSize;
    protected int maximumColumnId;
    protected int[] offsets;
    protected int[] lengths;
    protected int maximumColumnLength;
    protected DbImpl.BufferManager bufferManager;

    public OperationImpl(NdbOperation operation, ClusterTransactionImpl transaction) {
        this.ndbOperation = operation;
        this.clusterTransaction = transaction;
        this.bufferManager = this.clusterTransaction.getBufferManager();
    }

    public OperationImpl(Table storeTable, NdbOperation operation, ClusterTransactionImpl transaction) {
        this(operation, transaction);
        TableImpl tableImpl = (TableImpl)storeTable;
        this.maximumColumnId = tableImpl.getMaximumColumnId();
        this.bufferSize = tableImpl.getBufferSize();
        this.offsets = tableImpl.getOffsets();
        this.lengths = tableImpl.getLengths();
        this.maximumColumnLength = tableImpl.getMaximumColumnLength();
    }

    @Override
    public void equalBigInteger(Column storeColumn, BigInteger value) {
        ByteBuffer buffer = Utility.convertValue(storeColumn, value);
        int returnCode = this.ndbOperation.equal(storeColumn.getName(), buffer);
        this.handleError(returnCode, this.ndbOperation);
    }

    @Override
    public void equalBoolean(Column storeColumn, boolean booleanValue) {
        int value = booleanValue ? 1 : 0;
        int returnCode = this.ndbOperation.equal(storeColumn.getName(), value);
        this.handleError(returnCode, this.ndbOperation);
    }

    @Override
    public void equalByte(Column storeColumn, byte value) {
        int storeValue = Utility.convertByteValueForStorage(storeColumn, value);
        int returnCode = this.ndbOperation.equal(storeColumn.getName(), storeValue);
        this.handleError(returnCode, this.ndbOperation);
    }

    @Override
    public void equalBytes(Column storeColumn, byte[] value) {
        if (logger.isDetailEnabled()) {
            logger.detail("Column: " + storeColumn.getName() + " columnId: " + storeColumn.getColumnId() + " data length: " + value.length);
        }
        ByteBuffer buffer = Utility.convertValue(storeColumn, value);
        int returnCode = this.ndbOperation.equal(storeColumn.getName(), buffer);
        this.handleError(returnCode, this.ndbOperation);
    }

    @Override
    public void equalDecimal(Column storeColumn, BigDecimal value) {
        ByteBuffer buffer = Utility.convertValue(storeColumn, value);
        int returnCode = this.ndbOperation.equal(storeColumn.getName(), buffer);
        this.handleError(returnCode, this.ndbOperation);
    }

    @Override
    public void equalDouble(Column storeColumn, double value) {
        ByteBuffer buffer = Utility.convertValue(storeColumn, value);
        int returnCode = this.ndbOperation.equal(storeColumn.getName(), buffer);
        this.handleError(returnCode, this.ndbOperation);
    }

    @Override
    public void equalFloat(Column storeColumn, float value) {
        ByteBuffer buffer = Utility.convertValue(storeColumn, value);
        int returnCode = this.ndbOperation.equal(storeColumn.getName(), buffer);
        this.handleError(returnCode, this.ndbOperation);
    }

    @Override
    public void equalInt(Column storeColumn, int value) {
        int returnCode = this.ndbOperation.equal(storeColumn.getName(), value);
        this.handleError(returnCode, this.ndbOperation);
    }

    @Override
    public void equalShort(Column storeColumn, short value) {
        int storeValue = Utility.convertShortValueForStorage(storeColumn, value);
        int returnCode = this.ndbOperation.equal(storeColumn.getName(), storeValue);
        this.handleError(returnCode, this.ndbOperation);
    }

    @Override
    public void equalLong(Column storeColumn, long value) {
        long storeValue = Utility.convertLongValueForStorage(storeColumn, value);
        int returnCode = this.ndbOperation.equal(storeColumn.getName(), storeValue);
        this.handleError(returnCode, this.ndbOperation);
    }

    @Override
    public void equalString(Column storeColumn, String value) {
        ByteBuffer stringStorageBuffer = Utility.encode(value, storeColumn, this.bufferManager);
        int returnCode = this.ndbOperation.equal(storeColumn.getName(), stringStorageBuffer);
        this.bufferManager.clearStringStorageBuffer();
        this.handleError(returnCode, this.ndbOperation);
    }

    @Override
    public void getBlob(Column storeColumn) {
        NdbBlob ndbBlob = this.ndbOperation.getBlobHandleM(storeColumn.getColumnId());
        OperationImpl.handleError(ndbBlob, this.ndbOperation);
    }

    @Override
    public Blob getBlobHandle(Column storeColumn) {
        NdbBlob blobHandle = this.ndbOperation.getBlobHandleM(storeColumn.getColumnId());
        OperationImpl.handleError(blobHandle, this.ndbOperation);
        return new BlobImpl(blobHandle);
    }

    @Override
    public void getValue(Column storeColumn) {
        this.storeColumns.add(storeColumn);
    }

    @Override
    public void postExecuteCallback(Runnable callback) {
        this.clusterTransaction.postExecuteCallback(callback);
    }

    @Override
    public ResultData resultData() {
        return this.resultData(true);
    }

    @Override
    public ResultData resultData(boolean execute) {
        ResultDataImpl result;
        if (logger.isDetailEnabled()) {
            logger.detail("storeColumns: " + Arrays.toString(this.storeColumns.toArray()));
        }
        if (execute) {
            result = new ResultDataImpl(this.ndbOperation, this.storeColumns, this.maximumColumnId, this.bufferSize, this.offsets, this.lengths, this.bufferManager, false);
            this.clusterTransaction.executeNoCommit(false, true);
        } else {
            result = new ResultDataImpl(this.ndbOperation, this.storeColumns, this.maximumColumnId, this.bufferSize, this.offsets, this.lengths, this.bufferManager, true);
        }
        return result;
    }

    @Override
    public void setBigInteger(Column storeColumn, BigInteger value) {
        ByteBuffer buffer = Utility.convertValue(storeColumn, value);
        int returnCode = this.ndbOperation.setValue(storeColumn.getColumnId(), buffer);
        this.handleError(returnCode, this.ndbOperation);
    }

    @Override
    public void setBoolean(Column storeColumn, Boolean value) {
        byte byteValue = value != false ? (byte)1 : 0;
        this.setByte(storeColumn, byteValue);
    }

    @Override
    public void setByte(Column storeColumn, byte value) {
        int storeValue = Utility.convertByteValueForStorage(storeColumn, value);
        int returnCode = this.ndbOperation.setValue(storeColumn.getColumnId(), storeValue);
        this.handleError(returnCode, this.ndbOperation);
    }

    @Override
    public void setBytes(Column storeColumn, byte[] value) {
        int length = value.length;
        if (length > storeColumn.getLength()) {
            throw new ClusterJUserException(local.message("ERR_Data_Too_Long", storeColumn.getName(), storeColumn.getLength(), length));
        }
        ByteBuffer buffer = Utility.convertValue(storeColumn, value);
        int returnCode = this.ndbOperation.setValue(storeColumn.getColumnId(), buffer);
        this.handleError(returnCode, this.ndbOperation);
    }

    @Override
    public void setDecimal(Column storeColumn, BigDecimal value) {
        ByteBuffer buffer = Utility.convertValue(storeColumn, value);
        int returnCode = this.ndbOperation.setValue(storeColumn.getColumnId(), buffer);
        this.handleError(returnCode, this.ndbOperation);
    }

    @Override
    public void setDouble(Column storeColumn, Double value) {
        int returnCode = this.ndbOperation.setValue(storeColumn.getColumnId(), (double)value);
        this.handleError(returnCode, this.ndbOperation);
    }

    @Override
    public void setFloat(Column storeColumn, Float value) {
        int returnCode = this.ndbOperation.setValue(storeColumn.getColumnId(), value.floatValue());
        this.handleError(returnCode, this.ndbOperation);
    }

    @Override
    public void setInt(Column storeColumn, Integer value) {
        int returnCode = this.ndbOperation.setValue(storeColumn.getColumnId(), (int)value);
        this.handleError(returnCode, this.ndbOperation);
    }

    @Override
    public void setLong(Column storeColumn, long value) {
        long storeValue = Utility.convertLongValueForStorage(storeColumn, value);
        int returnCode = this.ndbOperation.setValue(storeColumn.getColumnId(), storeValue);
        this.handleError(returnCode, this.ndbOperation);
    }

    @Override
    public void setNull(Column storeColumn) {
        int returnCode = this.ndbOperation.setValue(storeColumn.getColumnId(), null);
        this.handleError(returnCode, this.ndbOperation);
    }

    @Override
    public void setShort(Column storeColumn, Short value) {
        int storeValue = Utility.convertShortValueForStorage(storeColumn, value);
        int returnCode = this.ndbOperation.setValue(storeColumn.getName(), storeValue);
        this.handleError(returnCode, this.ndbOperation);
    }

    @Override
    public void setString(Column storeColumn, String value) {
        ByteBuffer stringStorageBuffer = Utility.encode(value, storeColumn, this.bufferManager);
        int length = stringStorageBuffer.remaining() - storeColumn.getPrefixLength();
        if (length > storeColumn.getLength()) {
            throw new ClusterJUserException(local.message("ERR_Data_Too_Long", storeColumn.getName(), storeColumn.getLength(), length));
        }
        int returnCode = this.ndbOperation.setValue(storeColumn.getColumnId(), stringStorageBuffer);
        this.bufferManager.clearStringStorageBuffer();
        this.handleError(returnCode, this.ndbOperation);
    }

    @Override
    public int errorCode() {
        return this.ndbOperation.getNdbError().code();
    }

    protected void handleError(int returnCode, NdbOperation ndbOperation) {
        if (returnCode == 0) {
            return;
        }
        Utility.throwError(returnCode, ndbOperation.getNdbError());
    }

    protected static void handleError(Object object, NdbOperation ndbOperation) {
        if (object != null) {
            return;
        }
        Utility.throwError(null, ndbOperation.getNdbError());
    }

    @Override
    public void beginDefinition() {
    }

    @Override
    public void endDefinition() {
    }

    @Override
    public int getErrorCode() {
        return this.ndbOperation.getNdbError().code();
    }

    @Override
    public int getClassification() {
        return this.ndbOperation.getNdbError().classification();
    }

    @Override
    public int getMysqlCode() {
        return this.ndbOperation.getNdbError().mysql_code();
    }

    @Override
    public int getStatus() {
        return this.ndbOperation.getNdbError().status();
    }

    @Override
    public void freeResourcesAfterExecute() {
    }
}

