/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.ColumnMetadata;
import com.mysql.clusterj.core.CacheManager;
import com.mysql.clusterj.core.metadata.DomainTypeHandlerImpl;
import com.mysql.clusterj.core.metadata.InvocationHandlerImpl;
import com.mysql.clusterj.core.spi.DomainFieldHandler;
import com.mysql.clusterj.core.spi.DomainTypeHandler;
import com.mysql.clusterj.core.spi.SmartValueHandler;
import com.mysql.clusterj.core.spi.ValueHandler;
import com.mysql.clusterj.core.store.ClusterTransaction;
import com.mysql.clusterj.core.store.Db;
import com.mysql.clusterj.core.store.Operation;
import com.mysql.clusterj.core.store.ResultData;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.tie.ClusterTransactionImpl;
import com.mysql.clusterj.tie.DbImpl;
import com.mysql.clusterj.tie.NdbRecordBlobImpl;
import com.mysql.clusterj.tie.NdbRecordOperationImpl;
import com.mysql.clusterj.tie.NdbRecordResultDataImpl;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public class NdbRecordSmartValueHandlerImpl
implements SmartValueHandler {
    static final I18NHelper local = I18NHelper.getInstance(InvocationHandlerImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(InvocationHandlerImpl.class);
    protected NdbRecordOperationImpl operation;
    protected DomainTypeHandlerImpl<?> domainTypeHandler;
    protected DomainFieldHandler[] domainFieldHandlers;
    private int[] fieldNumberToColumnNumberMap;
    private Boolean found = null;
    private int numberOfTransientFields;
    private Object[] transientValues = null;
    private boolean[] transientModified;
    private Object proxy;

    public NdbRecordSmartValueHandlerImpl(DomainTypeHandlerImpl<?> domainTypeHandler) {
        this.domainTypeHandler = domainTypeHandler;
        this.domainFieldHandlers = domainTypeHandler.getFieldHandlers();
        this.fieldNumberToColumnNumberMap = domainTypeHandler.getFieldNumberToColumnNumberMap();
        this.numberOfTransientFields = domainTypeHandler.getNumberOfTransientFields();
        this.transientModified = new boolean[this.numberOfTransientFields];
        if (this.numberOfTransientFields != 0) {
            this.transientValues = this.domainTypeHandler.newTransientValues();
        }
    }

    public NdbRecordSmartValueHandlerImpl(DomainTypeHandlerImpl<?> domainTypeHandler, Db db) {
        this(domainTypeHandler);
        this.operation = ((DbImpl)db).newNdbRecordOperationImpl(domainTypeHandler.getStoreTable());
    }

    public NdbRecordSmartValueHandlerImpl(DomainTypeHandlerImpl<?> domainTypeHandler, Db db, ResultData resultData) {
        this(domainTypeHandler);
        this.operation = ((NdbRecordResultDataImpl)resultData).transformOperation();
    }

    @Override
    public Operation insert(ClusterTransaction clusterTransaction) {
        if (logger.isDetailEnabled()) {
            logger.detail("smart insert for type: " + this.domainTypeHandler.getName() + "\n" + this.operation.dumpValues());
        }
        ClusterTransactionImpl clusterTransactionImpl = (ClusterTransactionImpl)clusterTransaction;
        this.operation.insert(clusterTransactionImpl);
        return this.operation;
    }

    @Override
    public Operation delete(ClusterTransaction clusterTransaction) {
        if (logger.isDetailEnabled()) {
            logger.detail("smart delete for type: " + this.domainTypeHandler.getName() + "\n" + this.operation.dumpValues());
        }
        this.operation.delete((ClusterTransactionImpl)clusterTransaction);
        return this.operation;
    }

    @Override
    public Operation update(ClusterTransaction clusterTransaction) {
        if (logger.isDetailEnabled()) {
            logger.detail("smart update for type: " + this.domainTypeHandler.getName() + " record: " + this.operation.dumpValues());
        }
        this.operation.update((ClusterTransactionImpl)clusterTransaction);
        return this.operation;
    }

    @Override
    public Operation write(ClusterTransaction clusterTransaction) {
        if (logger.isDetailEnabled()) {
            logger.detail("smart write for type: " + this.domainTypeHandler.getName() + " record: " + this.operation.dumpValues());
        }
        this.operation.write((ClusterTransactionImpl)clusterTransaction);
        return this.operation;
    }

    @Override
    public Operation load(ClusterTransaction clusterTransaction) {
        if (logger.isDetailEnabled()) {
            logger.detail("smart load for type: " + this.domainTypeHandler.getName() + " record: " + this.operation.dumpValues());
        }
        for (int i = 0; i < this.domainFieldHandlers.length; ++i) {
            DomainFieldHandler domainFieldHandler = this.domainFieldHandlers[i];
            int columnId = this.fieldNumberToColumnNumberMap[i];
            if (!domainFieldHandler.isPersistent()) continue;
            if (domainFieldHandler.isLob()) {
                this.operation.getBlobHandle(columnId);
                continue;
            }
            this.operation.columnSet(columnId);
        }
        this.operation.load((ClusterTransactionImpl)clusterTransaction);
        final NdbRecordSmartValueHandlerImpl valueHandler = this;
        Runnable postExecuteOperation = new Runnable(){

            @Override
            public void run() {
                if (NdbRecordSmartValueHandlerImpl.this.operation.getErrorCode() == 0) {
                    valueHandler.found(Boolean.TRUE);
                    NdbRecordSmartValueHandlerImpl.this.operation.loadBlobValues();
                    NdbRecordSmartValueHandlerImpl.this.domainTypeHandler.objectResetModified(valueHandler);
                } else {
                    valueHandler.found(Boolean.FALSE);
                }
            }
        };
        clusterTransaction.postExecuteCallback(postExecuteOperation);
        return this.operation;
    }

    @Override
    public BigDecimal getBigDecimal(int fieldNumber) {
        int columnId = this.fieldNumberToColumnNumberMap[fieldNumber];
        if (columnId >= 0) {
            return this.operation.getDecimal(columnId);
        }
        return (BigDecimal)this.transientValues[-1 - columnId];
    }

    @Override
    public BigInteger getBigInteger(int fieldNumber) {
        int columnId = this.fieldNumberToColumnNumberMap[fieldNumber];
        if (columnId >= 0) {
            return this.operation.getBigInteger(columnId);
        }
        return (BigInteger)this.transientValues[-1 - columnId];
    }

    @Override
    public boolean getBoolean(int fieldNumber) {
        int columnId = this.fieldNumberToColumnNumberMap[fieldNumber];
        if (columnId >= 0) {
            return this.operation.getBoolean(columnId);
        }
        Boolean value = (Boolean)this.transientValues[-1 - columnId];
        return value == null ? false : value;
    }

    @Override
    public boolean[] getBooleans(int fieldNumber) {
        throw new ClusterJFatalInternalException(local.message("ERR_Method_Not_Implemented", (Object)"NdbRecordSmartValueHandler.getBooleans(int)"));
    }

    @Override
    public byte getByte(int fieldNumber) {
        int columnId = this.fieldNumberToColumnNumberMap[fieldNumber];
        if (columnId >= 0) {
            return this.operation.getByte(columnId);
        }
        Byte value = (Byte)this.transientValues[-1 - columnId];
        return value == null ? (byte)0 : value;
    }

    @Override
    public byte[] getBytes(int fieldNumber) {
        int columnId = this.fieldNumberToColumnNumberMap[fieldNumber];
        if (columnId >= 0) {
            return this.operation.getBytes(columnId);
        }
        return (byte[])this.transientValues[-1 - columnId];
    }

    @Override
    public double getDouble(int fieldNumber) {
        int columnId = this.fieldNumberToColumnNumberMap[fieldNumber];
        if (columnId >= 0) {
            return this.operation.getDouble(columnId);
        }
        Double value = (Double)this.transientValues[-1 - columnId];
        return value == null ? 0.0 : value;
    }

    @Override
    public float getFloat(int fieldNumber) {
        int columnId = this.fieldNumberToColumnNumberMap[fieldNumber];
        if (columnId >= 0) {
            return this.operation.getFloat(columnId);
        }
        Float value = (Float)this.transientValues[-1 - columnId];
        return value == null ? 0.0f : value.floatValue();
    }

    @Override
    public int getInt(int fieldNumber) {
        int columnId = this.fieldNumberToColumnNumberMap[fieldNumber];
        if (columnId >= 0) {
            int result = this.operation.getInt(columnId);
            return result;
        }
        Integer value = (Integer)this.transientValues[-1 - columnId];
        return value == null ? 0 : value;
    }

    @Override
    public Date getJavaSqlDate(int fieldNumber) {
        int columnId = this.fieldNumberToColumnNumberMap[fieldNumber];
        if (columnId >= 0) {
            Long millis = this.operation.getObjectLong(columnId);
            return millis == null ? null : new Date(millis);
        }
        return (Date)this.transientValues[-1 - columnId];
    }

    @Override
    public Time getJavaSqlTime(int fieldNumber) {
        int columnId = this.fieldNumberToColumnNumberMap[fieldNumber];
        if (columnId >= 0) {
            Long millis = this.operation.getObjectLong(columnId);
            return millis == null ? null : new Time(millis);
        }
        return (Time)this.transientValues[-1 - columnId];
    }

    @Override
    public Timestamp getJavaSqlTimestamp(int fieldNumber) {
        int columnId = this.fieldNumberToColumnNumberMap[fieldNumber];
        if (columnId >= 0) {
            Long millis = this.operation.getObjectLong(columnId);
            return millis == null ? null : new Timestamp(millis);
        }
        return (Timestamp)this.transientValues[-1 - columnId];
    }

    @Override
    public java.util.Date getJavaUtilDate(int fieldNumber) {
        int columnId = this.fieldNumberToColumnNumberMap[fieldNumber];
        if (columnId >= 0) {
            Long millis = this.operation.getObjectLong(columnId);
            return millis == null ? null : new java.util.Date(millis);
        }
        return (java.util.Date)this.transientValues[-1 - columnId];
    }

    @Override
    public byte[] getLobBytes(int fieldNumber) {
        int columnId = this.fieldNumberToColumnNumberMap[fieldNumber];
        NdbRecordBlobImpl blob = this.operation.getBlobHandle(columnId);
        return blob.getBytesData();
    }

    @Override
    public String getLobString(int fieldNumber) {
        int columnId = this.fieldNumberToColumnNumberMap[fieldNumber];
        NdbRecordBlobImpl blob = this.operation.getBlobHandle(columnId);
        String result = blob.getStringData();
        return result;
    }

    @Override
    public long getLong(int fieldNumber) {
        int columnId = this.fieldNumberToColumnNumberMap[fieldNumber];
        if (columnId >= 0) {
            return this.operation.getLong(columnId);
        }
        Long value = (Long)this.transientValues[-1 - columnId];
        return value == null ? 0L : value;
    }

    @Override
    public Boolean getObjectBoolean(int fieldNumber) {
        int columnId = this.fieldNumberToColumnNumberMap[fieldNumber];
        if (columnId >= 0) {
            return this.operation.getObjectBoolean(columnId);
        }
        return (Boolean)this.transientValues[-1 - columnId];
    }

    @Override
    public Byte getObjectByte(int fieldNumber) {
        int columnId = this.fieldNumberToColumnNumberMap[fieldNumber];
        if (columnId >= 0) {
            return this.operation.getObjectByte(columnId);
        }
        return (Byte)this.transientValues[-1 - columnId];
    }

    @Override
    public Double getObjectDouble(int fieldNumber) {
        int columnId = this.fieldNumberToColumnNumberMap[fieldNumber];
        if (columnId >= 0) {
            return this.operation.getObjectDouble(columnId);
        }
        return (Double)this.transientValues[-1 - columnId];
    }

    @Override
    public Float getObjectFloat(int fieldNumber) {
        int columnId = this.fieldNumberToColumnNumberMap[fieldNumber];
        if (columnId >= 0) {
            return this.operation.getObjectFloat(columnId);
        }
        return (Float)this.transientValues[-1 - columnId];
    }

    @Override
    public Integer getObjectInt(int fieldNumber) {
        int columnId = this.fieldNumberToColumnNumberMap[fieldNumber];
        if (columnId >= 0) {
            return this.operation.getObjectInteger(columnId);
        }
        return (Integer)this.transientValues[-1 - columnId];
    }

    @Override
    public Long getObjectLong(int fieldNumber) {
        int columnId = this.fieldNumberToColumnNumberMap[fieldNumber];
        if (columnId >= 0) {
            return this.operation.getObjectLong(columnId);
        }
        return (Long)this.transientValues[-1 - columnId];
    }

    @Override
    public Short getObjectShort(int fieldNumber) {
        int columnId = this.fieldNumberToColumnNumberMap[fieldNumber];
        if (columnId >= 0) {
            return this.operation.getObjectShort(columnId);
        }
        return (Short)this.transientValues[-1 - columnId];
    }

    @Override
    public short getShort(int fieldNumber) {
        int columnId = this.fieldNumberToColumnNumberMap[fieldNumber];
        if (columnId >= 0) {
            return this.operation.getShort(columnId);
        }
        Short value = (Short)this.transientValues[-1 - columnId];
        return value == null ? (short)0 : value;
    }

    @Override
    public String getString(int fieldNumber) {
        int columnId = this.fieldNumberToColumnNumberMap[fieldNumber];
        if (columnId >= 0) {
            return this.operation.getString(columnId);
        }
        return (String)this.transientValues[-1 - columnId];
    }

    @Override
    public boolean isModified(int fieldNumber) {
        int columnId = this.fieldNumberToColumnNumberMap[fieldNumber];
        if (columnId >= 0) {
            return this.operation.isModified(columnId);
        }
        return this.transientModified[-1 - columnId];
    }

    @Override
    public boolean isNull(int fieldNumber) {
        int columnId = this.fieldNumberToColumnNumberMap[fieldNumber];
        if (columnId >= 0) {
            return this.operation.isNull(columnId);
        }
        return this.transientValues[-1 - columnId] == null;
    }

    @Override
    public void markModified(int fieldNumber) {
        int columnId = this.fieldNumberToColumnNumberMap[fieldNumber];
        if (columnId >= 0) {
            this.operation.markModified(columnId);
            return;
        }
        this.transientModified[-1 - columnId] = true;
    }

    @Override
    public String pkToString(DomainTypeHandler<?> domainTypeHandler) {
        return null;
    }

    @Override
    public void resetModified() {
        this.operation.resetModified();
        this.transientModified = new boolean[this.numberOfTransientFields];
    }

    @Override
    public void setBigDecimal(int fieldNumber, BigDecimal value) {
        int columnId = this.fieldNumberToColumnNumberMap[fieldNumber];
        if (columnId >= 0) {
            this.operation.setDecimal(columnId, value);
        } else {
            this.transientValues[-1 - columnId] = value;
            this.transientModified[-1 - columnId] = true;
        }
    }

    @Override
    public void setBigInteger(int fieldNumber, BigInteger bigIntegerExact) {
        int columnId = this.fieldNumberToColumnNumberMap[fieldNumber];
        if (columnId >= 0) {
            this.operation.setBigInteger(columnId, bigIntegerExact);
        } else {
            this.transientValues[-1 - columnId] = bigIntegerExact;
            this.transientModified[-1 - columnId] = true;
        }
    }

    @Override
    public void setBoolean(int fieldNumber, boolean b) {
        int columnId = this.fieldNumberToColumnNumberMap[fieldNumber];
        if (columnId >= 0) {
            this.operation.setBoolean(columnId, b);
        } else {
            this.transientValues[-1 - columnId] = b;
            this.transientModified[-1 - columnId] = true;
        }
    }

    @Override
    public void setBooleans(int fieldNumber, boolean[] b) {
        throw new ClusterJFatalInternalException(local.message("ERR_Method_Not_Implemented", (Object)"NdbRecordSmartValueHandler.setBooleans(int, boolean[])"));
    }

    @Override
    public void setByte(int fieldNumber, byte value) {
        int columnId = this.fieldNumberToColumnNumberMap[fieldNumber];
        if (columnId >= 0) {
            this.operation.setByte(columnId, value);
        } else {
            this.transientModified[-1 - columnId] = true;
            this.transientValues[-1 - columnId] = value;
        }
    }

    @Override
    public void setBytes(int fieldNumber, byte[] value) {
        int columnId = this.fieldNumberToColumnNumberMap[fieldNumber];
        if (columnId >= 0) {
            this.operation.setBytes(columnId, value);
        } else {
            this.transientValues[-1 - columnId] = value;
            this.transientModified[-1 - columnId] = true;
        }
    }

    @Override
    public void setDouble(int fieldNumber, double value) {
        int columnId = this.fieldNumberToColumnNumberMap[fieldNumber];
        if (columnId >= 0) {
            this.operation.setDouble(columnId, value);
        } else {
            this.transientValues[-1 - columnId] = value;
            this.transientModified[-1 - columnId] = true;
        }
    }

    @Override
    public void setFloat(int fieldNumber, float value) {
        int columnId = this.fieldNumberToColumnNumberMap[fieldNumber];
        if (columnId >= 0) {
            this.operation.setFloat(columnId, value);
        } else {
            this.transientValues[-1 - columnId] = Float.valueOf(value);
            this.transientModified[-1 - columnId] = true;
        }
    }

    @Override
    public void setInt(int fieldNumber, int value) {
        int columnId = this.fieldNumberToColumnNumberMap[fieldNumber];
        if (columnId >= 0) {
            this.operation.setInt(columnId, value);
        } else {
            this.transientValues[-1 - columnId] = value;
            this.transientModified[-1 - columnId] = true;
        }
    }

    @Override
    public void setJavaSqlDate(int fieldNumber, Date value) {
        int columnId = this.fieldNumberToColumnNumberMap[fieldNumber];
        if (value == null) {
            this.operation.setNull(columnId);
        } else {
            this.setLong(fieldNumber, value.getTime());
        }
    }

    @Override
    public void setJavaSqlTime(int fieldNumber, Time value) {
        int columnId = this.fieldNumberToColumnNumberMap[fieldNumber];
        if (value == null) {
            this.operation.setNull(columnId);
        } else {
            this.setLong(fieldNumber, value.getTime());
        }
    }

    @Override
    public void setJavaSqlTimestamp(int fieldNumber, Timestamp value) {
        int columnId = this.fieldNumberToColumnNumberMap[fieldNumber];
        if (value == null) {
            this.operation.setNull(columnId);
        } else {
            this.setLong(fieldNumber, value.getTime());
        }
    }

    @Override
    public void setJavaUtilDate(int fieldNumber, java.util.Date value) {
        int columnId = this.fieldNumberToColumnNumberMap[fieldNumber];
        if (value == null) {
            this.operation.setNull(columnId);
        } else {
            this.setLong(fieldNumber, value.getTime());
        }
    }

    @Override
    public void setLobBytes(int fieldNumber, byte[] value) {
        int columnId = this.fieldNumberToColumnNumberMap[fieldNumber];
        NdbRecordBlobImpl blob = this.operation.getBlobHandle(columnId);
        this.operation.columnSet(columnId);
        blob.setData(value);
    }

    @Override
    public void setLobString(int fieldNumber, String value) {
        int columnId = this.fieldNumberToColumnNumberMap[fieldNumber];
        NdbRecordBlobImpl blob = this.operation.getBlobHandle(columnId);
        this.operation.columnSet(columnId);
        blob.setData(value);
    }

    @Override
    public void setLong(int fieldNumber, long value) {
        int columnId = this.fieldNumberToColumnNumberMap[fieldNumber];
        if (columnId >= 0) {
            this.operation.setLong(columnId, value);
        } else {
            this.transientValues[-1 - columnId] = value;
            this.transientModified[-1 - columnId] = true;
        }
    }

    @Override
    public void setObject(int fieldNumber, Object value) {
        int columnId = this.fieldNumberToColumnNumberMap[fieldNumber];
        if (columnId >= 0) {
            throw new ClusterJFatalInternalException(local.message("ERR_Method_Not_Implemented", (Object)"NdbRecordSmartValueHandler.setObject(int, Object) for persistent values"));
        }
        this.transientValues[-1 - columnId] = value;
        this.transientModified[-1 - columnId] = true;
    }

    @Override
    public void setObjectBoolean(int fieldNumber, Boolean value) {
        int columnId = this.fieldNumberToColumnNumberMap[fieldNumber];
        if (columnId >= 0) {
            this.operation.setObjectBoolean(columnId, value);
        } else {
            this.transientValues[-1 - columnId] = value;
            this.transientModified[-1 - columnId] = true;
        }
    }

    @Override
    public void setObjectByte(int fieldNumber, Byte value) {
        int columnId = this.fieldNumberToColumnNumberMap[fieldNumber];
        if (columnId >= 0) {
            this.operation.setObjectByte(columnId, value);
        } else {
            this.transientValues[-1 - columnId] = value;
            this.transientModified[-1 - columnId] = true;
        }
    }

    @Override
    public void setObjectDouble(int fieldNumber, Double value) {
        int columnId = this.fieldNumberToColumnNumberMap[fieldNumber];
        if (columnId >= 0) {
            this.operation.setObjectDouble(columnId, value);
        } else {
            this.transientValues[-1 - columnId] = value;
            this.transientModified[-1 - columnId] = true;
        }
    }

    @Override
    public void setObjectFloat(int fieldNumber, Float value) {
        int columnId = this.fieldNumberToColumnNumberMap[fieldNumber];
        if (columnId >= 0) {
            this.operation.setObjectFloat(columnId, value);
        } else {
            this.transientValues[-1 - columnId] = value;
            this.transientModified[-1 - columnId] = true;
        }
    }

    @Override
    public void setObjectInt(int fieldNumber, Integer value) {
        int columnId = this.fieldNumberToColumnNumberMap[fieldNumber];
        if (columnId >= 0) {
            this.operation.setObjectInt(columnId, value);
        } else {
            this.transientValues[-1 - columnId] = value;
            this.transientModified[-1 - columnId] = true;
        }
    }

    @Override
    public void setObjectLong(int fieldNumber, Long value) {
        int columnId = this.fieldNumberToColumnNumberMap[fieldNumber];
        if (columnId >= 0) {
            this.operation.setObjectLong(columnId, value);
        } else {
            this.transientValues[-1 - columnId] = value;
            this.transientModified[-1 - columnId] = true;
        }
    }

    @Override
    public void setObjectShort(int fieldNumber, Short value) {
        int columnId = this.fieldNumberToColumnNumberMap[fieldNumber];
        if (columnId >= 0) {
            this.operation.setObjectShort(columnId, value);
        } else {
            this.transientValues[-1 - columnId] = value;
            this.transientModified[-1 - columnId] = true;
        }
    }

    @Override
    public void setShort(int fieldNumber, short value) {
        int columnId = this.fieldNumberToColumnNumberMap[fieldNumber];
        if (columnId >= 0) {
            this.operation.setObjectShort(columnId, value);
        } else {
            this.transientValues[-1 - columnId] = value;
            this.transientModified[-1 - columnId] = true;
        }
    }

    @Override
    public void setString(int fieldNumber, String value) {
        int columnId = this.fieldNumberToColumnNumberMap[fieldNumber];
        if (columnId >= 0) {
            this.operation.setString(columnId, value);
        } else {
            this.transientValues[-1 - columnId] = value;
            this.transientModified[-1 - columnId] = true;
        }
    }

    @Override
    public ColumnMetadata[] columnMetadata() {
        return this.domainTypeHandler.columnMetadata();
    }

    @Override
    public Boolean found() {
        return this.found;
    }

    @Override
    public void found(Boolean found) {
        this.found = found;
    }

    @Override
    public Object get(int fieldNumber) {
        int columnId = this.fieldNumberToColumnNumberMap[fieldNumber];
        if (columnId < 0) {
            return this.transientValues[-1 - columnId];
        }
        return this.domainFieldHandlers[fieldNumber].objectGetValue(this);
    }

    @Override
    public void set(int fieldNumber, Object value) {
        int columnId = this.fieldNumberToColumnNumberMap[fieldNumber];
        if (columnId < 0) {
            this.transientValues[-1 - columnId] = value;
            this.transientModified[-1 - columnId] = true;
        } else {
            this.domainFieldHandlers[fieldNumber].objectSetValue(value, (ValueHandler)this);
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (logger.isDetailEnabled()) {
            logger.detail("invoke with Method: " + method.getName());
        }
        String propertyHead = methodName.substring(3, 4);
        String propertyTail = methodName.substring(4);
        String propertyName = propertyHead.toLowerCase() + propertyTail;
        if (methodName.startsWith("get")) {
            int fieldNumber = this.domainTypeHandler.getFieldNumber(propertyName);
            Object result = this.get(fieldNumber);
            if (logger.isDetailEnabled()) {
                logger.detail(methodName + ": Returning field number " + fieldNumber + " value: " + result);
            }
            return result;
        }
        if (methodName.startsWith("set")) {
            if (logger.isDetailEnabled()) {
                logger.detail("Property name: " + propertyName + " value: " + args[0]);
            }
        } else {
            if ("toString".equals(methodName)) {
                return this.domainTypeHandler.getDomainClass().getName() + this.pkToString(this.domainTypeHandler);
            }
            if ("hashCode".equals(methodName)) {
                return this.hashCode();
            }
            throw new ClusterJUserException(local.message("ERR_Method_Name", (Object)methodName));
        }
        int fieldNumber = this.domainTypeHandler.getFieldNumber(propertyName);
        this.set(fieldNumber, args[0]);
        return null;
    }

    @Override
    public void setCacheManager(CacheManager cm) {
    }

    @Override
    public void setProxy(Object proxy) {
        this.proxy = proxy;
    }

    @Override
    public Object getProxy() {
        return this.proxy;
    }
}

