/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.core.query;

import com.mysql.clusterj.ClusterJException;
import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.core.query.AndPredicateImpl;
import com.mysql.clusterj.core.query.CandidateIndexImpl;
import com.mysql.clusterj.core.query.NotPredicateImpl;
import com.mysql.clusterj.core.query.OrPredicateImpl;
import com.mysql.clusterj.core.query.ParameterImpl;
import com.mysql.clusterj.core.query.PropertyImpl;
import com.mysql.clusterj.core.query.QueryDomainTypeImpl;
import com.mysql.clusterj.core.spi.QueryExecutionContext;
import com.mysql.clusterj.core.store.IndexScanOperation;
import com.mysql.clusterj.core.store.Operation;
import com.mysql.clusterj.core.store.ScanFilter;
import com.mysql.clusterj.core.store.ScanOperation;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.query.Predicate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;

public abstract class PredicateImpl
implements Predicate {
    static final I18NHelper local = I18NHelper.getInstance(PredicateImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(PredicateImpl.class);
    protected QueryDomainTypeImpl<?> dobj;
    CandidateIndexImpl uniqueIndex;
    Comparator<CandidateIndexImpl> candidateIndexComparator = new Comparator<CandidateIndexImpl>(){

        @Override
        public int compare(CandidateIndexImpl o1, CandidateIndexImpl o2) {
            int scoreDifference = o2.score - o1.score;
            if (scoreDifference != 0) {
                return scoreDifference;
            }
            return o1.hashCode() - o2.hashCode();
        }
    };
    private TreeSet<CandidateIndexImpl> scoredCandidateIndices = new TreeSet<CandidateIndexImpl>(this.candidateIndexComparator);
    public static int NO_BOUND_SET = 0;
    public static int LOWER_BOUND_SET = 1;
    public static int UPPER_BOUND_SET = 2;
    public static int BOTH_BOUNDS_SET = 3;

    public PredicateImpl(QueryDomainTypeImpl<?> dobj) {
        this.dobj = dobj;
    }

    @Override
    public Predicate or(Predicate other) {
        this.assertPredicateImpl(other);
        PredicateImpl otherPredicateImpl = (PredicateImpl)other;
        this.assertIdenticalDomainObject(otherPredicateImpl, "or");
        return new OrPredicateImpl(this.dobj, this, otherPredicateImpl);
    }

    @Override
    public Predicate and(Predicate other) {
        this.assertPredicateImpl(other);
        PredicateImpl predicateImpl = (PredicateImpl)other;
        this.assertIdenticalDomainObject(predicateImpl, "and");
        if (other instanceof AndPredicateImpl) {
            AndPredicateImpl andPredicateImpl = (AndPredicateImpl)other;
            return andPredicateImpl.and(this);
        }
        return new AndPredicateImpl(this.dobj, this, predicateImpl);
    }

    @Override
    public Predicate not() {
        return new NotPredicateImpl(this);
    }

    void markBoundsForCandidateIndices(QueryExecutionContext context, CandidateIndexImpl[] candidateIndices) {
    }

    public int operationSetBounds(QueryExecutionContext context, IndexScanOperation op, boolean lastColumn) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    public int operationSetLowerBound(QueryExecutionContext context, IndexScanOperation op, boolean lastColumn) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    public int operationSetUpperBound(QueryExecutionContext context, IndexScanOperation op, boolean lastColumn) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    public void operationEqual(QueryExecutionContext context, Operation op) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    public void operationEqualFor(QueryExecutionContext context, Operation op, String indexName) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    public void objectSetValuesFor(QueryExecutionContext context, Object row, String indexName) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    public void filterCmpValue(QueryExecutionContext context, ScanOperation op) {
        try {
            ScanFilter filter = op.getScanFilter(context);
            filter.begin();
            this.filterCmpValue(context, op, filter);
            filter.end();
        }
        catch (ClusterJException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ClusterJException(local.message("ERR_Get_NdbFilter"), ex);
        }
    }

    public void filterCmpValue(QueryExecutionContext context, ScanOperation op, ScanFilter filter) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    public void assertIdenticalDomainObject(PredicateImpl other, String venue) {
        QueryDomainTypeImpl<?> otherDomainObject = other.getDomainObject();
        if (this.dobj != otherDomainObject) {
            throw new ClusterJUserException(local.message("ERR_Wrong_Domain_Object", (Object)venue));
        }
    }

    void setSatisfied() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void markParameters() {
    }

    public void unmarkParameters() {
    }

    private void assertPredicateImpl(Predicate other) {
        if (!(other instanceof PredicateImpl)) {
            throw new UnsupportedOperationException(local.message("ERR_NotImplemented"));
        }
    }

    private QueryDomainTypeImpl<?> getDomainObject() {
        return this.dobj;
    }

    public CandidateIndexImpl getBestCandidateIndex(QueryExecutionContext context, String[] orderingFields) {
        return this.getBestCandidateIndexFor(context, this.getTopLevelPredicates(), orderingFields);
    }

    protected CandidateIndexImpl getBestCandidateIndexFor(QueryExecutionContext context, PredicateImpl[] predicates, String[] orderingFields) {
        if (this.uniqueIndex != null && this.uniqueIndex.isUsable(context, null) > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("usable unique index: " + this.uniqueIndex.getIndexName());
            }
            return this.uniqueIndex;
        }
        CandidateIndexImpl lastResort = null;
        for (CandidateIndexImpl index : this.scoredCandidateIndices) {
            int usability = index.isUsable(context, orderingFields);
            if (logger.isDebugEnabled()) {
                logger.debug("index " + index.getIndexName() + " usability: " + usability);
            }
            if (usability > 0) {
                return index;
            }
            if (usability != 0 || index.isUnique()) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("last resort: " + lastResort.getIndexName());
            }
            lastResort = index;
        }
        return lastResort != null && orderingFields != null ? lastResort : CandidateIndexImpl.getIndexForNullWhereClause();
    }

    protected int getNumberOfConditionsInPredicate() {
        return 1;
    }

    public void prepare() {
        CandidateIndexImpl[] candidateIndices = this.dobj.createCandidateIndexes();
        for (PredicateImpl predicateImpl : this.getTopLevelPredicates()) {
            predicateImpl.markBoundsForCandidateIndices(candidateIndices);
        }
        int numberOfConditions = this.getNumberOfConditionsInPredicate();
        for (CandidateIndexImpl candidateIndex : candidateIndices) {
            if (!candidateIndex.supportsConditionsOfLength(numberOfConditions)) continue;
            candidateIndex.score();
            int score = candidateIndex.getScore();
            if (score != 0) {
                if (candidateIndex.isUnique()) {
                    this.uniqueIndex = candidateIndex;
                } else {
                    this.scoredCandidateIndices.add(candidateIndex);
                }
            }
            if (!logger.isDetailEnabled()) continue;
            logger.detail("Score: " + score + " from " + candidateIndex.getIndexName());
        }
    }

    protected void markBoundsForCandidateIndices(CandidateIndexImpl[] candidateIndices) {
    }

    protected PredicateImpl[] getTopLevelPredicates() {
        return new PredicateImpl[]{this};
    }

    public List<String> getTopLevelPropertyNames() {
        PredicateImpl[] predicates;
        ArrayList<String> result = new ArrayList<String>();
        for (PredicateImpl predicate : predicates = this.getTopLevelPredicates()) {
            PropertyImpl property = predicate.getProperty();
            if (property == null) continue;
            result.add(property.fmd.getName());
        }
        return result;
    }

    public ParameterImpl getParameter() {
        return null;
    }

    protected PropertyImpl getProperty() {
        return null;
    }

    public boolean isUsable(QueryExecutionContext context) {
        return false;
    }

    protected static enum ScanType {
        INDEX_SCAN,
        TABLE_SCAN,
        UNIQUE_KEY,
        PRIMARY_KEY;

    }
}

