/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.core.query;

import com.mysql.clusterj.ClusterJException;
import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.core.query.BetweenPredicateImpl;
import com.mysql.clusterj.core.query.ComparativePredicateImpl;
import com.mysql.clusterj.core.query.EqualPredicateImpl;
import com.mysql.clusterj.core.query.InPredicateImpl;
import com.mysql.clusterj.core.query.NotPredicateImpl;
import com.mysql.clusterj.core.query.OrPredicateImpl;
import com.mysql.clusterj.core.query.PredicateImpl;
import com.mysql.clusterj.core.query.QueryDomainTypeImpl;
import com.mysql.clusterj.core.spi.QueryExecutionContext;
import com.mysql.clusterj.core.store.Operation;
import com.mysql.clusterj.core.store.ScanFilter;
import com.mysql.clusterj.core.store.ScanOperation;
import com.mysql.clusterj.query.Predicate;
import java.util.ArrayList;
import java.util.List;

public class AndPredicateImpl
extends PredicateImpl {
    List<PredicateImpl> predicates = new ArrayList<PredicateImpl>();

    public AndPredicateImpl(QueryDomainTypeImpl<?> dobj, PredicateImpl left, PredicateImpl right) {
        super(dobj);
        this.predicates.add(left);
        this.predicates.add(right);
    }

    @Override
    public Predicate and(Predicate predicate) {
        if (predicate instanceof ComparativePredicateImpl) {
            this.predicates.add((PredicateImpl)predicate);
            return this;
        }
        if (predicate instanceof AndPredicateImpl) {
            this.predicates.addAll(((AndPredicateImpl)predicate).predicates);
            return this;
        }
        if (predicate instanceof OrPredicateImpl) {
            this.predicates.add((PredicateImpl)predicate);
            return this;
        }
        if (predicate instanceof InPredicateImpl) {
            this.predicates.add((PredicateImpl)predicate);
            return this;
        }
        if (predicate instanceof NotPredicateImpl) {
            this.predicates.add((PredicateImpl)predicate);
            return this;
        }
        if (predicate instanceof BetweenPredicateImpl) {
            this.predicates.add((PredicateImpl)predicate);
            return this;
        }
        throw new UnsupportedOperationException(local.message("ERR_NotImplemented"));
    }

    @Override
    public Predicate or(Predicate predicate) {
        throw new UnsupportedOperationException(local.message("ERR_NotImplemented"));
    }

    @Override
    public Predicate not() {
        throw new UnsupportedOperationException(local.message("ERR_NotImplemented"));
    }

    @Override
    public void markParameters() {
        for (PredicateImpl predicateImpl : this.predicates) {
            predicateImpl.markParameters();
        }
    }

    @Override
    public void unmarkParameters() {
        for (PredicateImpl predicateImpl : this.predicates) {
            predicateImpl.unmarkParameters();
        }
    }

    @Override
    public void filterCmpValue(QueryExecutionContext context, ScanOperation op) {
        try {
            ScanFilter filter = op.getScanFilter(context);
            filter.begin(ScanFilter.Group.GROUP_AND);
            for (PredicateImpl predicate : this.predicates) {
                predicate.filterCmpValue(context, op, filter);
            }
            filter.end();
        }
        catch (Exception ex) {
            throw new ClusterJException(local.message("ERR_Get_NdbFilter"), ex);
        }
    }

    @Override
    public void operationEqual(QueryExecutionContext context, Operation op) {
        for (PredicateImpl predicate : this.predicates) {
            if (!(predicate instanceof EqualPredicateImpl)) {
                throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
            }
            predicate.operationEqual(context, op);
        }
    }

    @Override
    protected int getNumberOfConditionsInPredicate() {
        return this.predicates.size();
    }

    @Override
    protected PredicateImpl[] getTopLevelPredicates() {
        return this.predicates.toArray(new PredicateImpl[this.predicates.size()]);
    }
}

