/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.core.query;

import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.core.query.BetweenPredicateImpl;
import com.mysql.clusterj.core.query.CandidateIndexImpl;
import com.mysql.clusterj.core.query.EqualPredicateImpl;
import com.mysql.clusterj.core.query.GreaterEqualPredicateImpl;
import com.mysql.clusterj.core.query.GreaterThanPredicateImpl;
import com.mysql.clusterj.core.query.InPredicateImpl;
import com.mysql.clusterj.core.query.IsNotNullPredicateImpl;
import com.mysql.clusterj.core.query.IsNullPredicateImpl;
import com.mysql.clusterj.core.query.LessEqualPredicateImpl;
import com.mysql.clusterj.core.query.LessThanPredicateImpl;
import com.mysql.clusterj.core.query.LikePredicateImpl;
import com.mysql.clusterj.core.query.ParameterImpl;
import com.mysql.clusterj.core.query.PredicateImpl;
import com.mysql.clusterj.core.query.QueryDomainTypeImpl;
import com.mysql.clusterj.core.spi.DomainFieldHandler;
import com.mysql.clusterj.core.spi.QueryExecutionContext;
import com.mysql.clusterj.core.store.IndexScanOperation;
import com.mysql.clusterj.core.store.Operation;
import com.mysql.clusterj.core.store.ScanFilter;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.query.Predicate;
import com.mysql.clusterj.query.PredicateOperand;

public class PropertyImpl
implements PredicateOperand {
    static final I18NHelper local = I18NHelper.getInstance(PropertyImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(PropertyImpl.class);
    protected QueryDomainTypeImpl<?> dobj;
    protected DomainFieldHandler fmd;
    private boolean complexParameter = false;

    public PropertyImpl(QueryDomainTypeImpl<?> dobj, DomainFieldHandler fmd) {
        this.dobj = dobj;
        this.fmd = fmd;
    }

    public String toString() {
        return this.fmd.getName();
    }

    public void setComplexParameter() {
        this.complexParameter = true;
    }

    public void operationSetBounds(Object value, IndexScanOperation.BoundType type, IndexScanOperation op) {
        this.fmd.operationSetBounds(value, type, op);
    }

    public void operationEqual(Object value, Operation op) {
        this.fmd.operationEqual(value, op);
    }

    void objectSetValuesFor(Object value, Object row, String indexName) {
        this.fmd.objectSetValueFor(value, row, indexName);
    }

    void operationEqualFor(Object parameterValue, Operation op, String indexName) {
        this.fmd.operationEqualForIndex(parameterValue, op, indexName);
    }

    public void filterCmpValue(Object value, ScanFilter.BinaryCondition condition, ScanFilter filter) {
        this.fmd.filterCompareValue(value, condition, filter);
    }

    @Override
    public Predicate equal(PredicateOperand other) {
        if (!(other instanceof ParameterImpl)) {
            throw new ClusterJUserException(local.message("ERR_Only_Parameters", (Object)"equal"));
        }
        return new EqualPredicateImpl(this.dobj, this, (ParameterImpl)other);
    }

    @Override
    public Predicate between(PredicateOperand lower, PredicateOperand upper) {
        if (!(lower instanceof ParameterImpl) || !(upper instanceof ParameterImpl)) {
            throw new ClusterJUserException(local.message("ERR_Only_Parameters", (Object)"between"));
        }
        return new BetweenPredicateImpl(this.dobj, this, (ParameterImpl)lower, (ParameterImpl)upper);
    }

    @Override
    public Predicate greaterThan(PredicateOperand other) {
        if (!(other instanceof ParameterImpl)) {
            throw new ClusterJUserException(local.message("ERR_Only_Parameters", (Object)"greaterThan"));
        }
        return new GreaterThanPredicateImpl(this.dobj, this, (ParameterImpl)other);
    }

    @Override
    public Predicate greaterEqual(PredicateOperand other) {
        if (!(other instanceof ParameterImpl)) {
            throw new ClusterJUserException(local.message("ERR_Only_Parameters", (Object)"greaterEqual"));
        }
        return new GreaterEqualPredicateImpl(this.dobj, this, (ParameterImpl)other);
    }

    @Override
    public Predicate lessThan(PredicateOperand other) {
        if (!(other instanceof ParameterImpl)) {
            throw new ClusterJUserException(local.message("ERR_Only_Parameters", (Object)"lessThan"));
        }
        return new LessThanPredicateImpl(this.dobj, this, (ParameterImpl)other);
    }

    @Override
    public Predicate lessEqual(PredicateOperand other) {
        if (!(other instanceof ParameterImpl)) {
            throw new ClusterJUserException(local.message("ERR_Only_Parameters", (Object)"lessEqual"));
        }
        return new LessEqualPredicateImpl(this.dobj, this, (ParameterImpl)other);
    }

    @Override
    public Predicate in(PredicateOperand other) {
        if (!(other instanceof ParameterImpl)) {
            throw new ClusterJUserException(local.message("ERR_Only_Parameters", (Object)"in"));
        }
        return new InPredicateImpl(this.dobj, this, (ParameterImpl)other);
    }

    @Override
    public Predicate like(PredicateOperand other) {
        if (!(other instanceof ParameterImpl)) {
            throw new ClusterJUserException(local.message("ERR_Only_Parameters", (Object)"like"));
        }
        return new LikePredicateImpl(this.dobj, this, (ParameterImpl)other);
    }

    @Override
    public Predicate isNull() {
        return new IsNullPredicateImpl(this.dobj, this);
    }

    @Override
    public Predicate isNotNull() {
        return new IsNotNullPredicateImpl(this.dobj, this);
    }

    void markLowerBound(CandidateIndexImpl[] candidateIndices, PredicateImpl predicate, boolean strict) {
        this.fmd.markLowerBounds(candidateIndices, predicate, strict);
    }

    void markUpperBound(CandidateIndexImpl[] candidateIndices, PredicateImpl predicate, boolean strict) {
        this.fmd.markUpperBounds(candidateIndices, predicate, strict);
    }

    void markEqualBound(CandidateIndexImpl[] candidateIndices, PredicateImpl predicate) {
        this.fmd.markEqualBounds(candidateIndices, predicate);
    }

    public void markInBound(CandidateIndexImpl[] candidateIndices, InPredicateImpl predicate) {
        this.fmd.markInBounds(candidateIndices, predicate);
    }

    public Object getParameterValue(QueryExecutionContext context, String parameterName) {
        if (this.complexParameter) {
            return context.getParameterValue(parameterName);
        }
        return this.fmd.getValue(context, parameterName);
    }

    public void filterIsNull(ScanFilter filter) {
        this.fmd.filterIsNull(filter);
    }

    public void filterIsNotNull(ScanFilter filter) {
        this.fmd.filterIsNotNull(filter);
    }
}

