#!/bin/sh

# Copyright (c) 2007, 2011, Oracle and/or its affiliates. All rights reserved.
#
# The MySQL Connector/ODBC is licensed under the terms of the GPLv2
# <http://www.gnu.org/licenses/old-licenses/gpl-2.0.html>, like most 
# MySQL Connectors. There are special exceptions to the terms and 
# conditions of the GPLv2 as it is applied to this software, see the 
# FLOSS License Exception
# <http://www.mysql.com/about/legal/licensing/foss-exception.html>.
#
# This program is free software; you can redistribute it and/or modify 
# it under the terms of the GNU General Public License as published 
# by the Free Software Foundation; version 2 of the License.
#
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
# or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
# for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA

##############################################################################
#
#  Post Install file for MySQL Connector ODBC 5.1
#
##############################################################################

# ----------------------------------------------------------------------
# ENSURE WE HAVE INI FILES
#
# Upon a fresh install of OS X these files do not exist. The ODBC Installer
# library calls should create these files for us when we do stuff like
# request to register a driver but this does not seem to happen and the
# request fails. So we we start by making sure we have some, mostly, empty
# ini files in place before we make installer calls.
#
# Also note that there are many places where these ini files *could* go
# based upon the search algorithm in the default ODBC system or any other
# ODBC system which may get installed. We choose the following because they
# seem to be the ones created when we use the standard ODBC Administrator
# application.
# ----------------------------------------------------------------------

libdir=/usr/local/lib
bindir=/usr/local/bin

for admdir in ~/Library/ODBC /Library/ODBC
do
  echo "Ensuring $admdir, odbcinst.ini and odbc.ini exists..."
  if [ ! -d $admdir ] ; then
      mkdir $admdir
      chmod 775 $admdir
      chown root:admin $admdir
  fi

  if [ ! -f $admdir/odbc.ini ] ; then
      echo "[ODBC Data Sources]"        > $admdir/odbc.ini
      echo ""                          >> $admdir/odbc.ini
      echo "[ODBC]"                    >> $admdir/odbc.ini
      echo "Trace         = 0"         >> $admdir/odbc.ini
      echo "TraceAutoStop = 0"         >> $admdir/odbc.ini
      echo "TraceFile     ="           >> $admdir/odbc.ini
      echo "TraceLibrary  ="           >> $admdir/odbc.ini
      chmod 664 $admdir/odbc.ini
      chown root:admin $admdir/odbc.ini
  fi

  if [ ! -f $admdir/odbcinst.ini ] ; then
      echo "[ODBC Drivers]"             > $admdir/odbcinst.ini
      echo ""                          >> $admdir/odbcinst.ini
      echo "[ODBC Connection Pooling]" >> $admdir/odbcinst.ini
      echo "PerfMon    = 0"            >> $admdir/odbcinst.ini
      echo "Retry Wait = "             >> $admdir/odbcinst.ini
      chmod 664 $admdir/odbcinst.ini
      chown root:admin $admdir/odbcinst.ini
  fi
done

# ----------------------------------------------------------------------
# SET USER PERMISSIONS
#
# Note that if the Mac OS X "ODBC Administrator" is run before this
# script, and unlocked (root rights), it would save files in the user
# area with root permissions, causing trouble later when trying to
# change user settings without unlocking (root rights).
# ----------------------------------------------------------------------
if [ "$USER" -a "$GROUPS" ] ; then
    chown -R $USER:$GROUPS ~/Library/ODBC
fi

# ----------------------------------------------------------------------
# REGISTER THE DRIVER
# ----------------------------------------------------------------------
echo "Registering driver..."
#$bindir/myodbc-installer -a -d -n "MySQL ODBC 5.1 Driver" -t "Driver=$libdir/libmyodbc5.so;Setup=$libdir/libmyodbc3S.so;"
$bindir/myodbc-installer -a -d -n "MySQL ODBC 5.1 Driver" -t "Driver=$libdir/libmyodbc5.so;"

# ----------------------------------------------------------------------
# CREATE A SAMPLE DSN
# ----------------------------------------------------------------------
echo "Ensuring sample data source name (myodbc) exists..."
$bindir/myodbc-installer -a -s -n myodbc -t "Driver=MySQL ODBC 5.1 Driver;SERVER=localhost;"
