/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management.util;

import [Ljava.lang.Object;;
import [Ljava.lang.String;;
import com.mysql.jdbc.Driver;
import com.mysql.management.util.Exceptions;
import com.mysql.management.util.NotImplementedException;
import com.mysql.management.util.QueryUtil;
import com.mysql.management.util.Str;
import com.mysql.management.util.Streams;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;

public class TestUtil {
    private static int testKillDelayDefault = 30000;
    private static int testMysqldPortDefault = 3336;
    private int port;
    private int testKillDelay;

    public TestUtil() {
        this(new Str().parseInt(System.getProperty("c-mxj_test_port"), testMysqldPortDefault, System.err), new Str().parseInt(System.getProperty("c-mxj_test_kill-delay"), testKillDelayDefault, System.err));
    }

    public TestUtil(int port, int testKillDelay) {
        this.port = port;
        this.testKillDelay = testKillDelay;
    }

    public int testPort() {
        return this.port;
    }

    public int testKillDelay() {
        return this.testKillDelay;
    }

    public void assertContainsIgnoreCase(String searchIn, String searchFor) {
        if (new Str().containsIgnoreCase(searchIn, searchFor)) {
            return;
        }
        String msg = "<" + searchFor + "> not found in <" + searchIn + ">";
        throw new AssertionFailedError(msg);
    }

    public void assertConnectViaJDBC(String url, boolean dbInUrl) throws ClassNotFoundException, InstantiationException, IllegalAccessException, SQLException {
        this.assertConnectViaJDBC(url, "root", "", dbInUrl);
    }

    public void assertConnectViaJDBC(String url) throws ClassNotFoundException, InstantiationException, IllegalAccessException, SQLException {
        this.assertConnectViaJDBC(url, false);
    }

    public void assertConnectViaJDBC(String url, String user, String password) throws ClassNotFoundException, InstantiationException, IllegalAccessException, SQLException {
        this.assertConnectViaJDBC(url, user, password, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertConnectViaJDBC(String url, String user, String password, boolean dbInUrl) throws ClassNotFoundException, InstantiationException, IllegalAccessException, SQLException {
        String name = Driver.class.getName();
        Class<?> c = Class.forName(name);
        c.newInstance();
        Connection conn = DriverManager.getConnection(url, user, password);
        try {
            if (!dbInUrl) {
                this.useDbTest(conn);
            }
            this.checkVersion(conn);
            this.checkBigInt(conn);
            this.variousStuff(conn);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    public void assertNotImplemented(Object stub, Method method) {
        try {
            this.invoke(stub, method);
        }
        catch (NotImplementedException e) {
            return;
        }
        catch (Exception e) {
            if (this.isNotImplementedMsg(e.getMessage())) {
                return;
            }
            Throwable cause = e.getCause();
            if (cause instanceof NotImplementedException) {
                return;
            }
            if (cause != null && this.isNotImplementedMsg(cause.getMessage())) {
                return;
            }
            new Exceptions().toRuntime(e);
        }
        throw new RuntimeException("This is now implemented.");
    }

    public void assertObjStubsInterface(Object stub, Class anInterface) {
        Method[] methods = anInterface.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            this.assertNotImplemented(stub, methods[i]);
        }
    }

    private boolean isNotImplementedMsg(String msg) {
        if (msg == null) {
            return false;
        }
        String serachFor = "Not implemented".toLowerCase();
        return msg.toLowerCase().indexOf(serachFor) >= 0;
    }

    private void invoke(Object target, Method method) throws Exception {
        Class<?>[] paramTypes = method.getParameterTypes();
        Object[] params = new Object[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            params[i] = this.newParamObject(paramTypes[i]);
        }
        method.invoke(target, params);
    }

    private Object newParamObject(Class paramType) {
        if (paramType.equals(Integer.TYPE) || paramType.equals(Integer.class)) {
            return new Integer(0);
        }
        if (paramType.equals(Boolean.TYPE) || paramType.equals(Boolean.class)) {
            return Boolean.FALSE;
        }
        if (paramType.equals(Object;.class) || paramType.equals(String;.class)) {
            return new String[0];
        }
        if (paramType.equals(Runnable.class) || paramType.equals(Thread.class)) {
            return new Thread();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkVersion(Connection conn) throws SQLException {
        ResultSet rs = null;
        try {
            Statement stmt = conn.createStatement();
            rs = stmt.executeQuery("SELECT VERSION()");
            Assert.assertTrue((boolean)rs.next());
            String version = rs.getString(1);
            Assert.assertTrue((String)version, (boolean)version.startsWith("5."));
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void useDbTest(Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        try {
            stmt.executeUpdate("use test");
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkBigInt(Connection conn) {
        QueryUtil util = new QueryUtil(conn);
        String tableName = "bigIntRegression";
        String col1 = "bigIntCol";
        long testVal = 6692730313872877584L;
        try {
            util.executeUpdate("DROP TABLE IF EXISTS " + tableName);
            util.executeUpdate("CREATE TABLE " + tableName + " (" + col1 + " BIGINT NOT NULL)");
            util.executeUpdate("INSERT INTO " + tableName + " VALUES (" + testVal + ")");
            List rows = util.executeQuery("SELECT " + col1 + " FROM " + tableName);
            for (int i = 0; i < rows.size(); ++i) {
                Map row = (Map)rows.get(i);
                Assert.assertTrue((row.size() > 0 ? 1 : 0) != 0);
                Map.Entry column1 = row.entrySet().iterator().next();
                Number n = (Number)column1.getValue();
                Assert.assertEquals((long)testVal, (long)n.longValue());
            }
            Assert.assertEquals((int)1, (int)rows.size());
        }
        finally {
            util.executeUpdate("DROP TABLE IF EXISTS " + tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void variousStuff(Connection conn) {
        QueryUtil util = new QueryUtil(conn);
        String tableName = "foo_table";
        String col1 = "foo_id";
        String col2 = "bar";
        try {
            util.executeUpdate("DROP TABLE IF EXISTS " + tableName);
            util.executeUpdate("CREATE TABLE " + tableName + " (" + col1 + " INTEGER NOT NULL AUTO_INCREMENT PRIMARY KEY," + col2 + " TEXT" + ")");
            String sql = "INSERT INTO " + tableName + " VALUES (NULL,'alpha')";
            List rows = util.executeUpdateReturningKeys(sql);
            Assert.assertEquals((int)1, (int)rows.size());
            Map key1Map = (Map)rows.get(0);
            Assert.assertEquals((int)1, (int)key1Map.size());
            Map.Entry entry = key1Map.entrySet().iterator().next();
            Object generatedKey = entry.getValue();
            Assert.assertEquals((Object)new Long(1L), generatedKey);
            sql = "INSERT INTO " + tableName + " VALUES (NULL,?)";
            Object[][] batchParams = new Object[][]{{"foo"}, {"bar"}, {"baz"}};
            int[] ints = util.executeBatch(sql, batchParams);
            Assert.assertEquals((int)3, (int)ints.length);
            for (int i = 0; i < ints.length; ++i) {
                Assert.assertEquals((int)1, (int)ints[i]);
            }
        }
        finally {
            util.executeUpdate("DROP TABLE IF EXISTS " + tableName);
        }
    }

    public String getSystemPropertyWithDefaultFromResource(String property, String resourceName, PrintStream err) {
        Properties props = new Streams().loadProperties(resourceName, err);
        String fileVal = props.getProperty(property);
        return System.getProperty(property, fileVal);
    }
}

