/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management.util;

import com.mysql.management.util.ListToString;
import java.util.Arrays;
import java.util.LinkedHashMap;
import junit.framework.TestCase;

public class ListToStringTest
extends TestCase {
    private ListToString ltos;

    protected void setUp() {
        this.ltos = new ListToString();
    }

    public void testArray() throws Exception {
        ListToStringTest.assertEquals((String)"[foo]", (String)this.ltos.toString(new Object[]{"foo"}));
        ListToStringTest.assertEquals((String)"[foo][bar]", (String)this.ltos.toString(new Object[]{"foo", "bar"}));
        Object[] objects = new Object[]{"foo", new Object[]{"bar", "baz"}, "wiz"};
        ListToStringTest.assertEquals((String)"[foo][[bar][baz]][wiz]", (String)this.ltos.toString(objects));
        objects = new Object[]{"foo", Arrays.asList("bar", "baz"), "wiz"};
        ListToStringTest.assertEquals((String)"[foo][[bar][baz]][wiz]", (String)this.ltos.toString(objects));
    }

    public void testMap() throws Exception {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("foo", null);
        map.put("bar", "baz");
        map.put("wiz", new String[]{"bang"});
        ListToStringTest.assertEquals((String)"[foo=null][bar=baz][wiz=[bang]]", (String)this.ltos.toString(map));
    }
}

