/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Buffer;
import com.mysql.jdbc.CharsetMapping;
import com.mysql.jdbc.DatabaseMetaData;
import com.mysql.jdbc.EscapeProcessor;
import com.mysql.jdbc.LicenseConfiguration;
import com.mysql.jdbc.MysqlIO;
import com.mysql.jdbc.NonRegisteringDriver;
import com.mysql.jdbc.NotImplemented;
import com.mysql.jdbc.PreparedStatement;
import com.mysql.jdbc.ResultSet;
import com.mysql.jdbc.SingleByteCharsetConverter;
import com.mysql.jdbc.Statement;
import com.mysql.jdbc.StringUtils;
import com.mysql.jdbc.TimeUtil;
import com.mysql.jdbc.Util;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.TreeMap;

public class Connection
implements java.sql.Connection {
    private static final String PING_COMMAND = "SELECT 1";
    private static Map mapTransIsolationName2Value = null;
    private static Map charsetMap;
    private static Map multibyteCharsetsMap;
    private static final String DEFAULT_SOCKET_FACTORY;
    private static final Object CHARSET_CONVERTER_NOT_AVAILABLE_MARKER;
    boolean parserKnowsUnicode = false;
    private DatabaseMetaData dbmd = null;
    private List hostList = null;
    private Map cachedPreparedStatementParams;
    private Map charsetConverterMap = new HashMap(CharsetMapping.JAVA_TO_MYSQL_CHARSET_MAP.size());
    private Map statementsUsingMaxRows;
    private Map typeMap;
    private MysqlIO io = null;
    private final Object mutex = new Object();
    private Map serverVariables = null;
    private NonRegisteringDriver myDriver;
    private Properties props = null;
    private String database = null;
    private String encoding = null;
    private String host = null;
    private String myURL = null;
    private String mysqlEncodingName = null;
    private String negativeInfinityRep = "-1.7976931348623157E+308";
    private String notANumberRep = "0";
    private String password = null;
    private String positiveInfinityRep = "1.7976931348623157E+308";
    private String socketFactoryClassName = null;
    private String user = null;
    private Throwable explicitCloseLocation;
    private Throwable forcedCloseReason;
    private TimeZone defaultTimeZone;
    private TimeZone serverTimezone = null;
    private String[] indexToCharsetMapping = CharsetMapping.INDEX_TO_CHARSET;
    private boolean allowLoadLocalInfile = true;
    private boolean alwaysClearStream = false;
    private boolean autoCommit = true;
    private boolean cachePreparedStatements = false;
    private boolean capitalizeDBMDTypes = false;
    private boolean clobberStreamingResults = false;
    private boolean continueBatchOnError = true;
    private boolean doUnicode = false;
    private boolean failOverReadOnly = true;
    private boolean failedOver = false;
    private boolean hasIsolationLevels = false;
    private boolean hasQuotedIdentifiers = false;
    private boolean highAvailability = false;
    private boolean ignoreNonTxTables = false;
    private boolean isClosed = true;
    private boolean isInteractiveClient = false;
    private boolean lowerCaseTableNames = false;
    private boolean maxRowsChanged = false;
    private boolean needsPing = false;
    private boolean negativeInfinityRepIsClipped = true;
    private boolean notANumberRepIsClipped = true;
    private boolean paranoid = false;
    private boolean pedantic = false;
    private boolean positiveInfinityRepIsClipped = true;
    private boolean readInfoMsg = false;
    private boolean readOnly = false;
    private boolean reconnectAtTxEnd = false;
    private boolean relaxAutoCommit = false;
    private boolean strictFloatingPoint = false;
    private boolean strictUpdates = true;
    private boolean transactionsSupported = false;
    private boolean useAnsiQuotes = false;
    private boolean useCompression = false;
    private boolean useFastPing = false;
    private boolean useHostsInPrivileges = true;
    private boolean useOnlyServerErrorMessages = true;
    private boolean useSSL = false;
    private boolean useStreamLengthsInPrepStmts = true;
    private boolean useTimezone = false;
    private boolean useUltraDevWorkAround = false;
    private boolean useUnbufferedInput = true;
    private double initialTimeout = 2.0;
    private int hostListSize = 0;
    private int isolationLevel = 2;
    private int maxAllowedPacket = 65536;
    private int maxReconnects = 3;
    private int maxRows = -1;
    private int netBufferLength = 16384;
    private int port = 3306;
    private int preparedStatementCacheMaxSqlSize = 256;
    private int preparedStatementCacheSize = 25;
    private int queriesBeforeRetryMaster = 50;
    private int socketTimeout = 0;
    private long lastQueryFinishedTime = 0L;
    private long masterFailTimeMillis = 0L;
    private long queriesIssuedFailedOver = 0L;
    private long secondsBeforeRetryMaster = 30L;
    private boolean useOldUTF8Behavior = false;
    private String characterSetResults = null;
    private String characterSetResultsOnServer = null;
    private String characterSetMetadata = null;
    private boolean rollbackOnPooledClose = true;
    private boolean tinyint1isBit;
    private boolean useSqlStateCodes;
    static /* synthetic */ Class class$com$mysql$jdbc$StandardSocketFactory;

    Connection(String host, int port, Properties info, String database, String url, NonRegisteringDriver d) throws SQLException {
        this.defaultTimeZone = TimeZone.getDefault();
        this.serverVariables = new HashMap();
        if (host == null) {
            this.host = "localhost";
            this.hostList = new ArrayList();
            this.hostList.add(this.host);
        } else if (host.indexOf(",") != -1) {
            this.hostList = StringUtils.split(host, ",", true);
        } else {
            this.host = host;
            this.hostList = new ArrayList();
            this.hostList.add(this.host);
        }
        this.hostListSize = this.hostList.size();
        this.port = port;
        if (database == null) {
            database = "";
        }
        this.database = database;
        this.myURL = url;
        this.myDriver = d;
        this.user = info.getProperty("user");
        this.password = info.getProperty("password");
        if (this.user == null || this.user.equals("")) {
            this.user = "nobody";
        }
        if (this.password == null) {
            this.password = "";
        }
        this.props = info;
        this.initializeDriverProperties(info);
        try {
            this.createNewIO(false);
            this.dbmd = new DatabaseMetaData(this, this.database);
        }
        catch (SQLException ex) {
            this.cleanup(ex);
            throw ex;
        }
        catch (Exception ex) {
            this.cleanup(ex);
            StringBuffer mesg = new StringBuffer();
            if (!this.useParanoidErrorMessages()) {
                mesg.append("Cannot connect to MySQL server on ");
                mesg.append(this.host);
                mesg.append(":");
                mesg.append(this.port);
                mesg.append(".\n\n");
                mesg.append("Make sure that there is a MySQL server ");
                mesg.append("running on the machine/port you are trying ");
                mesg.append("to connect to and that the machine this software is running on ");
                mesg.append("is able to connect to this host/port (i.e. not firewalled). ");
                mesg.append("Also make sure that the server has not been started with the --skip-networking ");
                mesg.append("flag.\n\n");
            } else {
                mesg.append("Unable to connect to database.");
            }
            mesg.append("Underlying exception: \n\n");
            mesg.append(ex.getClass().getName());
            if (!this.paranoid) {
                mesg.append(Util.stackTraceToString(ex));
            }
            throw new SQLException(mesg.toString(), "08S01");
        }
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkClosed();
        if (this.transactionsSupported) {
            this.autoCommit = autoCommit;
            if ((this.highAvailability || this.failedOver) && !this.autoCommit && this.needsPing) {
                this.pingAndReconnect(true);
            }
            String sql = "SET autocommit=" + (autoCommit ? "1" : "0");
            this.execSQL(sql, -1, this.database);
        } else {
            if (!autoCommit && !this.relaxAutoCommit) {
                throw new SQLException("MySQL Versions Older than 3.23.15 do not support transactions", "S1C00");
            }
            this.autoCommit = autoCommit;
        }
    }

    public boolean getAutoCommit() throws SQLException {
        return this.autoCommit;
    }

    public void setCatalog(String catalog) throws SQLException {
        this.checkClosed();
        String quotedId = this.dbmd.getIdentifierQuoteString();
        if (quotedId == null || quotedId.equals(" ")) {
            quotedId = "";
        }
        StringBuffer query = new StringBuffer("USE ");
        query.append(quotedId);
        query.append(catalog);
        query.append(quotedId);
        this.execSQL(query.toString(), -1, catalog);
        this.database = catalog;
    }

    public String getCatalog() throws SQLException {
        return this.database;
    }

    public boolean getClobberStreamingResults() {
        return this.clobberStreamingResults;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setHoldability(int arg0) throws SQLException {
    }

    public int getHoldability() throws SQLException {
        return 2;
    }

    public long getIdleFor() {
        if (this.lastQueryFinishedTime == 0L) {
            return 0L;
        }
        long now = System.currentTimeMillis();
        long idleTime = now - this.lastQueryFinishedTime;
        return idleTime;
    }

    public boolean isInteractiveClient() {
        return this.isInteractiveClient;
    }

    public java.sql.DatabaseMetaData getMetaData() throws SQLException {
        this.checkClosed();
        return new DatabaseMetaData(this, this.database);
    }

    public String getNegativeInfinityRep() {
        return this.negativeInfinityRep;
    }

    public boolean isNegativeInfinityRepIsClipped() {
        return this.negativeInfinityRepIsClipped;
    }

    public String getNotANumberRep() {
        return this.notANumberRep;
    }

    public boolean isNotANumberRepIsClipped() {
        return this.notANumberRepIsClipped;
    }

    public String getPositiveInfinityRep() {
        return this.positiveInfinityRep;
    }

    public boolean isPositiveInfinityRepIsClipped() {
        return this.positiveInfinityRepIsClipped;
    }

    public void setProfileSql(boolean flag) throws SQLException {
        this.props.setProperty("profileSql", String.valueOf(flag));
        this.getIO().setProfileSql(flag);
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkClosed();
        this.readOnly = readOnly;
    }

    public boolean isReadOnly() throws SQLException {
        return this.readOnly;
    }

    public Savepoint setSavepoint() throws SQLException {
        throw new NotImplemented();
    }

    public Savepoint setSavepoint(String arg0) throws SQLException {
        throw new NotImplemented();
    }

    public TimeZone getServerTimezone() {
        return this.serverTimezone;
    }

    public void setTransactionIsolation(int level) throws SQLException {
        StringBuffer sql;
        this.checkClosed();
        if (this.hasIsolationLevels) {
            sql = new StringBuffer("SET SESSION TRANSACTION ISOLATION LEVEL ");
            switch (level) {
                case 0: {
                    throw new SQLException("Transaction isolation level NONE not supported by MySQL");
                }
                case 2: {
                    sql.append("READ COMMITTED");
                    break;
                }
                case 1: {
                    sql.append("READ UNCOMMITTED");
                    break;
                }
                case 4: {
                    sql.append("REPEATABLE READ");
                    break;
                }
                case 8: {
                    sql.append("SERIALIZABLE");
                    break;
                }
                default: {
                    throw new SQLException("Unsupported transaction isolation level '" + level + "'", "S1C00");
                }
            }
        } else {
            throw new SQLException("Transaction Isolation Levels are not supported on MySQL versions older than 3.23.36.", "S1C00");
        }
        this.execSQL(sql.toString(), -1, this.database);
        this.isolationLevel = level;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getTransactionIsolation() throws SQLException {
        String s;
        block11: {
            Exception ex22;
            int n;
            java.sql.Statement stmt;
            block12: {
                if (!this.hasIsolationLevels) return this.isolationLevel;
                stmt = null;
                java.sql.ResultSet rs = null;
                try {
                    Integer intTI;
                    stmt = this.createStatement();
                    if (stmt.getMaxRows() != 0) {
                        stmt.setMaxRows(0);
                    }
                    String query = null;
                    query = this.io.versionMeetsMinimum(4, 0, 3) ? "SHOW VARIABLES LIKE 'tx_isolation'" : "SHOW VARIABLES LIKE 'transaction_isolation'";
                    rs = stmt.executeQuery(query);
                    if (!rs.next()) throw new SQLException("Could not retrieve transaction isolation level from server", "S1000");
                    s = rs.getString(2);
                    if (s == null || (intTI = (Integer)mapTransIsolationName2Value.get(s)) == null) break block11;
                    n = intTI;
                    Object var8_7 = null;
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    Exception ex22;
                    Object var8_8 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Exception ex22) {
                            // empty catch block
                        }
                        rs = null;
                    }
                    if (stmt == null) throw throwable;
                    try {
                        stmt.close();
                    }
                    catch (Exception ex22) {
                        // empty catch block
                    }
                    stmt = null;
                    throw throwable;
                }
                try {
                    rs.close();
                }
                catch (Exception ex22) {
                    // empty catch block
                }
                rs = null;
            }
            if (stmt == null) return n;
            try {
                stmt.close();
            }
            catch (Exception ex22) {
                // empty catch block
            }
            stmt = null;
            return n;
        }
        throw new SQLException("Could not map transaction isolation '" + s + " to a valid JDBC level.", "S1000");
    }

    public void setTypeMap(Map map) throws SQLException {
        this.typeMap = map;
    }

    public synchronized Map getTypeMap() throws SQLException {
        if (this.typeMap == null) {
            this.typeMap = new HashMap();
        }
        return this.typeMap;
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public boolean allowLoadLocalInfile() {
        return this.allowLoadLocalInfile;
    }

    public boolean capitalizeDBMDTypes() {
        return this.capitalizeDBMDTypes;
    }

    public void changeUser(String userName, String newPassword) throws SQLException {
        if (userName == null || userName.equals("")) {
            userName = "";
        }
        if (newPassword == null) {
            newPassword = "";
        }
        this.io.changeUser(userName, newPassword, this.database);
        this.user = userName;
        this.password = newPassword;
        if (this.io.versionMeetsMinimum(4, 1, 0)) {
            this.configureClientCharacterSet();
        }
    }

    public void clearWarnings() throws SQLException {
    }

    public void close() throws SQLException {
        if (this.explicitCloseLocation == null) {
            this.explicitCloseLocation = new Throwable();
        }
        this.realClose(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws SQLException {
        this.checkClosed();
        try {
            if (this.autoCommit && !this.relaxAutoCommit) {
                throw new SQLException("Can't call commit when autocommit=true", "S1000");
            }
            if (this.transactionsSupported) {
                this.execSQL("commit", -1, this.database);
            }
        }
        finally {
            if (this.reconnectAtTxEnd) {
                this.pingAndReconnect(true);
            }
        }
    }

    public java.sql.Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        Statement stmt = new Statement(this, this.database);
        stmt.setResultSetType(resultSetType);
        stmt.setResultSetConcurrency(resultSetConcurrency);
        return stmt;
    }

    public java.sql.Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    public java.sql.Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.pedantic && resultSetHoldability != 1) {
            throw new SQLException("HOLD_CUSRORS_OVER_COMMIT is only supported holdability level", "S1009");
        }
        return this.createStatement(resultSetType, resultSetConcurrency);
    }

    protected void finalize() throws Throwable {
        this.cleanup(null);
    }

    public boolean lowerCaseTableNames() {
        return this.lowerCaseTableNames;
    }

    public String nativeSQL(String sql) throws SQLException {
        return EscapeProcessor.escapeSQL(sql, this.getIO().versionMeetsMinimum(4, 0, 2));
    }

    public boolean parserKnowsUnicode() {
        return this.parserKnowsUnicode;
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        if (this.getUseUltraDevWorkAround()) {
            return new UltraDevWorkAround(this.prepareStatement(sql));
        }
        throw new SQLException("Callable statments not supported.", "S1C00");
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareCall(sql);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.pedantic && resultSetHoldability != 1) {
            throw new SQLException("HOLD_CUSRORS_OVER_COMMIT is only supported holdability level", "S1009");
        }
        throw new NotImplemented();
    }

    public java.sql.PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007);
    }

    public synchronized java.sql.PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        PreparedStatement pStmt = null;
        if (this.cachePreparedStatements) {
            PreparedStatement.ParseInfo pStmtInfo = (PreparedStatement.ParseInfo)this.cachedPreparedStatementParams.get(sql);
            if (pStmtInfo == null) {
                pStmt = new PreparedStatement(this, sql, this.database);
                PreparedStatement.ParseInfo parseInfo = pStmt.getParseInfo();
                if (parseInfo.statementLength < this.preparedStatementCacheMaxSqlSize) {
                    if (this.cachedPreparedStatementParams.size() >= 25) {
                        Iterator oldestIter = this.cachedPreparedStatementParams.keySet().iterator();
                        long lruTime = Long.MAX_VALUE;
                        String oldestSql = null;
                        while (oldestIter.hasNext()) {
                            String sqlKey = (String)oldestIter.next();
                            PreparedStatement.ParseInfo lruInfo = (PreparedStatement.ParseInfo)this.cachedPreparedStatementParams.get(sqlKey);
                            if (lruInfo.lastUsed >= lruTime) continue;
                            lruTime = lruInfo.lastUsed;
                            oldestSql = sqlKey;
                        }
                        if (oldestSql != null) {
                            this.cachedPreparedStatementParams.remove(oldestSql);
                        }
                    }
                    this.cachedPreparedStatementParams.put(sql, pStmt.getParseInfo());
                }
            } else {
                pStmtInfo.lastUsed = System.currentTimeMillis();
                pStmt = new PreparedStatement(this, sql, this.database, pStmtInfo);
            }
        } else {
            pStmt = new PreparedStatement(this, sql, this.database);
        }
        pStmt.setResultSetType(resultSetType);
        pStmt.setResultSetConcurrency(resultSetConcurrency);
        return pStmt;
    }

    public java.sql.PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.pedantic && resultSetHoldability != 1) {
            throw new SQLException("HOLD_CUSRORS_OVER_COMMIT is only supported holdability level", "S1009");
        }
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    public java.sql.PreparedStatement prepareStatement(String sql, int autoGenKeyIndex) throws SQLException {
        java.sql.PreparedStatement pStmt = this.prepareStatement(sql);
        ((PreparedStatement)pStmt).setRetrieveGeneratedKeys(autoGenKeyIndex == 1);
        return pStmt;
    }

    public java.sql.PreparedStatement prepareStatement(String sql, int[] autoGenKeyIndexes) throws SQLException {
        java.sql.PreparedStatement pStmt = this.prepareStatement(sql);
        ((PreparedStatement)pStmt).setRetrieveGeneratedKeys(autoGenKeyIndexes != null && autoGenKeyIndexes.length > 0);
        return pStmt;
    }

    public java.sql.PreparedStatement prepareStatement(String sql, String[] autoGenKeyColNames) throws SQLException {
        java.sql.PreparedStatement pStmt = this.prepareStatement(sql);
        ((PreparedStatement)pStmt).setRetrieveGeneratedKeys(autoGenKeyColNames != null && autoGenKeyColNames.length > 0);
        return pStmt;
    }

    public void releaseSavepoint(Savepoint arg0) throws SQLException {
        throw new NotImplemented();
    }

    public void resetServerState() throws SQLException {
        if (!this.paranoid && this.io != null & this.io.versionMeetsMinimum(4, 0, 6)) {
            this.changeUser(this.user, this.password);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws SQLException {
        block8: {
            this.checkClosed();
            try {
                if (this.autoCommit && !this.relaxAutoCommit) {
                    throw new SQLException("Can't call rollback when autocommit=true", "S1000");
                }
                if (!this.transactionsSupported) break block8;
                try {
                    this.rollbackNoChecks();
                }
                catch (SQLException sqlEx) {
                    if (this.ignoreNonTxTables && sqlEx.getErrorCode() != 1196) {
                        throw sqlEx;
                    }
                }
            }
            finally {
                if (this.reconnectAtTxEnd) {
                    this.pingAndReconnect(true);
                }
            }
        }
    }

    public void rollback(Savepoint arg0) throws SQLException {
        throw new NotImplemented();
    }

    public void shutdownServer() throws SQLException {
        try {
            this.io.sendCommand(8, null, null);
        }
        catch (Exception ex) {
            throw new SQLException("Unhandled exception '" + ex.toString() + "'", "S1000");
        }
    }

    public boolean supportsIsolationLevel() {
        return this.hasIsolationLevels;
    }

    public boolean supportsQuotedIdentifiers() {
        return this.hasQuotedIdentifiers;
    }

    public boolean supportsTransactions() {
        return this.transactionsSupported;
    }

    public boolean useCompression() {
        return this.useCompression;
    }

    public boolean useParanoidErrorMessages() {
        return this.paranoid;
    }

    public boolean useSSL() {
        return this.useSSL;
    }

    public boolean useStrictFloatingPoint() {
        return this.strictFloatingPoint;
    }

    public boolean useStrictUpdates() {
        return this.strictUpdates;
    }

    public boolean useTimezone() {
        return this.useTimezone;
    }

    public boolean useUnicode() {
        return this.doUnicode;
    }

    protected String getCharsetNameForIndex(int charsetIndex) throws SQLException {
        String charsetName = null;
        if (this.useOldUTF8Behavior) {
            return this.getEncoding();
        }
        if (charsetIndex != -1) {
            try {
                charsetName = this.indexToCharsetMapping[charsetIndex];
                if ("sjis".equalsIgnoreCase(charsetName) && CharsetMapping.isAliasForSjis(this.getEncoding())) {
                    charsetName = this.getEncoding();
                }
            }
            catch (ArrayIndexOutOfBoundsException outOfBoundsEx) {
                throw new SQLException("Unknown character set index for field '" + charsetIndex + "' received from server.", "S1000");
            }
            if (charsetName == null) {
                charsetName = this.getEncoding();
            }
        } else {
            charsetName = this.getEncoding();
        }
        if ((this.versionMeetsMinimum(5, 0, 3) || this.versionMeetsMinimum(4, 1, 11)) && "ms932".equalsIgnoreCase(charsetName)) {
            charsetName = "windows-31j";
        }
        return charsetName;
    }

    protected TimeZone getDefaultTimeZone() {
        return this.defaultTimeZone;
    }

    protected MysqlIO getIO() throws SQLException {
        if (this.io == null || this.isClosed) {
            throw new SQLException("Operation not allowed on closed connection", "08003");
        }
        return this.io;
    }

    protected int getNetWriteTimeout() {
        String netWriteTimeoutStr = (String)this.serverVariables.get("net_write_timeout");
        if (netWriteTimeoutStr != null) {
            try {
                return Integer.parseInt(netWriteTimeoutStr);
            }
            catch (NumberFormatException nfe) {
                return Integer.MAX_VALUE;
            }
        }
        return Integer.MAX_VALUE;
    }

    protected boolean isUsingUnbufferedInput() {
        return this.useUnbufferedInput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MysqlIO createNewIO(boolean isForReconnect) throws SQLException {
        MysqlIO newIo = null;
        long queriesIssuedFailedOverCopy = this.queriesIssuedFailedOver;
        this.queriesIssuedFailedOver = 0L;
        try {
            if (!this.highAvailability && !this.failedOver) {
                for (int hostIndex = 0; hostIndex < this.hostListSize; ++hostIndex) {
                    try {
                        String newHostPortPair = (String)this.hostList.get(hostIndex);
                        int newPort = 3306;
                        String[] hostPortPair = NonRegisteringDriver.parseHostPortPair(newHostPortPair);
                        String newHost = hostPortPair[0];
                        if (newHost == null || newHost.trim().length() == 0) {
                            newHost = "localhost";
                        }
                        if (hostPortPair[1] != null) {
                            try {
                                newPort = Integer.parseInt(hostPortPair[1]);
                            }
                            catch (NumberFormatException nfe) {
                                throw new SQLException("Illegal connection port value '" + hostPortPair[1] + "'", "01S00");
                            }
                        }
                        this.io = new MysqlIO(newHost, newPort, this.socketFactoryClassName, this.props, this, this.socketTimeout);
                        this.io.doHandshake(this.user, this.password, this.database);
                        this.isClosed = false;
                        if (this.database.length() != 0) {
                            this.io.sendCommand(2, this.database, null);
                        }
                        boolean autoCommit = this.getAutoCommit();
                        int oldIsolationLevel = this.isolationLevel;
                        boolean oldReadOnly = this.isReadOnly();
                        String oldCatalog = this.getCatalog();
                        this.initializePropsFromServer(this.props);
                        if (isForReconnect) {
                            this.setAutoCommit(autoCommit);
                            if (this.hasIsolationLevels) {
                                this.setTransactionIsolation(oldIsolationLevel);
                            }
                            this.setCatalog(oldCatalog);
                        }
                        if (hostIndex != 0) {
                            this.setFailedOverState();
                            queriesIssuedFailedOverCopy = 0L;
                        } else {
                            this.failedOver = false;
                            queriesIssuedFailedOverCopy = 0L;
                            if (this.hostListSize > 1) {
                                this.setReadOnly(false);
                            } else {
                                this.setReadOnly(oldReadOnly);
                            }
                        }
                        break;
                    }
                    catch (SQLException sqlEx) {
                        String sqlState;
                        if (this.io != null) {
                            this.io.forceClose();
                        }
                        if ((sqlState = sqlEx.getSQLState()) == null || !sqlState.equals("08S01")) {
                            throw sqlEx;
                        }
                        if (this.hostListSize - 1 != hostIndex) continue;
                        throw sqlEx;
                    }
                    catch (Exception unknownException) {
                        if (this.io != null) {
                            this.io.forceClose();
                        }
                        if (this.hostListSize - 1 != hostIndex) continue;
                        throw new SQLException("Unable to connect to any hosts due to exception: " + unknownException.toString() + (this.paranoid ? "" : Util.stackTraceToString(unknownException)), "08S01");
                    }
                }
            } else {
                double timeout = this.initialTimeout;
                boolean connectionGood = false;
                Exception connectionException = null;
                block15: for (int hostIndex = 0; hostIndex < this.hostListSize && !connectionGood; ++hostIndex) {
                    for (int attemptCount = 0; !connectionGood && attemptCount < this.maxReconnects; ++attemptCount) {
                        try {
                            if (this.io != null) {
                                this.io.forceClose();
                            }
                            String newHostPortPair = (String)this.hostList.get(hostIndex);
                            int newPort = 3306;
                            String[] hostPortPair = NonRegisteringDriver.parseHostPortPair(newHostPortPair);
                            String newHost = hostPortPair[0];
                            if (newHost == null || newHost.trim().length() == 0) {
                                newHost = "localhost";
                            }
                            if (hostPortPair[1] != null) {
                                try {
                                    newPort = Integer.parseInt(hostPortPair[1]);
                                }
                                catch (NumberFormatException nfe) {
                                    throw new SQLException("Illegal connection port value '" + hostPortPair[1] + "'", "01S00");
                                }
                            }
                            this.io = new MysqlIO(newHost, newPort, this.socketFactoryClassName, this.props, this, this.socketTimeout);
                            this.io.doHandshake(this.user, this.password, this.database);
                            if (this.database.length() != 0) {
                                this.io.sendCommand(2, this.database, null);
                            }
                            this.ping();
                            this.isClosed = false;
                            boolean autoCommit = this.getAutoCommit();
                            int oldIsolationLevel = this.isolationLevel;
                            boolean oldReadOnly = this.isReadOnly();
                            String oldCatalog = this.getCatalog();
                            this.initializePropsFromServer(this.props);
                            if (isForReconnect) {
                                this.setAutoCommit(autoCommit);
                                if (this.hasIsolationLevels) {
                                    this.setTransactionIsolation(oldIsolationLevel);
                                }
                                this.setCatalog(oldCatalog);
                            }
                            connectionGood = true;
                            if (hostIndex != 0) {
                                this.setFailedOverState();
                                queriesIssuedFailedOverCopy = 0L;
                                continue block15;
                            }
                            this.failedOver = false;
                            queriesIssuedFailedOverCopy = 0L;
                            if (this.hostListSize > 1) {
                                this.setReadOnly(false);
                                continue block15;
                            }
                            this.setReadOnly(oldReadOnly);
                            continue block15;
                        }
                        catch (Exception EEE) {
                            connectionException = EEE;
                            connectionGood = false;
                            if (connectionGood) continue;
                            try {
                                Thread.sleep((long)timeout * 1000L);
                                timeout *= 2.0;
                            }
                            catch (InterruptedException IE) {
                                // empty catch block
                            }
                            continue;
                        }
                    }
                }
                if (!connectionGood) {
                    throw new SQLException("Server connection failure during transaction. Due to underlying exception: '" + connectionException + "'." + (this.paranoid ? "" : Util.stackTraceToString(connectionException)) + "\nAttempted reconnect " + this.maxReconnects + " times. Giving up.", "08001");
                }
            }
            if (this.paranoid && !this.highAvailability && this.hostListSize <= 1) {
                this.password = null;
                this.user = null;
            }
            MysqlIO mysqlIO = newIo;
            return mysqlIO;
        }
        finally {
            this.queriesIssuedFailedOver = queriesIssuedFailedOverCopy;
        }
    }

    protected void realClose(boolean calledExplicitly, boolean issueRollback) throws SQLException {
        SQLException sqlEx = null;
        if (!this.isClosed() && !this.getAutoCommit() && issueRollback) {
            try {
                this.rollback();
            }
            catch (SQLException ex) {
                sqlEx = ex;
            }
        }
        if (this.io != null) {
            try {
                this.io.quit();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.io = null;
        }
        if (this.cachedPreparedStatementParams != null) {
            this.cachedPreparedStatementParams.clear();
            this.cachedPreparedStatementParams = null;
        }
        this.isClosed = true;
        if (sqlEx != null) {
            throw sqlEx;
        }
    }

    synchronized SingleByteCharsetConverter getCharsetConverter(String javaEncodingName) {
        SingleByteCharsetConverter converter = (SingleByteCharsetConverter)this.charsetConverterMap.get(javaEncodingName);
        if (converter == CHARSET_CONVERTER_NOT_AVAILABLE_MARKER) {
            return null;
        }
        if (converter == null) {
            try {
                converter = SingleByteCharsetConverter.getInstance(javaEncodingName);
                if (converter == null) {
                    this.charsetConverterMap.put(javaEncodingName, CHARSET_CONVERTER_NOT_AVAILABLE_MARKER);
                }
                this.charsetConverterMap.put(javaEncodingName, converter);
            }
            catch (UnsupportedEncodingException unsupEncEx) {
                this.charsetConverterMap.put(javaEncodingName, CHARSET_CONVERTER_NOT_AVAILABLE_MARKER);
                converter = null;
            }
        }
        return converter;
    }

    int getMaxAllowedPacket() {
        return this.maxAllowedPacket;
    }

    int getMaxRows() {
        return this.maxRows;
    }

    Object getMutex() throws SQLException {
        if (this.io == null) {
            throw new SQLException("Connection.close() has already been called. Invalid operation in this state.", "08003");
        }
        return this.mutex;
    }

    int getNetBufferLength() {
        return this.netBufferLength;
    }

    boolean isPedantic() {
        return this.pedantic;
    }

    void setReadInfoMsgEnabled(boolean flag) {
        this.readInfoMsg = flag;
    }

    boolean isReadInfoMsgEnabled() {
        return this.readInfoMsg;
    }

    int getServerMajorVersion() {
        return this.io.getServerMajorVersion();
    }

    int getServerMinorVersion() {
        return this.io.getServerMinorVersion();
    }

    int getServerSubMinorVersion() {
        return this.io.getServerSubMinorVersion();
    }

    String getServerVersion() {
        return this.io.getServerVersion();
    }

    String getURL() {
        return this.myURL;
    }

    void setUseSSL(boolean flag) {
        this.useSSL = flag;
    }

    String getUser() {
        return this.user;
    }

    boolean alwaysClearStream() {
        return this.alwaysClearStream;
    }

    boolean continueBatchOnError() {
        return this.continueBatchOnError;
    }

    ResultSet execSQL(String sql, int maxRowsToRetreive, String catalog) throws SQLException {
        return this.execSQL(sql, maxRowsToRetreive, null, 1007, catalog);
    }

    ResultSet execSQL(String sql, int maxRows, int resultSetType, boolean streamResults, boolean queryIsSelectOnly, String catalog) throws SQLException {
        return this.execSQL(sql, maxRows, null, resultSetType, streamResults, queryIsSelectOnly, catalog);
    }

    ResultSet execSQL(String sql, int maxRows, Buffer packet, String catalog) throws SQLException {
        return this.execSQL(sql, maxRows, packet, 1007, catalog);
    }

    ResultSet execSQL(String sql, int maxRows, Buffer packet, int resultSetType, String catalog) throws SQLException {
        return this.execSQL(sql, maxRows, packet, resultSetType, true, false, catalog);
    }

    /*
     * Exception decompiling
     */
    ResultSet execSQL(String sql, int maxRows, Buffer packet, int resultSetType, boolean streamResults, boolean queryIsSelectOnly, String catalog) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 0[TRYBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void maxRowsChanged(Statement stmt) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.statementsUsingMaxRows == null) {
                this.statementsUsingMaxRows = new HashMap();
            }
            this.statementsUsingMaxRows.put(stmt, stmt);
            this.maxRowsChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unsetMaxRows(Statement stmt) throws SQLException {
        Object object = this.mutex;
        synchronized (object) {
            Object found;
            if (this.statementsUsingMaxRows != null && (found = this.statementsUsingMaxRows.remove(stmt)) != null && this.statementsUsingMaxRows.size() == 0) {
                this.execSQL("SET OPTION SQL_SELECT_LIMIT=DEFAULT", -1, this.database);
                this.maxRowsChanged = false;
            }
        }
    }

    boolean useAnsiQuotedIdentifiers() {
        return this.useAnsiQuotes;
    }

    boolean useHostsInPrivileges() {
        return this.useHostsInPrivileges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean useMaxRows() {
        Object object = this.mutex;
        synchronized (object) {
            return this.maxRowsChanged;
        }
    }

    boolean useStreamLengthsInPrepStmts() {
        return this.useStreamLengthsInPrepStmts;
    }

    private void setFailedOverState() throws SQLException {
        if (this.failOverReadOnly) {
            this.setReadOnly(true);
        }
        this.queriesIssuedFailedOver = 0L;
        this.failedOver = true;
        this.masterFailTimeMillis = System.currentTimeMillis();
    }

    /*
     * Loose catch block
     */
    private void buildCollationMapping() throws SQLException {
        block20: {
            block19: {
                SQLException sqlE22;
                ResultSet results;
                Statement stmt;
                block18: {
                    if (!this.io.versionMeetsMinimum(4, 1, 0)) break block19;
                    stmt = null;
                    results = null;
                    TreeMap<Integer, String> sortedCollationMap = new TreeMap<Integer, String>();
                    stmt = (Statement)this.createStatement();
                    if (stmt.getMaxRows() != 0) {
                        stmt.setMaxRows(0);
                    }
                    results = (ResultSet)stmt.executeQuery("SHOW COLLATION");
                    while (results.next()) {
                        String charsetName = results.getString(2);
                        Integer charsetIndex = new Integer(results.getInt(3));
                        sortedCollationMap.put(charsetIndex, charsetName);
                    }
                    int highestIndex = (Integer)sortedCollationMap.lastKey();
                    if (CharsetMapping.INDEX_TO_CHARSET.length > highestIndex) {
                        highestIndex = CharsetMapping.INDEX_TO_CHARSET.length;
                    }
                    this.indexToCharsetMapping = new String[highestIndex + 1];
                    for (int i = 0; i < CharsetMapping.INDEX_TO_CHARSET.length; ++i) {
                        this.indexToCharsetMapping[i] = CharsetMapping.INDEX_TO_CHARSET[i];
                    }
                    Iterator indexIter = sortedCollationMap.entrySet().iterator();
                    while (indexIter.hasNext()) {
                        Map.Entry indexEntry = indexIter.next();
                        String mysqlCharsetName = (String)indexEntry.getValue();
                        this.indexToCharsetMapping[((Integer)indexEntry.getKey()).intValue()] = (String)CharsetMapping.MYSQL_TO_JAVA_CHARSET_MAP.get(mysqlCharsetName);
                    }
                    Object var9_12 = null;
                    if (results == null) break block18;
                    try {
                        results.close();
                    }
                    catch (SQLException sqlE22) {
                        // empty catch block
                    }
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException sqlE22) {}
                }
                break block20;
                {
                    catch (SQLException e) {
                        throw e;
                    }
                }
                catch (Throwable throwable) {
                    SQLException sqlE22;
                    Object var9_13 = null;
                    if (results != null) {
                        try {
                            results.close();
                        }
                        catch (SQLException sqlE22) {
                            // empty catch block
                        }
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException sqlE22) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
            this.indexToCharsetMapping = CharsetMapping.INDEX_TO_CHARSET;
        }
    }

    private void checkClosed() throws SQLException {
        if (this.isClosed) {
            StringBuffer exceptionMessage = new StringBuffer();
            exceptionMessage.append("No operations allowed after connection closed.");
            if (!this.paranoid) {
                if (this.forcedCloseReason != null) {
                    exceptionMessage.append("\n\nConnection was closed due to the following exception:");
                    exceptionMessage.append(Util.stackTraceToString(this.forcedCloseReason));
                } else if (this.explicitCloseLocation != null) {
                    exceptionMessage.append("\n\nConnection was closed explicitly by the application at the following location:");
                    exceptionMessage.append(Util.stackTraceToString(this.explicitCloseLocation));
                }
            }
            throw new SQLException(exceptionMessage.toString(), "08003");
        }
    }

    private void checkServerEncoding() throws SQLException {
        SingleByteCharsetConverter converter;
        if (this.doUnicode && this.encoding != null) {
            return;
        }
        this.mysqlEncodingName = (String)this.serverVariables.get("character_set");
        String javaEncodingName = null;
        if (this.mysqlEncodingName != null) {
            javaEncodingName = (String)charsetMap.get(this.mysqlEncodingName.toUpperCase());
        }
        if (!this.doUnicode && javaEncodingName != null && (converter = this.getCharsetConverter(javaEncodingName)) != null) {
            this.doUnicode = true;
            this.encoding = javaEncodingName;
            return;
        }
        if (this.mysqlEncodingName != null) {
            if (javaEncodingName == null && Character.isLowerCase(this.mysqlEncodingName.charAt(0))) {
                char[] ach = this.mysqlEncodingName.toCharArray();
                ach[0] = Character.toUpperCase(this.mysqlEncodingName.charAt(0));
                this.encoding = new String(ach);
            }
            try {
                "abc".getBytes(javaEncodingName);
                this.encoding = javaEncodingName;
                this.doUnicode = true;
            }
            catch (UnsupportedEncodingException UE) {
                throw new SQLException("The driver can not map the character encoding '" + this.encoding + "' that your server is using " + "to a character encoding your JVM understands. You " + "can specify this mapping manually by adding \"useUnicode=true\" " + "as well as \"characterEncoding=[an_encoding_your_jvm_understands]\" " + "to your JDBC URL.", "01S00");
            }
        }
    }

    private void checkTransactionIsolationLevel() throws SQLException {
        Integer intTI;
        String txIsolationName = null;
        txIsolationName = this.io.versionMeetsMinimum(4, 0, 3) ? "tx_isolation" : "transaction_isolation";
        String s = (String)this.serverVariables.get(txIsolationName);
        if (s != null && (intTI = (Integer)mapTransIsolationName2Value.get(s)) != null) {
            this.isolationLevel = intTI;
        }
    }

    private void cleanup(Throwable cleanupReason) {
        try {
            if (this.io != null && !this.isClosed()) {
                this.realClose(false, false);
            } else if (this.io != null) {
                this.io.forceClose();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.isClosed = true;
        this.forcedCloseReason = cleanupReason;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean configureClientCharacterSet() throws SQLException {
        boolean characterSetAlreadyConfigured;
        block28: {
            String realJavaEncoding = this.getEncoding();
            characterSetAlreadyConfigured = false;
            try {
                if (this.io.versionMeetsMinimum(4, 1, 0)) {
                    characterSetAlreadyConfigured = true;
                    this.doUnicode = true;
                    this.configureCharsetProperties(this.props);
                    realJavaEncoding = this.getEncoding();
                    try {
                        this.encoding = CharsetMapping.INDEX_TO_CHARSET[this.io.serverCharsetIndex];
                    }
                    catch (ArrayIndexOutOfBoundsException outOfBoundsEx) {
                        if (realJavaEncoding != null) {
                            this.encoding = realJavaEncoding;
                        }
                        throw new SQLException("Unknown initial character set index '" + this.io.serverCharsetIndex + "' received from server. Initial client character set can be forced via the 'characterEncoding' property.", "S1000");
                    }
                    if (this.encoding == null) {
                        this.encoding = "ISO8859_1";
                    }
                    if (this.useUnicode()) {
                        if (realJavaEncoding != null) {
                            if ("ISO8859_2".equals(realJavaEncoding) && this.mysqlEncodingName == null) {
                                throw new SQLException("Character encoding 'ISO8859_2' specified in JDBC URL which maps to multiple MySQL character encodings:\n\n* 'latin2'\n* 'czech'\n* 'hungarian'\n* 'croat'\n\nSpecify one of the above encodings using the 'mysqlEncoding' connection property.", "01S00");
                            }
                            if ("ISO8859_13".equals(realJavaEncoding) && this.mysqlEncodingName == null) {
                                throw new SQLException("Character encoding 'ISO8859_13' specified in JDBC URL which maps to multiple MySQL character encodings:\n\n* 'latvian'\n* 'latvian1'\n* 'estonia'\n\nSpecify one of the above encodings using the 'mysqlEncoding' connection property.", "01S00");
                            }
                            if (("MS932".equalsIgnoreCase(realJavaEncoding) || "WINDOWS-31J".equalsIgnoreCase(realJavaEncoding)) && this.io.versionMeetsMinimum(4, 1, 11)) {
                                this.mysqlEncodingName = "cp932";
                            } else if ("EUC_JP_Solaris".equalsIgnoreCase(realJavaEncoding) && this.io.versionMeetsMinimum(5, 0, 3)) {
                                this.mysqlEncodingName = "eucjpms";
                            }
                            if (this.mysqlEncodingName == null) {
                                this.mysqlEncodingName = (String)CharsetMapping.JAVA_UC_TO_MYSQL_CHARSET_MAP.get(realJavaEncoding.toUpperCase());
                            }
                            if (realJavaEncoding.equalsIgnoreCase("UTF-8") || realJavaEncoding.equalsIgnoreCase("UTF8")) {
                                if (!this.useOldUTF8Behavior) {
                                    this.execSQL("SET NAMES utf8", -1, this.database);
                                }
                                this.encoding = realJavaEncoding;
                            } else {
                                String namesEncoding = this.mysqlEncodingName;
                                if ("koi8_ru".equals(this.mysqlEncodingName)) {
                                    namesEncoding = "ko18r";
                                } else if ("euc_kr".equals(this.mysqlEncodingName)) {
                                    namesEncoding = "euckr";
                                }
                                if (namesEncoding != null) {
                                    this.execSQL("SET NAMES " + namesEncoding, -1, this.database);
                                }
                                this.encoding = realJavaEncoding;
                            }
                        } else if (this.encoding != null) {
                            this.mysqlEncodingName = (String)CharsetMapping.JAVA_UC_TO_MYSQL_CHARSET_MAP.get(this.encoding.toUpperCase());
                            this.execSQL("SET NAMES " + this.mysqlEncodingName, -1, this.database);
                            realJavaEncoding = this.encoding;
                        }
                    }
                    if (this.io.versionMeetsMinimum(4, 1, 1)) {
                        if (this.characterSetResults == null) {
                            this.execSQL("SET character_set_results = NULL", -1, this.database);
                        } else {
                            StringBuffer setBuf = new StringBuffer("SET character_set_results = ".length() + this.characterSetResults.length());
                            setBuf.append("SET character_set_results = ").append(this.characterSetResults);
                            this.execSQL(setBuf.toString(), -1, this.database);
                        }
                    }
                    break block28;
                }
                realJavaEncoding = this.encoding;
            }
            finally {
                this.encoding = realJavaEncoding;
            }
        }
        return characterSetAlreadyConfigured;
    }

    private void configureTimezone() throws SQLException {
        String configuredTimeZoneOnServer = (String)this.serverVariables.get("timezone");
        if (configuredTimeZoneOnServer == null && "SYSTEM".equalsIgnoreCase(configuredTimeZoneOnServer = (String)this.serverVariables.get("time_zone"))) {
            configuredTimeZoneOnServer = (String)this.serverVariables.get("system_time_zone");
        }
        if (this.useTimezone && configuredTimeZoneOnServer != null) {
            String canoncicalTimezone = this.props.getProperty("serverTimezone");
            if (canoncicalTimezone == null || canoncicalTimezone.length() == 0) {
                String serverTimezoneStr = configuredTimeZoneOnServer;
                try {
                    canoncicalTimezone = TimeUtil.getCanoncialTimezone(serverTimezoneStr);
                    if (canoncicalTimezone == null) {
                        throw new SQLException("Can't map timezone '" + serverTimezoneStr + "' to " + " canonical timezone.", "S1009");
                    }
                }
                catch (IllegalArgumentException iae) {
                    throw new SQLException(iae.getMessage(), "S1000");
                }
            }
            this.serverTimezone = TimeZone.getTimeZone(canoncicalTimezone);
            if (!canoncicalTimezone.equalsIgnoreCase("GMT") && this.serverTimezone.getID().equals("GMT")) {
                throw new SQLException("No timezone mapping entry for '" + canoncicalTimezone + "'", "S1009");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void detectFloatingPointStyle() throws SQLException {
        block23: {
            SQLException sqlEx2;
            java.sql.ResultSet rs;
            java.sql.Statement stmt;
            block20: {
                stmt = null;
                rs = null;
                stmt = this.createStatement();
                if (stmt.getMaxRows() != 0) {
                    stmt.setMaxRows(0);
                }
                if ((rs = stmt.executeQuery("select round('inf'), round('-inf'), round('nan')")).next()) {
                    String nan;
                    String negInf;
                    String posInf = rs.getString(1);
                    if ("inf".equalsIgnoreCase(posInf)) {
                        this.positiveInfinityRep = "'inf'";
                        this.positiveInfinityRepIsClipped = false;
                    }
                    if ("-inf".equalsIgnoreCase(negInf = rs.getString(2))) {
                        this.negativeInfinityRep = "'-inf'";
                        this.negativeInfinityRepIsClipped = false;
                    }
                    if ("nan".equalsIgnoreCase(nan = rs.getString(3))) {
                        this.notANumberRep = "'nan'";
                        this.notANumberRepIsClipped = false;
                    }
                }
                rs.close();
                rs = null;
                stmt.close();
                stmt = null;
                Object var7_7 = null;
                if (rs == null) break block20;
                try {
                    rs.close();
                }
                catch (SQLException sqlEx2) {
                    // empty catch block
                }
                rs = null;
            }
            if (stmt == null) break block23;
            try {
                stmt.close();
            }
            catch (SQLException sqlEx2) {
                // empty catch block
            }
            stmt = null;
            {
                break block23;
                catch (SQLException sQLException) {
                    Object var7_8 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException sqlEx2) {
                            // empty catch block
                        }
                        rs = null;
                    }
                    if (stmt == null) break block23;
                    try {
                        stmt.close();
                    }
                    catch (SQLException sqlEx2) {
                        // empty catch block
                    }
                    stmt = null;
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sqlEx2) {
                        // empty catch block
                    }
                    rs = null;
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException sqlEx2) {
                        // empty catch block
                    }
                    stmt = null;
                }
                throw throwable;
            }
        }
    }

    private void initializeDriverProperties(Properties info) throws SQLException {
        this.useSqlStateCodes = info.getProperty("useSqlStateCodes") != null ? "TRUE".equalsIgnoreCase(info.getProperty("useSqlStateCodes")) : false;
        this.tinyint1isBit = info.getProperty("tinyInt1isBit") != null ? "TRUE".equalsIgnoreCase(info.getProperty("tinyInt1isBit")) : true;
        this.useOldUTF8Behavior = "TRUE".equalsIgnoreCase(info.getProperty("useOldUTF8Behavior"));
        this.useOnlyServerErrorMessages = "TRUE".equalsIgnoreCase(info.getProperty("useOnlyServerErrorMessages"));
        if (info.getProperty("rollbackOnPooledClose") != null) {
            this.rollbackOnPooledClose = "TRUE".equalsIgnoreCase(info.getProperty("rollbackOnPooledClose"));
        }
        this.socketFactoryClassName = info.getProperty("socketFactory", DEFAULT_SOCKET_FACTORY);
        this.failOverReadOnly = "TRUE".equalsIgnoreCase(info.getProperty("failOverReadOnly"));
        if (info.getProperty("useUnbufferedInput") != null) {
            this.useUnbufferedInput = "TRUE".equalsIgnoreCase(info.getProperty("useUnbufferedInput"));
        }
        if (info.getProperty("cachePrepStmts") != null) {
            this.cachePreparedStatements = info.getProperty("cachePrepStmts").equalsIgnoreCase("TRUE");
            if (this.cachePreparedStatements) {
                if (info.getProperty("prepStmtCacheSize") != null) {
                    try {
                        this.preparedStatementCacheSize = Integer.parseInt(info.getProperty("prepStmtCacheSize"));
                        if (this.preparedStatementCacheSize < 0) {
                            throw new SQLException("Connection property 'prepStmtCacheSize' must be a non-negative integer value.", "S1009");
                        }
                    }
                    catch (NumberFormatException nfe) {
                        throw new SQLException("Connection property 'prepStmtCacheSize' must be a non-negative integer value.", "S1009");
                    }
                }
                if (info.getProperty("prepStmtCacheSqlLimit") != null) {
                    try {
                        this.preparedStatementCacheMaxSqlSize = Integer.parseInt(info.getProperty("prepStmtCacheSqlLimit"));
                        if (this.preparedStatementCacheMaxSqlSize < 0) {
                            throw new SQLException("Connection property 'prepStmtCacheSqlLimit' must be a non-negative integer value.", "S1009");
                        }
                    }
                    catch (NumberFormatException nfe) {
                        throw new SQLException("Connection property 'prepStmtCacheSqlLimit' must be a non-negative integer value.", "S1009");
                    }
                }
                this.cachedPreparedStatementParams = new HashMap(this.preparedStatementCacheSize);
            }
        }
        if (info.getProperty("alwaysClearStream") != null) {
            this.alwaysClearStream = info.getProperty("alwaysClearStream").equalsIgnoreCase("TRUE");
        }
        if (info.getProperty("reconnectAtTxEnd") != null) {
            this.reconnectAtTxEnd = info.getProperty("reconnectAtTxEnd").equalsIgnoreCase("TRUE");
        }
        if (info.getProperty("clobberStreamingResults") != null) {
            this.clobberStreamingResults = info.getProperty("clobberStreamingResults").equalsIgnoreCase("TRUE");
        }
        if (info.getProperty("strictUpdates") != null) {
            this.strictUpdates = info.getProperty("strictUpdates").equalsIgnoreCase("TRUE");
        }
        if (info.getProperty("ignoreNonTxTables") != null) {
            this.ignoreNonTxTables = info.getProperty("ignoreNonTxTables").equalsIgnoreCase("TRUE");
        }
        if (info.getProperty("secondsBeforeRetryMaster") != null) {
            String secondsBeforeRetryStr = info.getProperty("secondsBeforeRetryMaster");
            try {
                int seconds = Integer.parseInt(secondsBeforeRetryStr);
                if (seconds < 1) {
                    throw new SQLException("Illegal (< 1)  value '" + secondsBeforeRetryStr + "' for 'secondsBeforeRetryMaster'", "S1009");
                }
                this.secondsBeforeRetryMaster = seconds;
            }
            catch (NumberFormatException nfe) {
                throw new SQLException("Illegal non-numeric value '" + secondsBeforeRetryStr + "' for 'secondsBeforeRetryMaster'", "S1009");
            }
        }
        if (info.getProperty("queriesBeforeRetryMaster") != null) {
            String queriesBeforeRetryStr = info.getProperty("queriesBeforeRetryMaster");
            try {
                this.queriesBeforeRetryMaster = Integer.parseInt(queriesBeforeRetryStr);
            }
            catch (NumberFormatException nfe) {
                throw new SQLException("Illegal non-numeric value '" + queriesBeforeRetryStr + "' for 'queriesBeforeRetryMaster'", "S1009");
            }
        }
        if (info.getProperty("allowLoadLocalInfile") != null) {
            this.allowLoadLocalInfile = info.getProperty("allowLoadLocalInfile").equalsIgnoreCase("TRUE");
        }
        if (info.getProperty("continueBatchOnError") != null) {
            this.continueBatchOnError = info.getProperty("continueBatchOnError").equalsIgnoreCase("TRUE");
        }
        if (info.getProperty("pedantic") != null) {
            this.pedantic = info.getProperty("pedantic").equalsIgnoreCase("TRUE");
        }
        if (info.getProperty("useStreamLengthsInPrepStmts") != null) {
            this.useStreamLengthsInPrepStmts = info.getProperty("useStreamLengthsInPrepStmts").equalsIgnoreCase("TRUE");
        }
        if (info.getProperty("useTimezone") != null) {
            this.useTimezone = info.getProperty("useTimezone").equalsIgnoreCase("TRUE");
        }
        if (info.getProperty("relaxAutoCommit") != null) {
            this.relaxAutoCommit = info.getProperty("relaxAutoCommit").equalsIgnoreCase("TRUE");
        } else if (info.getProperty("relaxAutocommit") != null) {
            this.relaxAutoCommit = info.getProperty("relaxAutocommit").equalsIgnoreCase("TRUE");
        }
        if (info.getProperty("paranoid") != null) {
            this.paranoid = info.getProperty("paranoid").equalsIgnoreCase("TRUE");
        }
        if (info.getProperty("autoReconnect") != null) {
            this.highAvailability = info.getProperty("autoReconnect").equalsIgnoreCase("TRUE");
        }
        if (info.getProperty("capitalizeTypeNames") != null) {
            this.capitalizeDBMDTypes = info.getProperty("capitalizeTypeNames").equalsIgnoreCase("TRUE");
        }
        if (info.getProperty("ultraDevHack") != null) {
            this.useUltraDevWorkAround = info.getProperty("ultraDevHack").equalsIgnoreCase("TRUE");
        }
        if (info.getProperty("strictFloatingPoint") != null) {
            this.strictFloatingPoint = info.getProperty("strictFloatingPoint").equalsIgnoreCase("TRUE");
        }
        if (info.getProperty("useSSL") != null) {
            this.useSSL = info.getProperty("useSSL").equalsIgnoreCase("TRUE");
        }
        if (info.getProperty("useCompression") != null) {
            this.useCompression = info.getProperty("useCompression").equalsIgnoreCase("TRUE");
        }
        if (info.getProperty("socketTimeout") != null) {
            try {
                int n = Integer.parseInt(info.getProperty("socketTimeout"));
                if (n < 0) {
                    throw new SQLException("socketTimeout can not be < 0", "01S00");
                }
                this.socketTimeout = n;
            }
            catch (NumberFormatException NFE) {
                throw new SQLException("Illegal parameter '" + info.getProperty("socketTimeout") + "' for socketTimeout", "01S00");
            }
        }
        if (this.highAvailability) {
            if (info.getProperty("maxReconnects") != null) {
                try {
                    int n;
                    this.maxReconnects = n = Integer.parseInt(info.getProperty("maxReconnects"));
                }
                catch (NumberFormatException NFE) {
                    throw new SQLException("Illegal parameter '" + info.getProperty("maxReconnects") + "' for maxReconnects", "01S00");
                }
            }
            if (info.getProperty("initialTimeout") != null) {
                try {
                    double n;
                    this.initialTimeout = n = (double)Integer.parseInt(info.getProperty("initialTimeout"));
                }
                catch (NumberFormatException NFE) {
                    throw new SQLException("Illegal parameter '" + info.getProperty("initialTimeout") + "' for initialTimeout", "01S00");
                }
            }
        }
        if (info.getProperty("maxRows") != null) {
            try {
                int n = Integer.parseInt(info.getProperty("maxRows"));
                if (n == 0) {
                    n = -1;
                }
                this.maxRows = n;
                this.maxRowsChanged = true;
            }
            catch (NumberFormatException NFE) {
                throw new SQLException("Illegal parameter '" + info.getProperty("maxRows") + "' for maxRows", "01S00");
            }
        }
        if (info.getProperty("useHostsInPrivileges") != null) {
            this.useHostsInPrivileges = info.getProperty("useHostsInPrivileges").equalsIgnoreCase("TRUE");
        }
        if (info.getProperty("interactiveClient") != null) {
            this.isInteractiveClient = info.getProperty("interactiveClient").equalsIgnoreCase("TRUE");
        }
        if (info.getProperty("useUnicode") != null) {
            this.doUnicode = info.getProperty("useUnicode").equalsIgnoreCase("TRUE");
        }
        if (this.doUnicode) {
            this.configureCharsetProperties(info);
        }
    }

    private void configureCharsetProperties(Properties info) throws SQLException {
        if (info.getProperty("mysqlEncoding") != null) {
            this.mysqlEncodingName = info.getProperty("mysqlEncoding");
        }
        if (info.getProperty("characterEncoding") != null) {
            this.encoding = info.getProperty("characterEncoding");
            try {
                String testString = "abc";
                testString.getBytes(this.encoding);
            }
            catch (UnsupportedEncodingException UE) {
                String oldEncoding = this.encoding;
                this.encoding = (String)CharsetMapping.MYSQL_TO_JAVA_CHARSET_MAP.get(oldEncoding);
                if (this.encoding == null) {
                    throw new SQLException("Java does not support the MySQL character encoding  encoding '" + oldEncoding + "'.", "01S00");
                }
                try {
                    String testString = "abc";
                    testString.getBytes(this.encoding);
                }
                catch (UnsupportedEncodingException encodingEx) {
                    throw new SQLException("Unsupported character encoding '" + this.encoding + "'.", "01S00");
                }
            }
        }
    }

    private void initializePropsFromServer(Properties info) throws SQLException {
        String profileSql = info.getProperty("profileSql");
        if (profileSql != null && profileSql.trim().equalsIgnoreCase("true")) {
            this.io.setProfileSql(true);
        } else {
            this.io.setProfileSql(false);
        }
        boolean clientCharsetIsConfigured = this.configureClientCharacterSet();
        this.useFastPing = this.io.versionMeetsMinimum(3, 22, 1);
        this.parserKnowsUnicode = this.io.versionMeetsMinimum(4, 1, 0);
        this.detectFloatingPointStyle();
        this.serverVariables.clear();
        if (this.io.versionMeetsMinimum(3, 21, 22)) {
            this.loadServerVariables();
            this.buildCollationMapping();
            LicenseConfiguration.checkLicenseType(this.serverVariables);
            String lowerCaseTables = (String)this.serverVariables.get("lower_case_table_names");
            this.lowerCaseTableNames = "on".equalsIgnoreCase(lowerCaseTables) || "1".equalsIgnoreCase(lowerCaseTables) || "2".equalsIgnoreCase(lowerCaseTables);
            this.configureTimezone();
            if (this.serverVariables.containsKey("max_allowed_packet")) {
                this.maxAllowedPacket = Integer.parseInt((String)this.serverVariables.get("max_allowed_packet"));
            }
            if (this.serverVariables.containsKey("net_buffer_length")) {
                this.netBufferLength = Integer.parseInt((String)this.serverVariables.get("net_buffer_length"));
            }
            this.checkTransactionIsolationLevel();
            if (!clientCharsetIsConfigured) {
                this.checkServerEncoding();
            }
            this.io.checkForCharsetMismatch();
            if (this.serverVariables.containsKey("sql_mode")) {
                int sqlMode = 0;
                try {
                    sqlMode = Integer.parseInt((String)this.serverVariables.get("sql_mode"));
                }
                catch (NumberFormatException nfe) {
                    sqlMode = 0;
                }
                this.useAnsiQuotes = (sqlMode & 4) > 0;
            }
        }
        if (this.io.versionMeetsMinimum(3, 23, 15)) {
            this.transactionsSupported = true;
            this.setAutoCommit(true);
        } else {
            this.transactionsSupported = false;
        }
        this.hasIsolationLevels = this.io.versionMeetsMinimum(3, 23, 36);
        this.hasQuotedIdentifiers = this.io.versionMeetsMinimum(3, 23, 6);
        this.io.resetMaxBuf();
        if (this.io.versionMeetsMinimum(4, 1, 0)) {
            String characterSetResultsOnServerMysql = (String)this.serverVariables.get("character_set_results");
            if (characterSetResultsOnServerMysql == null || StringUtils.startsWithIgnoreCaseAndWs(characterSetResultsOnServerMysql, "NULL")) {
                String defaultMetadataCharsetMysql = (String)this.serverVariables.get("character_set_system");
                String defaultMetadataCharset = null;
                defaultMetadataCharset = defaultMetadataCharsetMysql != null ? (String)CharsetMapping.MYSQL_TO_JAVA_CHARSET_MAP.get(defaultMetadataCharsetMysql) : "UTF-8";
                this.characterSetMetadata = defaultMetadataCharset;
            } else {
                this.characterSetMetadata = this.characterSetResultsOnServer = (String)CharsetMapping.MYSQL_TO_JAVA_CHARSET_MAP.get(characterSetResultsOnServerMysql);
            }
        }
    }

    private static void loadCharacterSetMapping() {
        multibyteCharsetsMap = new HashMap();
        Iterator multibyteCharsets = CharsetMapping.MULTIBYTE_CHARSETS.keySet().iterator();
        while (multibyteCharsets.hasNext()) {
            String charset = ((String)multibyteCharsets.next()).toUpperCase();
            multibyteCharsetsMap.put(charset, charset);
        }
        Iterator keys = CharsetMapping.MYSQL_TO_JAVA_CHARSET_MAP.keySet().iterator();
        charsetMap = new HashMap();
        while (keys.hasNext()) {
            String mysqlCharsetName = ((String)keys.next()).trim();
            String javaCharsetName = CharsetMapping.MYSQL_TO_JAVA_CHARSET_MAP.get(mysqlCharsetName).toString().trim();
            charsetMap.put(mysqlCharsetName.toUpperCase(), javaCharsetName);
            charsetMap.put(mysqlCharsetName, javaCharsetName);
        }
    }

    private boolean getUseUltraDevWorkAround() {
        return this.useUltraDevWorkAround;
    }

    /*
     * Loose catch block
     */
    private void loadServerVariables() throws SQLException {
        block16: {
            SQLException sqlE22;
            ResultSet results;
            Statement stmt;
            block15: {
                stmt = null;
                results = null;
                stmt = (Statement)this.createStatement();
                if (stmt.getMaxRows() != 0) {
                    stmt.setMaxRows(0);
                }
                results = (ResultSet)stmt.executeQuery("SHOW VARIABLES");
                while (results.next()) {
                    this.serverVariables.put(results.getString(1), results.getString(2));
                }
                Object var5_3 = null;
                if (results == null) break block15;
                try {
                    results.close();
                }
                catch (SQLException sqlE22) {
                    // empty catch block
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sqlE22) {}
            }
            break block16;
            {
                catch (SQLException e) {
                    throw e;
                }
            }
            catch (Throwable throwable) {
                SQLException sqlE22;
                Object var5_4 = null;
                if (results != null) {
                    try {
                        results.close();
                    }
                    catch (SQLException sqlE22) {
                        // empty catch block
                    }
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException sqlE22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    private void ping() throws Exception {
        if (this.useFastPing) {
            this.io.sendCommand(14, null, null);
        } else {
            this.io.sqlQuery(PING_COMMAND, 50000000, this.encoding, this, 1007, false, this.database);
        }
    }

    private void pingAndReconnect(boolean ignoreAutoCommitSetting) throws SQLException {
        boolean localAutoCommit = this.autoCommit;
        if (ignoreAutoCommitSetting) {
            localAutoCommit = true;
        }
        if (this.failedOver && localAutoCommit && this.shouldFallBack()) {
            this.createNewIO(true);
            String connectedHost = this.io.getHost();
            if (connectedHost != null && this.hostList.get(0).equals(connectedHost)) {
                this.failedOver = false;
                this.queriesIssuedFailedOver = 0L;
                this.setReadOnly(false);
            }
        }
        if ((this.highAvailability || this.failedOver) && localAutoCommit) {
            try {
                this.ping();
            }
            catch (Exception Ex) {
                this.createNewIO(true);
            }
        }
        this.needsPing = false;
    }

    private void rollbackNoChecks() throws SQLException {
        this.execSQL("rollback", -1, null);
    }

    private boolean shouldFallBack() {
        long secondsSinceFailedOver = (System.currentTimeMillis() - this.masterFailTimeMillis) / 1000L;
        return secondsSinceFailedOver >= this.secondsBeforeRetryMaster || this.queriesIssuedFailedOver >= (long)this.queriesBeforeRetryMaster;
    }

    protected String getCharacterSetMetadata() {
        return this.characterSetMetadata;
    }

    protected String getServerCharacterEncoding() {
        return (String)this.serverVariables.get("character_set");
    }

    public boolean getRollbackOnPooledClose() {
        return this.rollbackOnPooledClose;
    }

    protected boolean getUseOnlyServerErrorMessages() {
        return this.useOnlyServerErrorMessages;
    }

    public boolean getTinyint1isBit() {
        return this.tinyint1isBit;
    }

    public boolean getUseSqlStateCodes() {
        return this.useSqlStateCodes;
    }

    public boolean versionMeetsMinimum(int major, int minor, int subminor) throws SQLException {
        return this.io.versionMeetsMinimum(major, minor, subminor);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        DEFAULT_SOCKET_FACTORY = (class$com$mysql$jdbc$StandardSocketFactory == null ? (class$com$mysql$jdbc$StandardSocketFactory = Connection.class$("com.mysql.jdbc.StandardSocketFactory")) : class$com$mysql$jdbc$StandardSocketFactory).getName();
        Connection.loadCharacterSetMapping();
        mapTransIsolationName2Value = new HashMap(8);
        mapTransIsolationName2Value.put("READ-UNCOMMITED", new Integer(1));
        mapTransIsolationName2Value.put("READ-UNCOMMITTED", new Integer(1));
        mapTransIsolationName2Value.put("READ-COMMITTED", new Integer(2));
        mapTransIsolationName2Value.put("REPEATABLE-READ", new Integer(4));
        mapTransIsolationName2Value.put("SERIALIZABLE", new Integer(8));
        CHARSET_CONVERTER_NOT_AVAILABLE_MARKER = new Object();
    }

    class UltraDevWorkAround
    implements CallableStatement {
        private java.sql.PreparedStatement delegate = null;

        UltraDevWorkAround(java.sql.PreparedStatement pstmt) {
            this.delegate = pstmt;
        }

        public void setArray(int p1, Array p2) throws SQLException {
            this.delegate.setArray(p1, p2);
        }

        public Array getArray(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Array getArray(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public void setAsciiStream(int p1, InputStream p2, int p3) throws SQLException {
            this.delegate.setAsciiStream(p1, p2, p3);
        }

        public void setAsciiStream(String arg0, InputStream arg1, int arg2) throws SQLException {
            throw new NotImplemented();
        }

        public void setBigDecimal(int p1, BigDecimal p2) throws SQLException {
            this.delegate.setBigDecimal(p1, p2);
        }

        public void setBigDecimal(String arg0, BigDecimal arg1) throws SQLException {
            throw new NotImplemented();
        }

        public BigDecimal getBigDecimal(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public BigDecimal getBigDecimal(int p1, int p2) throws SQLException {
            throw new SQLException("Not supported");
        }

        public BigDecimal getBigDecimal(String arg0) throws SQLException {
            return null;
        }

        public void setBinaryStream(int p1, InputStream p2, int p3) throws SQLException {
            this.delegate.setBinaryStream(p1, p2, p3);
        }

        public void setBinaryStream(String arg0, InputStream arg1, int arg2) throws SQLException {
            throw new NotImplemented();
        }

        public void setBlob(int p1, Blob p2) throws SQLException {
            this.delegate.setBlob(p1, p2);
        }

        public Blob getBlob(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Blob getBlob(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public void setBoolean(int p1, boolean p2) throws SQLException {
            this.delegate.setBoolean(p1, p2);
        }

        public void setBoolean(String arg0, boolean arg1) throws SQLException {
            throw new NotImplemented();
        }

        public boolean getBoolean(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public boolean getBoolean(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public void setByte(int p1, byte p2) throws SQLException {
            this.delegate.setByte(p1, p2);
        }

        public void setByte(String arg0, byte arg1) throws SQLException {
            throw new NotImplemented();
        }

        public byte getByte(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public byte getByte(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public void setBytes(int p1, byte[] p2) throws SQLException {
            this.delegate.setBytes(p1, p2);
        }

        public void setBytes(String arg0, byte[] arg1) throws SQLException {
            throw new NotImplemented();
        }

        public byte[] getBytes(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public byte[] getBytes(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public void setCharacterStream(int p1, Reader p2, int p3) throws SQLException {
            this.delegate.setCharacterStream(p1, p2, p3);
        }

        public void setCharacterStream(String arg0, Reader arg1, int arg2) throws SQLException {
            throw new NotImplemented();
        }

        public void setClob(int p1, Clob p2) throws SQLException {
            this.delegate.setClob(p1, p2);
        }

        public Clob getClob(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Clob getClob(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public java.sql.Connection getConnection() throws SQLException {
            return this.delegate.getConnection();
        }

        public void setCursorName(String p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public void setDate(int p1, Date p2) throws SQLException {
            this.delegate.setDate(p1, p2);
        }

        public void setDate(int p1, Date p2, Calendar p3) throws SQLException {
            this.delegate.setDate(p1, p2, p3);
        }

        public void setDate(String arg0, Date arg1, Calendar arg2) throws SQLException {
            throw new NotImplemented();
        }

        public void setDate(String arg0, Date arg1) throws SQLException {
            throw new NotImplemented();
        }

        public Date getDate(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Date getDate(int p1, Calendar p2) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Date getDate(String arg0, Calendar arg1) throws SQLException {
            throw new NotImplemented();
        }

        public Date getDate(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public void setDouble(int p1, double p2) throws SQLException {
            this.delegate.setDouble(p1, p2);
        }

        public void setDouble(String arg0, double arg1) throws SQLException {
            throw new NotImplemented();
        }

        public double getDouble(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public double getDouble(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public void setEscapeProcessing(boolean p1) throws SQLException {
            this.delegate.setEscapeProcessing(p1);
        }

        public void setFetchDirection(int p1) throws SQLException {
            this.delegate.setFetchDirection(p1);
        }

        public int getFetchDirection() throws SQLException {
            return this.delegate.getFetchDirection();
        }

        public void setFetchSize(int p1) throws SQLException {
            this.delegate.setFetchSize(p1);
        }

        public int getFetchSize() throws SQLException {
            return this.delegate.getFetchSize();
        }

        public void setFloat(int p1, float p2) throws SQLException {
            this.delegate.setFloat(p1, p2);
        }

        public void setFloat(String arg0, float arg1) throws SQLException {
            throw new NotImplemented();
        }

        public float getFloat(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public float getFloat(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public java.sql.ResultSet getGeneratedKeys() throws SQLException {
            return this.delegate.getGeneratedKeys();
        }

        public void setInt(int p1, int p2) throws SQLException {
            this.delegate.setInt(p1, p2);
        }

        public void setInt(String arg0, int arg1) throws SQLException {
            throw new NotImplemented();
        }

        public int getInt(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public int getInt(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public void setLong(int p1, long p2) throws SQLException {
            this.delegate.setLong(p1, p2);
        }

        public void setLong(String arg0, long arg1) throws SQLException {
            throw new NotImplemented();
        }

        public long getLong(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public long getLong(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public void setMaxFieldSize(int p1) throws SQLException {
            this.delegate.setMaxFieldSize(p1);
        }

        public int getMaxFieldSize() throws SQLException {
            return this.delegate.getMaxFieldSize();
        }

        public void setMaxRows(int p1) throws SQLException {
            this.delegate.setMaxRows(p1);
        }

        public int getMaxRows() throws SQLException {
            return this.delegate.getMaxRows();
        }

        public ResultSetMetaData getMetaData() throws SQLException {
            throw new SQLException("Not supported");
        }

        public boolean getMoreResults() throws SQLException {
            return this.delegate.getMoreResults();
        }

        public boolean getMoreResults(int arg0) throws SQLException {
            return this.delegate.getMoreResults();
        }

        public void setNull(int p1, int p2) throws SQLException {
            this.delegate.setNull(p1, p2);
        }

        public void setNull(int p1, int p2, String p3) throws SQLException {
            this.delegate.setNull(p1, p2, p3);
        }

        public void setNull(String arg0, int arg1, String arg2) throws SQLException {
            throw new NotImplemented();
        }

        public void setNull(String arg0, int arg1) throws SQLException {
            throw new NotImplemented();
        }

        public void setObject(int p1, Object p2) throws SQLException {
            this.delegate.setObject(p1, p2);
        }

        public void setObject(int p1, Object p2, int p3) throws SQLException {
            this.delegate.setObject(p1, p2, p3);
        }

        public void setObject(int p1, Object p2, int p3, int p4) throws SQLException {
            this.delegate.setObject(p1, p2, p3, p4);
        }

        public void setObject(String arg0, Object arg1, int arg2, int arg3) throws SQLException {
            throw new NotImplemented();
        }

        public void setObject(String arg0, Object arg1, int arg2) throws SQLException {
            throw new NotImplemented();
        }

        public void setObject(String arg0, Object arg1) throws SQLException {
            throw new NotImplemented();
        }

        public Object getObject(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Object getObject(int p1, Map p2) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Object getObject(String arg0, Map arg1) throws SQLException {
            throw new NotImplemented();
        }

        public Object getObject(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public ParameterMetaData getParameterMetaData() throws SQLException {
            return this.delegate.getParameterMetaData();
        }

        public void setQueryTimeout(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public int getQueryTimeout() throws SQLException {
            return this.delegate.getQueryTimeout();
        }

        public void setRef(int p1, Ref p2) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Ref getRef(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Ref getRef(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public java.sql.ResultSet getResultSet() throws SQLException {
            return this.delegate.getResultSet();
        }

        public int getResultSetConcurrency() throws SQLException {
            return this.delegate.getResultSetConcurrency();
        }

        public int getResultSetHoldability() throws SQLException {
            return this.delegate.getResultSetHoldability();
        }

        public int getResultSetType() throws SQLException {
            return this.delegate.getResultSetType();
        }

        public void setShort(int p1, short p2) throws SQLException {
            this.delegate.setShort(p1, p2);
        }

        public void setShort(String arg0, short arg1) throws SQLException {
            throw new NotImplemented();
        }

        public short getShort(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public short getShort(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public void setString(int p1, String p2) throws SQLException {
            this.delegate.setString(p1, p2);
        }

        public void setString(String arg0, String arg1) throws SQLException {
            throw new NotImplemented();
        }

        public String getString(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public String getString(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public void setTime(int p1, Time p2) throws SQLException {
            this.delegate.setTime(p1, p2);
        }

        public void setTime(int p1, Time p2, Calendar p3) throws SQLException {
            this.delegate.setTime(p1, p2, p3);
        }

        public void setTime(String arg0, Time arg1, Calendar arg2) throws SQLException {
            throw new NotImplemented();
        }

        public void setTime(String arg0, Time arg1) throws SQLException {
            throw new NotImplemented();
        }

        public Time getTime(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Time getTime(int p1, Calendar p2) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Time getTime(String arg0, Calendar arg1) throws SQLException {
            throw new NotImplemented();
        }

        public Time getTime(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public void setTimestamp(int p1, Timestamp p2) throws SQLException {
            this.delegate.setTimestamp(p1, p2);
        }

        public void setTimestamp(int p1, Timestamp p2, Calendar p3) throws SQLException {
            this.delegate.setTimestamp(p1, p2, p3);
        }

        public void setTimestamp(String arg0, Timestamp arg1, Calendar arg2) throws SQLException {
            throw new NotImplemented();
        }

        public void setTimestamp(String arg0, Timestamp arg1) throws SQLException {
            throw new NotImplemented();
        }

        public Timestamp getTimestamp(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Timestamp getTimestamp(int p1, Calendar p2) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Timestamp getTimestamp(String arg0, Calendar arg1) throws SQLException {
            throw new NotImplemented();
        }

        public Timestamp getTimestamp(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public void setURL(String arg0, URL arg1) throws SQLException {
            throw new NotImplemented();
        }

        public void setURL(int arg0, URL arg1) throws SQLException {
            this.delegate.setURL(arg0, arg1);
        }

        public URL getURL(int arg0) throws SQLException {
            throw new NotImplemented();
        }

        public URL getURL(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public void setUnicodeStream(int p1, InputStream p2, int p3) throws SQLException {
            this.delegate.setUnicodeStream(p1, p2, p3);
        }

        public int getUpdateCount() throws SQLException {
            return this.delegate.getUpdateCount();
        }

        public SQLWarning getWarnings() throws SQLException {
            return this.delegate.getWarnings();
        }

        public void addBatch() throws SQLException {
            this.delegate.addBatch();
        }

        public void addBatch(String p1) throws SQLException {
            this.delegate.addBatch(p1);
        }

        public void cancel() throws SQLException {
            this.delegate.cancel();
        }

        public void clearBatch() throws SQLException {
            this.delegate.clearBatch();
        }

        public void clearParameters() throws SQLException {
            this.delegate.clearParameters();
        }

        public void clearWarnings() throws SQLException {
            this.delegate.clearWarnings();
        }

        public void close() throws SQLException {
            this.delegate.close();
        }

        public boolean execute() throws SQLException {
            return this.delegate.execute();
        }

        public boolean execute(String p1) throws SQLException {
            return this.delegate.execute(p1);
        }

        public boolean execute(String arg0, int arg1) throws SQLException {
            return this.delegate.execute(arg0, arg1);
        }

        public boolean execute(String arg0, int[] arg1) throws SQLException {
            return this.delegate.execute(arg0, arg1);
        }

        public boolean execute(String arg0, String[] arg1) throws SQLException {
            return this.delegate.execute(arg0, arg1);
        }

        public int[] executeBatch() throws SQLException {
            return this.delegate.executeBatch();
        }

        public java.sql.ResultSet executeQuery() throws SQLException {
            return this.delegate.executeQuery();
        }

        public java.sql.ResultSet executeQuery(String p1) throws SQLException {
            return this.delegate.executeQuery(p1);
        }

        public int executeUpdate() throws SQLException {
            return this.delegate.executeUpdate();
        }

        public int executeUpdate(String p1) throws SQLException {
            return this.delegate.executeUpdate(p1);
        }

        public int executeUpdate(String arg0, int arg1) throws SQLException {
            return this.delegate.executeUpdate(arg0, arg1);
        }

        public int executeUpdate(String arg0, int[] arg1) throws SQLException {
            return this.delegate.executeUpdate(arg0, arg1);
        }

        public int executeUpdate(String arg0, String[] arg1) throws SQLException {
            return this.delegate.executeUpdate(arg0, arg1);
        }

        public void registerOutParameter(int p1, int p2) throws SQLException {
            throw new SQLException("Not supported");
        }

        public void registerOutParameter(int p1, int p2, int p3) throws SQLException {
            throw new SQLException("Not supported");
        }

        public void registerOutParameter(int p1, int p2, String p3) throws SQLException {
            throw new SQLException("Not supported");
        }

        public void registerOutParameter(String arg0, int arg1, int arg2) throws SQLException {
            throw new NotImplemented();
        }

        public void registerOutParameter(String arg0, int arg1, String arg2) throws SQLException {
            throw new NotImplemented();
        }

        public void registerOutParameter(String arg0, int arg1) throws SQLException {
            throw new NotImplemented();
        }

        public boolean wasNull() throws SQLException {
            throw new SQLException("Not supported");
        }
    }
}

