/*
 *  pci-vr41xx.h, Include file for PCI Control Unit of the NEC VR4100 series.
 *
 *  Copyright (C) 2002  MontaVista Software Inc.
 *    Author: Yoichi Yuasa <yyuasa@mvista.com or source@mvista.com>
 *  Copyright (C) 2004  Yoichi Yuasa <yuasa@hh.iij4u.or.jp>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef __PCI_VR41XX_H
#define __PCI_VR41XX_H

#define PCIMMAW1REG		KSEG1ADDR(0x0f000c00)
#define PCIMMAW2REG		KSEG1ADDR(0x0f000c04)
#define PCITAW1REG		KSEG1ADDR(0x0f000c08)
#define PCITAW2REG		KSEG1ADDR(0x0f000c0c)
#define PCIMIOAWREG		KSEG1ADDR(0x0f000c10)
 #define IBA(addr)		((addr) & 0xff000000U)
 #define MASTER_MSK(mask)	(((mask) >> 11) & 0x000fe000U)
 #define PCIA(addr)		(((addr) >> 24) & 0x000000ffU)
 #define TARGET_MSK(mask)	(((mask) >> 8) & 0x000fe000U)
 #define ITA(addr)		(((addr) >> 24) & 0x000000ffU)
 #define PCIIA(addr)		(((addr) >> 24) & 0x000000ffU)
 #define WINEN			0x1000U
#define PCICONFDREG		KSEG1ADDR(0x0f000c14)
#define PCICONFAREG		KSEG1ADDR(0x0f000c18)
#define PCIMAILREG		KSEG1ADDR(0x0f000c1c)
#define BUSERRADREG		KSEG1ADDR(0x0f000c24)
 #define EA(reg)		((reg) &0xfffffffc)

#define INTCNTSTAREG		KSEG1ADDR(0x0f000c28)
 #define MABTCLR		0x80000000U
 #define TRDYCLR		0x40000000U
 #define PARCLR			0x20000000U
 #define MBCLR			0x10000000U
 #define SERRCLR		0x08000000U
 #define RTYCLR			0x04000000U
 #define MABCLR			0x02000000U
 #define TABCLR			0x01000000U
 /* RFU */
 #define MABTMSK		0x00008000U
 #define TRDYMSK		0x00004000U
 #define PARMSK			0x00002000U
 #define MBMSK			0x00001000U
 #define SERRMSK		0x00000800U
 #define RTYMSK			0x00000400U
 #define MABMSK			0x00000200U
 #define TABMSK			0x00000100U
 #define IBAMABT		0x00000080U
 #define TRDYRCH		0x00000040U
 #define PAR			0x00000020U
 #define MB			0x00000010U
 #define PCISERR		0x00000008U
 #define RTYRCH			0x00000004U
 #define MABORT			0x00000002U
 #define TABORT			0x00000001U

#define PCIEXACCREG		KSEG1ADDR(0x0f000c2c)
 #define UNLOCK			0x2U
 #define EAREQ			0x1U
#define PCIRECONTREG		KSEG1ADDR(0x0f000c30)
 #define RTRYCNT(reg)		((reg) & 0x000000ffU)
#define PCIENREG		KSEG1ADDR(0x0f000c34)
 #define BLOODY_CONFIG_DONE	0x4U
#define PCICLKSELREG		KSEG1ADDR(0x0f000c38)
 #define EQUAL_VTCLOCK		0x2U
 #define HALF_VTCLOCK		0x0U
 #define ONE_THIRD_VTCLOCK	0x3U
 #define QUARTER_VTCLOCK	0x1U
#define PCITRDYVREG		KSEG1ADDR(0x0f000c3c)
 #define TRDYV(val)		((uint32_t)(val) & 0xffU)
#define PCICLKRUNREG		KSEG1ADDR(0x0f000c60)

#define VENDORIDREG		KSEG1ADDR(0x0f000d00)
#define DEVICEIDREG		KSEG1ADDR(0x0f000d00)
#define COMMANDREG		KSEG1ADDR(0x0f000d04)
#define STATUSREG		KSEG1ADDR(0x0f000d04)
#define REVIDREG		KSEG1ADDR(0x0f000d08)
#define CLASSREG		KSEG1ADDR(0x0f000d08)
#define CACHELSREG		KSEG1ADDR(0x0f000d0c)
#define LATTIMEREG		KSEG1ADDR(0x0f000d0c)
 #define MLTIM(val)		(((uint32_t)(val) << 7) & 0xff00U)
#define MAILBAREG		KSEG1ADDR(0x0f000d10)
#define PCIMBA1REG		KSEG1ADDR(0x0f000d14)
#define PCIMBA2REG		KSEG1ADDR(0x0f000d18)
 #define MBADD(base)		((base) & 0xfffff800U)
 #define PMBA(base)		((base) & 0xffe00000U)
 #define PREF			0x8U
 #define PREF_APPROVAL		0x8U
 #define PREF_DISAPPROVAL	0x0U
 #define TYPE			0x6U
 #define TYPE_32BITSPACE	0x0U
 #define MSI			0x1U
 #define MSI_MEMORY		0x0U
#define INTLINEREG		KSEG1ADDR(0x0f000d3c)
#define INTPINREG		KSEG1ADDR(0x0f000d3c)
#define RETVALREG		KSEG1ADDR(0x0f000d40)
#define PCIAPCNTREG		KSEG1ADDR(0x0f000d40)
 #define TKYGNT			0x04000000U
 #define TKYGNT_ENABLE		0x04000000U
 #define TKYGNT_DISABLE		0x00000000U
 #define PAPC			0x03000000U
 #define PAPC_ALTERNATE_B	0x02000000U
 #define PAPC_ALTERNATE_0	0x01000000U
 #define PAPC_FAIR		0x00000000U
 #define RTYVAL(val)		(((uint32_t)(val) << 7) & 0xff00U)
 #define RTYVAL_MASK		0xff00U

#define PCI_CLOCK_MAX		33333333U

/*
 * Default setup
 */
#define PCI_MASTER_MEM1_BUS_BASE_ADDRESS	0x10000000U
#define PCI_MASTER_MEM1_ADDRESS_MASK		0x7c000000U
#define PCI_MASTER_MEM1_PCI_BASE_ADDRESS	0x10000000U

#define PCI_TARGET_MEM1_ADDRESS_MASK		0x08000000U
#define PCI_TARGET_MEM1_BUS_BASE_ADDRESS	0x00000000U

#define PCI_MASTER_IO_BUS_BASE_ADDRESS		0x16000000U
#define PCI_MASTER_IO_ADDRESS_MASK		0x7e000000U
#define PCI_MASTER_IO_PCI_BASE_ADDRESS		0x00000000U

#define PCI_MAILBOX_BASE_ADDRESS		0x00000000U

#define PCI_TARGET_WINDOW1_BASE_ADDRESS		0x00000000U

#define IO_PORT_BASE		KSEG1ADDR(PCI_MASTER_IO_BUS_BASE_ADDRESS)
#define IO_PORT_RESOURCE_START	PCI_MASTER_IO_PCI_BASE_ADDRESS
#define IO_PORT_RESOURCE_END	(~PCI_MASTER_IO_ADDRESS_MASK & PCI_MASTER_ADDRESS_MASK)

#define PCI_IO_RESOURCE_START	0x01000000UL
#define PCI_IO_RESOURCE_END	0x01ffffffUL

#define PCI_MEM_RESOURCE_START	0x11000000UL
#define PCI_MEM_RESOURCE_END	0x13ffffffUL

#endif /* __PCI_VR41XX_H */
