#!/bin/sh
# This file may be copied without restriction.

PATH=/bin:/usr/bin:/usr/local/bin:/usr/bin/X11:/usr/X11R6/bin
MD5SUM=/usr/bin/md5sum
FIND=/usr/bin/find
DIFF=/usr/bin/diff
RM=/bin/rm

PROJECT_NAME="swbis[^/]*"

# Get the package path.
	if [ "$1" ]; then
		base1="$1"
	else
		base1=`pwd`
	fi
	
	package_path=`echo "$base1" |
		sed -e s@'\(.*'"${PROJECT_NAME}"'\).*@\1@'` 

	package_dir=`echo "$base1" |
		sed -e s@'.*/\('"${PROJECT_NAME}"'\)@\1@' |
		sed -e s@'\('"${PROJECT_NAME}"'\).*@\1@'`


	echo "$package_dir" | grep / 1>/dev/null
	case $? in
		0)
			echo "Try running from within the package directory." 1>&2
			echo "script failed loc = 1" 1>&2
			exit 1
	esac


	echo "$package_dir" | grep . 1>/dev/null
	case $? in
		1)
			echo "Try running from within the package directory." 1>&2
			echo "script failed loc = 2" 1>&2
			exit 1
	esac

	#echo "$package_dir"
	#echo "$package_path"

cd "$package_path"
	case $? in
		0)
			;;
		*)
			echo "Try running from within the package directory." 1>&2
			echo "script failed loc = 3" 1>&2
			exit 1
			;;
	esac

TMPNAME=tmp/findsums

$FIND . \( -path './catalog' \)  -prune -o \( -type f -print  \) | xargs $MD5SUM >$TMPNAME

bin/info2digests.sh <catalog/INFO | ${DIFF} $TMPNAME -
ret=$? 

${RM} -f $TMPNAME

exit $ret
