/*
 * Copyright 2002 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * This class gathers together all the test cases for the dtv
 * directory into a single test suite.  As you create new test cases,
 * add them here.
 */

#include <qa_dtv.h>
#include <qa_atsc_randomizer.h>
#include <qa_atsc_reed_solomon.h>
#include <qa_interleaver_fifo.h>
#include <qa_convolutional_interleaver.h>
#include <qa_atsc_data_interleaver.h>
#include <qa_atsc_basic_trellis_encoder.h>
#include <qa_atsc_sliding_correlator.h>
#include <qa_atsc_fake_single_viterbi.h>
#include <qa_atsc_single_viterbi.h>
#include <qa_atsc_trellis_encoder.h>
#include <qa_atsc_viterbi_decoder.h>
#include <qa_atsc_fs_correlator.h>
#include <qa_atsc_equalizer_nop.h>

CppUnit::TestSuite *
qa_dtv::suite ()
{
  CppUnit::TestSuite	*s = new CppUnit::TestSuite ("dtv");

  qa_atsc_randomizer::register_tests (s);
  qa_atsc_reed_solomon::register_tests (s);
  qa_interleaver_fifo::register_tests (s);
  qa_convolutional_interleaver::register_tests (s);
  qa_atsc_data_interleaver::register_tests (s);
  qa_atsc_basic_trellis_encoder::register_tests (s);
  qa_atsc_sliding_correlator::register_tests (s);
  qa_atsc_fake_single_viterbi::register_tests (s);
  qa_atsc_single_viterbi::register_tests (s);
  qa_atsc_trellis_encoder::register_tests (s);
  qa_atsc_viterbi_decoder::register_tests (s);
  qa_atsc_fs_correlator::register_tests (s);
  qa_atsc_equalizer_nop::register_tests (s);
  
  return s;
}
