/* Copyright 2020 The Chromium OS Authors. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */
#include "body_detection_test_data.h"

const struct body_detect_test_data kBodyDetectOnBodyTestData[] = {
	/*       x,		y,		z, action*/
	{3.233367f,	1.968032f,	8.875299f,	0},
	{3.190272f,	2.127247f,	9.054865f,	0},
	{3.361457f,	2.057815f,	9.054865f,	0},
	{3.377019f,	1.917754f,	9.093172f,	0},
	{3.460816f,	1.817198f,	9.058456f,	0},
	{3.500320f,	1.726218f,	8.900438f,	0},
	{3.715799f,	1.363497f,	8.836992f,	0},
	{3.883393f,	0.884657f,	8.832204f,	0},
	{3.948036f,	0.577002f,	9.016558f,	0},
	{3.600877f,	0.717063f,	9.200911f,	0},
	{3.318361f,	0.854729f,	9.166195f,	0},
	{3.272871f,	0.731428f,	9.149436f,	0},
	{3.452436f,	0.250194f,	9.297876f,	0},
	{3.817552f,	-0.353144f,	9.424768f,	0},
	{3.828326f,	-0.495599f,	9.284708f,	0},
	{3.312376f,	-0.040701f,	9.204502f,	0},
	{3.049014f,	0.515950f,	9.223656f,	0},
	{3.099292f,	0.980425f,	8.882483f,	0},
	{3.153162f,	1.443703f,	8.154645f,	0},
	{3.501518f,	1.487995f,	8.054089f,	0},
	{4.235340f,	1.292868f,	8.480257f,	0},
	{4.284421f,	1.511937f,	8.848964f,	0},
	{3.988737f,	1.928528f,	9.149436f,	0},
	{3.825932f,	2.076969f,	9.576800f,	0},
	{3.903743f,	1.991974f,	10.133451f,	0},
	{3.841494f,	2.000354f,	10.165773f,	0},
	{3.706222f,	1.930922f,	9.649823f,	0},
	{3.949233f,	1.614888f,	9.054865f,	0},
	{4.237734f,	1.272517f,	8.625106f,	0},
	{4.188653f,	1.134851f,	8.268370f,	0},
	{4.242523f,	0.991199f,	8.091199f,	0},
	{4.157528f,	0.970848f,	8.135491f,	0},
	{3.951627f,	0.967257f,	8.353364f,	0},
	{4.073731f,	0.994790f,	8.854949f,	0},
	{3.840297f,	1.124077f,	9.249992f,	0},
	{3.736149f,	1.142033f,	9.491806f,	0},
	{3.809172f,	1.126471f,	9.651020f,	0},
	{3.987540f,	1.173158f,	9.633064f,	0},
	{4.237734f,	1.005564f,	9.467864f,	0},
	{4.308363f,	0.939724f,	9.190137f,	0},
	{4.367021f,	0.986410f,	9.021346f,	0},
	{4.406525f,	1.033097f,	9.074018f,	0},
	{4.185062f,	1.276109f,	9.235627f,	0},
	{3.971978f,	1.363497f,	9.525325f,	0},
	{4.031833f,	1.318007f,	10.833755f,	0},
	{4.214989f,	1.144428f,	10.241191f,	0},
	{4.808751f,	0.590170f,	9.690525f,	0},
	{4.697421f,	0.372298f,	10.245979f,	0},
	{4.490322f,	0.207098f,	9.682145f,	0},
	{4.353853f,	0.494402f,	8.651442f,	0},
	{3.981555f,	1.094149f,	8.230062f,	0},
	{3.933671f,	1.310825f,	8.426387f,	0},
	{4.107250f,	1.189917f,	9.068033f,	0},
	{4.529827f,	0.888248f,	9.501383f,	0},
	{4.699815f,	0.720654f,	9.765942f,	0},
	{4.661508f,	0.647631f,	9.916777f,	0},
	{4.627989f,	0.587776f,	9.925157f,	0},
	{4.413708f,	0.587776f,	9.791081f,	0},
	{4.369415f,	0.466869f,	9.840162f,	0},
	{4.412511f,	0.335188f,	9.932339f,	0},
	{4.234143f,	0.452504f,	9.502580f,	0},
	{3.817552f,	1.055842f,	8.638274f,	0},
	{3.130417f,	1.842337f,	7.748828f,	0},
	{2.511516f,	2.430113f,	7.059299f,	0},
	{2.267308f,	2.840718f,	6.742067f,	0},
	{2.082954f,	3.129220f,	6.706154f,	0},
	{1.653195f,	3.483561f,	6.813893f,	0},
	{1.053448f,	3.797201f,	7.132322f,	0},
	{0.333991f,	4.125207f,	7.364560f,	0},
	{-0.039504f,	4.228158f,	8.018176f,	0},
	{0.403423f,	3.726573f,	8.789108f,	0},
	{1.179144f,	3.120840f,	9.289496f,	0},
	{1.683123f,	2.905362f,	9.911988f,	0},
	{1.442506f,	3.038240f,	10.551240f,	0},
	{1.403001f,	2.936486f,	12.229574f,	0},
	{1.601720f,	2.541443f,	14.815310f,	0},
	{2.233789f,	2.037464f,	14.715951f,	0},
	{2.664745f,	1.736992f,	12.216406f,	0},
	{3.331529f,	1.385045f,	10.475822f,	0},
	{3.337515f,	1.235407f,	9.133873f,	0},
	{3.173512f,	1.292868f,	8.406036f,	0},
	{3.201046f,	1.462856f,	8.306677f,	0},
	{3.157950f,	1.595734f,	9.011769f,	0},
	{2.759315f,	1.777694f,	10.049655f,	0},
	{2.315192f,	2.105699f,	10.682920f,	0},
	{2.063801f,	2.375046f,	10.832559f,	0},
	{2.310403f,	2.485180f,	10.688907f,	0},
	{2.553414f,	2.606087f,	10.153803f,	0},
	{2.475603f,	2.731782f,	9.356534f,	0},
	{2.710234f,	2.529472f,	9.297876f,	0},
	{2.777272f,	2.193087f,	9.394841f,	0},
	{2.938881f,	1.920148f,	9.531310f,	0},
	{3.108869f,	1.635239f,	10.534480f,	0},
	{3.187877f,	1.425746f,	10.899596f,	0},
	{3.448845f,	1.331175f,	10.508144f,	0},
	{3.606862f,	1.470039f,	9.440331f,	0},
	{3.700236f,	1.162384f,	8.781926f,	0},
	{3.713404f,	0.864306f,	8.845372f,	0},
	{3.575738f,	0.404620f,	9.610319f,	0},
	{3.495532f,	-0.130484f,	9.526522f,	0},
	{3.403355f,	-0.411802f,	8.833401f,	0},
	{3.203440f,	-0.380678f,	8.850161f,	0},
	{2.822762f,	-0.191536f,	9.560040f,	0},
	{2.488771f,	-0.459686f,	9.883258f,	0},
	{3.065773f,	-0.764947f,	10.110707f,	0},
	{1.993172f,	1.004367f,	9.798264f,	0},
	{2.426522f,	1.732204f,	10.036487f,	0},
	{3.213017f,	1.238999f,	10.182533f,	0},
	{2.779666f,	2.394200f,	9.916777f,	0},
	{3.187877f,	2.622846f,	9.593559f,	0},
	{4.195836f,	1.867476f,	9.876076f,	0},
	{3.720587f,	2.114079f,	9.998179f,	0},
	{2.948457f,	2.766498f,	9.500186f,	0},
	{3.869027f,	2.822762f,	9.572012f,	0},
	{4.205412f,	2.656365f,	9.753971f,	0},
	{4.151543f,	2.828747f,	9.751576f,	0},
	{4.046198f,	2.905362f,	9.131479f,	0},
	{3.915714f,	3.032254f,	8.237246f,	0},
	{3.864239f,	3.126825f,	8.008599f,	0},
	{3.466802f,	2.999933f,	8.634683f,	0},
	{2.876631f,	2.902968f,	9.473849f,	0},
	{2.329557f,	2.899376f,	10.187322f,	0},
	{2.197876f,	3.608059f,	10.637431f,	0},
	{2.357090f,	4.205412f,	10.235206f,	0},
	{2.716220f,	4.076126f,	9.261963f,	0},
	{3.520671f,	3.847480f,	8.461103f,	0},
	{4.180274f,	3.879801f,	7.758405f,	0},
	{4.691435f,	4.034227f,	7.019794f,	0},
	{4.918884f,	3.915714f,	6.659468f,	0},
	{4.722559f,	4.205412f,	6.113590f,	0},
	{5.349840f,	4.169499f,	5.413286f,	0},
	{6.423639f,	3.742135f,	5.009864f,	0},
	{6.799528f,	3.581723f,	4.843467f,	0},
	{6.915647f,	3.337515f,	4.921278f,	0},
	{7.358574f,	3.173512f,	5.214568f,	0},
	{7.584826f,	2.861069f,	5.182246f,	0},
	{7.077255f,	2.771286f,	5.073310f,	0},
	{7.192177f,	2.306812f,	5.501872f,	0},
	{7.241258f,	2.145203f,	5.888535f,	0},
	{7.599191f,	1.898601f,	6.099225f,	0},
	{7.576446f,	2.138021f,	6.144714f,	0},
	{7.465116f,	1.962047f,	6.021413f,	0},
	{7.677002f,	1.740583f,	5.643129f,	0},
	{7.966701f,	1.648407f,	4.964374f,	0},
	{8.038527f,	1.636436f,	4.419693f,	0},
	{8.176193f,	1.582566f,	4.183865f,	0},
	{8.489834f,	1.460462f,	4.319137f,	0},
	{8.804670f,	1.314416f,	4.444832f,	0},
	{8.803473f,	1.308430f,	4.492716f,	0},
	{8.580813f,	1.392227f,	4.501096f,	0},
	{8.056483f,	1.595734f,	4.428073f,	0},
	{8.418008f,	1.316810f,	4.600455f,	0},
	{8.826219f,	1.170764f,	4.411314f,	0},
	{8.652639f,	1.201888f,	3.910926f,	0},
	{8.285130f,	0.927753f,	3.752909f,	0},
	{8.475469f,	1.027112f,	3.569752f,	0},
	{9.009375f,	0.708683f,	3.605665f,	0},
	{8.797488f,	0.600944f,	3.107672f,	0},
	{8.864526f,	0.620098f,	2.863463f,	0},
	{8.833401f,	0.214281f,	2.640803f,	0},
	{9.212882f,	0.150835f,	2.487574f,	0},
	{9.308650f,	0.226252f,	2.375046f,	0},
	{8.869314f,	0.094571f,	2.142809f,	0},
	{9.208094f,	0.002394f,	2.132035f,	0},
	{9.100354f,	0.015562f,	2.367864f,	0},
	{8.973462f,	-0.011971f,	2.602495f,	0},
	{8.872906f,	0.000000f,	2.564188f,	0},
	{8.883679f,	0.092177f,	2.452858f,	0},
	{8.857343f,	0.241814f,	2.480391f,	0},
	{8.919592f,	0.371101f,	2.612072f,	0},
	{9.002192f,	0.483628f,	2.536655f,	0},
	{9.056062f,	0.521936f,	2.335542f,	0},
	{9.023740f,	0.572214f,	2.012325f,	0},
	{9.085989f,	0.592565f,	1.854308f,	0},
	{9.127888f,	0.505176f,	1.783679f,	0},
	{8.968674f,	0.653617f,	1.787270f,	0},
	{8.872906f,	0.650025f,	1.867476f,	0},
	{8.798685f,	0.628478f,	2.148795f,	0},
	{8.841781f,	0.530315f,	2.687490f,	0},
	{8.541308f,	0.642843f,	2.780863f,	0},
	{8.499411f,	0.402226f,	2.566582f,	0},
	{8.734042f,	-0.217872f,	2.597707f,	0},
	{8.689749f,	-0.295684f,	3.051408f,	0},
	{8.298298f,	-0.123301f,	3.968387f,	0},
	{7.545321f,	-0.111330f,	4.738122f,	0},
	{6.827062f,	-0.112527f,	5.501872f,	0},
	{6.604401f,	0.435744f,	6.827062f,	0},
	{6.572079f,	0.610521f,	7.642287f,	0},
	{6.546940f,	0.383072f,	7.778756f,	0},
	{6.274001f,	0.530315f,	7.600388f,	0},
	{5.847834f,	1.544259f,	7.811078f,	0},
	{5.374979f,	1.781285f,	7.654258f,	0},
	{5.163093f,	1.493981f,	7.372939f,	0},
	{5.104434f,	1.314416f,	7.807487f,	0},
	{5.424060f,	0.847547f,	8.513776f,	0},
	{5.471944f,	0.817619f,	8.461103f,	0},
	{4.618412f,	1.319204f,	8.107959f,	0},
	{4.265267f,	1.634042f,	7.587220f,	0},
	{5.191823f,	1.347935f,	7.196965f,	0},
	{4.748896f,	1.868673f,	7.097606f,	0},
	{4.595667f,	1.187523f,	7.428006f,	0},
	{3.948036f,	1.272517f,	8.262384f,	0},
	{2.280476f,	1.892615f,	8.998601f,	0},
	{2.828747f,	1.725021f,	8.937549f,	0},
	{3.256112f,	1.863885f,	9.101552f,	0},
	{3.264492f,	1.679531f,	8.540112f,	0},
	{3.616439f,	1.237801f,	8.178588f,	0},
	{3.713404f,	1.492784f,	9.411600f,	0},
	{3.654746f,	1.428140f,	10.740381f,	0},
	{3.139993f,	1.246181f,	10.362098f,	0},
	{2.381032f,	1.161187f,	9.357731f,	0},
	{2.602495f,	1.027112f,	11.311399f,	0},
	{2.964020f,	1.120486f,	12.570747f,	0},
	{2.501939f,	1.344343f,	10.244782f,	0},
	{2.152386f,	1.455674f,	9.786293f,	0},
	{1.878250f,	1.450885f,	10.216052f,	0},
	{1.844731f,	1.434126f,	12.245136f,	0},
	{2.011128f,	1.198297f,	13.654123f,	0},
	{1.562216f,	1.192312f,	10.202884f,	0},
	{1.046265f,	1.596931f,	8.796291f,	0},
	{1.344343f,	1.769314f,	9.710876f,	0},
	{1.857899f,	1.845928f,	10.510538f,	0},
	{2.217029f,	1.814804f,	11.314989f,	0},
	{2.341528f,	1.612494f,	11.218024f,	0},
	{2.144006f,	1.527500f,	10.122678f,	0},
	{2.220621f,	1.271320f,	10.222037f,	0},
	{2.487574f,	0.978031f,	10.830164f,	0},
	{2.782060f,	0.950497f,	11.261120f,	0},
	{3.031057f,	0.894234f,	10.802630f,	0},
	{2.880223f,	0.992396f,	9.764745f,	0},
	{2.115276f,	1.447294f,	8.930367f,	0},
	{1.849520f,	1.715444f,	8.956702f,	0},
	{2.313994f,	1.569398f,	9.429557f,	0},
	{2.365470f,	1.504755f,	9.142253f,	0},
	{2.184708f,	1.528697f,	8.570039f,	0},
	{2.346316f,	1.491587f,	8.657428f,	0},
	{2.662350f,	1.338358f,	8.938745f,	0},
	{2.619255f,	1.200691f,	8.894453f,	0},
	{2.372652f,	1.073799f,	8.850161f,	0},
	{2.363075f,	1.012747f,	9.173378f,	0},
	{2.529472f,	1.101332f,	9.485821f,	0},
	{2.730585f,	1.132457f,	9.469061f,	0},
	{2.913742f,	1.120486f,	9.311044f,	0},
	{3.093307f,	1.151610f,	9.610319f,	0},
	{3.087321f,	1.296459f,	10.226826f,	0},
	{2.811988f,	1.377862f,	10.601518f,	0},
	{2.683898f,	1.231816f,	10.516523f,	0},
	{2.584539f,	1.250970f,	10.043670f,	0},
	{2.732979f,	1.283291f,	9.721649f,	0},
	{2.949655f,	1.004367f,	9.597151f,	0},
	{2.908953f,	0.938526f,	9.525325f,	0},
	{2.630029f,	1.124077f,	9.534902f,	0},
	{2.710234f,	0.859518f,	9.769533f,	0},
	{2.574962f,	0.883460f,	9.832980f,	0},
	{2.279279f,	1.092952f,	9.628276f,	0},
	{2.272096f,	1.016338f,	9.598348f,	0},
	{2.448070f,	0.889445f,	9.724044f,	0},
	{2.395397f,	0.984016f,	9.685737f,	0},
	{2.266110f,	1.094149f,	9.788687f,	0},
	{2.366667f,	1.074996f,	9.836571f,	0},
	{2.486377f,	1.023521f,	9.856922f,	0},
	{2.391806f,	1.103726f,	9.935930f,	0},
	{2.179919f,	1.174355f,	9.900018f,	0},
	{2.024296f,	1.203086f,	9.925157f,	0},
	{2.039858f,	1.156399f,	9.900018f,	0},
	{2.087743f,	1.066616f,	9.976632f,	0},
	{2.084151f,	0.975637f,	9.853331f,	0},
	{2.179919f,	0.985213f,	9.618699f,	0},
	{2.300826f,	1.031900f,	9.533705f,	0},
	{2.246957f,	1.083376f,	9.599545f,	0},
	{2.124853f,	0.970848f,	9.703692f,	0},
	{2.005142f,	1.036689f,	9.664188f,	0},
	{2.142809f,	1.047463f,	9.641443f,	0},
	{2.340331f,	0.885854f,	9.666583f,	0},
	{2.238577f,	0.888248f,	9.624684f,	0},
	{2.110487f,	0.960074f,	9.634261f,	0},
	{2.123656f,	1.030703f,	9.668977f,	0},
	{2.196679f,	1.061828f,	9.731226f,	0},
	{2.325965f,	0.931344f,	9.607924f,	0},
	{2.492362f,	0.841561f,	9.391250f,	0},
	{2.663548f,	0.991199f,	9.607924f,	0},
	{2.663548f,	0.933738f,	9.994588f,	0},
	{2.318783f,	0.817619f,	9.791081f,	0},
	{1.841140f,	0.946906f,	9.582786f,	0},
	{1.580172f,	1.162384f,	9.424768f,	0},
	{1.405395f,	1.210268f,	9.209291f,	0},
	{1.625662f,	1.034294f,	9.338577f,	0},
	{1.824380f,	1.120486f,	9.599545f,	0},
	{1.843534f,	1.120486f,	10.004165f,	0},
	{2.057815f,	0.648828f,	10.226826f,	0},
	{2.493559f,	0.673967f,	9.695313f,	0},
	{2.706643f,	0.766144f,	9.198517f,	0},
	{2.315192f,	0.678756f,	8.605952f,	0},
	{1.771708f,	0.752976f,	8.489834f,	0},
	{1.243787f,	0.969651f,	9.085989f,	0},
	{1.102529f,	0.957680f,	9.589969f,	0},
	{0.967257f,	0.730231f,	9.928748f,	0},
	{0.428562f,	0.812831f,	10.267527f,	0},
	{0.254982f,	1.097741f,	10.530889f,	0},
	{0.830787f,	1.238999f,	10.898398f,	0},
	{1.181538f,	1.061828f,	11.079161f,	0},
	{1.320401f,	1.142033f,	11.312595f,	0},
	{1.430535f,	0.967257f,	11.358085f,	0},
	{1.130062f,	0.909796f,	11.218024f,	0},
	{0.805648f,	0.810437f,	11.358085f,	0},
	{0.553060f,	0.751779f,	11.392801f,	0},
	{0.617704f,	0.609324f,	11.170140f,	0},
	{0.879869f,	0.511162f,	11.275485f,	0},
	{0.829590f,	0.587776f,	11.293442f,	0},
	{0.312443f,	0.672770f,	11.064795f,	0},
	{0.293290f,	0.867898f,	10.777492f,	0},
	{0.509965f,	0.920570f,	10.351324f,	0},
	{0.536301f,	1.023521f,	10.133451f,	0},
	{0.774524f,	1.107318f,	10.016136f,	0},
	{1.381453f,	0.903811f,	9.916777f,	0},
	{1.589749f,	0.810437f,	9.695313f,	0},
	{1.593340f,	0.811634f,	9.537296f,	0},
	{1.824380f,	0.887051f,	9.521733f,	0},
	{1.902192f,	0.964863f,	9.576800f,	0},
	{1.674743f,	1.398213f,	9.964661f,	0},
	{1.234210f,	1.440111f,	9.610319f,	0},
	{1.334767f,	1.115697f,	9.568420f,	0},
	{1.393424f,	1.659181f,	9.431952f,	0},
	{1.001973f,	2.656365f,	9.647429f,	0},
	{0.780509f,	3.013101f,	9.451105f,	0},
	{1.270123f,	3.008312f,	9.417586f,	0},
	{1.909375f,	3.031057f,	9.946704f,	0},
	{1.747766f,	3.309982f,	9.271540f,	0},
	{1.356314f,	3.300405f,	8.287523f,	0},
	{0.751779f,	3.156753f,	7.970292f,	0},
	{0.063446f,	3.359063f,	8.893256f,	0},
	{0.136469f,	3.002327f,	8.529338f,	0},
	{0.253785f,	3.015495f,	8.072045f,	0},
	{-0.045490f,	3.882195f,	8.609544f,	0},
	{0.149638f,	4.250902f,	9.435542f,	0},
	{1.071405f,	3.465605f,	9.838965f,	0},
	{1.856702f,	3.051408f,	11.276682f,	0},
	{2.770089f,	2.961626f,	10.789463f,	0},
	{3.514686f,	2.636014f,	7.386107f,	0},
	{3.545810f,	2.828747f,	7.304704f,	0},
	{3.815158f,	3.108869f,	6.725308f,	0},
	{3.323150f,	3.184286f,	4.733334f,	0},
	{2.572568f,	3.155556f,	6.907267f,	0},
	{3.299208f,	2.012325f,	9.501383f,	0},
	{3.531445f,	2.621649f,	8.761575f,	0},
	{4.510673f,	3.228579f,	12.022475f,	0},
	{6.127955f,	1.776496f,	13.516457f,	0},
	{5.631158f,	1.547850f,	11.772282f,	0},
	{5.889732f,	-0.058658f,	7.119154f,	0},
	{4.481943f,	1.406592f,	6.591233f,	0},
	{4.230552f,	1.640027f,	9.447514f,	0},
	{4.007891f,	0.654814f,	11.417940f,	0},
	{4.525038f,	0.415394f,	11.757916f,	0},
	{4.125207f,	0.555454f,	10.915158f,	0},
	{3.624819f,	0.526724f,	9.951492f,	0},
	{3.210622f,	0.480037f,	10.086765f,	0},
	{3.298011f,	1.221042f,	9.670174f,	0},
	{3.142388f,	1.479616f,	9.212882f,	0},
	{2.955640f,	1.448491f,	8.816642f,	0},
	{3.101686f,	2.088940f,	9.536098f,	0},
	{3.215411f,	2.460041f,	9.319424f,	0},
	{3.247732f,	2.573765f,	8.180982f,	0},
	{3.251324f,	2.348710f,	8.084017f,	0},
	{3.372231f,	2.255337f,	9.076412f,	0},
	{3.545810f,	2.310403f,	9.700102f,	0},
	{3.739741f,	2.173934f,	9.156618f,	0},
	{3.809172f,	1.825577f,	9.087187f,	0},
	{3.727770f,	1.434126f,	9.709679f,	0},
	{3.596088f,	1.175552f,	10.115496f,	0},
	{3.452436f,	1.128865f,	9.888046f,	0},
	{3.217805f,	1.009155f,	9.366111f,	0},
	{3.197454f,	1.152807f,	9.042893f,	0},
	{3.360260f,	1.312022f,	8.710100f,	0},
	{3.630804f,	1.417366f,	8.561660f,	0},
	{3.858253f,	1.345540f,	8.723268f,	0},
	{4.018665f,	1.070207f,	9.018951f,	0},
	{4.181470f,	0.847547f,	9.135071f,	0},
	{4.359838f,	0.720654f,	9.123099f,	0},
	{4.487928f,	0.720654f,	9.082398f,	0},
	{4.380189f,	0.676362f,	9.085989f,	0},
	{4.357444f,	0.766144f,	9.149436f,	0},
	{4.260479f,	0.820014f,	8.944732f,	0},
	{4.271253f,	0.809240f,	9.156618f,	0},
	{4.315546f,	0.563834f,	9.089581f,	0},
	{4.484337f,	0.366313f,	8.816642f,	1},
	{4.460395f,	0.489614f,	8.925578f,	0},
	{4.448424f,	0.270545f,	9.436740f,	0},
	{4.559754f,	0.149638f,	9.291890f,	0},
	{4.551374f,	0.318429f,	8.737633f,	0},
	{4.523841f,	0.301669f,	8.877694f,	0},
	{4.411314f,	0.075417f,	9.094369f,	0},
	{4.203018f,	-0.062249f,	9.162603f,	0},
	{4.171894f,	-0.029928f,	8.957899f,	0},
	{4.235340f,	-0.195127f,	9.186545f,	0},
	{4.386175f,	-0.499191f,	9.753971f,	0},
	{4.505885f,	-0.679953f,	10.381251f,	0},
	{4.586090f,	-0.547075f,	10.471034f,	0},
	{4.892548f,	-0.622492f,	9.931142f,	0},
	{5.498281f,	-0.993593f,	9.714467f,	0},
	{5.907689f,	-1.383848f,	9.782701f,	0},
	{6.193796f,	-1.279700f,	9.963464f,	0},
	{6.526589f,	-1.408987f,	8.862131f,	0},
	{6.619963f,	-2.099714f,	7.775165f,	0},
	{6.324279f,	-2.311600f,	7.964306f,	0},
	{5.984303f,	-2.063801f,	9.196122f,	0},
	{5.639538f,	-1.571792f,	8.735239f,	0},
	{5.276817f,	-1.029506f,	7.680594f,	0},
	{5.011061f,	-0.629675f,	7.769179f,	0},
	{4.618412f,	-0.131681f,	8.444344f,	0},
	{4.189850f,	0.440533f,	8.780728f,	0},
	{4.214989f,	1.012747f,	8.608346f,	0},
	{4.211398f,	1.684320f,	8.520958f,	0},
	{4.193441f,	2.132035f,	9.264358f,	0},
	{4.256888f,	2.742556f,	9.690525f,	0},
	{4.542994f,	3.782836f,	9.542085f,	0},
	{5.335475f,	4.732136f,	8.649048f,	0},
	{5.679042f,	5.600034f,	7.328646f,	0},
	{5.938813f,	6.015428f,	5.878958f,	0},
	{5.702984f,	5.841848f,	3.946839f,	0},
	{5.978318f,	4.942826f,	2.680307f,	0},
	{6.204569f,	4.444832f,	3.429692f,	0},
	{6.102816f,	4.230552f,	4.288013f,	0},
	{6.244074f,	4.173091f,	4.954797f,	0},
	{6.355404f,	3.830720f,	5.212173f,	0},
	{7.004232f,	3.655943f,	4.850649f,	0},
	{7.965504f,	2.867055f,	4.497505f,	0},
	{8.603558f,	3.070562f,	4.267662f,	0},
	{9.105143f,	4.338291f,	4.809948f,	0},
	{8.657428f,	4.848255f,	3.834311f,	0},
	{7.819458f,	5.075704f,	0.330400f,	0},
	{7.815866f,	5.650312f,	-3.190272f,	0},
	{7.144293f,	6.502647f,	-10.860091f,	0},
	{7.374136f,	4.941629f,	-7.758405f,	0},
	{8.832204f,	3.672703f,	0.448913f,	0},
	{9.153027f,	3.536233f,	0.270545f,	0},
	{8.880088f,	4.343079f,	0.025139f,	0},
	{8.923183f,	4.811145f,	-0.472855f,	0},
	{9.080004f,	4.722559f,	-0.604536f,	0},
	{9.029726f,	4.490322f,	-0.079009f,	0},
	{9.149436f,	4.181470f,	-0.168791f,	0},
	{9.192532f,	4.162317f,	-0.488417f,	0},
	{9.105143f,	4.446030f,	-0.647631f,	0},
	{9.289496f,	4.550177f,	-0.691924f,	0},
	{9.198517f,	4.359838f,	-0.305261f,	0},
	{8.995009f,	4.213792f,	0.192733f,	0},
	{8.955505f,	4.545389f,	-0.177171f,	0},
	{8.451527f,	5.149924f,	-1.136048f,	0},
	{7.418429f,	5.443214f,	0.033519f,	0},
	{6.846215f,	5.254072f,	2.087743f,	0},
	{7.192177f,	4.586090f,	3.452436f,	0},
	{7.727281f,	3.658338f,	3.614045f,	0},
	{8.420402f,	3.105278f,	2.424128f,	0},
	{9.446317f,	2.968808f,	1.719036f,	0},
	{9.706087f,	2.862266f,	2.051830f,	0},
	{9.520536f,	2.778469f,	2.466026f,	0},
	{9.439134f,	2.862266f,	3.065773f,	0},
	{8.769955f,	3.287237f,	3.415326f,	0},
	{8.048103f,	3.784033f,	2.977188f,	0},
	{7.817063f,	3.926488f,	1.849520f,	0},
	{8.365335f,	3.857056f,	0.901416f,	0},
	{8.749604f,	3.778048f,	0.855927f,	0},
	{7.741646f,	4.425679f,	1.212662f,	0},
	{6.775586f,	5.135559f,	1.638830f,	0},
	{7.811078f,	4.550177f,	3.052605f,	0},
	{8.285130f,	4.247311f,	3.077744f,	0},
	{8.590390f,	4.511870f,	2.555809f,	0},
	{8.787911f,	4.813539f,	2.319980f,	0},
	{8.252808f,	4.928461f,	1.952470f,	0},
	{7.679397f,	4.880577f,	1.568201f,	0},
	{7.946350f,	4.525038f,	1.531091f,	0},
	{8.236049f,	4.353853f,	1.537076f,	0},
	{8.593981f,	4.235340f,	1.843534f,	0},
	{8.511381f,	4.062957f,	1.691502f,	0},
	{8.268370f,	4.389766f,	1.649604f,	0},
	{8.129506f,	5.080492f,	1.691502f,	0},
	{8.280341f,	5.632356f,	1.444900f,	0},
	{8.936352f,	5.948390f,	1.972821f,	0},
	{10.184927f,	5.974726f,	3.705025f,	0},
	{11.186900f,	5.440820f,	3.477576f,	0},
	{11.239573f,	4.985922f,	1.543062f,	0},
	{11.077964f,	4.748896f,	1.107318f,	0},
	{10.912764f,	4.514264f,	1.528697f,	0},
	{10.890019f,	3.810369f,	1.624465f,	0},
	{9.329000f,	2.948457f,	1.057039f,	0},
	{7.509408f,	2.424128f,	1.201888f,	0},
	{7.207739f,	1.965638f,	1.035492f,	0},
	{7.030569f,	1.936908f,	0.076614f,	0},
	{6.907267f,	2.347513f,	-0.646434f,	0},
	{7.483072f,	2.871843f,	-0.088585f,	0},
	{8.190558f,	3.590103f,	1.675940f,	0},
	{8.498213f,	3.961204f,	1.974018f,	0},
	{8.552083f,	3.774457f,	1.284488f,	0},
	{8.402445f,	3.895364f,	2.099714f,	0},
	{8.273158f,	4.100068f,	2.432507f,	0},
	{8.030147f,	4.141966f,	1.668757f,	0},
	{7.900860f,	4.010285f,	1.027112f,	0},
	{7.912831f,	3.936065f,	0.803254f,	0},
	{7.878115f,	4.007891f,	0.687135f,	0},
	{7.789530f,	4.050986f,	0.326808f,	0},
	{8.213304f,	3.869027f,	0.050278f,	0},
	{8.558068f,	3.667914f,	0.016759f,	0},
	{8.617923f,	3.523065f,	0.405817f,	0},
	{8.524549f,	3.506306f,	0.683544f,	0},
	{8.438358f,	3.640381f,	0.433350f,	0},
	{8.262384f,	3.952824f,	0.190339f,	0},
	{8.115141f,	4.276042f,	0.306458f,	0},
	{8.386883f,	4.367021f,	0.554257f,	0},
	{8.827415f,	4.244917f,	0.985213f,	0},
	{9.200911f,	4.337093f,	0.806845f,	0},
	{10.524903f,	4.668690f,	-0.792480f,	0},
	{11.640601f,	4.612426f,	-1.328781f,	0},
	{11.060007f,	4.495111f,	-0.488417f,	0},
	{9.582786f,	5.093661f,	0.833182f,	0},
	{9.582786f,	5.696999f,	1.917754f,	0},
	{10.176547f,	5.428849f,	1.911769f,	0},
	{10.186124f,	5.148727f,	2.031479f,	0},
	{9.921565f,	4.803962f,	2.525881f,	0},
	{9.082398f,	3.547007f,	2.503136f,	0},
	{8.127112f,	2.201467f,	3.013101f,	0},
	{8.121126f,	2.080560f,	3.895364f,	0},
	{7.538139f,	3.345895f,	3.219002f,	0},
	{7.010218f,	3.763683f,	2.015916f,	0},
	{7.691368f,	3.278857f,	1.988383f,	0},
	{9.029726f,	2.555809f,	2.470814f,	0},
	{9.815023f,	2.255337f,	1.878250f,	0},
	{9.594757f,	2.603693f,	0.724246f,	0},
	{8.785517f,	3.135205f,	0.660799f,	0},
	{8.186967f,	3.447648f,	1.098938f,	0},
	{7.940364f,	3.257309f,	1.605311f,	0},
	{7.721295f,	2.911347f,	1.705868f,	0},
	{7.763194f,	2.804805f,	1.307233f,	0},
	{8.137886f,	2.965217f,	1.130062f,	0},
	{8.329422f,	3.266886f,	1.200691f,	0},
	{8.224077f,	3.472787f,	1.547850f,	0},
	{7.841005f,	3.687068f,	1.614888f,	0},
	{7.527365f,	4.015073f,	1.435323f,	0},
	{7.979869f,	4.304772f,	1.449688f,	0},
	{6.466734f,	4.948812f,	0.798466f,	0},
	{5.912477f,	5.204991f,	0.487220f,	0},
	{8.413219f,	5.108026f,	3.270477f,	0},
	{9.945507f,	5.396527f,	3.342303f,	0},
	{10.691300f,	5.128376f,	2.308009f,	0},
	{10.842135f,	4.801568f,	1.601720f,	0},
	{9.938325f,	4.821919f,	1.177946f,	0},
	{8.507790f,	4.671084f,	1.237801f,	0},
	{8.838189f,	4.602849f,	2.097319f,	0},
	{10.510538f,	4.817131f,	2.170342f,	0},
	{12.216406f,	4.753684f,	1.561018f,	0},
	{12.654545f,	3.897758f,	0.378284f,	0},
	{11.204856f,	1.860294f,	-0.105345f,	0},
	{8.844175f,	0.367510f,	1.064222f,	0},
	{7.511803f,	0.355539f,	1.830366f,	0},
	{7.447159f,	0.761356f,	1.376665f,	0},
	{7.492649f,	1.477221f,	1.074996f,	0},
	{7.439977f,	1.969230f,	1.636436f,	0},
	{8.178588f,	2.361878f,	2.212241f,	0},
	{9.138661f,	2.566582f,	3.772062f,	0},
	{8.628697f,	3.113657f,	5.457579f,	0},
	{7.310690f,	3.958810f,	4.115630f,	0},
	{6.605598f,	3.852268f,	-0.732625f,	0},
	{7.333435f,	2.907756f,	-0.568623f,	0},
	{7.597994f,	2.693475f,	1.482010f,	0},
	{7.583629f,	2.049435f,	0.691924f,	0},
	{9.470259f,	0.593762f,	-0.951695f,	0},
	{10.658978f,	0.784101f,	-0.517147f,	0},
	{10.287878f,	1.835154f,	0.626083f,	0},
	{9.807840f,	2.612072f,	1.288080f,	0},
	{8.984236f,	2.947260f,	0.714669f,	0},
	{8.761575f,	2.649182f,	-0.256179f,	0},
	{8.923183f,	2.196679f,	-0.543483f,	0},
	{8.926775f,	1.908177f,	-0.259771f,	0},
	{8.783123f,	2.282870f,	0.343568f,	0},
	{8.637076f,	2.968808f,	0.847547f,	0},
	{9.196122f,	2.409762f,	1.001973f,	0},
	{10.965436f,	2.219424f,	-0.040701f,	0},
	{12.228376f,	2.415748f,	-2.486377f,	0},
	{11.583140f,	2.370258f,	-2.585736f,	0},
	{10.394420f,	2.659956f,	-0.113724f,	0},
	{9.483426f,	3.004721f,	1.859096f,	0},
	{9.071624f,	3.149570f,	2.835930f,	0},
	{9.080004f,	3.254915f,	3.105278f,	0},
	{9.205699f,	3.192666f,	3.260900f,	0},
	{9.168590f,	2.627635f,	3.888181f,	0},
	{8.310268f,	1.988383f,	3.989934f,	0},
	{6.813893f,	1.753752f,	3.471590f,	0},
	{6.712140f,	1.843534f,	3.975569f,	0},
	{7.686579f,	1.092952f,	4.849452f,	0},
	{8.225274f,	-0.057461f,	5.044580f,	0},
	{9.645035f,	-1.168370f,	5.014652f,	0},
	{10.184927f,	-1.946485f,	5.219356f,	0},
	{9.691722f,	-2.285264f,	4.790794f,	0},
	{9.776716f,	-2.582145f,	4.147952f,	0},
	{9.946704f,	-2.756921f,	3.651155f,	0},
	{9.209291f,	-2.138021f,	3.199848f,	0},
	{8.215697f,	-1.181538f,	2.749739f,	0},
	{7.557292f,	-0.480037f,	2.457646f,	0},
	{7.584826f,	-0.227449f,	2.263716f,	0},
	{8.142674f,	0.092177f,	1.337161f,	0},
	{8.587996f,	0.541089f,	-0.260968f,	0},
	{9.088384f,	0.393846f,	-1.416169f,	0},
	{9.514551f,	0.010774f,	-0.566228f,	0},
	{9.374491f,	0.046687f,	0.678756f,	0},
	{9.302665f,	0.275333f,	0.553060f,	0},
	{9.515748f,	0.501585f,	0.005986f,	0},
	{9.652218f,	0.667982f,	-0.077812f,	0},
	{9.983814f,	0.775721f,	0.123301f,	0},
	{10.466246f,	0.855927f,	0.921767f,	0},
	{11.034868f,	0.636857f,	1.392227f,	0},
	{11.848896f,	-0.166397f,	0.960074f,	0},
	{12.391183f,	-1.085770f,	0.053870f,	0},
	{12.482162f,	-1.602917f,	-0.912190f,	0},
	{12.077542f,	-1.947682f,	-1.058236f,	0},
	{11.311399f,	-1.833957f,	-0.653617f,	0},
	{10.664965f,	-1.778891f,	0.350750f,	0},
	{9.764745f,	-2.568977f,	2.135627f,	0},
	{8.580813f,	-3.081336f,	2.833536f,	0},
	{7.436386f,	-2.665942f,	2.202664f,	0},
	{6.769601f,	-1.289277f,	2.110487f,	0},
	{7.038948f,	0.441730f,	3.216608f,	0},
	{8.155843f,	1.883038f,	4.080914f,	0},
	{9.284708f,	1.380256f,	3.860648f,	0},
	{9.452302f,	-0.167594f,	2.287658f,	0},
	{9.560040f,	-0.761356f,	0.659602f,	0},
	{9.497791f,	-0.784101f,	-0.830787f,	0},
	{9.290693f,	-0.700303f,	-1.665166f,	0},
	{8.920790f,	-0.146046f,	-1.515529f,	0},
	{8.766363f,	0.034716f,	-0.599747f,	0},
	{8.348576f,	-0.287304f,	-0.076614f,	0},
	{8.081622f,	-0.591367f,	0.045490f,	0},
	{7.095212f,	-1.157596f,	1.143231f,	0},
	{6.483494f,	-1.507149f,	0.781706f,	0},
	{6.980290f,	-1.605311f,	0.519541f,	0},
	{8.282735f,	-1.045068f,	1.046265f,	0},
	{7.284354f,	-1.468842f,	0.658405f,	0},
	{8.409628f,	-2.402580f,	-0.105345f,	0},
	{10.058035f,	-2.456449f,	2.020705f,	0},
	{11.830939f,	-2.476800f,	2.808397f,	0},
	{12.722779f,	-1.401804f,	0.846350f,	0},
	{11.550818f,	-0.071826f,	-3.417721f,	0},
	{10.788265f,	-0.575805f,	-7.012612f,	0},
	{10.037683f,	-1.229422f,	-8.307875f,	0},
	{9.273934f,	-0.415394f,	-6.815091f,	0},
	{9.394841f,	0.909796f,	-5.343854f,	0},
	{8.586799f,	1.194706f,	-2.789243f,	0},
	{8.435964f,	0.617704f,	-0.373495f,	0},
	{8.913607f,	-0.415394f,	0.533907f,	0},
	{8.986629f,	-1.616085f,	0.727837f,	0},
	{8.663413f,	-2.105699f,	1.237801f,	0},
	{8.337802f,	-2.239774f,	1.921346f,	0},
	{8.827415f,	-2.661153f,	2.705446f,	0},
	{9.233232f,	-3.117249f,	3.457225f,	0},
	{9.272737f,	-2.991553f,	3.994723f,	0},
	{8.706509f,	-2.610875f,	4.343079f,	0},
	{7.984657f,	-2.519896f,	4.351459f,	0},
	{8.218092f,	-3.441663f,	4.805160f,	0},
	{9.825797f,	-4.513067f,	4.161120f,	0},
	{10.711651f,	-6.089648f,	4.596864f,	0},
	{11.142607f,	-7.103591f,	3.855859f,	0},
	{10.658978f,	-6.648694f,	3.931277f,	0},
	{10.046063f,	-5.696999f,	4.780020f,	0},
	{9.539690f,	-4.680661f,	5.057748f,	0},
	{7.566869f,	-3.590103f,	4.860226f,	0},
	{6.440398f,	-3.344697f,	4.193441f,	0},
	{6.586444f,	-3.541022f,	3.108869f,	0},
	{7.125139f,	-3.699039f,	0.994790f,	0},
	{8.431175f,	-4.952403f,	-2.618058f,	0},
	{9.090777f,	-5.112814f,	-7.767982f,	0},
	{8.908818f,	-3.330332f,	-9.904806f,	0},
	{8.309072f,	-1.798044f,	-7.811078f,	0},
	{8.213304f,	-1.308430f,	-7.665031f,	0},
	{8.283933f,	-1.283291f,	-4.946417f,	0},
	{8.704114f,	-1.482010f,	-1.357511f,	0},
	{8.904030f,	-1.138442f,	-0.214281f,	0},
	{9.314635f,	-1.148019f,	-0.150835f,	0},
	{9.588771f,	-0.961271f,	-1.286883f,	0},
	{9.983814f,	-0.888248f,	-3.894166f,	0},
	{10.663767f,	-0.937329f,	-6.470325f,	0},
	{11.098314f,	-0.972045f,	-6.862975f,	0},
	{10.899596f,	-1.125274f,	-5.509054f,	0},
	{10.278301f,	-1.490390f,	-3.240550f,	0},
	{9.907200f,	-1.777694f,	-0.620098f,	0},
	{8.779531f,	-2.339134f,	1.922543f,	0},
	{7.435188f,	-2.651577f,	4.188653f,	0},
	{6.859383f,	-2.463632f,	5.175064f,	0},
	{6.631934f,	-2.347513f,	5.786782f,	0},
	{6.870157f,	-2.407368f,	6.654679f,	0},
	{7.872130f,	-2.549823f,	6.404485f,	0},
	{9.375688f,	-3.722981f,	3.958810f,	0},
	{11.268303f,	-5.311533f,	-0.108936f,	0},
	{12.009308f,	-6.212949f,	-5.847834f,	0},
	{10.462654f,	-5.131968f,	-11.382027f,	0},
	{7.885298f,	-2.762907f,	-11.698062f,	0},
	{7.011415f,	-1.878250f,	-9.295482f,	0},
	{6.627146f,	-1.376665f,	-6.520604f,	0},
	{7.509408f,	-1.753752f,	-3.491941f,	0},
	{8.297100f,	-1.997960f,	-0.979228f,	0},
	{8.939943f,	-1.666363f,	-0.052672f,	0},
	{8.857343f,	-0.831985f,	0.451307f,	0},
	{8.007402f,	-0.197522f,	1.444900f,	0},
	{7.693762f,	0.035913f,	3.700236f,	0},
	{7.378925f,	-0.505176f,	3.415326f,	0},
	{5.979515f,	-1.707065f,	-0.325611f,	0},
	{7.726084f,	-3.241747f,	-5.707773f,	0},
	{8.884876f,	-3.162738f,	-12.425899f,	0},
	{9.512156f,	0.045490f,	-13.029237f,	0},
	{8.766363f,	1.078587f,	-6.048946f,	0},
	{8.428782f,	-0.650025f,	-1.023521f,	0},
	{8.790305f,	-0.999579f,	1.993172f,	0},
	{9.354139f,	-0.804451f,	2.904165f,	0},
	{10.168168f,	-1.060631f,	-0.969651f,	0},
	{11.595111f,	-1.048660f,	-4.067746f,	0},
	{13.030434f,	-0.831985f,	-6.460749f,	0},
	{11.122256f,	0.191536f,	-7.928393f,	0},
	{9.040500f,	0.798466f,	-6.001062f,	0},
	{8.956702f,	0.328005f,	-1.649604f,	0},
	{9.064442f,	0.119710f,	0.561440f,	0},
	{9.356534f,	0.306458f,	0.186748f,	0},
	{10.399208f,	-0.664391f,	-0.585382f,	0},
	{11.281470f,	-1.975215f,	-2.223015f,	0},
	{10.011348f,	-1.996763f,	-4.955994f,	0},
	{9.003389f,	-2.169145f,	-6.757630f,	0},
	{8.583207f,	-2.082954f,	-5.573698f,	0},
	{8.798685f,	-1.921346f,	-2.810791f,	0},
	{8.974659f,	-1.520317f,	-1.250970f,	0},
	{8.078031f,	-0.515950f,	0.366313f,	0},
	{6.692986f,	0.751779f,	2.220621f,	0},
	{6.210555f,	1.480813f,	1.197100f,	0},
	{7.131125f,	0.602141f,	-2.041055f,	0},
	{8.007402f,	0.234632f,	-4.835087f,	0},
	{8.462300f,	0.919373f,	-5.451593f,	0},
	{7.928393f,	1.326387f,	-4.395751f,	0},
	{6.871354f,	1.467645f,	-2.835930f,	0},
	{6.029793f,	1.558624f,	-0.976834f,	0},
	{5.135559f,	1.978806f,	0.028730f,	0},
	{7.839808f,	1.517923f,	0.440533f,	0},
	{11.483781f,	0.501585f,	-0.684741f,	0},
	{9.314635f,	0.493205f,	-3.245338f,	0},
	{8.585602f,	0.633266f,	-4.395751f,	0},
	{9.229641f,	0.914584f,	-4.349064f,	0},
	{9.064442f,	0.970848f,	-3.658338f,	0},
	{9.977829f,	0.555454f,	-2.989159f,	0},
	{9.810235f,	0.744596f,	-3.434480f,	0},
	{9.325409f,	1.397016f,	-3.568555f,	0},
	{9.496594f,	1.741781f,	-3.239353f,	0},
	{10.398011f,	1.367088f,	-3.130417f,	0},
	{10.730804f,	0.985213f,	-2.704249f,	0},
	{10.894808f,	1.125274f,	-1.823183f,	0},
	{11.997336f,	0.918176f,	-2.120064f,	0},
	{12.749115f,	0.508767f,	-3.248930f,	0},
	{12.022475f,	0.416591f,	-3.471590f,	0},
	{10.839741f,	0.440533f,	-5.136756f,	0},
	{10.629051f,	0.883460f,	-8.376109f,	0},
	{11.104300f,	1.051054f,	-8.720874f,	0},
	{10.903187f,	0.842758f,	-5.995077f,	0},
	{11.470613f,	0.239420f,	-2.959231f,	0},
	{11.871641f,	-0.373495f,	-0.988805f,	0},
	{9.727634f,	-0.487220f,	1.842337f,	0},
	{6.479902f,	-0.034716f,	3.007115f,	0},
	{4.198230f,	0.515950f,	3.420115f,	0},
	{2.959231f,	1.742978f,	3.507503f,	0},
	{3.488349f,	2.468420f,	2.369061f,	0},
	{5.433637f,	2.197876f,	-2.054224f,	0},
	{6.564897f,	2.667139f,	-4.945220f,	0},
	{7.331040f,	3.190272f,	-2.327163f,	0},
	{10.497370f,	3.070562f,	0.073023f,	0},
	{10.967831f,	1.744175f,	-2.159569f,	0},
	{10.575182f,	0.481234f,	-3.937262f,	0},
	{10.111904f,	0.632069f,	-2.493559f,	0},
	{9.317030f,	1.003170f,	-0.973242f,	0},
	{8.687355f,	1.310825f,	-0.208295f,	0},
	{8.713691f,	1.209071f,	-0.918176f,	0},
	{8.810657f,	1.183932f,	-2.063801f,	0},
	{8.763969f,	1.406592f,	-2.553414f,	0},
	{8.019373f,	1.916557f,	-2.993947f,	0},
	{7.505817f,	2.184708f,	-3.209425f,	0},
	{7.550110f,	2.245760f,	-2.833536f,	0},
	{7.843400f,	2.250548f,	-2.468420f,	0},
	{8.210909f,	2.315192f,	-2.410959f,	0},
	{8.468286f,	2.409762f,	-3.126825f,	0},
	{8.376109f,	2.358287f,	-3.925291f,	0},
	{8.769955f,	2.191890f,	-3.524262f,	0},
	{9.360126f,	2.389412f,	-3.094504f,	0},
	{10.235206f,	2.645591f,	-4.356247f,	0},
	{10.369281f,	3.308784f,	-5.960361f,	0},
	{9.583982f,	3.739741f,	-6.137532f,	0},
	{9.226050f,	3.244141f,	-4.029438f,	0},
	{9.249992f,	3.345895f,	-1.376665f,	0},
	{9.409206f,	3.989934f,	0.690727f,	0},
	{9.866499f,	4.723757f,	1.246181f,	0},
	{11.179717f,	3.829523f,	-0.788889f,	0},
	{12.655742f,	2.403777f,	-3.202243f,	0},
	{12.897555f,	0.988805f,	-4.781218f,	0},
	{11.311399f,	0.092177f,	-4.595667f,	0},
	{8.464694f,	0.628478f,	-2.196679f,	0},
	{6.581656f,	1.258152f,	-0.107739f,	0},
	{6.366178f,	1.856702f,	0.781706f,	0},
	{6.930012f,	1.881841f,	0.209493f,	0},
	{7.776362f,	0.798466f,	-0.858321f,	0},
	{8.432373f,	-0.011971f,	-1.729810f,	0},
	{8.836992f,	-0.251391f,	-2.906559f,	0},
	{8.950717f,	-0.007183f,	-3.992329f,	0},
	{8.702917f,	0.239420f,	-3.590103f,	0},
	{8.307875f,	0.493205f,	-2.304418f,	0},
	{7.890086f,	1.065419f,	-1.701079f,	0},
	{7.886495f,	1.557427f,	-1.941696f,	0},
	{8.344984f,	1.771708f,	-2.163160f,	0},
	{8.882483f,	2.037464f,	-2.286461f,	0},
	{8.996207f,	2.401383f,	-2.816776f,	0},
	{9.011769f,	2.549823f,	-3.086124f,	0},
	{9.118311f,	2.431310f,	-3.043028f,	0},
	{9.022543f,	2.371455f,	-3.132811f,	0},
	{8.949520f,	2.278081f,	-3.059788f,	0},
	{9.159013f,	2.190693f,	-2.688687f,	0},
	{9.372096f,	2.074574f,	-2.284067f,	0},
	{9.406812f,	2.118867f,	-1.695094f,	0},
	{9.403221f,	2.088940f,	-1.282094f,	0},
	{9.539690f,	2.345119f,	-1.448491f,	0},
	{9.548070f,	2.826353f,	-2.069786f,	0},
	{9.326607f,	3.178301f,	-2.748542f,	0},
	{9.295482f,	3.290828f,	-2.521093f,	0},
	{10.214854f,	3.190272f,	-2.946063f,	0},
	{11.439487f,	3.104080f,	-4.429270f,	0},
	{12.179296f,	2.619255f,	-5.501872f,	0},
	{12.650953f,	1.750160f,	-4.109644f,	0},
	{11.921919f,	0.913387f,	-1.047463f,	0},
	{10.370478f,	0.256179f,	0.997184f,	0},
	{9.369702f,	-0.351947f,	2.355893f,	0},
	{7.855371f,	-0.039504f,	2.788046f,	0},
	{6.522998f,	0.343568f,	1.185129f,	0},
	{6.356601f,	0.954089f,	-0.673967f,	0},
	{6.839033f,	1.606508f,	-1.197100f,	0},
	{8.453920f,	1.814804f,	-0.993593f,	0},
	{9.556450f,	1.889024f,	-0.434547f,	0},
	{9.387658f,	2.385820f,	-0.804451f,	0},
	{9.039303f,	2.761710f,	-1.951273f,	0},
	{8.828612f,	2.579751f,	-2.316389f,	0},
	{8.649048f,	2.282870f,	-2.097319f,	0},
	{8.495819f,	2.323571f,	-1.842337f,	0},
	{8.274356f,	2.814382f,	-1.483207f,	0},
	{8.022964f,	3.214214f,	-1.207874f,	0},
	{7.991840f,	3.224988f,	-1.155202f,	0},
	{8.200135f,	3.023875f,	-1.380256f,	0},
	{8.465892f,	2.995144f,	-1.857899f,	0},
	{8.471877f,	3.099292f,	-2.273293f,	0},
	{8.388080f,	3.125628f,	-2.305615f,	0},
	{8.433570f,	3.105278f,	-2.064998f,	0},
	{8.494622f,	3.213017f,	-1.946485f,	0},
	{8.669398f,	3.210622f,	-2.211044f,	0},
	{8.773546f,	3.099292f,	-2.907756f,	0},
	{8.705312f,	3.130417f,	-3.394976f,	0},
	{8.570039f,	3.405750f,	-1.821986f,	0},
	{8.820233f,	3.371034f,	-1.948879f,	0},
	{9.376884f,	3.290828f,	-4.145557f,	0},
	{9.933537f,	3.511094f,	-5.504266f,	0},
	{10.266330f,	3.343500f,	-4.606441f,	0},
	{10.199292f,	3.286040f,	-2.880223f,	0},
	{10.279498f,	3.457225f,	-2.645591f,	0},
	{10.939100f,	3.313573f,	-3.344697f,	0},
	{11.617856f,	1.872265f,	-3.330332f,	0},
	{11.283865f,	0.302866f,	-2.816776f,	0},
	{8.844175f,	0.647631f,	-0.970848f,	0},
	{6.621161f,	1.608902f,	0.426168f,	0},
	{6.217738f,	2.564188f,	0.738611f,	0},
	{6.973108f,	3.286040f,	-0.644040f,	0},
	{8.750801f,	2.173934f,	-1.210268f,	0},
	{10.366886f,	0.428562f,	-1.189917f,	0},
	{10.743973f,	0.110133f,	-1.969230f,	0},
	{10.110707f,	0.746990f,	-2.530669f,	0},
	{8.839387f,	1.630450f,	-2.548626f,	0},
	{7.795516f,	2.329557f,	-2.692278f,	0},
	{7.451948f,	2.700658f,	-2.602495f,	0},
	{7.606374f,	2.907756f,	-2.309206f,	0},
	{8.056483f,	3.023875f,	-2.039858f,	0},
	{8.440752f,	3.139993f,	-1.945288f,	0},
	{8.403643f,	3.387793f,	-1.736992f,	0},
	{8.280341f,	3.640381f,	-1.544259f,	0},
	{8.359349f,	3.767274f,	-1.551442f,	0},
	{8.535323f,	3.780442f,	-1.817198f,	0},
	{8.860934f,	3.679886f,	-2.035070f,	0},
	{9.190137f,	3.599680f,	-2.019508f,	0},
	{9.193728f,	3.535036f,	-2.249351f,	0},
	{8.997404f,	3.507503f,	-2.041055f,	0},
	{8.646653f,	3.554190f,	-1.903389f,	0},
	{8.368926f,	3.604468f,	-1.539471f,	0},
	{8.249216f,	3.761288f,	-1.181538f,	0},
	{8.482651f,	3.960007f,	-1.823183f,	0},
	{8.767561f,	3.967190f,	-2.565385f,	0},
	{8.783123f,	3.831917f,	-3.102883f,	0},
	{8.614332f,	3.810369f,	-3.654746f,	0},
	{8.664610f,	3.786427f,	-4.390963f,	0},
	{8.987827f,	4.016271f,	-5.419272f,	0},
	{9.724044f,	4.271253f,	-6.058523f,	0},
	{10.873260f,	3.715799f,	-6.293155f,	0},
	{12.078739f,	3.123234f,	-5.191823f,	0},
	{12.312174f,	2.310403f,	-2.348710f,	0},
	{11.079161f,	1.405395f,	1.435323f,	0},
	{9.323015f,	1.150413f,	2.363075f,	0},
	{7.666229f,	0.990002f,	1.956061f,	0},
	{6.414062f,	1.784876f,	2.576159f,	0},
	{5.781993f,	3.196257f,	2.535458f,	0},
	{6.141123f,	3.886984f,	0.312443f,	0},
	{7.559687f,	3.445254f,	-1.547850f,	0},
	{9.400826f,	2.853886f,	-1.867476f,	0},
	{9.509763f,	3.022678f,	-3.046620f,	0},
	{8.577222f,	3.954021f,	-4.252100f,	0},
	{8.172602f,	3.744529f,	-3.657140f,	0},
	{8.269567f,	3.207031f,	-2.509122f,	0},
	{8.135491f,	3.442860f,	-1.326387f,	0},
	{7.990643f,	3.718193f,	-0.969651f,	0},
	{8.020570f,	3.763683f,	-1.307233f,	0},
	{8.246822f,	3.590103f,	-1.707065f,	0},
	{8.331817f,	3.252521f,	-1.964441f,	0},
	{8.212107f,	2.896982f,	-2.375046f,	0},
	{8.174996f,	2.774878f,	-2.712629f,	0},
	{8.511381f,	2.673124f,	-2.576159f,	0},
	{8.957899f,	2.570174f,	-2.475603f,	0},
	{9.176969f,	2.637211f,	-2.371455f,	0},
	{9.011769f,	2.729388f,	-2.279279f,	0},
	{8.756786f,	2.636014f,	-2.651577f,	0},
	{8.678975f,	2.534261f,	-3.602074f,	0},
	{8.603558f,	2.598904f,	-3.883393f,	0},
	{8.331817f,	2.859872f,	-3.414129f,	0},
	{8.225274f,	3.234564f,	-3.913320f,	0},
	{8.254004f,	3.434480f,	-4.692632f,	0},
	{7.493846f,	3.796004f,	-4.635171f,	0},
	{7.006627f,	4.036621f,	-3.604468f,	0},
	{6.774389f,	4.210201f,	-2.053027f,	0},
	{7.364560f,	4.368218f,	-1.525105f,	0},
	{9.597151f,	3.620030f,	-1.552639f,	0},
	{11.402378f,	1.831563f,	-2.977188f,	0},
	{12.288232f,	0.525527f,	-4.697421f,	0},
	{11.234784f,	0.181959f,	-4.031833f,	0},
	{9.607924f,	0.386663f,	-1.760934f,	0},
	{9.303862f,	0.387860f,	-0.899022f,	0},
	{9.464272f,	0.622492f,	-1.006761f,	0},
	{9.558844f,	1.036689f,	-1.015141f,	0},
	{9.920368f,	0.829590f,	-1.874659f,	0},
	{10.107116f,	0.355539f,	-3.119643f,	0},
	{9.897623f,	-0.099359f,	-4.199427f,	0},
	{9.185349f,	-0.276530f,	-4.827904f,	0},
	{8.003811f,	0.396240f,	-4.807554f,	0},
	{7.156264f,	0.701501f,	-5.153516f,	0},
	{7.101197f,	0.053870f,	-4.508279f,	0},
	{7.503423f,	-0.792480f,	-3.005918f,	0},
	{8.105564f,	-1.297656f,	-1.985989f,	0},
	{8.426387f,	-1.464053f,	-1.731007f,	0},
	{8.543703f,	-1.358709f,	-1.970427f,	0},
	{8.645456f,	-1.344343f,	-2.333148f,	0},
	{8.863329f,	-1.558624f,	-2.579751f,	0},
	{8.951914f,	-1.918951f,	-3.125628f,	0},
	{8.690947f,	-1.860294f,	-3.743332f,	0},
	{8.432373f,	-1.956061f,	-4.167105f,	0},
	{8.066060f,	-2.053027f,	-4.120419f,	0},
	{7.721295f,	-2.195482f,	-3.816355f,	0},
	{8.643063f,	-2.871843f,	-3.706222f,	0},
	{9.257174f,	-3.336318f,	-3.749317f,	0},
	{8.542506f,	-3.499123f,	-4.060563f,	0},
	{7.796712f,	-4.046198f,	-3.117249f,	0},
	{9.125494f,	-4.362233f,	-1.403001f,	0},
	{10.022121f,	-4.328714f,	0.181959f,	0},
	{9.467864f,	-4.274844f,	0.749385f,	0},
	{8.961491f,	-3.708616f,	-0.160411f,	0},
	{9.466667f,	-3.045423f,	-1.674743f,	0},
	{10.119086f,	-2.406171f,	-2.686292f,	0},
	{10.562014f,	-1.898601f,	-3.098095f,	0},
	{10.864880f,	-1.751357f,	-2.885011f,	0},
	{11.161760f,	-1.505952f,	-2.561794f,	0},
	{11.179717f,	-1.201888f,	-3.112460f,	0},
	{10.089159f,	-1.221042f,	-4.156332f,	0},
	{7.001838f,	-0.794874f,	-3.333924f,	0},
	{5.855016f,	-0.556652f,	-2.070983f,	0},
	{5.731715f,	-0.816422f,	-1.926134f,	0},
	{5.664677f,	-0.999579f,	-2.529472f,	0},
	{5.078098f,	-0.949300f,	-3.558978f,	0},
	{4.414905f,	-0.963666f,	-4.428073f,	0},
	{4.523841f,	-1.501163f,	-5.098449f,	0},
	{4.826707f,	-2.104502f,	-5.495886f,	0},
	{5.408498f,	-2.646788f,	-4.911702f,	0},
	{7.024583f,	-3.204637f,	-3.964795f,	0},
	{8.048103f,	-3.580526f,	-2.898179f,	0},
	{8.647851f,	-4.011482f,	-2.421733f,	0},
	{8.653836f,	-3.981555f,	-2.619255f,	0},
	{8.593981f,	-3.761288f,	-2.304418f,	0},
	{9.291890f,	-3.605665f,	-1.768117f,	0},
	{10.421953f,	-3.653549f,	-2.403777f,	0},
	{10.747564f,	-4.040213f,	-3.653549f,	0},
	{11.080358f,	-4.187456f,	-3.568555f,	0},
	{11.591519f,	-4.479548f,	-3.045423f,	0},
	{12.521667f,	-4.991907f,	-3.197454f,	0},
	{12.606661f,	-5.301956f,	-3.508700f,	0},
	{12.215209f,	-5.559332f,	-3.132811f,	0},
	{11.514905f,	-5.664677f,	-2.713826f,	0},
	{10.378858f,	-5.208582f,	-2.182313f,	0},
	{9.202108f,	-4.546586f,	-1.216254f,	0},
	{8.280341f,	-4.206610f,	-0.418985f,	0},
	{7.450751f,	-4.313151f,	0.014365f,	0},
	{7.369348f,	-4.450818f,	0.191536f,	0},
	{7.760799f,	-4.636368f,	0.500388f,	0},
	{8.317451f,	-4.886562f,	0.723048f,	0},
	{9.074018f,	-4.566936f,	1.207874f,	0},
	{9.854527f,	-4.408919f,	1.930922f,	0},
	{9.587574f,	-3.520671f,	2.163160f,	0},
	{7.569263f,	-1.774102f,	2.106896f,	0},
	{6.695381f,	-1.079784f,	3.076547f,	0},
	{6.536166f,	-1.090558f,	2.916136f,	0},
	{7.067678f,	-1.138442f,	1.533485f,	0},
	{8.107959f,	-0.973242f,	-2.732979f,	0},
	{9.166195f,	-1.021126f,	-7.004232f,	0},
	{9.587574f,	-1.686714f,	-7.388502f,	0},
	{9.416389f,	-1.589749f,	-5.742489f,	0},
	{8.761575f,	-1.954864f,	-2.201467f,	0},
	{8.656230f,	-2.102108f,	-0.766144f,	0},
	{8.858541f,	-2.230197f,	-0.316034f,	0},
	{9.175772f,	-2.531867f,	0.506373f,	0},
	{9.725241f,	-2.759315f,	1.114500f,	0},
	{10.110707f,	-2.782060f,	0.573411f,	0},
	{9.934733f,	-2.370258f,	0.377087f,	0},
	{9.617501f,	-2.214635f,	-0.361524f,	0},
	{9.494201f,	-2.189496f,	-1.580172f,	0},
	{9.704890f,	-2.115276f,	-2.446872f,	0},
	{9.459484f,	-2.057815f,	-2.561794f,	0},
	{9.435542f,	-2.030282f,	-2.092531f,	0},
	{9.346957f,	-1.996763f,	-1.692699f,	0},
	{9.319424f,	-2.132035f,	-1.470039f,	0},
	{9.446317f,	-2.430113f,	-1.489192f,	0},
	{9.703692f,	-2.687490f,	-1.851914f,	0},
	{9.847345f,	-2.719811f,	-2.027887f,	0},
	{9.732423f,	-2.558203f,	-2.355893f,	0},
	{9.549267f,	-2.409762f,	-2.292447f,	0},
	{9.601939f,	-2.473209f,	-1.733401f,	0},
	{9.971844f,	-2.697066f,	-1.748963f,	0},
	{10.626657f,	-3.017889f,	-1.353920f,	0},
	{11.123453f,	-3.641578f,	-1.219845f,	0},
	{11.133030f,	-4.373006f,	-1.596931f,	0},
	{10.457866f,	-4.733334f,	-2.841915f,	0},
	{9.214079f,	-4.768049f,	-3.096898f,	0},
	{7.812275f,	-4.437650f,	-1.672349f,	0},
	{6.750447f,	-4.045001f,	0.490811f,	0},
	{6.290761f,	-3.907335f,	1.800438f,	0},
	{6.235694f,	-4.234143f,	1.041477f,	0},
	{7.199359f,	-4.850649f,	-2.310403f,	0},
	{8.538915f,	-4.039015f,	-3.203440f,	0},
	{9.186545f,	-2.800017f,	-4.298786f,	0},
	{9.197320f,	-2.372652f,	-4.565740f,	0},
	{9.024938f,	-1.969230f,	-4.732136f,	0},
	{8.607149f,	-1.534682f,	-4.993104f,	0},
	{7.957124f,	-1.502361f,	-4.132390f,	0},
	{7.705733f,	-1.678334f,	-2.855083f,	0},
	{7.752420f,	-1.753752f,	-1.508346f,	0},
	{8.034935f,	-1.557427f,	-0.313640f,	0},
	{7.546519f,	-1.106120f,	0.447715f,	0},
	{6.752841f,	-0.906205f,	1.265335f,	0},
	{6.906070f,	-1.195903f,	1.750160f,	0},
	{7.101197f,	-1.496375f,	1.381453f,	0},
	{7.223301f,	-1.824380f,	0.837970f,	0},
	{7.374136f,	-2.153583f,	0.274136f,	0},
	{7.323858f,	-2.404974f,	-0.490811f,	0},
	{7.491452f,	-2.598904f,	-1.482010f,	0},
	{7.899663f,	-2.819170f,	-2.953246f,	0},
	{8.497016f,	-3.117249f,	-4.119221f,	0},
	{9.168590f,	-3.533839f,	-6.064509f,	0},
	{9.417586f,	-3.632001f,	-6.847412f,	0},
	{9.738409f,	-3.272871f,	-6.969516f,	0},
	{9.919171f,	-2.809594f,	-6.331462f,	0},
	{9.987406f,	-2.677913f,	-4.316743f,	0},
	{9.593559f,	-2.616861f,	-3.142388f,	0},
	{9.325409f,	-2.674321f,	-3.335121f,	0},
	{9.167392f,	-2.829944f,	-3.014298f,	0},
	{9.194925f,	-3.105278f,	-2.008734f,	0},
	{9.613911f,	-3.459619f,	-2.535458f,	0},
	{10.720031f,	-4.271253f,	-3.035846f,	0},
	{11.372450f,	-5.182246f,	-2.151189f,	0},
	{10.842135f,	-5.142742f,	-0.895431f,	0},
	{9.220064f,	-4.575316f,	0.703895f,	0},
	{7.491452f,	-4.206610f,	1.714247f,	0},
	{6.665453f,	-4.437650f,	2.238577f,	0},
	{7.479481f,	-4.993104f,	3.179498f,	0},
	{8.750801f,	-5.791570f,	2.965217f,	0},
	{9.563632f,	-6.527786f,	1.649604f,	0},
	{9.215276f,	-6.408076f,	0.693121f,	0},
	{8.240837f,	-5.831074f,	-0.050278f,	0},
	{7.832625f,	-5.178655f,	-0.134075f,	0},
	{6.849806f,	-4.006694f,	0.402226f,	0},
	{6.220132f,	-3.184286f,	-0.293290f,	0},
	{6.138729f,	-3.074153f,	0.524330f,	0},
	{7.079649f,	-3.414129f,	-1.236604f,	0},
	{7.497437f,	-3.640381f,	-2.803608f,	0},
	{7.586023f,	-3.466802f,	-3.118446f,	0},
	{7.608768f,	-3.038240f,	-3.612848f,	0},
	{7.706930f,	-2.804805f,	-3.219002f,	0},
	{7.848188f,	-2.905362f,	-3.991132f,	0},
	{8.244428f,	-3.093307f,	-4.150346f,	0},
	{8.699326f,	-2.829944f,	-4.168303f,	0},
	{8.613134f,	-2.391806f,	-3.326741f,	0},
	{8.754393f,	-2.479194f,	-2.382229f,	0},
	{9.027331f,	-2.700658f,	-2.299629f,	0},
	{9.117114f,	-2.700658f,	-2.309206f,	0},
	{9.198517f,	-2.815579f,	-1.631647f,	0},
	{9.265554f,	-2.861069f,	-0.093374f,	0},
	{9.057259f,	-2.791637f,	0.238223f,	0},
	{9.398433f,	-2.922121f,	0.565031f,	0},
	{9.453499f,	-2.892194f,	0.474052f,	0},
	{9.267948f,	-2.750936f,	0.118513f,	0},
	{9.593559f,	-2.905362f,	0.064643f,	0},
	{9.916777f,	-3.290828f,	0.547075f,	0},
	{9.968252f,	-3.573344f,	0.733822f,	0},
	{10.299849f,	-4.295195f,	-2.195482f,	0},
	{10.365689f,	-5.293576f,	-3.512291f,	0},
	{10.035290f,	-6.093239f,	-3.232170f,	0},
	{9.386461f,	-5.595245f,	-0.808043f,	0},
	{7.836217f,	-5.037397f,	-1.355117f,	0},
	{7.586023f,	-4.918884f,	-0.707486f,	0},
	{8.003811f,	-5.001484f,	-1.582566f,	0},
	{8.651442f,	-5.248086f,	-3.233367f,	0},
	{8.804670f,	-4.791991f,	-2.944866f,	0},
	{7.832625f,	-3.906137f,	-2.813185f,	0},
	{6.901282f,	-3.084927f,	-2.161963f,	0},
	{6.792346f,	-2.578553f,	-1.455674f,	0},
	{7.048525f,	-2.341528f,	-1.499966f,	0},
	{7.358574f,	-2.551020f,	-1.587355f,	0},
	{7.480678f,	-2.724600f,	-2.063801f,	0},
	{7.368151f,	-2.518698f,	-1.176749f,	0},
	{7.399275f,	-2.738965f,	-1.344343f,	0},
	{7.823049f,	-2.987962f,	-1.318007f,	0},
	{7.832625f,	-2.798820f,	-1.460462f,	0},
	{7.547716f,	-2.303221f,	-1.837548f,	0},
	{7.366954f,	-2.001551f,	-2.175131f,	0},
	{7.653060f,	-2.163160f,	-2.703052f,	0},
	{7.995431f,	-2.481588f,	-3.134008f,	0},
	{8.619121f,	-2.681504f,	-3.325544f,	0},
	{8.935155f,	-2.726994f,	-4.122813f,	0},
	{9.391250f,	-2.748542f,	-4.546586f,	0},
	{9.763548f,	-2.730585f,	-4.378992f,	0},
	{10.044867f,	-2.233789f,	-5.177458f,	0},
	{10.336959f,	-2.200270f,	-5.360614f,	0},
	{10.339353f,	-2.786849f,	-4.867409f,	0},
	{10.545254f,	-3.339909f,	-4.352656f,	0},
	{10.761930f,	-3.875013f,	-3.894166f,	0},
	{10.625460f,	-4.471169f,	-3.217805f,	0},
	{9.902411f,	-4.558557f,	-2.613269f,	0},
	{8.913607f,	-3.739741f,	-1.416169f,	0},
	{8.100776f,	-3.011904f,	1.066616f,	0},
	{7.064087f,	-3.003524f,	3.325544f,	0},
	{6.754038f,	-3.834311f,	5.176260f,	0},
	{7.175417f,	-4.786006f,	7.241258f,	0},
	{7.382516f,	-5.288788f,	6.618766f,	0},
	{8.252808f,	-5.669466f,	4.605244f,	0},
	{9.193728f,	-6.020216f,	2.553414f,	0},
	{9.549267f,	-5.853819f,	0.247800f,	0},
	{8.914804f,	-5.385753f,	-0.512359f,	0},
	{8.572433f,	-4.914096f,	-1.824380f,	0},
	{8.161828f,	-3.992329f,	-3.460816f,	0},
	{7.699748f,	-2.631226f,	-3.369837f,	0},
	{7.472299f,	-2.184708f,	-1.789665f,	0},
	{7.617147f,	-2.147598f,	-1.602917f,	0},
	{7.779953f,	-1.984792f,	-1.983595f,	0},
	{8.039723f,	-1.725021f,	-2.574962f,	0},
	{8.286326f,	-1.487995f,	-2.779666f,	0},
	{8.273158f,	-1.437717f,	-2.838324f,	0},
	{8.219289f,	-1.659181f,	-2.960428f,	0},
	{8.444344f,	-1.786073f,	-2.853886f,	0},
	{8.597572f,	-1.544259f,	-2.703052f,	0},
	{8.681370f,	-1.361103f,	-2.530669f,	0},
	{8.962687f,	-1.437717f,	-2.333148f,	0},
	{9.131479f,	-1.589749f,	-1.939302f,	0},
	{9.050076f,	-1.765723f,	-1.616085f,	0},
	{9.041697f,	-1.929725f,	-1.650801f,	0},
	{9.260766f,	-2.108093f,	-1.804030f,	0},
	{9.653415f,	-2.413354f,	-2.396594f,	0},
	{9.742000f,	-2.288855f,	-1.392227f,	0},
	{9.372096f,	-1.877053f,	-0.934935f,	0},
	{9.860513f,	-2.138021f,	-1.429337f,	0},
	{10.694892f,	-2.595313f,	-1.260546f,	0},
	{11.317384f,	-2.925713f,	-0.727837f,	0},
	{11.739960f,	-3.251324f,	-0.887051f,	0},
	{11.595111f,	-3.508700f,	-2.597707f,	0},
	{10.346536f,	-4.009088f,	-4.683055f,	0},
	{9.039303f,	-4.310757f,	-4.425679f,	0},
	{8.474271f,	-4.114433f,	-2.164357f,	0},
	{8.452724f,	-3.538628f,	-0.290895f,	0},
	{8.659822f,	-3.467999f,	0.682347f,	0},
	{8.937549f,	-3.530248f,	0.061052f,	0},
	{8.566448f,	-2.431310f,	-0.852335f,	0},
	{8.067257f,	-1.312022f,	-1.903389f,	0},
	{8.377306f,	-1.103726f,	-1.419761f,	0},
	{8.070848f,	-1.212662f,	-2.258928f,	0},
	{8.067257f,	-1.584960f,	-2.608481f,	0},
	{7.800304f,	-1.910572f,	-3.106475f,	0},
	{7.347800f,	-2.184708f,	-3.384202f,	0},
	{7.348997f,	-2.264913f,	-2.862266f,	0},
	{7.765588f,	-2.091334f,	-1.757343f,	0},
	{7.970292f,	-1.810015f,	-1.043871f,	0},
	{8.240837f,	-1.757343f,	-0.768538f,	0},
	{8.485045f,	-1.801636f,	-0.395043f,	0},
	{8.564054f,	-1.716641f,	-0.083797f,	0},
	{8.844175f,	-1.758540f,	-0.086191f,	0},
	{9.075215f,	-1.959653f,	-0.597353f,	0},
	{9.182955f,	-2.019508f,	-1.362300f,	0},
	{9.318227f,	-2.041055f,	-1.719036f,	0},
	{9.363716f,	-2.062603f,	-2.341528f,	0},
	{9.173378f,	-1.891418f,	-2.298432f,	0},
	{9.066835f,	-1.715444f,	-2.759315f,	0},
	{9.272737f,	-1.723824f,	-2.409762f,	0},
	{9.367308f,	-1.574187f,	-1.908177f,	0},
	{9.205699f,	-1.302445f,	-1.863885f,	0},
	{9.190137f,	-1.492784f,	-1.729810f,	0},
	{9.236824f,	-1.769314f,	-1.782482f,	0},
	{9.534902f,	-2.070983f,	-2.035070f,	0},
	{10.097539f,	-2.543838f,	-1.827972f,	0},
	{10.522510f,	-2.759315f,	-2.231395f,	0},
	{10.928327f,	-2.730585f,	-2.249351f,	0},
	{11.123453f,	-2.719811f,	-1.364694f,	0},
	{10.806222f,	-2.395397f,	-0.016759f,	0},
	{9.789884f,	-1.911769f,	0.586579f,	0},
	{8.809459f,	-2.251745f,	0.070629f,	0},
	{8.212107f,	-3.077744f,	0.161609f,	0},
	{8.462300f,	-3.548204f,	1.023521f,	0},
	{8.960294f,	-3.872619f,	1.528697f,	0},
	{9.425965f,	-4.192245f,	1.470039f,	0},
	{9.999376f,	-4.453212f,	1.244984f,	0},
	{9.986209f,	-4.420890f,	0.696712f,	0},
	{9.368505f,	-4.025847f,	0.286107f,	0},
	{8.735239f,	-3.618833f,	0.021548f,	0},
	{8.062469f,	-3.245338f,	-0.644040f,	0},
	{7.747632f,	-2.964020f,	-1.055842f,	0},
	{7.532154f,	-2.788046f,	-0.582988f,	0},
	{7.694959f,	-2.956837f,	-0.339976f,	0},
	{8.044512f,	-3.439268f,	-0.831985f,	0},
	{8.398854f,	-3.869027f,	-1.472433f,	0},
	{8.674187f,	-3.954021f,	-1.877053f,	0},
	{8.778335f,	-3.669111f,	-1.696291f,	0},
	{8.744816f,	-3.325544f,	-2.801214f,	0},
	{9.170983f,	-3.161541f,	-2.974794f,	0},
	{8.848964f,	-2.875434f,	-3.779245f,	0},
	{8.207318f,	-2.503136f,	-4.129995f,	0},
	{8.026556f,	-2.263716f,	-4.618412f,	0},
	{8.368926f,	-2.215832f,	-4.732136f,	0},
	{8.961491f,	-2.413354f,	-3.232170f,	0},
	{9.333789f,	-2.713826f,	-1.446097f,	0},
	{9.246401f,	-2.952049f,	-0.226252f,	0},
	{8.790305f,	-2.959231f,	0.460884f,	0},
	{8.155843f,	-2.730585f,	0.590170f,	0},
	{7.708127f,	-2.560597f,	0.263362f,	0},
	{7.612359f,	-2.658759f,	0.471657f,	0},
	{8.567645f,	-3.356668f,	0.718260f,	0},
	{10.579970f,	-4.683055f,	1.223436f,	0},
	{12.627011f,	-5.783190f,	2.347513f,	0},
	{11.851291f,	-5.154713f,	2.021902f,	0},
	{8.839387f,	-3.144782f,	-3.478773f,	0},
	{8.154645f,	-3.208228f,	-8.307875f,	0},
	{9.410403f,	-4.708194f,	-0.691924f,	0},
	{9.804249f,	-4.711786f,	1.703473f,	0},
	{9.985011f,	-4.288013f,	-2.111685f,	0},
	{9.917974f,	-3.863042f,	-0.809240f,	0},
	{9.002192f,	-3.196257f,	-0.214281f,	0},
	{8.477862f,	-2.410959f,	-0.794874f,	0},
	{8.450329f,	-1.956061f,	-0.992396f,	0},
	{8.361744f,	-1.842337f,	-1.545456f,	0},
	{8.178588f,	-1.766920f,	-1.849520f,	0},
	{8.061272f,	-1.640027f,	-2.190693f,	0},
	{7.553701f,	-1.369482f,	-2.219424f,	0},
	{7.180206f,	-1.359906f,	-2.621649f,	0},
	{7.414838f,	-1.776496f,	-3.306390f,	0},
	{7.927197f,	-1.954864f,	-3.851071f,	0},
	{8.195347f,	-1.989580f,	-4.341882f,	0},
	{8.341393f,	-2.115276f,	-4.428073f,	0},
	{8.359349f,	-2.343922f,	-4.118024f,	0},
	{8.401248f,	-2.454055f,	-3.053802f,	0},
	{8.487439f,	-2.311600f,	-2.007537f,	0},
	{8.573630f,	-2.114079f,	-1.933317f,	0},
	{8.593981f,	-2.120064f,	-2.171540f,	0},
	{8.409628f,	-2.209847f,	-2.895785f,	0},
	{8.107959f,	-2.146400f,	-2.240971f,	0},
	{8.183376f,	-1.910572f,	-1.847125f,	0},
	{8.455117f,	-1.956061f,	-1.793256f,	0},
	{8.859737f,	-2.144006f,	-2.002748f,	0},
	{9.208094f,	-2.382229f,	-2.218226f,	0},
	{9.277525f,	-2.410959f,	-2.454055f,	0},
	{9.018951f,	-2.202664f,	-2.607284f,	0},
	{8.807065f,	-1.917754f,	-3.163935f,	0},
	{8.732844f,	-1.766920f,	-3.756500f,	0},
	{8.488636f,	-1.750160f,	-3.998314f,	0},
	{8.299495f,	-1.744175f,	-3.921700f,	0},
	{8.184573f,	-1.738189f,	-3.780442f,	0},
	{8.080425f,	-1.723824f,	-3.687068f,	0},
	{7.970292f,	-1.810015f,	-3.618833f,	0},
	{7.970292f,	-1.811212f,	-3.657140f,	0},
	{7.902057f,	-1.886630f,	-3.809172f,	0},
	{8.113944f,	-2.105699f,	-4.045001f,	0},
	{8.355759f,	-2.325965f,	-3.809172f,	0},
	{8.410825f,	-2.215832f,	-3.554190f,	0},
	{8.657428f,	-2.017113f,	-3.271674f,	0},
	{8.823824f,	-2.086545f,	-2.360681f,	0},
	{8.422796f,	-2.122458f,	-1.601720f,	0},
	{8.717282f,	-1.810015f,	-1.653195f,	0},
	{9.615108f,	-1.516726f,	-1.790862f,	0},
	{9.629473f,	-1.593340f,	-3.891772f,	0},
	{10.530889f,	-2.082954f,	-6.175839f,	0},
	{10.994166f,	-2.302023f,	-4.498702f,	0},
	{9.297876f,	-1.614888f,	-3.004721f,	0},
	{7.264003f,	-0.905008f,	-0.735019f,	0},
	{7.615951f,	-1.219845f,	0.140061f,	0},
	{8.942337f,	-1.484404f,	-0.383072f,	0},
	{10.296257f,	-2.246957f,	-0.167594f,	0},
	{11.376041f,	-2.970005f,	0.173579f,	0},
	{10.957057f,	-2.890997f,	-0.011971f,	0},
	{10.125072f,	-2.902968f,	-0.169988f,	0},
	{9.543282f,	-2.770089f,	-0.092177f,	0},
	{9.082398f,	-2.452858f,	0.432153f,	0},
	{8.699326f,	-1.927331f,	0.356736f,	0},
	{8.416810f,	-1.535879f,	0.282516f,	0},
	{7.886495f,	-0.933738f,	-0.872686f,	0},
	{8.098382f,	-0.636857f,	1.728612f,	0},
	{8.451527f,	-0.509965f,	1.399410f,	0},
	{9.103946f,	-0.675164f,	0.752976f,	0},
	{9.591166f,	-0.895431f,	0.257377f,	0},
	{9.684539f,	-0.997184f,	-0.475249f,	0},
	{9.461879f,	-0.949300f,	-0.150835f,	0},
	{9.260766f,	-0.992396f,	-0.387860f,	0},
	{9.248795f,	-1.278503f,	-0.785298f,	0},
	{9.558844f,	-1.503558f,	-0.909796f,	0},
	{10.126269f,	-1.493981f,	-0.755370f,	0},
	{10.194504f,	-1.428140f,	-0.456095f,	0},
	{10.286680f,	-1.380256f,	-0.415394f,	0},
	{10.317805f,	-1.411381f,	-0.383072f,	0},
	{10.150211f,	-1.398213f,	-0.389058f,	0},
	{9.968252f,	-1.315613f,	-0.265756f,	0},
	{9.878469f,	-1.361103f,	-0.398634f,	0},
	{9.900018f,	-1.498769f,	-0.544681f,	0},
	{9.877273f,	-1.466448f,	-1.072602f,	0},
	{9.799460f,	-1.371877f,	-1.558624f,	0},
	{9.544478f,	-1.285685f,	-1.635239f,	0},
	{9.278723f,	-1.120486f,	-1.229422f,	0},
	{9.204502f,	-1.103726f,	-0.731428f,	0},
	{9.202108f,	-1.182735f,	-0.477643f,	0},
	{9.107537f,	-1.255758f,	0.050278f,	0},
	{8.898045f,	-1.216254f,	0.428562f,	0},
	{8.766363f,	-1.130062f,	0.016759f,	0},
	{8.706509f,	-1.060631f,	-0.681150f,	0},
	{8.720874f,	-1.039083f,	-1.149216f,	0},
	{9.220064f,	-1.296459f,	-1.238999f,	0},
	{10.467443f,	-1.696291f,	-0.963666f,	0},
	{11.536453f,	-1.877053f,	-1.309627f,	0},
	{11.785450f,	-1.964441f,	-2.002748f,	0},
	{11.763902f,	-2.772484f,	-3.430889f,	0},
	{11.314989f,	-3.549402f,	-5.012258f,	0},
	{9.746788f,	-3.913320f,	-4.704603f,	0},
	{8.693340f,	-4.775232f,	-3.177104f,	0},
	{8.215697f,	-5.501872f,	-1.019929f,	0},
	{7.824246f,	-5.450397f,	0.652420f,	0},
	{7.545321f,	-4.419693f,	0.913387f,	0},
	{7.720098f,	-3.350683f,	-0.903811f,	0},
	{7.936773f,	-2.221818f,	-3.144782f,	0},
	{8.151054f,	-1.693897f,	-4.214989f,	0},
	{7.918817f,	-1.904586f,	-3.973175f,	0},
	{7.843400f,	-2.130838f,	-3.676294f,	0},
	{7.507014f,	-2.142809f,	-2.937684f,	0},
	{7.426809f,	-2.203861f,	-2.422930f,	0},
	{7.520183f,	-2.273293f,	-2.515107f,	0},
	{7.607571f,	-2.073377f,	-2.264913f,	0},
	{7.933182f,	-1.736992f,	-2.202664f,	0},
	{8.366532f,	-1.519120f,	-2.388215f,	0},
	{8.694537f,	-1.306036f,	-2.293644f,	0},
	{8.757984f,	-1.061828f,	-1.953667f,	0},
	{8.790305f,	-1.007958f,	-1.453279f,	0},
	{8.921987f,	-1.209071f,	-0.818816f,	0},
	{8.914804f,	-1.312022f,	-0.050278f,	0},
	{8.711297f,	-1.246181f,	0.578199f,	0},
	{8.656230f,	-1.249772f,	0.275333f,	0},
	{8.939943f,	-1.387439f,	-0.482431f,	0},
	{9.241612f,	-1.586158f,	-0.899022f,	0},
	{9.497791f,	-1.592143f,	-1.055842f,	0},
	{9.671371f,	-1.361103f,	-1.174355f,	0},
	{9.715664f,	-1.000776f,	-1.108515f,	0},
	{9.829389f,	-0.665588f,	-1.197100f,	0},
	{9.860513f,	-0.462081f,	-1.599326f,	0},
	{9.821009f,	-0.490811f,	-2.014719f,	0},
	{9.856922f,	-0.694318f,	-2.319980f,	0},
	{10.049655f,	-1.024718f,	-2.524684f,	0},
	{10.514130f,	-1.493981f,	-1.921346f,	0},
	{10.843332f,	-1.666363f,	-1.532288f,	0},
	{11.147395f,	-1.837548f,	-1.659181f,	0},
	{11.727989f,	-2.455252f,	-1.991974f,	0},
	{12.029658f,	-3.106475f,	-0.149638f,	0},
	{10.973816f,	-3.138796f,	2.298432f,	0},
	{9.229641f,	-2.894588f,	2.509122f,	0},
	{8.149857f,	-2.712629f,	1.924937f,	0},
	{7.643484f,	-3.005918f,	1.844731f,	0},
	{7.934379f,	-3.333924f,	1.647210f,	0},
	{8.604755f,	-3.669111f,	1.010352f,	0},
	{9.069230f,	-3.952824f,	0.132878f,	0},
	{9.255978f,	-3.986343f,	-0.216675f,	0},
	{9.123099f,	-3.824735f,	0.580594f,	0},
	{8.698129f,	-3.511094f,	0.641646f,	0},
	{8.346182f,	-3.187877f,	1.156399f,	0},
	{8.060075f,	-2.959231f,	1.389833f,	0},
	{7.915226f,	-2.890997f,	1.458068f,	0},
	{8.005008f,	-3.084927f,	1.079784f,	0},
	{7.953533f,	-3.286040f,	-0.043096f,	0},
	{8.371321f,	-3.442860f,	-2.762907f,	0},
	{8.309072f,	-3.312376f,	-4.205412f,	0},
	{8.149857f,	-2.729388f,	-3.705025f,	0},
	{7.922408f,	-2.109290f,	-3.027466f,	0},
	{7.881707f,	-1.766920f,	-3.349486f,	0},
	{7.872130f,	-1.252167f,	-4.329911f,	0},
	{8.201332f,	-0.677559f,	-3.967190f,	0},
	{8.599967f,	-0.760159f,	-3.022678f,	0},
	{8.785517f,	-1.183932f,	-2.488771f,	0},
	{9.235627f,	-1.813607f,	-1.701079f,	0},
	{9.714467f,	-2.225409f,	-0.598550f,	0},
	{9.683342f,	-2.312797f,	0.444124f,	0},
	{9.585180f,	-2.341528f,	0.554257f,	0},
	{9.459484f,	-2.260125f,	0.377087f,	0},
	{9.476244f,	-2.183511f,	0.265756f,	0},
	{9.752774f,	-2.238577f,	0.000000f,	0},
	{10.631446f,	-2.571371f,	0.381875f,	0},
	{11.678908f,	-2.847901f,	1.048660f,	0},
	{11.956635f,	-2.754527f,	1.926134f,	0},
	{11.179717f,	-2.287658f,	1.643618f,	0},
	{9.974237f,	-1.684320f,	-0.531512f,	0},
	{9.130282f,	-1.295262f,	0.968454f,	0},
	{8.774743f,	-0.958877f,	1.218648f,	0},
	{8.473074f,	-0.690727f,	1.455674f,	0},
	{8.464694f,	-0.987608f,	0.141258f,	0},
	{9.175772f,	-1.808818f,	-3.797201f,	0},
	{10.365689f,	-2.500742f,	-9.164998f,	0},
	{10.453077f,	-1.736992f,	-3.761288f,	0},
	{9.622290f,	-0.969651f,	0.599747f,	0},
	{8.990221f,	-0.987608f,	-4.253296f,	0},
	{9.148238f,	-1.395819f,	-3.313573f,	0},
	{8.651442f,	-1.607705f,	-1.174355f,	0},
	{7.994234f,	-1.643618f,	-0.547075f,	0},
	{7.620739f,	-1.555033f,	-0.290895f,	0},
	{7.387304f,	-1.526303f,	-0.118513f,	0},
	{7.176615f,	-1.487995f,	-0.105345f,	0},
	{7.222105f,	-1.329978f,	-0.065841f,	0},
	{7.553701f,	-1.047463f,	-0.521936f,	0},
	{7.945153f,	-0.768538f,	-0.612915f,	0},
	{8.386883f,	-0.518344f,	-0.260968f,	0},
	{8.783123f,	-0.316034f,	-0.155623f,	0},
	{9.229641f,	-0.201113f,	-0.294487f,	0},
	{9.470259f,	-0.234632f,	-0.818816f,	0},
	{9.665385f,	-0.349553f,	-0.980425f,	0},
	{9.798264f,	-0.347159f,	-0.960074f,	0},
	{9.586377f,	-0.480037f,	-1.021126f,	0},
	{9.587574f,	-0.565031f,	-0.806845f,	0},
	{9.617501f,	-0.590170f,	-0.330400f,	0},
	{9.609122f,	-0.484826f,	0.050278f,	0},
	{9.691722f,	-0.368707f,	0.562637f,	0},
	{9.884455f,	-0.318429f,	1.296459f,	0},
	{9.916777f,	-0.286107f,	1.254561f,	0},
	{10.086765f,	-0.414197f,	0.605733f,	0},
	{10.672147f,	-0.663193f,	-0.056264f,	0},
	{11.547227f,	-0.732625f,	-1.089361f,	0},
	{12.741933f,	-0.981622f,	-1.647210f,	0},
	{13.311752f,	-1.082178f,	-2.098516f,	0},
	{12.233165f,	-1.091755f,	-1.170764f,	0},
	{9.745591f,	-1.782482f,	-1.260546f,	0},
	{6.040567f,	-2.230197f,	-1.437717f,	0},
	{5.289985f,	-2.487574f,	0.503979f,	0},
	{6.959939f,	-3.001130f,	3.216608f,	0},
	{8.799882f,	-4.107250f,	4.249705f,	0},
	{9.941916f,	-4.839875f,	4.045001f,	0},
	{9.454696f,	-5.104434f,	3.131614f,	0},
	{8.892059f,	-5.509054f,	1.795650f,	0},
	{7.688973f,	-5.981909f,	0.606930f,	0},
	{7.673411f,	-6.725308f,	0.831985f,	0},
	{8.412022f,	-7.346603f,	0.257377f,	0},
	{8.220486f,	-6.330265f,	-0.105345f,	0},
	{7.586023f,	-4.578907f,	0.073023f,	0},
	{7.775165f,	-3.556584f,	-1.447294f,	0},
	{8.498213f,	-3.017889f,	-4.783612f,	0},
	{8.949520f,	-2.546232f,	-4.119221f,	0},
	{8.564054f,	-2.585736f,	-1.102529f,	0},
	{7.644681f,	-3.087321f,	-0.313640f,	0},
	{8.555674f,	-2.998736f,	-0.015562f,	0},
	{9.572012f,	-2.636014f,	-0.071826f,	0},
	{8.997404f,	-2.252942f,	1.218648f,	0},
	{7.629118f,	-1.496375f,	0.980425f,	0},
	{7.766785f,	-1.379059f,	1.416169f,	0},
	{8.343787f,	-1.787270f,	1.284488f,	0},
	{8.748407f,	-1.811212f,	0.870292f,	0},
	{9.136268f,	-2.027887f,	1.131260f,	0},
	{9.615108f,	-2.226606f,	1.380256f,	0},
	{10.127466f,	-2.141612f,	0.444124f,	0},
	{10.301045f,	-1.841140f,	-0.062249f,	0},
	{10.163380f,	-1.441308f,	-2.595313f,	0},
	{9.898820f,	-1.045068f,	1.595734f,	0},
	{9.682145f,	-1.219845f,	2.372652f,	0},
	{10.177745f,	-1.084573f,	1.078587f,	0},
	{11.180914f,	-0.885854f,	0.757764f,	0},
	{12.489345f,	-1.234210f,	2.330754f,	0},
	{13.658912f,	-2.050632f,	2.142809f,	0},
	{13.063952f,	-2.145203f,	-0.293290f,	0},
	{9.628276f,	-1.520317f,	-2.880223f,	0},
	{6.360192f,	-1.479616f,	-3.886984f,	0},
	{5.079296f,	-1.917754f,	-2.090137f,	0},
	{6.202175f,	-3.551796f,	-0.855927f,	0},
	{7.969095f,	-4.886562f,	-0.975637f,	0},
	{11.101906f,	-4.876986f,	0.645237f,	0},
	{11.766296f,	-4.067746f,	0.531512f,	0},
	{10.569196f,	-3.503912f,	-0.644040f,	0},
	{10.237599f,	-3.076547f,	-0.447715f,	0},
	{9.629473f,	-2.752133f,	-0.193930f,	0},
	{8.340196f,	-1.911769f,	-0.742202f,	0},
	{7.272383f,	-1.003170f,	-1.213859f,	0},
	{6.823470f,	-0.739808f,	-1.057039f,	0},
	{7.050919f,	-0.673967f,	-0.834379f,	0},
	{7.595600f,	-0.442927f,	-0.532710f,	0},
	{8.060075f,	-0.168791f,	-0.527921f,	0},
	{8.573630f,	0.094571f,	-1.207874f,	0},
	{8.899241f,	0.466869f,	-1.898601f,	0},
	{9.060850f,	0.805648f,	-1.408987f,	0},
	{9.222459f,	0.831985f,	-0.489614f,	0},
	{9.290693f,	0.647631f,	0.099359f,	0},
	{8.882483f,	0.517147f,	-0.029928f,	0},
	{8.628697f,	0.389058f,	-0.817619f,	0},
	{9.248795f,	0.234632f,	-1.046265f,	0},
	{9.690525f,	-0.081403f,	-1.126471f,	0},
	{10.071202f,	-0.231040f,	-0.632069f,	0},
	{10.299849f,	-0.039504f,	0.476446f,	0},
	{10.965436f,	0.278924f,	0.920570f,	0},
	{11.526876f,	0.132878f,	-0.335188f,	0},
	{11.572366f,	0.118513f,	-0.995987f,	0},
	{12.087119f,	0.074220f,	0.064643f,	0},
	{14.025224f,	-0.268150f,	0.715866f,	0},
	{13.812140f,	-0.075417f,	2.175131f,	0},
	{10.393223f,	0.955286f,	4.447227f,	0},
	{5.740095f,	2.165554f,	5.378571f,	0},
	{2.682701f,	2.470814f,	4.266465f,	0},
	{2.267308f,	1.452082f,	2.970005f,	0},
	{5.784388f,	-0.737414f,	2.178722f,	0},
	{8.700523f,	-2.176328f,	0.712274f,	0},
	{8.658625f,	-2.545035f,	-1.139639f,	0},
	{8.984236f,	-3.094504f,	-0.059855f,	0},
	{10.274710f,	-4.108448f,	2.123656f,	0},
	{11.112679f,	-5.146333f,	2.748542f,	0},
	{12.083528f,	-5.299562f,	-0.111330f,	0},
	{11.859670f,	-3.488349f,	-2.300826f,	0},
	{10.259148f,	-1.679531f,	-0.063446f,	0},
	{8.656230f,	-1.307233f,	1.798044f,	0},
	{7.996628f,	-1.447294f,	1.592143f,	0},
	{8.142674f,	-1.909375f,	0.881066f,	0},
	{8.282735f,	-2.118867f,	0.978031f,	0},
	{8.382094f,	-1.970427f,	1.248575f,	0},
	{8.866920f,	-1.735795f,	0.386663f,	0},
	{9.623487f,	-1.595734f,	-0.269348f,	0},
	{9.806643f,	-1.525105f,	-0.345962f,	0},
	{9.609122f,	-1.367088f,	0.299275f,	0},
	{9.714467f,	-1.388636f,	1.693897f,	0},
	{9.576800f,	-1.092952f,	2.396594f,	0},
	{9.296679f,	-1.480813f,	2.565385f,	0},
	{9.323015f,	-0.742202f,	2.341528f,	0},
	{9.384068f,	-1.109712f,	1.960850f,	0},
	{9.868893f,	-1.590946f,	2.421733f,	0},
	{10.109509f,	-1.939302f,	2.955640f,	0},
	{9.973041f,	-2.006340f,	3.324347f,	0},
	{9.859316f,	-1.581369f,	3.942050f,	0},
	{9.793475f,	-0.999579f,	3.818749f,	0},
	{8.820233f,	-0.578199f,	2.885011f,	0},
	{7.404064f,	-0.547075f,	1.671152f,	0},
	{6.730096f,	-0.906205f,	0.976834f,	0},
	{8.153448f,	-2.236183f,	0.503979f,	0},
	{9.867696f,	-4.234143f,	-0.254982f,	0},
	{7.984657f,	-2.888602f,	-1.261743f,	0},
	{9.093172f,	-3.695448f,	-2.171540f,	0},
	{9.166195f,	-3.958810f,	-1.365891f,	0},
	{9.483426f,	-4.307166f,	-1.432929f,	0},
	{9.564829f,	-4.777626f,	-2.000354f,	0},
	{9.548070f,	-5.154713f,	-2.106896f,	0},
	{9.175772f,	-5.427651f,	-1.608902f,	0},
	{8.127112f,	-6.010639f,	-1.829169f,	0},
	{8.129506f,	-6.432018f,	-1.207874f,	0},
	{7.790727f,	-5.821497f,	0.189142f,	0},
	{7.073664f,	-4.104856f,	2.110487f,	0},
	{7.091620f,	-3.636790f,	1.745372f,	0},
	{7.758405f,	-3.837903f,	0.458489f,	0},
	{8.832204f,	-3.739741f,	0.357933f,	0},
	{9.786293f,	-3.177104f,	0.160411f,	0},
	{9.618699f,	-2.337936f,	-0.683544f,	0},
	{9.124296f,	-1.669955f,	-0.986410f,	0},
	{8.815445f,	-1.297656f,	0.074220f,	0},
	{8.663413f,	-1.192312f,	0.752976f,	0},
	{8.526943f,	-1.224633f,	0.095768f,	0},
	{8.671793f,	-1.508346f,	-0.044293f,	0},
	{9.041697f,	-1.966835f,	-1.302445f,	0},
	{9.320621f,	-2.434901f,	-0.640449f,	0},
	{9.319424f,	-2.719811f,	-0.933738f,	0},
	{9.598348f,	-2.252942f,	0.096965f,	0},
	{9.272737f,	-2.086545f,	-0.335188f,	0},
	{9.397235f,	-1.977609f,	-0.829590f,	0},
	{9.585180f,	-1.861491f,	-0.963666f,	0},
	{9.563632f,	-1.543062f,	-1.194706f,	0},
	{9.265554f,	-1.262941f,	-1.276109f,	0},
	{8.941140f,	-0.998381f,	-1.148019f,	0},
	{8.711297f,	-0.948103f,	-1.108515f,	0},
	{8.803473f,	-1.259349f,	-1.027112f,	0},
	{9.475047f,	-2.545035f,	-0.591367f,	0},
	{10.941494f,	-4.028242f,	-0.374692f,	0},
	{11.295835f,	-3.961204f,	0.489614f,	0},
	{9.697707f,	-2.606087f,	1.587355f,	0},
	{8.414416f,	-2.354696f,	1.309627f,	0},
	{8.408431f,	-3.039437f,	0.598550f,	0},
	{8.759181f,	-3.227382f,	0.460884f,	0},
	{9.191334f,	-3.215411f,	0.717063f,	0},
	{9.106340f,	-3.286040f,	-1.228225f,	0},
	{9.215276f,	-3.016692f,	-0.532710f,	0},
	{9.226050f,	-2.573765f,	1.215057f,	0},
	{9.278723f,	-2.743753f,	0.444124f,	0},
	{9.779110f,	-3.204637f,	1.349132f,	0},
	{9.914383f,	-3.223790f,	1.940499f,	0},
	{9.907200f,	-2.806002f,	1.668757f,	0},
	{10.375266f,	-2.416945f,	2.098516f,	0},
	{11.027685f,	-2.161963f,	2.414551f,	0},
	{11.603491f,	-1.948879f,	2.486377f,	0},
	{11.531665f,	-1.472433f,	2.813185f,	0},
	{10.983393f,	-0.723048f,	2.525881f,	0},
	{9.938325f,	0.086191f,	2.130838f,	0},
	{8.816642f,	0.365116f,	2.731782f,	0},
	{10.491385f,	0.019154f,	3.318361f,	0},
	{10.913961f,	-0.289698f,	4.115630f,	0},
	{9.964661f,	0.154426f,	4.765655f,	0},
	{7.896072f,	1.101332f,	4.291604f,	0},
	{7.783545f,	1.666363f,	4.158726f,	0},
	{8.256399f,	1.159990f,	4.963177f,	0},
	{8.441950f,	0.727837f,	5.633553f,	0},
	{7.973883f,	0.981622f,	5.418075f,	0},
	{7.131125f,	1.492784f,	4.759670f,	0},
	{7.067678f,	1.640027f,	4.987119f,	0},
	{7.246047f,	1.323993f,	5.380965f,	0},
	{7.788333f,	1.154004f,	5.783190f,	0},
	{8.256399f,	1.544259f,	6.980290f,	0},
	{8.076834f,	2.169145f,	7.654258f,	0},
	{7.649469f,	2.182313f,	7.368151f,	0},
	{7.462722f,	2.094925f,	6.817485f,	0},
	{6.956348f,	1.817198f,	6.009442f,	0},
	{6.156685f,	1.295262f,	5.595245f,	0},
	{5.171472f,	1.101332f,	5.043383f,	0},
	{4.614820f,	1.007958f,	4.921278f,	0},
	{4.693829f,	0.915781f,	5.402513f,	0},
	{4.863817f,	1.090558f,	5.463564f,	0},
	{4.620806f,	1.468842f,	5.919660f,	0},
	{4.741713f,	1.361103f,	6.609190f,	0},
	{4.047395f,	1.677137f,	6.482296f,	0},
	{4.094082f,	1.859096f,	6.527786f,	0},
	{4.349064f,	1.829169f,	6.309914f,	0},
	{4.477154f,	1.816001f,	6.591233f,	0},
	{4.513067f,	1.195903f,	7.651864f,	0},
	{5.130771f,	0.706289f,	8.787911f,	0},
	{5.143939f,	0.804451f,	8.456315f,	0},
	{4.619609f,	0.244208f,	7.931985f,	0},
	{3.963598f,	-0.852335f,	8.146266f,	0},
	{4.163514f,	-1.314416f,	8.972264f,	0},
	{4.601653f,	-1.395819f,	9.185349f,	0},
	{4.854240f,	-1.686714f,	8.943534f,	0},
	{4.542994f,	-2.023099f,	8.414416f,	0},
	{3.835509f,	-2.602495f,	8.085214f,	0},
	{2.978385f,	-2.853886f,	8.039723f,	0},
	{2.686292f,	-2.522290f,	7.716507f,	0},
	{2.425325f,	-2.989159f,	10.263936f,	0},
	{1.680728f,	-3.276463f,	12.568354f,	0},
	{1.449688f,	-2.462435f,	9.834177f,	0},
	{1.904586f,	-2.296038f,	8.819036f,	0},
	{2.072180f,	-2.254139f,	9.337380f,	0},
	{2.197876f,	-2.144006f,	9.494201f,	0},
	{2.105699f,	-1.899798f,	9.169786f,	0},
	{1.717839f,	-1.751357f,	9.096764f,	0},
	{1.574187f,	-1.813607f,	9.458287f,	0},
	{1.502361f,	-1.717839f,	9.576800f,	0},
	{1.379059f,	-1.528697f,	9.473849f,	0},
	{1.168370f,	-1.182735f,	9.206897f,	0},
	{1.060631f,	-1.138442f,	9.701299f,	0},
	{0.893037f,	-1.142033f,	10.007756f,	0},
	{0.729034f,	-1.097741f,	10.362098f,	0},
	{0.847547f,	-1.270123f,	11.415545f,	0},
	{0.700303f,	-1.437717f,	11.802209f,	0},
	{0.657208f,	-0.940921f,	10.297455f,	0},
	{0.820014f,	-0.262165f,	8.865723f,	0},
	{1.120486f,	-0.100556f,	9.303862f,	0},
	{1.000776f,	-0.172382f,	10.194504f,	0},
	{0.691924f,	0.026336f,	8.984236f,	0},
	{0.712274f,	0.058658f,	8.265976f,	0},
	{0.530315f,	-0.462081f,	10.773900f,	0},
	{0.463278f,	-0.685938f,	10.289075f,	0},
	{0.442927f,	-0.518344f,	7.893678f,	0},
	{0.445321f,	-0.438139f,	7.972686f,	0},
	{0.378284f,	-0.450110f,	8.655033f,	0},
	{0.043096f,	0.015562f,	8.980644f,	0},
	{0.220266f,	0.984016f,	9.639050f,	0},
	{0.154426f,	1.146822f,	9.488214f,	0},
	{-0.119710f,	1.325190f,	9.168590f,	0},
	{-0.130484f,	1.334767f,	9.746788f,	0},
	{-0.025139f,	1.310825f,	10.338156f,	0},
	{0.028730f,	1.616085f,	9.712072f,	0},
	{0.044293f,	1.892615f,	8.583207f,	0},
	{0.069432f,	1.480813f,	8.564054f,	0},
	{0.033519f,	1.243787f,	8.768758f,	0},
	{0.373495f,	1.514332f,	8.633486f,	0},
	{0.353144f,	1.561018f,	8.446738f,	0},
	{0.129287f,	1.313219f,	8.616726f,	0},
	{-0.028730f,	0.976834f,	9.123099f,	0},
	{-0.076614f,	0.966060f,	9.351746f,	0},
	{-0.161609f,	1.165975f,	8.965082f,	0},
	{-0.343568f,	1.641224f,	8.194150f,	0},
	{-0.442927f,	1.661575f,	8.437161f,	0},
	{-0.363918f,	1.365891f,	9.854527f,	0},
	{-0.282516f,	1.326387f,	10.666162f,	0},
	{-0.314837f,	1.443703f,	10.433924f,	0},
	{-0.644040f,	1.332372f,	9.327804f,	0},
	{-0.999579f,	1.479616f,	8.036133f,	0},
	{-0.799663f,	1.452082f,	8.346182f,	0},
	{-0.858321f,	1.567004f,	9.868893f,	0},
	{-0.938526f,	1.495178f,	11.599899f,	0},
	{-1.193509f,	1.498769f,	11.905160f,	0},
	{-1.556230f,	1.338358f,	10.947480f,	0},
	{-1.557427f,	1.256955f,	11.003743f,	0},
	{-1.413775f,	1.060631f,	11.848896f,	0},
	{-1.280897f,	0.922964f,	12.215209f,	0},
	{-1.132457f,	0.927753f,	11.399983f,	0},
	{-1.037886f,	0.881066f,	10.413573f,	0},
	{-0.605733f,	0.897825f,	10.074794f,	0},
	{-0.149638f,	0.872686f,	10.181335f,	0},
	{0.278924f,	0.933738f,	10.765521f,	0},
	{0.741005f,	1.137245f,	10.898398f,	0},
	{1.114500f,	1.398213f,	10.672147f,	0},
	{1.337161f,	1.841140f,	11.609476f,	0},
	{1.916557f,	1.922543f,	13.679262f,	0},
	{2.594116f,	1.768117f,	13.814534f,	0},
	{3.088518f,	2.280476f,	12.144580f,	0},
	{3.426100f,	2.173934f,	11.726792f,	0},
	{3.564964f,	1.717839f,	11.662148f,	0},
	{3.779245f,	1.653195f,	11.219221f,	0},
	{3.823538f,	1.709459f,	10.377660f,	0},
};

const size_t kBodyDetectOnBodyTestDataLength =
	ARRAY_SIZE(kBodyDetectOnBodyTestData);

const struct body_detect_test_data kBodyDetectOffOnTestData[] = {
	{-0.269348,	0.220266,	10.030501,	0},
	{-0.259771,	0.216675,	10.113101,	0},
	{-0.253785,	0.213084,	10.096342,	0},
	{-0.262165,	0.201113,	10.098736,	0},
	{-0.257377,	0.210690,	10.093947,	0},
	{-0.253785,	0.202310,	10.096342,	0},
	{-0.257377,	0.213084,	10.113101,	0},
	{-0.257377,	0.221464,	10.096342,	0},
	{-0.262165,	0.217872,	10.115496,	0},
	{-0.258574,	0.219069,	10.102327,	0},
	{-0.275333,	0.205901,	10.123875,	0},
	{-0.262165,	0.209493,	10.085567,	0},
	{-0.271742,	0.209493,	10.110707,	0},
	{-0.275333,	0.220266,	10.096342,	0},
	{-0.251391,	0.210690,	10.097539,	0},
	{-0.262165,	0.210690,	10.090356,	0},
	{-0.268150,	0.208295,	10.108313,	0},
	{-0.258574,	0.210690,	10.098736,	0},
	{-0.270545,	0.219069,	10.097539,	0},
	{-0.263362,	0.211887,	10.102327,	0},
	{-0.264559,	0.211887,	10.097539,	0},
	{-0.262165,	0.204704,	10.090356,	0},
	{-0.246603,	0.203507,	10.089159,	0},
	{-0.250194,	0.215478,	10.099933,	0},
	{-0.270545,	0.225055,	10.109509,	0},
	{-0.256179,	0.213084,	10.097539,	0},
	{-0.248997,	0.207098,	10.086765,	0},
	{-0.248997,	0.210690,	10.087962,	0},
	{-0.256179,	0.201113,	10.089159,	0},
	{-0.258574,	0.203507,	10.104721,	0},
	{-0.262165,	0.208295,	10.093947,	0},
	{-0.246603,	0.204704,	10.086765,	0},
	{-0.247800,	0.208295,	10.108313,	0},
	{-0.252588,	0.220266,	10.099933,	0},
	{-0.264559,	0.210690,	10.098736,	0},
	{-0.266953,	0.185551,	10.084371,	0},
	{-0.253785,	0.213084,	10.109509,	0},
	{-0.256179,	0.231040,	10.099933,	0},
	{-0.252588,	0.205901,	10.091554,	0},
	{-0.259771,	0.207098,	10.095144,	0},
	{-0.260968,	0.203507,	10.096342,	0},
	{-0.253785,	0.205901,	10.095144,	0},
	{-0.256179,	0.217872,	10.093947,	0},
	{-0.265756,	0.209493,	10.083174,	0},
	{-0.263362,	0.204704,	10.103524,	0},
	{-0.253785,	0.198719,	10.095144,	0},
	{-0.252588,	0.209493,	10.103524,	0},
	{-0.260968,	0.205901,	10.098736,	0},
	{-0.259771,	0.205901,	10.083174,	0},
	{-0.266953,	0.216675,	10.090356,	0},
	{-0.265756,	0.207098,	10.101130,	0},
	{-0.262165,	0.204704,	10.111904,	0},
	{-0.248997,	0.199916,	10.101130,	0},
	{-0.263362,	0.207098,	10.096342,	0},
	{-0.281319,	0.227449,	10.108313,	0},
	{-0.259771,	0.219069,	10.087962,	0},
	{-0.258574,	0.214281,	10.079582,	0},
	{-0.268150,	0.204704,	10.108313,	0},
	{-0.277727,	0.204704,	10.114298,	0},
	{-0.257377,	0.208295,	10.115496,	0},
	{-0.260968,	0.222661,	10.104721,	0},
	{-0.265756,	0.213084,	10.102327,	0},
	{-0.256179,	0.210690,	10.099933,	0},
	{-0.253785,	0.203507,	10.109509,	0},
	{-0.270545,	0.201113,	10.103524,	0},
	{-0.259771,	0.209493,	10.115496,	0},
	{-0.264559,	0.207098,	10.103524,	0},
	{-0.263362,	0.202310,	10.105919,	0},
	{-0.260968,	0.220266,	10.110707,	0},
	{-0.257377,	0.216675,	10.110707,	0},
	{-0.259771,	0.195127,	10.093947,	0},
	{-0.271742,	0.209493,	10.104721,	0},
	{-0.257377,	0.223858,	10.108313,	0},
	{-0.265756,	0.205901,	10.101130,	0},
	{-0.270545,	0.196324,	10.101130,	0},
	{-0.254982,	0.202310,	10.115496,	0},
	{-0.248997,	0.214281,	10.116693,	0},
	{-0.268150,	0.207098,	10.111904,	0},
	{-0.263362,	0.204704,	10.091554,	0},
	{-0.270545,	0.210690,	10.091554,	0},
	{-0.268150,	0.215478,	10.102327,	0},
	{-0.264559,	0.223858,	10.096342,	0},
	{-0.262165,	0.203507,	10.099933,	0},
	{-0.259771,	0.203507,	10.103524,	0},
	{-0.269348,	0.204704,	10.119086,	0},
	{-0.265756,	0.202310,	10.091554,	0},
	{-0.260968,	0.201113,	10.092751,	0},
	{-0.260968,	0.210690,	10.092751,	0},
	{-0.266953,	0.205901,	10.109509,	0},
	{-0.269348,	0.203507,	10.105919,	0},
	{-0.264559,	0.193930,	10.114298,	0},
	{-0.263362,	0.216675,	10.093947,	0},
	{-0.256179,	0.208295,	10.095144,	0},
	{-0.271742,	0.203507,	10.103524,	0},
	{-0.259771,	0.208295,	10.089159,	0},
	{-0.257377,	0.220266,	10.108313,	0},
	{-0.266953,	0.207098,	10.101130,	0},
	{-0.268150,	0.198719,	10.117889,	0},
	{-0.258574,	0.204704,	10.091554,	0},
	{-0.266953,	0.201113,	10.104721,	0},
	{-0.265756,	0.205901,	10.091554,	0},
	{-0.277727,	0.203507,	10.102327,	0},
	{-0.266953,	0.204704,	10.093947,	0},
	{-0.265756,	0.215478,	10.107116,	0},
	{-0.254982,	0.215478,	10.110707,	0},
	{-0.269348,	0.217872,	10.095144,	0},
	{-0.265756,	0.229843,	10.109509,	0},
	{-0.260968,	0.226252,	10.098736,	0},
	{-0.253785,	0.208295,	10.095144,	0},
	{-0.253785,	0.211887,	10.085567,	0},
	{-0.268150,	0.214281,	10.109509,	0},
	{-0.258574,	0.201113,	10.107116,	0},
	{-0.265756,	0.211887,	10.103524,	0},
	{-0.256179,	0.215478,	10.093947,	0},
	{-0.263362,	0.204704,	10.107116,	0},
	{-0.260968,	0.214281,	10.098736,	0},
	{-0.259771,	0.213084,	10.110707,	0},
	{-0.276530,	0.215478,	10.095144,	0},
	{-0.263362,	0.211887,	10.084371,	0},
	{-0.245406,	0.217872,	10.110707,	0},
	{-0.251391,	0.209493,	10.105919,	0},
	{-0.269348,	0.205901,	10.093947,	0},
	{-0.271742,	0.201113,	10.099933,	0},
	{-0.270545,	0.228646,	10.099933,	0},
	{-0.262165,	0.217872,	10.096342,	0},
	{-0.259771,	0.209493,	10.099933,	0},
	{-0.260968,	0.210690,	10.105919,	0},
	{-0.252588,	0.203507,	10.099933,	0},
	{-0.263362,	0.197522,	10.095144,	0},
	{-0.271742,	0.213084,	10.101130,	0},
	{-0.268150,	0.196324,	10.110707,	0},
	{-0.248997,	0.213084,	10.108313,	0},
	{-0.254982,	0.215478,	10.095144,	0},
	{-0.260968,	0.208295,	10.107116,	0},
	{-0.259771,	0.219069,	10.108313,	0},
	{-0.266953,	0.214281,	10.098736,	0},
	{-0.269348,	0.202310,	10.090356,	0},
	{-0.258574,	0.204704,	10.113101,	0},
	{-0.263362,	0.226252,	10.086765,	0},
	{-0.264559,	0.204704,	10.096342,	0},
	{-0.271742,	0.219069,	10.096342,	0},
	{-0.252588,	0.210690,	10.104721,	0},
	{-0.258574,	0.211887,	10.113101,	0},
	{-0.264559,	0.210690,	10.104721,	0},
	{-0.269348,	0.214281,	10.103524,	0},
	{-0.253785,	0.211887,	10.093947,	0},
	{-0.256179,	0.223858,	10.110707,	0},
	{-0.274136,	0.207098,	10.098736,	0},
	{-0.274136,	0.207098,	10.092751,	0},
	{-0.254982,	0.210690,	10.091554,	0},
	{-0.257377,	0.204704,	10.098736,	0},
	{-0.257377,	0.209493,	10.108313,	0},
	{-0.257377,	0.211887,	10.095144,	0},
	{-0.259771,	0.199916,	10.095144,	0},
	{-0.257377,	0.214281,	10.101130,	0},
	{-0.270545,	0.217872,	10.103524,	0},
	{-0.281319,	0.204704,	10.104721,	0},
	{-0.271742,	0.208295,	10.103524,	0},
	{-0.258574,	0.211887,	10.104721,	0},
	{-0.264559,	0.204704,	10.126269,	0},
	{-0.262165,	0.201113,	10.101130,	0},
	{-0.258574,	0.219069,	10.096342,	0},
	{-0.263362,	0.211887,	10.107116,	0},
	{-0.265756,	0.203507,	10.091554,	0},
	{-0.264559,	0.205901,	10.107116,	0},
	{-0.256179,	0.214281,	10.095144,	0},
	{-0.263362,	0.202310,	10.097539,	0},
	{-0.271742,	0.207098,	10.104721,	0},
	{-0.272939,	0.210690,	10.101130,	0},
	{-0.262165,	0.205901,	10.096342,	0},
	{-0.260968,	0.209493,	10.107116,	0},
	{-0.269348,	0.217872,	10.093947,	0},
	{-0.256179,	0.220266,	10.087962,	0},
	{-0.264559,	0.208295,	10.092751,	0},
	{-0.265756,	0.208295,	10.095144,	0},
	{-0.262165,	0.199916,	10.098736,	0},
	{-0.259771,	0.215478,	10.101130,	0},
	{-0.263362,	0.217872,	10.097539,	0},
	{-0.263362,	0.204704,	10.095144,	0},
	{-0.248997,	0.202310,	10.096342,	0},
	{-0.260968,	0.226252,	10.097539,	0},
	{-0.259771,	0.216675,	10.103524,	0},
	{-0.270545,	0.205901,	10.090356,	0},
	{-0.250194,	0.219069,	10.089159,	0},
	{-0.254982,	0.213084,	10.098736,	0},
	{-0.268150,	0.204704,	10.102327,	0},
	{-0.258574,	0.215478,	10.104721,	0},
	{-0.250194,	0.217872,	10.102327,	0},
	{-0.250194,	0.215478,	10.097539,	0},
	{-0.251391,	0.213084,	10.086765,	0},
	{-0.266953,	0.204704,	10.108313,	0},
	{-0.270545,	0.199916,	10.099933,	0},
	{-0.271742,	0.208295,	10.092751,	0},
	{-0.268150,	0.222661,	10.098736,	0},
	{-0.252588,	0.213084,	10.096342,	0},
	{-0.266953,	0.213084,	10.092751,	0},
	{-0.265756,	0.205901,	10.105919,	0},
	{-0.258574,	0.209493,	10.103524,	0},
	{-0.263362,	0.203507,	10.103524,	0},
	{-0.265756,	0.213084,	10.092751,	0},
	{-0.266953,	0.209493,	10.097539,	0},
	{-0.272939,	0.193930,	10.110707,	0},
	{-0.258574,	0.209493,	10.109509,	0},
	{-0.259771,	0.213084,	10.101130,	0},
	{-0.274136,	0.215478,	10.101130,	0},
	{-0.259771,	0.207098,	10.091554,	0},
	{-0.265756,	0.208295,	10.101130,	0},
	{-0.263362,	0.210690,	10.109509,	0},
	{-0.264559,	0.216675,	10.110707,	0},
	{-0.266953,	0.211887,	10.099933,	0},
	{-0.268150,	0.199916,	10.093947,	0},
	{-0.265756,	0.216675,	10.105919,	0},
	{-0.262165,	0.204704,	10.081977,	0},
	{-0.263362,	0.214281,	10.086765,	0},
	{-0.263362,	0.210690,	10.084371,	0},
	{-0.257377,	0.201113,	10.104721,	0},
	{-0.262165,	0.203507,	10.109509,	0},
	{-0.266953,	0.217872,	10.113101,	0},
	{-0.252588,	0.209493,	10.102327,	0},
	{-0.257377,	0.213084,	10.096342,	0},
	{-0.260968,	0.211887,	10.101130,	0},
	{-0.263362,	0.197522,	10.114298,	0},
	{-0.272939,	0.192733,	10.103524,	0},
	{-0.250194,	0.207098,	10.079582,	0},
	{-0.253785,	0.214281,	10.107116,	0},
	{-0.254982,	0.205901,	10.095144,	0},
	{-0.256179,	0.209493,	10.103524,	0},
	{-0.265756,	0.222661,	10.111904,	0},
	{-0.259771,	0.211887,	10.101130,	0},
	{-0.256179,	0.202310,	10.115496,	0},
	{-0.260968,	0.209493,	10.109509,	0},
	{-0.243011,	0.203507,	10.101130,	0},
	{-0.252588,	0.205901,	10.096342,	0},
	{-0.253785,	0.225055,	10.095144,	0},
	{-0.258574,	0.225055,	10.096342,	0},
	{-0.264559,	0.215478,	10.092751,	0},
	{-0.265756,	0.205901,	10.114298,	0},
	{-0.266953,	0.220266,	10.108313,	0},
	{-0.268150,	0.208295,	10.109509,	0},
	{-0.259771,	0.210690,	10.103524,	0},
	{-0.253785,	0.210690,	10.109509,	0},
	{-0.268150,	0.213084,	10.097539,	0},
	{-0.268150,	0.215478,	10.102327,	0},
	{-0.269348,	0.201113,	10.103524,	0},
	{-0.262165,	0.199916,	10.107116,	0},
	{-0.260968,	0.205901,	10.120284,	0},
	{-0.257377,	0.193930,	10.102327,	0},
	{-0.264559,	0.203507,	10.104721,	0},
	{-0.265756,	0.210690,	10.093947,	0},
	{-0.256179,	0.209493,	10.097539,	0},
	{-0.257377,	0.204704,	10.107116,	0},
	{-0.260968,	0.208295,	10.093947,	0},
	{-0.258574,	0.204704,	10.102327,	0},
	{-0.263362,	0.211887,	10.107116,	0},
	{-0.263362,	0.191536,	10.097539,	0},
	{-0.253785,	0.209493,	10.107116,	0},
	{-0.254982,	0.217872,	10.105919,	0},
	{-0.259771,	0.207098,	10.096342,	0},
	{-0.265756,	0.204704,	10.114298,	0},
	{-0.270545,	0.208295,	10.099933,	0},
	{-0.262165,	0.214281,	10.104721,	0},
	{-0.257377,	0.205901,	10.095144,	0},
	{-0.266953,	0.214281,	10.096342,	0},
	{-0.274136,	0.225055,	10.093947,	0},
	{-0.266953,	0.216675,	10.099933,	0},
	{-0.269348,	0.208295,	10.099933,	0},
	{-0.266953,	0.222661,	10.105919,	0},
	{-0.246603,	0.204704,	10.090356,	0},
	{-0.257377,	0.202310,	10.102327,	0},
	{-0.258574,	0.217872,	10.114298,	0},
	{-0.268150,	0.225055,	10.099933,	0},
	{-0.278924,	0.210690,	10.097539,	0},
	{-0.263362,	0.203507,	10.104721,	0},
	{-0.252588,	0.221464,	10.089159,	0},
	{-0.252588,	0.208295,	10.073597,	0},
	{-0.252588,	0.213084,	10.091554,	0},
	{-0.256179,	0.210690,	10.087962,	0},
	{-0.272939,	0.214281,	10.097539,	0},
	{-0.259771,	0.203507,	10.097539,	0},
	{-0.271742,	0.208295,	10.102327,	0},
	{-0.262165,	0.216675,	10.095144,	0},
	{-0.264559,	0.215478,	10.095144,	0},
	{-0.265756,	0.214281,	10.103524,	0},
	{-0.268150,	0.217872,	10.096342,	0},
	{-0.262165,	0.221464,	10.104721,	0},
	{-0.274136,	0.219069,	10.101130,	0},
	{-0.264559,	0.208295,	10.097539,	0},
	{-0.265756,	0.203507,	10.089159,	0},
	{-0.269348,	0.204704,	10.110707,	0},
	{-0.268150,	0.214281,	10.116693,	0},
	{-0.250194,	0.199916,	10.102327,	0},
	{-0.266953,	0.197522,	10.105919,	0},
	{-0.268150,	0.199916,	10.108313,	0},
	{-0.259771,	0.195127,	10.093947,	0},
	{-0.262165,	0.215478,	10.085567,	0},
	{-0.263362,	0.216675,	10.101130,	0},
	{-0.252588,	0.227449,	10.037683,	0},
	{-0.276530,	0.208295,	10.177745,	0},
	{-0.254982,	0.205901,	10.175350,	0},
	{-0.257377,	0.204704,	10.041275,	0},
	{-0.258574,	0.210690,	10.117889,	1},
	{-0.243011,	0.209493,	10.085567,	0},
	{-0.254982,	0.196324,	10.109509,	0},
	{-0.248997,	0.193930,	10.097539,	0},
	{-0.269348,	0.207098,	10.098736,	0},
	{-0.262165,	0.213084,	10.098736,	0},
	{-0.262165,	0.201113,	10.066414,	0},
	{-0.264559,	0.208295,	10.103524,	0},
	{-0.264559,	0.208295,	10.101130,	0},
	{-0.257377,	0.210690,	10.119086,	0},
	{-0.256179,	0.198719,	10.093947,	0},
	{-0.253785,	0.198719,	10.113101,	0},
	{-0.254982,	0.215478,	10.081977,	0},
	{-0.259771,	0.210690,	10.092751,	0},
	{-0.264559,	0.214281,	10.090356,	0},
	{-0.260968,	0.187945,	10.144226,	0},
	{-0.268150,	0.245406,	10.073597,	0},
	{-0.408211,	0.396240,	10.056837,	0},
	{-2.020705,	2.340331,	10.170562,	0},
	{-0.186748,	1.916557,	10.966634,	0},
	{7.234076,	-2.675519,	16.133318,	0},
	{7.775165,	0.863109,	11.798618,	0},
	{3.503912,	-1.510740,	2.634817,	0},
	{-3.895364,	-5.768825,	9.538493,	0},
	{-4.587287,	-2.717417,	26.975452,	0},
	{-3.013101,	4.329911,	32.156502,	0},
	{-4.693829,	-1.854308,	19.993965,	0},
	{-5.236115,	-2.634817,	18.126490,	0},
	{-6.558911,	1.010352,	20.283663,	0},
	{-8.033738,	0.130484,	22.203812,	0},
	{-7.487861,	-0.525527,	18.705885,	0},
	{-6.692986,	0.266953,	15.228310,	0},
	{-6.151897,	0.128090,	10.176547,	0},
	{-6.020216,	0.745793,	5.400118,	0},
	{-5.798753,	1.690305,	1.695094,	0},
	{-3.584117,	1.229422,	-1.827972,	0},
	{-0.386663,	1.133654,	-4.835087,	0},
	{0.955286,	1.742978,	-4.969162,	0},
	{3.201046,	1.059434,	-6.075283,	0},
	{7.366954,	-0.312443,	-7.837414,	0},
	{8.429978,	-0.656011,	-6.296746,	0},
	{6.950363,	-0.164003,	-3.179498,	0},
	{6.801922,	-0.415394,	-0.955286,	0},
	{7.827837,	-0.814028,	1.152807,	0},
	{7.793121,	-0.723048,	3.940853,	0},
	{7.422020,	-0.292092,	6.720520,	0},
	{7.978672,	-0.298078,	7.856567,	0},
	{8.202530,	-0.122104,	7.301113,	0},
	{7.778756,	0.360327,	6.107605,	0},
	{7.892480,	0.318429,	5.987895,	0},
	{8.950717,	0.108936,	6.327871,	0},
	{8.798685,	0.319626,	7.009021,	0},
	{7.748828,	0.839167,	7.133519,	0},
	{7.795516,	0.958877,	6.597219,	0},
	{7.850582,	1.035492,	5.942405,	0},
	{7.547716,	1.152807,	5.074507,	0},
	{7.116760,	1.128865,	4.546586,	0},
	{7.422020,	0.805648,	4.566936,	0},
	{7.937970,	0.517147,	4.827904,	0},
	{8.088805,	0.418985,	5.172669,	0},
	{8.329422,	0.415394,	5.573698,	0},
	{8.099579,	0.739808,	5.117603,	0},
	{7.973883,	0.805648,	4.387372,	0},
	{7.833823,	1.048660,	3.857056,	0},
	{8.100776,	1.177946,	3.950430,	0},
	{8.722071,	1.122880,	4.909307,	0},
	{9.400826,	0.921767,	5.566515,	0},
	{9.440331,	0.920570,	5.175064,	0},
	{8.723268,	1.022323,	4.551374,	0},
	{8.115141,	1.175552,	4.096477,	0},
	{8.135491,	1.387439,	3.754106,	0},
	{8.602361,	1.533485,	3.762486,	0},
	{8.884876,	1.289277,	4.268859,	0},
	{8.775940,	0.867898,	4.517856,	0},
	{8.434767,	0.647631,	4.377795,	0},
	{8.220486,	0.623689,	4.394554,	0},
	{7.817063,	0.945709,	4.226960,	0},
	{8.021768,	1.249772,	3.598483,	0},
	{9.108734,	0.667982,	3.156753,	0},
	{9.658203,	0.177171,	2.748542,	0},
	{9.301467,	0.393846,	2.639606,	0},
	{9.026134,	0.736217,	3.105278,	0},
	{8.865723,	0.814028,	3.799596,	0},
	{8.759181,	0.849941,	4.060563,	0},
	{8.493424,	0.964863,	4.404131,	0},
	{8.276750,	1.033097,	4.540600,	0},
	{8.324634,	0.908599,	4.672281,	0},
	{8.778335,	0.644040,	4.946417,	0},
	{8.558068,	0.827196,	5.007470,	0},
	{8.507790,	0.703895,	4.434059,	0},
	{8.688552,	0.684741,	3.661929,	0},
	{8.784320,	0.820014,	3.207031,	0},
	{8.844175,	0.839167,	3.385399,	0},
	{8.908818,	0.858321,	3.974372,	0},
	{9.044091,	0.907402,	4.442438,	0},
	{8.989024,	0.899022,	4.399343,	0},
	{8.925578,	0.815225,	4.141966,	0},
	{9.033317,	0.615309,	3.840297,	0},
	{9.083595,	0.436942,	3.727770,	0},
	{9.020149,	0.338779,	3.928882,	0},
	{8.930367,	0.299275,	4.174288,	0},
	{8.963885,	0.246603,	4.288013,	0},
	{8.842978,	0.304063,	4.236537,	0},
	{8.641865,	0.396240,	4.152740,	0},
	{8.591587,	0.466869,	4.163514,	0},
	{8.656230,	0.460884,	4.255691,	0},
	{8.836992,	0.398634,	4.118024,	0},
	{8.957899,	0.453701,	3.754106,	0},
	{9.045288,	0.502782,	3.326741,	0},
	{9.083595,	0.586579,	3.045423,	0},
	{9.033317,	0.705092,	3.004721,	0},
	{8.968674,	0.715866,	3.072956,	0},
	{8.899241,	0.684741,	3.071759,	0},
	{8.809459,	0.632069,	3.072956,	0},
	{8.832204,	0.585382,	3.138796,	0},
	{8.825022,	0.575805,	3.143585,	0},
	{8.761575,	0.556652,	3.064576,	0},
	{8.750801,	0.594959,	3.092109,	0},
	{8.817839,	0.633266,	3.129220,	0},
	{8.913607,	0.640449,	3.046620,	0},
	{8.998601,	0.658405,	2.869449,	0},
	{9.095566,	0.684741,	2.670730,	0},
	{9.133873,	0.694318,	2.789243,	0},
	{9.126691,	0.676362,	3.256112,	0},
	{9.041697,	0.723048,	3.632001,	0},
	{8.827415,	0.763750,	3.794807,	0},
	{8.853752,	0.694318,	3.775654,	0},
	{9.000996,	0.618901,	3.673900,	0},
	{9.066835,	0.561440,	3.708616,	0},
	{9.075215,	0.497994,	3.767274,	0},
	{9.064442,	0.417788,	3.775654,	0},
	{9.003389,	0.444124,	3.676294,	0},
	{8.943534,	0.500388,	3.551796,	0},
	{8.961491,	0.505176,	3.343500,	0},
	{8.789108,	0.600944,	3.191469,	0},
	{8.816642,	0.596156,	3.118446,	0},
	{8.889665,	0.549469,	3.131614,	0},
	{8.881285,	0.533907,	3.242944,	0},
	{8.783123,	0.590170,	3.416523,	0},
	{8.716085,	0.642843,	3.600877,	0},
	{8.719677,	0.612915,	3.694251,	0},
	{8.792700,	0.532710,	3.641578,	0},
	{8.895650,	0.470460,	3.475181,	0},
	{8.902833,	0.453701,	3.179498,	0},
	{8.833401,	0.399831,	2.855083,	0},
	{8.759181,	0.278924,	2.383426,	0},
	{8.670595,	0.118513,	1.875856,	0},
	{8.531732,	-0.013168,	1.414972,	0},
	{8.376109,	-0.057461,	1.115697,	0},
	{8.304283,	-0.015562,	1.341949,	0},
	{7.916422,	0.159214,	1.878250,	0},
	{7.595600,	0.270545,	3.086124,	0},
	{7.516591,	0.349553,	4.906913,	0},
	{7.881707,	0.061052,	6.694183,	0},
	{8.112747,	-0.235829,	7.243652,	0},
	{8.034935,	-0.387860,	7.001838,	0},
	{8.052892,	-0.222661,	6.254848,	0},
	{7.948744,	0.203507,	5.623976,	0},
	{7.327449,	0.853532,	5.892127,	0},
	{6.556517,	1.406592,	6.268016,	0},
	{6.993458,	1.375468,	6.548137,	0},
	{7.503423,	1.138442,	6.823470,	0},
	{7.237667,	1.118091,	7.408852,	0},
	{7.144293,	1.031900,	8.170208,	0},
	{7.127533,	0.927753,	8.361744,	0},
	{6.883325,	0.820014,	8.204924,	0},
	{6.708549,	0.644040,	7.923605,	0},
	{6.877340,	0.410605,	7.595600,	0},
	{7.054511,	0.339976,	7.395684,	0},
	{7.176615,	0.295684,	7.271185,	0},
	{7.182600,	0.259771,	7.201754,	0},
	{6.823470,	0.384269,	7.207739,	0},
	{6.624752,	0.464475,	7.419626,	0},
	{6.767207,	0.436942,	7.730872,	0},
	{6.834244,	0.386663,	7.971489,	0},
	{6.795937,	0.344765,	7.827837,	0},
	{6.531378,	0.404620,	7.354982,	0},
	{6.513421,	0.317232,	7.140702,	0},
	{6.649891,	0.192733,	7.065284,	0},
	{6.544546,	0.299275,	6.846215,	0},
	{6.555320,	0.381875,	6.678621,	0},
	{6.630737,	0.332794,	6.690592,	0},
	{6.636723,	0.199916,	6.915647,	0},
	{6.590036,	0.169988,	7.594403,	0},
	{6.248862,	0.393846,	8.506593,	0},
	{6.199781,	0.445321,	8.953111,	0},
	{6.538560,	0.023942,	8.977053,	0},
	{6.251256,	0.074220,	8.766363,	0},
	{6.154291,	0.337582,	8.178588,	0},
	{6.550531,	0.281319,	7.522577,	0},
	{6.397303,	0.652420,	7.284354,	0},
	{6.174642,	0.914584,	7.181403,	0},
	{6.265622,	0.825999,	6.584050,	0},
	{6.449975,	0.812831,	6.244074,	0},
	{6.738476,	0.641646,	6.549335,	0},
	{6.904873,	0.591367,	6.961137,	0},
	{6.669044,	0.671573,	7.244849,	0},
	{6.514618,	0.677559,	7.499832,	0},
	{6.716928,	0.464475,	7.510606,	0},
	{6.792346,	0.463278,	7.596797,	0},
	{6.734885,	0.585382,	7.791924,	0},
	{6.658270,	0.447715,	7.554898,	0},
	{6.463143,	0.486023,	7.091620,	0},
	{6.501450,	0.563834,	6.517013,	0},
	{6.488282,	0.654814,	6.062115,	0},
	{6.436807,	0.670376,	6.069297,	0},
	{6.479902,	0.659602,	6.549335,	0},
	{6.368572,	0.628478,	7.060496,	0},
	{6.446383,	0.487220,	7.497437,	0},
	{6.628343,	0.423773,	7.789530,	0},
	{6.636723,	0.460884,	7.996628,	0},
	{6.369769,	0.560243,	8.149857,	0},
	{6.105210,	0.602141,	8.106761,	0},
	{6.810302,	0.294487,	8.166616,	0},
	{7.140702,	0.201113,	8.110353,	0},
	{6.691789,	0.211887,	7.706930,	0},
	{6.524195,	0.271742,	7.422020,	0},
	{6.406879,	0.363918,	7.422020,	0},
	{6.278790,	0.423773,	7.556096,	0},
	{6.175839,	0.460884,	7.661440,	0},
	{6.229709,	0.451307,	7.507014,	0},
	{6.511027,	0.403423,	6.991064,	0},
	{6.872551,	0.345962,	6.734885,	0},
	{6.777980,	0.488417,	6.701366,	0},
	{6.730096,	0.620098,	6.682212,	0},
	{6.818682,	0.694318,	6.673833,	0},
	{6.897690,	0.634463,	6.702563,	0},
	{6.824667,	0.557849,	6.743265,	0},
	{6.700169,	0.621295,	6.815091,	0},
	{6.441595,	0.687135,	6.744462,	0},
	{6.476311,	0.812831,	6.872551,	0},
	{7.070073,	0.621295,	7.327449,	0},
	{6.791149,	0.446518,	7.169432,	0},
	{6.742067,	0.513556,	7.479481,	0},
	{6.738476,	0.420182,	7.603980,	0},
	{6.797134,	0.195127,	7.705733,	0},
	{6.882128,	0.363918,	7.593205,	0},
	{6.769601,	0.568623,	7.325055,	0},
	{6.915647,	0.465672,	7.016203,	0},
	{7.165841,	0.305261,	6.475114,	0},
	{7.277171,	0.234632,	5.893323,	0},
	{7.274777,	0.275333,	5.352234,	0},
	{6.994656,	0.428562,	5.149924,	0},
	{6.801922,	0.456095,	5.353431,	0},
	{6.751644,	0.354342,	5.864593,	0},
	{6.592430,	0.339976,	6.321885,	0},
	{6.416456,	0.262165,	6.567291,	0},
	{6.847412,	-0.142455,	7.101197,	0},
	{7.248441,	-0.061052,	7.084438,	0},
	{6.556517,	0.310049,	7.459130,	0},
	{6.555320,	0.251391,	7.558490,	0},
	{6.552926,	0.347159,	7.578840,	0},
	{6.534969,	0.442927,	7.498635,	0},
	{6.439201,	0.484826,	7.303507,	0},
	{6.555320,	0.341173,	7.278368,	0},
	{6.587642,	0.209493,	7.347800,	0},
	{6.563700,	0.135272,	7.492649,	0},
	{6.603204,	0.100556,	7.559687,	0},
	{6.515815,	0.198719,	7.558490,	0},
	{6.441595,	0.270545,	7.536942,	0},
	{6.330265,	0.298078,	7.629118,	0},
	{6.339842,	0.277727,	7.694959,	0},
	{6.260833,	0.245406,	7.636301,	0},
	{6.145912,	0.185551,	7.546519,	0},
	{6.068100,	0.132878,	7.322661,	0},
	{5.987895,	0.122104,	7.220907,	0},
	{5.989091,	0.123301,	7.357377,	0},
	{5.981909,	0.122104,	7.590811,	0},
	{6.020216,	0.088585,	7.677002,	0},
	{6.030990,	0.148440,	7.593205,	0},
	{6.063312,	0.219069,	7.480678,	0},
	{6.089648,	0.265756,	7.527365,	0},
	{6.050144,	0.359130,	7.862553,	0},
	{6.011837,	0.365116,	8.170208,	0},
	{6.011837,	0.265756,	8.222880,	0},
	{5.893323,	0.202310,	8.207318,	0},
	{5.845439,	0.137667,	8.021768,	0},
	{5.822695,	0.196324,	8.021768,	0},
	{5.906492,	0.239420,	8.250414,	0},
	{5.809526,	0.296881,	8.378503,	0},
	{5.810724,	0.222661,	8.389277,	0},
	{5.754460,	0.226252,	8.317451,	0},
	{5.809526,	0.104148,	8.396460,	0},
	{5.810724,	0.187945,	8.570039,	0},
	{6.063312,	0.287304,	8.530535,	0},
	{6.098028,	0.141258,	8.274356,	0},
	{5.651509,	0.290895,	8.311465,	0},
	{5.661086,	0.392649,	8.327028,	0},
	{5.258861,	0.590170,	8.374912,	0},
	{6.062115,	0.117316,	7.928393,	0},
	{6.623555,	-0.246603,	7.491452,	0},
	{6.019019,	0.135272,	7.080847,	0},
	{6.084859,	0.463278,	7.062890,	0},
	{5.912477,	0.451307,	7.258018,	0},
	{5.827483,	0.532710,	7.372939,	0},
	{5.821497,	0.537498,	7.540533,	0},
	{5.737700,	0.536301,	7.648272,	0},
	{5.851425,	0.383072,	7.718901,	0},
	{6.072888,	0.365116,	7.699748,	0},
	{5.929236,	0.392649,	7.878115,	0},
	{5.967544,	0.354342,	8.107959,	0},
	{6.045355,	0.253785,	8.421598,	0},
	{5.923251,	0.323217,	8.574827,	0},
	{5.803541,	0.372298,	8.486242,	0},
	{5.785584,	0.416591,	8.215697,	0},
	{5.768825,	0.496797,	7.946350,	0},
	{5.838257,	0.527921,	7.711719,	0},
	{5.963953,	0.471657,	7.472299,	0},
	{5.986697,	0.430956,	7.435188,	0},
	{5.928040,	0.436942,	7.484270,	0},
	{5.907689,	0.472855,	7.449553,	0},
	{5.935222,	0.456095,	7.354982,	0},
	{5.959164,	0.450110,	7.420823,	0},
	{5.960361,	0.391452,	7.717704,	0},
	{5.880156,	0.399831,	7.902057,	0},
	{5.771219,	0.411802,	7.936773,	0},
	{5.997471,	0.266953,	8.137886,	0},
	{5.945996,	0.380678,	8.301888,	0},
	{5.877761,	0.434547,	8.265976,	0},
	{5.904098,	0.408211,	7.947547,	0},
	{5.918463,	0.432153,	7.615951,	0},
	{5.869381,	0.438139,	7.486664,	0},
	{5.837060,	0.451307,	7.556096,	0},
	{5.900506,	0.465672,	7.654258,	0},
	{5.870579,	0.454898,	7.651864,	0},
	{5.875367,	0.454898,	7.615951,	0},
	{5.887338,	0.451307,	7.697353,	0},
	{5.850228,	0.456095,	7.779953,	0},
	{5.858608,	0.477643,	7.884101,	0},
	{5.749671,	0.506373,	7.787136,	0},
	{5.683831,	0.507570,	7.660243,	0},
	{5.740095,	0.469263,	7.811078,	0},
	{5.766431,	0.405817,	8.002614,	0},
	{5.714955,	0.442927,	8.042118,	0},
	{5.723335,	0.399831,	8.002614,	0},
	{5.712561,	0.343568,	7.995431,	0},
	{5.741292,	0.323217,	8.110353,	0},
	{5.766431,	0.349553,	8.237246,	0},
	{5.704182,	0.367510,	8.276750,	0},
	{5.651509,	0.348356,	8.161828,	0},
	{5.655100,	0.367510,	7.977475,	0},
	{5.770022,	0.269348,	8.037330,	0},
	{5.765234,	0.149638,	8.125915,	0},
	{5.671860,	0.073023,	7.973883,	0},
	{5.667071,	0.105345,	7.836217,	0},
	{5.662283,	0.092177,	7.824246,	0},
	{5.702984,	0.031125,	7.970292,	0},
	{5.731715,	-0.005986,	8.169010,	0},
	{5.705379,	-0.038307,	8.178588,	0},
	{5.635947,	-0.082600,	8.060075,	0},
	{5.614399,	-0.087388,	7.846991,	0},
	{5.607216,	-0.051475,	7.807487,	0},
	{5.610808,	-0.033519,	7.864947,	0},
	{5.594049,	0.014365,	7.959518,	0},
	{5.595245,	0.070629,	8.085214,	0},
	{5.577289,	0.046687,	8.267173,	0},
	{5.512646,	-0.061052,	8.195347,	0},
	{5.414484,	-0.068235,	7.988248,	0},
	{5.358220,	0.023942,	7.862553,	0},
	{5.412089,	0.094571,	7.925999,	0},
	{5.420469,	0.159214,	8.106761,	0},
	{5.276817,	0.208295,	8.341393,	0},
	{5.264846,	0.239420,	8.215697,	0},
	{5.281605,	0.105345,	8.564054,	0},
	{5.311533,	-0.020351,	8.683764,	0},
	{5.209779,	0.087388,	8.489834,	0},
	{5.149924,	0.135272,	8.765166,	0},
	{5.169078,	0.017957,	9.282313,	0},
	{5.274423,	-0.105345,	9.628276,	0},
	{5.270832,	-0.059855,	9.247598,	0},
	{5.166684,	0.098162,	8.629894,	0},
	{5.128376,	0.126893,	8.294706,	0},
	{5.119997,	0.088585,	8.373714,	0},
	{5.146333,	0.090980,	8.540112,	0},
	{5.112814,	0.226252,	8.293509,	0},
	{5.086478,	0.238223,	8.079228,	0},
	{5.076901,	0.137667,	8.086411,	0},
	{5.064930,	0.064643,	8.396460,	0},
	{5.090069,	0.101754,	8.791503,	0},
	{5.090069,	0.272939,	9.018951,	0},
	{5.106829,	0.399831,	8.947125,	0},
	{5.129574,	0.401029,	8.738831,	0},
	{5.143939,	0.233435,	8.713691,	0},
	{5.165487,	0.124498,	8.570039,	0},
	{5.170275,	0.147243,	8.276750,	0},
	{5.114011,	0.207098,	7.818260,	0},
	{5.033806,	0.308852,	7.491452,	0},
	{5.043383,	0.314837,	7.789530,	0},
	{5.061339,	0.219069,	8.386883,	0},
	{5.069719,	0.137667,	8.644259,	0},
	{5.058945,	0.147243,	8.481454,	0},
	{5.007470,	0.186748,	8.107959,	0},
	{4.957191,	0.214281,	8.024161,	0},
	{5.048171,	0.130484,	8.451527,	0},
	{5.088872,	0.058658,	8.924380,	0},
	{5.104434,	-0.016759,	9.154224,	0},
	{5.117603,	-0.027533,	8.935155,	0},
	{5.018243,	0.071826,	8.637076,	0},
	{4.983528,	0.090980,	8.604755,	0},
	{5.019441,	0.026336,	8.650245,	0},
	{5.030214,	-0.013168,	8.646653,	0},
	{4.939235,	-0.026336,	8.565250,	0},
	{4.879380,	-0.089783,	8.562857,	0},
	{4.832693,	-0.186748,	8.906425,	0},
	{4.851846,	-0.294487,	9.361322,	0},
	{4.910504,	-0.284910,	9.572012,	0},
	{4.920081,	-0.166397,	9.233232,	0},
	{4.865015,	-0.051475,	8.621514,	0},
	{4.821919,	-0.007183,	8.482651,	0},
	{4.851846,	-0.021548,	8.792700,	0},
	{4.916490,	-0.056264,	9.081201,	0},
	{4.939235,	-0.034716,	8.680172,	0},
	{4.878182,	0.039504,	8.130703,	0},
	{4.825510,	0.070629,	8.079228,	0},
	{4.854240,	0.033519,	8.445540,	0},
	{4.932052,	-0.016759,	8.767561,	0},
	{4.988316,	-0.080206,	8.864526,	0},
	{5.024229,	-0.152032,	8.710100,	0},
	{5.026623,	-0.175974,	8.593981,	0},
	{5.011061,	-0.119710,	8.465892,	0},
	{5.051762,	-0.058658,	8.503001,	0},
	{5.104434,	0.028730,	8.389277,	0},
	{5.108026,	0.174777,	8.304283,	0},
	{5.121194,	0.207098,	8.368926,	0},
	{5.137953,	0.177171,	8.186967,	0},
	{5.123588,	0.141258,	8.036133,	0},
	{5.098449,	0.186748,	8.031344,	0},
	{5.036200,	0.240617,	8.049300,	0},
	{4.977542,	0.316034,	8.190558,	0},
	{4.978739,	0.294487,	8.428782,	0},
	{5.046974,	0.195127,	8.704114,	0},
	{5.042185,	0.211887,	8.719677,	0},
	{4.927264,	0.299275,	8.538915,	0},
	{4.918884,	0.241814,	8.495819,	0},
	{4.897336,	0.189142,	8.492228,	0},
	{4.878182,	0.237026,	8.601164,	0},
	{4.818327,	0.262165,	8.705312,	0},
	{4.871000,	0.172382,	8.791503,	0},
	{4.924870,	0.119710,	8.872906,	0},
	{4.873394,	0.243011,	8.825022,	0},
	{4.832693,	0.408211,	8.659822,	0},
	{4.838678,	0.367510,	8.619121,	0},
	{4.904519,	0.169988,	8.809459,	0},
	{4.926067,	0.071826,	9.058456,	0},
	{4.940432,	0.058658,	8.823824,	0},
	{4.930855,	0.167594,	8.331817,	0},
	{4.918884,	0.266953,	8.265976,	0},
	{4.941629,	0.207098,	8.900438,	0},
	{4.957191,	0.129287,	9.339774,	0},
	{4.915293,	0.180762,	9.089581,	0},
	{4.930855,	0.190339,	8.826219,	0},
	{5.080492,	0.038307,	8.766363,	0},
	{5.204991,	-0.108936,	8.631091,	0},
	{5.202597,	-0.047884,	8.157040,	0},
	{5.157107,	0.095768,	7.870933,	0},
	{5.164289,	0.168791,	8.019373,	0},
	{5.199006,	0.167594,	8.428782,	0},
	{5.215765,	0.180762,	8.804670,	0},
	{5.201400,	0.278924,	8.614332,	0},
	{5.171472,	0.433350,	8.225274,	0},
	{5.199006,	0.466869,	8.068454,	0},
	{5.245692,	0.434547,	8.081622,	0},
	{5.252875,	0.493205,	8.092396,	0},
	{5.194217,	0.633266,	8.359349,	0},
	{5.155910,	0.772130,	8.494622,	0},
	{5.196611,	0.809240,	8.324634,	0},
	{5.245692,	0.724246,	8.206120,	0},
	{5.252875,	0.677559,	8.295903,	0},
	{5.234919,	0.689530,	8.449132,	0},
	{5.256466,	0.666785,	8.635880,	0},
	{5.276817,	0.672770,	8.653836,	0},
	{5.300759,	0.682347,	8.694537,	0},
	{5.352234,	0.640449,	8.677778,	0},
	{5.373782,	0.659602,	8.445540,	0},
	{5.371388,	0.752976,	8.093594,	0},
	{5.348643,	0.889445,	7.916422,	0},
	{5.337869,	0.974439,	8.097184,	0},
	{5.346249,	0.991199,	8.227669,	0},
	{5.382162,	0.978031,	8.289918,	0},
	{5.436031,	0.922964,	8.264779,	0},
	{5.408498,	0.940921,	8.136689,	0},
	{5.376176,	0.939724,	8.165420,	0},
	{5.364205,	0.924161,	8.331817,	0},
	{5.351037,	0.873883,	8.446738,	0},
	{5.334278,	0.855927,	8.334210,	0},
	{5.292379,	0.861912,	8.178588,	0},
	{5.298365,	0.858321,	8.146266,	0},
	{5.319912,	0.841561,	8.136689,	0},
	{5.353431,	0.793677,	8.121126,	0},
	{5.378571,	0.736217,	8.218092,	0},
	{5.397724,	0.694318,	8.354561,	0},
	{5.367796,	0.709880,	8.420402,	0},
	{5.335475,	0.749385,	8.528141,	0},
	{5.313927,	0.818816,	8.493424,	0},
	{5.306745,	0.889445,	8.315057,	0},
	{5.333081,	0.893037,	8.216895,	0},
	{5.345052,	0.899022,	8.208515,	0},
	{5.348643,	0.920570,	8.322240,	0},
	{5.346249,	0.955286,	8.494622,	0},
	{5.325898,	0.984016,	8.801080,	0},
	{5.355825,	0.998381,	9.132676,	0},
	{5.388147,	0.967257,	9.349351,	0},
	{5.489901,	0.889445,	9.421177,	0},
	{5.553347,	0.900219,	9.010572,	0},
	{5.532996,	1.004367,	8.176193,	0},
	{5.509054,	1.109712,	7.471101,	0},
	{5.504266,	1.175552,	7.400473,	0},
	{5.482718,	1.159990,	7.684185,	0},
	{5.443214,	1.177946,	8.027753,	0},
	{5.426455,	1.201888,	8.292312,	0},
	{5.492295,	1.139639,	8.359349,	0},
	{5.532996,	1.092952,	8.263581,	0},
	{5.522223,	1.072602,	7.959518,	0},
	{5.504266,	1.033097,	7.606374,	0},
	{5.524617,	0.958877,	7.461524,	0},
	{5.505463,	0.876277,	7.580038,	0},
	{5.458776,	0.823605,	7.835020,	0},
	{5.432440,	0.756567,	8.016979,	0},
	{5.386950,	0.760159,	8.174996,	0},
	{5.400118,	0.748188,	8.362941,	0},
	{5.449199,	0.687135,	8.324634,	0},
	{5.426455,	0.701501,	7.993037,	0},
	{5.407301,	0.751779,	7.637498,	0},
	{5.455185,	0.737414,	7.868538,	0},
	{5.456382,	0.735019,	8.342590,	0},
	{5.409695,	0.805648,	8.420402,	0},
	{5.379767,	0.878671,	8.323437,	0},
	{5.433637,	0.877474,	8.230062,	0},
	{5.477930,	0.864306,	8.248019,	0},
	{5.511448,	0.831985,	8.370124,	0},
	{5.525814,	0.817619,	8.439555,	0},
	{5.498281,	0.797269,	8.486242,	0},
	{5.485112,	0.806845,	8.465892,	0},
	{5.480324,	0.830787,	8.364138,	0},
	{5.485112,	0.831985,	8.337802,	0},
	{5.487506,	0.854729,	8.340196,	0},
	{5.434834,	0.873883,	8.372518,	0},
	{5.397724,	0.854729,	8.346182,	0},
	{5.392936,	0.869095,	8.216895,	0},
	{5.373782,	0.891840,	8.018176,	0},
	{5.401315,	0.872686,	7.902057,	0},
	{5.448002,	0.833182,	7.929591,	0},
	{5.425257,	0.835576,	8.146266,	0},
	{5.413286,	0.849941,	8.409628,	0},
	{5.421666,	0.837970,	8.495819,	0},
	{5.434834,	0.802057,	8.402445,	0},
	{5.456382,	0.772130,	8.238442,	0},
	{5.482718,	0.749385,	8.231260,	0},
	{5.497083,	0.744596,	8.304283,	0},
	{5.479127,	0.781706,	8.298298,	0},
	{5.432440,	0.882263,	8.295903,	0},
	{5.404907,	0.958877,	8.201332,	0},
	{5.397724,	0.944512,	8.110353,	0},
	{5.394133,	0.920570,	8.216895,	0},
	{5.437228,	0.899022,	8.328225,	0},
	{5.474339,	0.902613,	8.413219,	0},
	{5.529405,	0.889445,	8.447935,	0},
	{5.590457,	0.873883,	8.355759,	0},
	{5.612005,	0.877474,	8.292312,	0},
	{5.613202,	0.870292,	8.209712,	0},
	{5.585669,	0.913387,	8.025358,	0},
	{5.511448,	0.933738,	7.991840,	0},
	{5.475535,	0.949300,	8.026556,	0},
	{5.463564,	0.999579,	8.031344,	0},
	{5.469550,	0.994790,	7.918817,	0},
	{5.504266,	0.974439,	7.881707,	0},
	{5.546165,	0.991199,	7.955927,	0},
	{5.553347,	0.997184,	8.128309,	0},
	{5.567712,	1.010352,	8.230062,	0},
	{5.553347,	1.048660,	8.279144,	0},
	{5.578486,	1.033097,	8.268370,	0},
	{5.571303,	1.016338,	8.101973,	0},
	{5.543770,	0.985213,	7.933182,	0},
	{5.550953,	0.909796,	7.971489,	0},
	{5.547361,	0.855927,	7.951138,	0},
	{5.540179,	0.840364,	7.978672,	0},
	{5.523419,	0.848744,	8.152251,	0},
	{5.491098,	0.853532,	8.298298,	0},
	{5.420469,	0.901416,	8.333014,	0},
	{5.403709,	0.937329,	8.419205,	0},
	{5.440820,	0.964863,	8.601164,	0},
	{5.465959,	0.991199,	8.426387,	0},
	{5.457579,	1.051054,	8.109156,	0},
	{5.437228,	1.104923,	7.977475,	0},
	{5.428849,	1.102529,	8.027753,	0},
	{5.433637,	1.090558,	8.195347,	0},
	{5.432440,	1.100135,	8.276750,	0},
	{5.461170,	1.134851,	8.309072,	0},
	{5.511448,	1.119289,	8.292312,	0},
	{5.540179,	1.089361,	8.316254,	0},
	{5.518631,	1.103726,	8.358152,	0},
	{5.528208,	1.112106,	8.343787,	0},
	{5.527011,	1.094149,	8.257596,	0},
	{5.495886,	1.116894,	8.154645,	0},
	{5.510252,	1.092952,	8.208515,	0},
	{5.538982,	1.058236,	8.158237,	0},
	{5.511448,	1.088164,	7.948744,	0},
	{5.515040,	1.084573,	7.852976,	0},
	{5.507857,	1.104923,	7.959518,	0},
	{5.468353,	1.138442,	8.188165,	0},
	{5.468353,	1.148019,	8.327028,	0},
	{5.481521,	1.133654,	8.289918,	0},
	{5.511448,	1.120486,	8.226472,	0},
	{5.530602,	1.086967,	8.198938,	0},
	{5.529405,	1.065419,	8.166616,	0},
	{5.469550,	1.060631,	8.221684,	0},
	{5.440820,	1.053448,	8.240837,	0},
	{5.396527,	1.053448,	8.213304,	0},
	{5.386950,	1.055842,	8.234851,	0},
	{5.421666,	1.046265,	8.246822,	0},
	{5.431243,	1.029506,	8.155843,	0},
	{5.298365,	1.292868,	5.756854,	0},
	{5.191823,	1.255758,	8.088805,	0},
	{5.204991,	1.169567,	10.260345,	0}
};

const size_t kBodyDetectOffOnTestDataLength =
	ARRAY_SIZE(kBodyDetectOffOnTestData);

const struct body_detect_test_data kBodyDetectOnOffTestData[] = {
	{-6.536166,	0.264559,	7.560884,	0},
	{-6.253651,	0.108936,	8.167813,	0},
	{-5.890929,	-0.029928,	8.061272,	0},
	{-5.833468,	-0.045490,	8.250414,	0},
	{-5.932828,	0.038307,	8.573630,	0},
	{-5.995077,	0.104148,	8.634683,	0},
	{-6.080071,	0.181959,	8.317451,	0},
	{-6.069297,	0.177171,	8.151054,	0},
	{-5.978318,	0.113724,	8.407233,	0},
	{-5.895718,	0.033519,	8.592784,	0},
	{-5.828680,	-0.022745,	8.299495,	0},
	{-5.768825,	-0.070629,	7.958321,	0},
	{-5.770022,	-0.089783,	8.028950,	0},
	{-5.832272,	-0.074220,	8.360547,	0},
	{-5.880156,	-0.067038,	8.488636,	0},
	{-5.987895,	-0.017957,	8.342590,	0},
	{-6.148306,	0.014365,	8.317451,	0},
	{-6.337448,	0.102951,	8.492228,	0},
	{-6.411668,	0.148440,	8.571237,	0},
	{-6.341039,	0.099359,	8.250414,	0},
	{-6.232103,	0.067038,	7.899663,	0},
	{-6.172248,	0.100556,	8.152251,	0},
	{-6.095634,	0.111330,	8.632288,	0},
	{-6.033384,	0.126893,	8.614332,	0},
	{-5.936419,	0.131681,	8.136689,	0},
	{-5.931631,	0.205901,	7.739252,	0},
	{-5.986697,	0.271742,	7.870933,	0},
	{-6.040567,	0.250194,	8.099579,	0},
	{-6.077677,	0.244208,	8.191755,	0},
	{-6.071692,	0.277727,	8.146266,	0},
	{-5.953178,	0.292092,	8.025358,	0},
	{-5.847834,	0.330400,	7.942759,	0},
	{-5.776008,	0.392649,	8.036133,	0},
	{-5.680240,	0.417788,	7.892480,	0},
	{-5.617990,	0.458489,	7.609965,	0},
	{-5.550953,	0.496797,	7.418429,	0},
	{-5.301956,	0.369904,	8.050498,	0},
	{-5.276817,	0.290895,	9.167392,	0},
	{-5.890929,	0.215478,	9.044091,	0},
	{-6.495465,	0.108936,	9.111129,	0},
	{-6.545743,	-0.049081,	9.390053,	0},
	{-5.966347,	-0.161609,	9.362519,	0},
	{-5.325898,	-0.117316,	8.969871,	0},
	{-5.263649,	0.105345,	8.404840,	0},
	{-5.620385,	0.336385,	8.085214,	0},
	{-5.886141,	0.472855,	8.037330,	0},
	{-5.704182,	0.427365,	8.032541,	0},
	{-5.359417,	0.301669,	7.813472,	0},
	{-5.331883,	0.329203,	7.632710,	0},
	{-5.483915,	0.433350,	7.621936,	0},
	{-5.862199,	0.703895,	8.079228,	0},
	{-5.808330,	0.616507,	9.142253,	0},
	{-5.513843,	0.481234,	9.751576,	0},
	{-5.365402,	0.470460,	9.706087,	0},
	{-5.378571,	0.440533,	9.333789,	0},
	{-5.637144,	0.565031,	8.905227,	0},
	{-5.776008,	0.560243,	8.019373,	0},
	{-5.779599,	0.676362,	7.132322,	0},
	{-5.549756,	0.760159,	7.116760,	0},
	{-5.303153,	0.730231,	7.817063,	0},
	{-5.206188,	0.831985,	8.506593,	0},
	{-5.151122,	0.725443,	8.941140,	0},
	{-5.292379,	0.556652,	9.176969,	0},
	{-5.622779,	0.563834,	9.362519,	0},
	{-5.481521,	0.433350,	9.410403,	0},
	{-5.045777,	-0.074220,	9.109931,	0},
	{-5.035003,	-0.328005,	8.900438,	0},
	{-5.307941,	-0.389058,	9.000996,	0},
	{-5.561727,	-0.269348,	9.169786,	0},
	{-5.603625,	0.213084,	9.216474,	0},
	{-5.357023,	0.697909,	9.339774,	0},
	{-5.081690,	0.764947,	9.429557,	0},
	{-5.063733,	0.520739,	9.349351,	0},
	{-5.212173,	0.463278,	9.210487,	0},
	{-5.079296,	0.622492,	9.057259,	0},
	{-4.827904,	0.758961,	8.755589,	0},
	{-4.689041,	0.723048,	8.749604,	0},
	{-4.681858,	0.731428,	9.129085,	0},
	{-4.598061,	0.723048,	9.536098,	0},
	{-4.378992,	0.730231,	9.668977,	0},
	{-4.214989,	0.672770,	9.102749,	0},
	{-4.241325,	0.641646,	8.643063,	0},
	{-4.289209,	0.708683,	8.941140,	0},
	{-4.304772,	0.984016,	9.394841,	0},
	{-4.106053,	0.980425,	9.239218,	0},
	{-3.926488,	0.615309,	8.754393,	0},
	{-4.012679,	0.414197,	8.646653,	0},
	{-4.191047,	0.730231,	9.080004,	0},
	{-4.211398,	1.057039,	9.763548,	0},
	{-4.055775,	0.944512,	9.933537,	0},
	{-3.976766,	0.493205,	9.303862,	0},
	{-4.319137,	0.397437,	8.835795,	0},
	{-4.368218,	0.577002,	9.014163,	0},
	{-4.213792,	0.700303,	9.281116,	0},
	{-4.164711,	0.563834,	9.527719,	0},
	{-4.132390,	0.458489,	9.472652,	0},
	{-4.106053,	0.392649,	9.238021,	0},
	{-4.090491,	0.524330,	9.093172,	0},
	{-4.052184,	0.738611,	9.153027,	0},
	{-4.015073,	0.524330,	9.047682,	0},
	{-4.149149,	0.454898,	8.930367,	0},
	{-4.250902,	0.724246,	9.131479,	0},
	{-4.231749,	0.701501,	9.166195,	0},
	{-4.356247,	0.757764,	9.208094,	0},
	{-4.443635,	0.785298,	9.235627,	0},
	{-4.355050,	0.804451,	9.149436,	0},
	{-4.307166,	0.567425,	9.187743,	0},
	{-4.550177,	0.476446,	9.249992,	0},
	{-4.790794,	0.457292,	9.175772,	0},
	{-4.935644,	0.417788,	9.200911,	0},
	{-4.940432,	0.588973,	9.419980,	0},
	{-4.709392,	0.357933,	9.624684,	0},
	{-4.763261,	0.093374,	9.773125,	0},
	{-5.021835,	0.171185,	9.756365,	0},
	{-5.087675,	0.294487,	9.680948,	0},
	{-4.916490,	0.357933,	9.610319,	0},
	{-4.729742,	0.360327,	9.296679,	0},
	{-4.635171,	0.266953,	8.780728,	0},
	{-4.843467,	0.410605,	8.383291,	0},
	{-4.898533,	0.500388,	8.177390,	0},
	{-4.692632,	0.489614,	8.313860,	0},
	{-4.566936,	0.451307,	8.595179,	0},
	{-4.624397,	0.457292,	8.774743,	0},
	{-4.781218,	0.441730,	8.777138,	0},
	{-4.916490,	0.410605,	8.816642,	0},
	{-5.014652,	0.482431,	8.795094,	0},
	{-4.830298,	0.306458,	8.991419,	0},
	{-5.154713,	0.448913,	8.974659,	0},
	{-5.114011,	0.424971,	8.789108,	0},
	{-4.894942,	0.238223,	8.692143,	0},
	{-4.979936,	0.184353,	8.980644,	0},
	{-5.267240,	0.381875,	9.326607,	0},
	{-5.289985,	0.413000,	9.498989,	0},
	{-5.128376,	0.320823,	9.273934,	0},
	{-4.978739,	0.312443,	8.930367,	0},
	{-5.054156,	0.391452,	8.816642,	0},
	{-5.224144,	0.409408,	8.898045,	0},
	{-5.287591,	0.392649,	8.862131,	0},
	{-5.182246,	0.426168,	8.808262,	0},
	{-5.039791,	0.471657,	8.797488,	0},
	{-4.969162,	0.490811,	8.793897,	0},
	{-5.032609,	0.511162,	8.804670,	0},
	{-5.021835,	0.465672,	8.822627,	0},
	{-4.967965,	0.496797,	8.820233,	0},
	{-4.969162,	0.571017,	8.796291,	0},
	{-4.904519,	0.560243,	8.785517,	0},
	{-4.750093,	0.547075,	8.775940,	0},
	{-4.687844,	0.500388,	8.554477,	0},
	{-4.741713,	0.487220,	8.224077,	0},
	{-4.880577,	0.569820,	8.147463,	0},
	{-4.959586,	0.610521,	8.506593,	0},
	{-4.977542,	0.555454,	8.856146,	0},
	{-4.910504,	0.424971,	8.870511,	0},
	{-4.947615,	0.316034,	8.845372,	0},
	{-5.177458,	0.336385,	9.156618,	0},
	{-5.345052,	0.371101,	9.455894,	0},
	{-5.370191,	0.402226,	9.381673,	0},
	{-5.357023,	0.372298,	9.232036,	0},
	{-5.309139,	0.289698,	9.148238,	0},
	{-5.236115,	0.247800,	9.085989,	0},
	{-5.159501,	0.211887,	9.010572,	0},
	{-5.081690,	0.173579,	8.878891,	0},
	{-5.049368,	0.208295,	8.710100,	0},
	{-5.026623,	0.229843,	8.664610,	0},
	{-5.032609,	0.237026,	8.772349,	0},
	{-4.967965,	0.233435,	8.868117,	0},
	{-4.844664,	0.164003,	8.799882,	0},
	{-4.906913,	0.155623,	8.500607,	0},
	{-5.141545,	0.264559,	8.359349,	0},
	{-5.264846,	0.310049,	8.640668,	0},
	{-5.348643,	0.306458,	8.961491,	0},
	{-5.366600,	0.301669,	8.968674,	0},
	{-5.404907,	0.298078,	8.802277,	0},
	{-5.386950,	0.259771,	8.801080,	0},
	{-5.335475,	0.208295,	8.759181,	0},
	{-5.300759,	0.174777,	8.723268,	0},
	{-5.237313,	0.147243,	8.762773,	0},
	{-5.303153,	0.185551,	8.772349,	0},
	{-5.394133,	0.204704,	8.888468,	0},
	{-5.383359,	0.167594,	8.965082,	0},
	{-5.257663,	0.110133,	8.893256,	0},
	{-5.116405,	0.039504,	8.738831,	0},
	{-5.194217,	0.044293,	8.644259,	0},
	{-5.336672,	0.111330,	8.772349,	0},
	{-5.389344,	0.132878,	8.972264,	0},
	{-5.400118,	0.136469,	8.959097,	0},
	{-5.455185,	0.185551,	8.850161,	0},
	{-5.519828,	0.210690,	8.804670,	0},
	{-5.555741,	0.210690,	8.898045,	0},
	{-5.507857,	0.222661,	8.835795,	0},
	{-5.402513,	0.205901,	8.598769,	0},
	{-5.368994,	0.257377,	8.353364,	0},
	{-5.437228,	0.366313,	8.394066,	0},
	{-5.401315,	0.345962,	8.656230,	0},
	{-5.341460,	0.350750,	8.723268,	0},
	{-5.272028,	0.362721,	8.585602,	0},
	{-5.282803,	0.387860,	8.337802,	0},
	{-5.285197,	0.420182,	8.268370,	0},
	{-5.250481,	0.415394,	8.337802,	0},
	{-5.185837,	0.379481,	8.416810,	0},
	{-5.161895,	0.356736,	8.468286,	0},
	{-5.203794,	0.344765,	8.577222,	0},
	{-5.272028,	0.306458,	8.719677,	0},
	{-5.315124,	0.271742,	8.868117,	0},
	{-5.337869,	0.296881,	8.939943,	0},
	{-5.376176,	0.299275,	8.894453,	0},
	{-5.442017,	0.318429,	8.793897,	0},
	{-5.452791,	0.331597,	8.714889,	0},
	{-5.412089,	0.289698,	8.700523,	0},
	{-5.406104,	0.251391,	8.773546,	0},
	{-5.368994,	0.252588,	8.866920,	0},
	{-5.323504,	0.240617,	8.942337,	0},
	{-5.333081,	0.231040,	9.015361,	0},
	{-5.377373,	0.231040,	8.980644,	0},
	{-5.450397,	0.292092,	8.865723,	0},
	{-5.483915,	0.336385,	8.750801,	0},
	{-5.474339,	0.355539,	8.653836,	0},
	{-5.404907,	0.342371,	8.593981,	0},
	{-5.243298,	0.234632,	8.598769,	0},
	{-5.164289,	0.198719,	8.635880,	0},
	{-5.214568,	0.248997,	8.646653,	0},
	{-5.316321,	0.288501,	8.589192,	0},
	{-5.452791,	0.343568,	8.579616,	0},
	{-5.509054,	0.366313,	8.670595,	0},
	{-5.474339,	0.319626,	8.686158,	0},
	{-5.384556,	0.275333,	8.689749,	0},
	{-5.365402,	0.268150,	8.750801,	0},
	{-5.437228,	0.357933,	8.748407,	0},
	{-5.470747,	0.402226,	8.730451,	0},
	{-5.386950,	0.362721,	8.672990,	0},
	{-5.339066,	0.363918,	8.700523,	0},
	{-5.295970,	0.398634,	8.793897,	0},
	{-5.307941,	0.413000,	8.899241,	0},
	{-5.295970,	0.392649,	8.924380,	0},
	{-5.287591,	0.405817,	8.936352,	0},
	{-5.269634,	0.417788,	8.896848,	0},
	{-5.342658,	0.471657,	8.640668,	0},
	{-5.464762,	0.557849,	8.434767,	0},
	{-5.467156,	0.575805,	8.456315,	0},
	{-5.443214,	0.561440,	8.497016,	0},
	{-5.440820,	0.574608,	8.524549,	0},
	{-5.438426,	0.598550,	8.480257,	0},
	{-5.348643,	0.553060,	8.530535,	0},
	{-5.238510,	0.509965,	8.638274,	0},
	{-5.155910,	0.445321,	8.657428,	0},
	{-5.111617,	0.395043,	8.583207,	0},
	{-5.115209,	0.365116,	8.610741,	0},
	{-5.176260,	0.344765,	8.625106,	0},
	{-5.254072,	0.373495,	8.711297,	0},
	{-5.267240,	0.379481,	8.808262,	0},
	{-5.238510,	0.329203,	8.795094,	0},
	{-5.266043,	0.282516,	8.694537,	0},
	{-5.410892,	0.308852,	8.599967,	0},
	{-5.538982,	0.337582,	8.520958,	0},
	{-5.544967,	0.344765,	8.590390,	0},
	{-5.458776,	0.276530,	8.730451,	0},
	{-5.408498,	0.211887,	8.729254,	0},
	{-5.450397,	0.195127,	8.633486,	0},
	{-5.509054,	0.216675,	8.659822,	0},
	{-5.483915,	0.190339,	8.823824,	0},
	{-5.430046,	0.169988,	9.004586,	0},
	{-5.392936,	0.186748,	9.078807,	0},
	{-5.406104,	0.197522,	9.024938,	0},
	{-5.462368,	0.269348,	8.857343,	0},
	{-5.462368,	0.290895,	8.724465,	0},
	{-5.409695,	0.284910,	8.667005,	0},
	{-5.389344,	0.288501,	8.643063,	0},
	{-5.354629,	0.284910,	8.577222,	0},
	{-5.329489,	0.287304,	8.591587,	0},
	{-5.280408,	0.282516,	8.658625,	0},
	{-5.206188,	0.225055,	8.695735,	0},
	{-5.169078,	0.235829,	8.741224,	0},
	{-5.181049,	0.256179,	8.693340,	0},
	{-5.245692,	0.262165,	8.619121,	0},
	{-5.334278,	0.257377,	8.613134,	0},
	{-5.388147,	0.248997,	8.681370,	0},
	{-5.376176,	0.240617,	8.742421,	0},
	{-5.360614,	0.199916,	8.707705,	0},
	{-5.443214,	0.190339,	8.631091,	0},
	{-5.489901,	0.172382,	8.549688,	0},
	{-5.524617,	0.192733,	8.529338,	0},
	{-5.518631,	0.189142,	8.562857,	0},
	{-5.479127,	0.158017,	8.555674,	0},
	{-5.499477,	0.140061,	8.599967,	0},
	{-5.519828,	0.130484,	8.643063,	0},
	{-5.493492,	0.090980,	8.652639,	0},
	{-5.458776,	0.074220,	8.610741,	0},
	{-5.483915,	0.107739,	8.635880,	0},
	{-5.445608,	0.087388,	8.746013,	0},
	{-5.422863,	0.052672,	8.787911,	0},
	{-5.402513,	0.032322,	8.768758,	0},
	{-5.373782,	-0.007183,	8.802277,	0},
	{-5.371388,	-0.031125,	8.772349,	0},
	{-5.416878,	-0.052672,	8.682567,	0},
	{-5.614399,	-0.032322,	8.693340,	0},
	{-5.582078,	0.015562,	8.038527,	0},
	{-5.532996,	-0.019154,	8.003811,	1},
	{-5.451593,	-0.088585,	8.389277,	0},
	{-5.433637,	-0.120907,	8.461103,	0},
	{-5.456382,	-0.082600,	8.352167,	0},
	{-5.480324,	-0.110133,	8.429978,	0},
	{-5.503069,	-0.126893,	8.602361,	0},
	{-5.524617,	-0.173579,	8.689749,	0},
	{-5.519828,	-0.161609,	8.710100,	0},
	{-5.448002,	-0.165200,	8.803473,	0},
	{-5.337869,	-0.209493,	8.835795,	0},
	{-5.226539,	-0.217872,	8.792700,	0},
	{-5.204991,	-0.144849,	8.779531,	0},
	{-5.155910,	-0.038307,	8.741224,	0},
	{-5.038594,	0.025139,	8.692143,	0},
	{-4.826707,	0.129287,	8.741224,	0},
	{-4.588484,	0.221464,	9.275131,	0},
	{-4.413708,	0.146046,	9.674962,	0},
	{-4.571725,	0.420182,	9.512156,	0},
	{-4.693829,	0.806845,	9.115917,	0},
	{-4.513067,	1.146822,	8.775940,	0},
	{-3.907335,	0.906205,	8.744816,	0},
	{-3.440465,	0.709880,	8.558068,	0},
	{-3.076547,	0.870292,	8.097184,	0},
	{-2.567780,	0.849941,	7.629118,	0},
	{-0.930147,	-0.430956,	9.020149,	0},
	{0.472855,	-1.265335,	13.321329,	0},
	{-0.475249,	-0.396240,	11.602294,	0},
	{-2.302023,	0.135272,	10.661373,	0},
	{-2.796426,	-0.083797,	11.195279,	0},
	{-2.404974,	-0.368707,	10.447092,	0},
	{-1.205480,	-0.381875,	9.781505,	0},
	{-0.250194,	0.064643,	9.928748,	0},
	{-0.004788,	0.374692,	9.695313,	0},
	{0.256179,	-0.470460,	8.904030,	0},
	{0.268150,	-0.964863,	8.276750,	0},
	{0.314837,	-0.756567,	8.742421,	0},
	{0.496797,	-0.694318,	9.910791,	0},
	{0.828393,	-0.748188,	10.779886,	0},
	{0.738611,	-0.306458,	11.670528,	0},
	{0.616507,	-0.045490,	11.973394,	0},
	{0.690727,	-0.164003,	11.194082,	0},
	{0.632069,	-0.343568,	10.463851,	0},
	{0.422576,	0.026336,	10.319002,	0},
	{0.520739,	0.468066,	10.074794,	0},
	{0.845153,	0.277727,	9.525325,	0},
	{1.058236,	-0.199916,	9.085989,	0},
	{1.198297,	-0.499191,	9.630670,	0},
	{1.109712,	-0.314837,	10.516523,	0},
	{1.086967,	0.258574,	10.805025,	0},
	{1.313219,	0.523133,	10.685315,	0},
	{1.334767,	0.202310,	10.316608,	0},
	{1.298854,	-0.199916,	9.993391,	0},
	{1.471236,	-0.282516,	10.037683,	0},
	{1.620873,	0.053870,	9.892835,	0},
	{1.553836,	0.363918,	9.296679,	0},
	{1.425746,	0.114922,	8.937549,	0},
	{1.545456,	-0.174777,	9.566027,	0},
	{1.985989,	0.075417,	10.395617,	0},
	{2.272096,	0.312443,	10.295060,	0},
	{2.181116,	0.196324,	9.525325,	0},
	{1.965638,	0.197522,	9.500186,	0},
	{2.054224,	-0.038307,	9.800658,	0},
	{1.924937,	0.196324,	9.728832,	0},
	{2.146400,	0.402226,	9.747986,	0},
	{2.321177,	0.282516,	9.983814,	0},
	{2.279279,	0.118513,	7.716507,	0},
	{2.229000,	-0.113724,	9.612713,	0},
	{2.345119,	0.343568,	11.982971,	0},
	{2.196679,	0.189142,	9.917974,	0},
	{2.218226,	-0.119710,	9.633064,	0},
	{2.020705,	0.239420,	9.703692,	0},
	{1.997960,	0.318429,	9.247598,	0},
	{1.975215,	0.132878,	8.886073,	0},
	{1.841140,	0.253785,	8.754393,	0},
	{1.507149,	0.458489,	8.775940,	0},
	{1.295262,	0.497994,	9.170983,	0},
	{1.291671,	0.102951,	9.712072,	0},
	{1.267729,	0.034716,	9.686934,	0},
	{1.474827,	-0.047884,	9.932339,	0},
	{1.121683,	-0.041899,	10.319002,	0},
	{0.475249,	0.349553,	11.362873,	0},
	{0.029928,	0.153229,	13.443434,	0},
	{1.442506,	-0.270545,	12.089513,	0},
	{0.821211,	0.186748,	10.431530,	0},
	{0.302866,	0.573411,	9.538493,	0},
	{0.973242,	-0.051475,	8.095987,	0},
	{1.428140,	-1.648407,	7.060496,	0},
	{1.292868,	-2.129641,	8.062469,	0},
	{0.068235,	0.414197,	8.157040,	0},
	{-1.018732,	1.418563,	9.985011,	0},
	{-1.479616,	1.746569,	18.444918,	0},
	{0.362721,	0.951695,	11.461036,	0},
	{0.283713,	-0.120907,	8.001416,	0},
	{-0.320823,	0.131681,	11.031277,	0},
	{-0.141258,	0.141258,	9.783898,	0},
	{-0.098162,	0.118513,	10.248373,	0},
	{-0.278924,	0.311246,	9.223656,	0},
	{-0.034716,	0.162806,	9.734818,	0},
	{-0.282516,	-0.306458,	12.023673,	0},
	{-0.219069,	0.069432,	9.692919,	0},
	{-0.235829,	0.088585,	10.111904,	0},
	{-0.243011,	0.071826,	10.181335,	0},
	{-0.237026,	0.084994,	10.177745,	0},
	{-0.246603,	0.079009,	10.078385,	0},
	{-0.222661,	0.083797,	10.192110,	0},
	{-0.252588,	0.067038,	10.103524,	0},
	{-0.226252,	0.084994,	10.156197,	0},
	{-0.265756,	0.071826,	10.116693,	0},
	{-0.235829,	0.083797,	10.168168,	0},
	{-0.251391,	0.083797,	10.108313,	0},
	{-0.248997,	0.083797,	10.155000,	0},
	{-0.228646,	0.083797,	10.122678,	0},
	{-0.266953,	0.067038,	10.104721,	0},
	{-0.233435,	0.074220,	10.141831,	0},
	{-0.259771,	0.080206,	10.107116,	0},
	{-0.245406,	0.080206,	10.166970,	0},
	{-0.256179,	0.075417,	10.099933,	0},
	{-0.243011,	0.070629,	10.153803,	0},
	{-0.256179,	0.073023,	10.090356,	0},
	{-0.258574,	0.077812,	10.200489,	0},
	{-0.253785,	0.063446,	10.095144,	0},
	{-0.245406,	0.073023,	10.135846,	0},
	{-0.251391,	0.082600,	10.134649,	0},
	{-0.251391,	0.068235,	10.116693,	0},
	{-0.247800,	0.079009,	10.164577,	0},
	{-0.244208,	0.075417,	10.115496,	0},
	{-0.238223,	0.073023,	10.137043,	0},
	{-0.251391,	0.077812,	10.078385,	0},
	{-0.235829,	0.077812,	10.131058,	0},
	{-0.250194,	0.087388,	10.123875,	0},
	{-0.250194,	0.079009,	10.147817,	0},
	{-0.254982,	0.064643,	10.110707,	0},
	{-0.256179,	0.083797,	10.151408,	0},
	{-0.237026,	0.079009,	10.103524,	0},
	{-0.256179,	0.079009,	10.137043,	0},
	{-0.246603,	0.081403,	10.139438,	0},
	{-0.243011,	0.077812,	10.115496,	0},
	{-0.254982,	0.063446,	10.159788,	0},
	{-0.248997,	0.089783,	10.092751,	0},
	{-0.251391,	0.074220,	10.164577,	0},
	{-0.246603,	0.079009,	10.117889,	0},
	{-0.247800,	0.086191,	10.145423,	0},
	{-0.247800,	0.088585,	10.123875,	0},
	{-0.254982,	0.075417,	10.122678,	0},
	{-0.250194,	0.080206,	10.147817,	0},
	{-0.251391,	0.068235,	10.113101,	0},
	{-0.246603,	0.074220,	10.147817,	0},
	{-0.243011,	0.068235,	10.104721,	0},
	{-0.245406,	0.063446,	10.143028,	0},
	{-0.250194,	0.075417,	10.121481,	0},
	{-0.252588,	0.079009,	10.141831,	0},
	{-0.245406,	0.071826,	10.129861,	0},
	{-0.240617,	0.079009,	10.135846,	0},
	{-0.240617,	0.069432,	10.141831,	0},
	{-0.245406,	0.079009,	10.121481,	0},
	{-0.252588,	0.069432,	10.160985,	0},
	{-0.258574,	0.067038,	10.121481,	0},
	{-0.260968,	0.067038,	10.140635,	0},
	{-0.250194,	0.068235,	10.127466,	0},
	{-0.239420,	0.074220,	10.129861,	0},
	{-0.250194,	0.065841,	10.131058,	0},
	{-0.245406,	0.074220,	10.128663,	0},
	{-0.247800,	0.088585,	10.133451,	0},
	{-0.245406,	0.082600,	10.105919,	0},
	{-0.251391,	0.067038,	10.133451,	0},
	{-0.241814,	0.075417,	10.121481,	0},
	{-0.247800,	0.075417,	10.140635,	0},
	{-0.254982,	0.080206,	10.132255,	0},
	{-0.237026,	0.074220,	10.137043,	0},
	{-0.251391,	0.082600,	10.135846,	0},
	{-0.247800,	0.095768,	10.135846,	0},
	{-0.244208,	0.075417,	10.115496,	0},
	{-0.245406,	0.074220,	10.138240,	0},
	{-0.239420,	0.080206,	10.137043,	0},
	{-0.257377,	0.073023,	10.128663,	0},
	{-0.253785,	0.081403,	10.134649,	0},
	{-0.256179,	0.061052,	10.137043,	0},
	{-0.243011,	0.082600,	10.129861,	0},
	{-0.246603,	0.080206,	10.116693,	0},
	{-0.240617,	0.080206,	10.120284,	0},
	{-0.251391,	0.069432,	10.109509,	0},
	{-0.247800,	0.073023,	10.144226,	0},
	{-0.248997,	0.077812,	10.110707,	0},
	{-0.256179,	0.065841,	10.134649,	0},
	{-0.246603,	0.071826,	10.111904,	0},
	{-0.265756,	0.075417,	10.123875,	0},
	{-0.245406,	0.084994,	10.131058,	0},
	{-0.251391,	0.073023,	10.114298,	0},
	{-0.247800,	0.090980,	10.145423,	0},
	{-0.263362,	0.088585,	10.121481,	0},
	{-0.258574,	0.074220,	10.149014,	0},
	{-0.252588,	0.069432,	10.114298,	0},
	{-0.259771,	0.074220,	10.121481,	0},
	{-0.251391,	0.068235,	10.137043,	0},
	{-0.245406,	0.074220,	10.131058,	0},
	{-0.244208,	0.074220,	10.121481,	0},
	{-0.253785,	0.070629,	10.108313,	0},
	{-0.256179,	0.077812,	10.144226,	0},
	{-0.241814,	0.058658,	10.104721,	0},
	{-0.244208,	0.069432,	10.133451,	0},
	{-0.241814,	0.081403,	10.113101,	0},
	{-0.253785,	0.080206,	10.110707,	0},
	{-0.257377,	0.086191,	10.121481,	0},
	{-0.252588,	0.080206,	10.129861,	0},
	{-0.246603,	0.081403,	10.121481,	0},
	{-0.245406,	0.086191,	10.123875,	0},
	{-0.251391,	0.076614,	10.153803,	0},
	{-0.246603,	0.068235,	10.120284,	0},
	{-0.234632,	0.090980,	10.134649,	0},
	{-0.253785,	0.080206,	10.098736,	0},
	{-0.256179,	0.093374,	10.135846,	0},
	{-0.259771,	0.076614,	10.126269,	0},
	{-0.240617,	0.074220,	10.147817,	0},
	{-0.256179,	0.068235,	10.119086,	0},
	{-0.254982,	0.073023,	10.120284,	0},
	{-0.250194,	0.082600,	10.143028,	0},
	{-0.250194,	0.076614,	10.115496,	0},
	{-0.247800,	0.068235,	10.145423,	0},
	{-0.241814,	0.077812,	10.122678,	0},
	{-0.245406,	0.079009,	10.138240,	0},
	{-0.266953,	0.083797,	10.111904,	0},
	{-0.254982,	0.074220,	10.116693,	0},
	{-0.248997,	0.090980,	10.138240,	0},
	{-0.262165,	0.083797,	10.123875,	0},
	{-0.245406,	0.081403,	10.128663,	0},
	{-0.252588,	0.065841,	10.103524,	0},
	{-0.248997,	0.089783,	10.128663,	0},
	{-0.250194,	0.070629,	10.108313,	0},
	{-0.248997,	0.068235,	10.147817,	0},
	{-0.251391,	0.083797,	10.125072,	0},
	{-0.258574,	0.070629,	10.125072,	0},
	{-0.259771,	0.058658,	10.125072,	0},
	{-0.246603,	0.070629,	10.120284,	0},
	{-0.243011,	0.064643,	10.128663,	0},
	{-0.263362,	0.073023,	10.134649,	0},
	{-0.246603,	0.076614,	10.140635,	0},
	{-0.246603,	0.084994,	10.122678,	0},
	{-0.241814,	0.068235,	10.131058,	0},
	{-0.243011,	0.073023,	10.115496,	0},
	{-0.252588,	0.074220,	10.157393,	0},
	{-0.264559,	0.076614,	10.105919,	0},
	{-0.254982,	0.069432,	10.135846,	0},
	{-0.234632,	0.075417,	10.126269,	0},
	{-0.239420,	0.080206,	10.120284,	0},
	{-0.251391,	0.087388,	10.146620,	0},
	{-0.238223,	0.069432,	10.126269,	0},
	{-0.247800,	0.065841,	10.127466,	0},
	{-0.253785,	0.069432,	10.113101,	0},
	{-0.252588,	0.079009,	10.144226,	0},
	{-0.254982,	0.074220,	10.123875,	0},
	{-0.247800,	0.061052,	10.134649,	0},
	{-0.248997,	0.067038,	10.119086,	0},
	{-0.247800,	0.077812,	10.123875,	0},
	{-0.253785,	0.079009,	10.134649,	0},
	{-0.246603,	0.084994,	10.111904,	0},
	{-0.253785,	0.087388,	10.139438,	0},
	{-0.256179,	0.082600,	10.097539,	0},
	{-0.240617,	0.087388,	10.149014,	0},
	{-0.252588,	0.059855,	10.108313,	0},
	{-0.235829,	0.082600,	10.129861,	0},
	{-0.247800,	0.094571,	10.127466,	0},
	{-0.248997,	0.082600,	10.122678,	0},
	{-0.240617,	0.084994,	10.131058,	0},
	{-0.253785,	0.077812,	10.116693,	0},
	{-0.258574,	0.086191,	10.133451,	0},
	{-0.247800,	0.071826,	10.128663,	0},
	{-0.247800,	0.074220,	10.132255,	0},
	{-0.254982,	0.071826,	10.120284,	0},
	{-0.253785,	0.080206,	10.140635,	0},
	{-0.269348,	0.076614,	10.132255,	0},
	{-0.253785,	0.082600,	10.131058,	0},
	{-0.244208,	0.089783,	10.140635,	0},
	{-0.247800,	0.073023,	10.110707,	0},
	{-0.252588,	0.070629,	10.129861,	0},
	{-0.257377,	0.071826,	10.125072,	0},
	{-0.252588,	0.074220,	10.117889,	0},
	{-0.254982,	0.068235,	10.128663,	0},
	{-0.259771,	0.058658,	10.134649,	0},
	{-0.252588,	0.070629,	10.119086,	0},
	{-0.243011,	0.089783,	10.146620,	0},
	{-0.240617,	0.075417,	10.128663,	0},
	{-0.254982,	0.063446,	10.145423,	0},
	{-0.272939,	0.081403,	10.127466,	0},
	{-0.241814,	0.075417,	10.127466,	0},
	{-0.233435,	0.073023,	10.125072,	0},
	{-0.248997,	0.080206,	10.132255,	0},
	{-0.241814,	0.074220,	10.134649,	0},
	{-0.266953,	0.068235,	10.133451,	0},
	{-0.245406,	0.069432,	10.127466,	0},
	{-0.247800,	0.087388,	10.131058,	0},
	{-0.247800,	0.082600,	10.129861,	0},
	{-0.257377,	0.070629,	10.137043,	0},
	{-0.247800,	0.074220,	10.131058,	0},
	{-0.252588,	0.086191,	10.114298,	0},
	{-0.247800,	0.089783,	10.135846,	0},
	{-0.256179,	0.073023,	10.131058,	0},
	{-0.257377,	0.080206,	10.133451,	0},
	{-0.245406,	0.069432,	10.125072,	0},
	{-0.250194,	0.061052,	10.126269,	0},
	{-0.252588,	0.079009,	10.135846,	0},
	{-0.250194,	0.073023,	10.128663,	0},
	{-0.237026,	0.075417,	10.155000,	0},
	{-0.247800,	0.079009,	10.140635,	0},
	{-0.251391,	0.069432,	10.151408,	0},
	{-0.244208,	0.075417,	10.127466,	0},
	{-0.252588,	0.071826,	10.111904,	0},
	{-0.257377,	0.077812,	10.138240,	0},
	{-0.241814,	0.069432,	10.122678,	0},
	{-0.253785,	0.071826,	10.139438,	0},
	{-0.256179,	0.077812,	10.119086,	0},
	{-0.262165,	0.077812,	10.133451,	0},
	{-0.252588,	0.061052,	10.132255,	0},
	{-0.250194,	0.077812,	10.119086,	0},
	{-0.253785,	0.081403,	10.132255,	0},
	{-0.253785,	0.079009,	10.117889,	0},
	{-0.252588,	0.064643,	10.129861,	0},
	{-0.247800,	0.073023,	10.117889,	0},
	{-0.253785,	0.065841,	10.126269,	0},
	{-0.256179,	0.069432,	10.128663,	0},
	{-0.250194,	0.080206,	10.128663,	0},
	{-0.257377,	0.084994,	10.107116,	0},
	{-0.254982,	0.080206,	10.137043,	0},
	{-0.259771,	0.076614,	10.137043,	0},
	{-0.265756,	0.063446,	10.132255,	0},
	{-0.251391,	0.056264,	10.120284,	0},
	{-0.247800,	0.067038,	10.132255,	0},
	{-0.247800,	0.074220,	10.126269,	0},
	{-0.247800,	0.070629,	10.127466,	0},
	{-0.239420,	0.081403,	10.143028,	0},
	{-0.254982,	0.081403,	10.129861,	0},
	{-0.259771,	0.088585,	10.138240,	0},
	{-0.246603,	0.080206,	10.108313,	0},
	{-0.252588,	0.086191,	10.125072,	0},
	{-0.247800,	0.071826,	10.132255,	0},
	{-0.240617,	0.073023,	10.126269,	0},
	{-0.256179,	0.075417,	10.134649,	0},
	{-0.254982,	0.081403,	10.117889,	0},
	{-0.250194,	0.070629,	10.133451,	0},
	{-0.254982,	0.064643,	10.137043,	0},
	{-0.254982,	0.075417,	10.147817,	0},
	{-0.240617,	0.077812,	10.122678,	0},
	{-0.239420,	0.083797,	10.153803,	0},
	{-0.258574,	0.070629,	10.131058,	0},
	{-0.256179,	0.077812,	10.133451,	0},
	{-0.265756,	0.080206,	10.143028,	0},
	{-0.256179,	0.070629,	10.138240,	0},
	{-0.250194,	0.067038,	10.129861,	0},
	{-0.245406,	0.071826,	10.126269,	0},
	{-0.259771,	0.073023,	10.135846,	0},
	{-0.251391,	0.061052,	10.121481,	0},
	{-0.254982,	0.075417,	10.150211,	0},
	{-0.247800,	0.081403,	10.137043,	0},
	{-0.248997,	0.084994,	10.126269,	0},
	{-0.257377,	0.082600,	10.135846,	0},
	{-0.257377,	0.073023,	10.110707,	0},
	{-0.251391,	0.077812,	10.138240,	0},
	{-0.238223,	0.064643,	10.116693,	0},
	{-0.239420,	0.075417,	10.138240,	0},
	{-0.260968,	0.071826,	10.132255,	0},
	{-0.253785,	0.094571,	10.132255,	0},
	{-0.248997,	0.081403,	10.127466,	0},
	{-0.245406,	0.073023,	10.150211,	0},
	{-0.252588,	0.080206,	10.120284,	0},
	{-0.247800,	0.075417,	10.122678,	0},
	{-0.246603,	0.069432,	10.122678,	0},
	{-0.246603,	0.090980,	10.119086,	0},
	{-0.253785,	0.076614,	10.139438,	0},
	{-0.253785,	0.063446,	10.127466,	0},
	{-0.248997,	0.094571,	10.146620,	0},
	{-0.257377,	0.079009,	10.115496,	0},
	{-0.247800,	0.068235,	10.122678,	0},
	{-0.244208,	0.080206,	10.117889,	0},
	{-0.257377,	0.099359,	10.134649,	0},
	{-0.257377,	0.089783,	10.111904,	0},
	{-0.247800,	0.073023,	10.133451,	0},
	{-0.238223,	0.070629,	10.120284,	0},
	{-0.256179,	0.073023,	10.125072,	0},
	{-0.257377,	0.063446,	10.144226,	0},
	{-0.259771,	0.081403,	10.122678,	0},
	{-0.251391,	0.079009,	10.123875,	0},
	{-0.256179,	0.068235,	10.122678,	0},
	{-0.252588,	0.065841,	10.128663,	0},
	{-0.239420,	0.074220,	10.122678,	0},
	{-0.247800,	0.073023,	10.138240,	0},
	{-0.245406,	0.076614,	10.111904,	0},
	{-0.252588,	0.076614,	10.125072,	0},
	{-0.259771,	0.059855,	10.122678,	0},
	{-0.262165,	0.067038,	10.137043,	0},
	{-0.248997,	0.073023,	10.127466,	0},
	{-0.248997,	0.076614,	10.132255,	0},
	{-0.244208,	0.080206,	10.115496,	0},
	{-0.245406,	0.055067,	10.140635,	0},
	{-0.251391,	0.059855,	10.135846,	0},
	{-0.246603,	0.073023,	10.111904,	0},
	{-0.248997,	0.081403,	10.123875,	0},
	{-0.248997,	0.070629,	10.126269,	0},
	{-0.251391,	0.075417,	10.129861,	0},
	{-0.239420,	0.071826,	10.139438,	0},
	{-0.244208,	0.076614,	10.109509,	0},
	{-0.263362,	0.082600,	10.135846,	0},
	{-0.252588,	0.071826,	10.127466,	0},
	{-0.241814,	0.067038,	10.122678,	0},
	{-0.252588,	0.079009,	10.125072,	0},
	{-0.260968,	0.084994,	10.125072,	0},
	{-0.245406,	0.080206,	10.119086,	0},
	{-0.241814,	0.071826,	10.126269,	0},
	{-0.251391,	0.075417,	10.135846,	0},
	{-0.254982,	0.068235,	10.127466,	0},
	{-0.260968,	0.074220,	10.127466,	0},
	{-0.247800,	0.076614,	10.122678,	0},
	{-0.258574,	0.067038,	10.114298,	0},
	{-0.258574,	0.073023,	10.122678,	0},
	{-0.257377,	0.058658,	10.145423,	0},
	{-0.254982,	0.063446,	10.127466,	0},
	{-0.245406,	0.068235,	10.135846,	0},
	{-0.247800,	0.071826,	10.135846,	0},
	{-0.256179,	0.068235,	10.138240,	0},
	{-0.257377,	0.074220,	10.113101,	0},
	{-0.244208,	0.081403,	10.139438,	0},
	{-0.241814,	0.061052,	10.131058,	0},
	{-0.257377,	0.073023,	10.116693,	0},
	{-0.256179,	0.083797,	10.129861,	0},
	{-0.240617,	0.084994,	10.121481,	0},
	{-0.239420,	0.073023,	10.135846,	0},
	{-0.252588,	0.074220,	10.132255,	0},
	{-0.252588,	0.077812,	10.127466,	0},
	{-0.251391,	0.082600,	10.140635,	0},
	{-0.256179,	0.077812,	10.129861,	0},
	{-0.254982,	0.064643,	10.117889,	0},
	{-0.263362,	0.065841,	10.122678,	0},
	{-0.252588,	0.079009,	10.135846,	0},
	{-0.248997,	0.075417,	10.127466,	0},
	{-0.238223,	0.079009,	10.133451,	0},
	{-0.244208,	0.080206,	10.133451,	0},
	{-0.254982,	0.076614,	10.150211,	0},
	{-0.264559,	0.068235,	10.141831,	0},
	{-0.246603,	0.077812,	10.132255,	0},
	{-0.262165,	0.070629,	10.134649,	0},
	{-0.258574,	0.062249,	10.129861,	0},
	{-0.259771,	0.071826,	10.133451,	0},
	{-0.243011,	0.086191,	10.125072,	0},
	{-0.250194,	0.074220,	10.125072,	0},
	{-0.260968,	0.059855,	10.101130,	0},
	{-0.252588,	0.063446,	10.129861,	0},
	{-0.251391,	0.079009,	10.128663,	0},
	{-0.252588,	0.069432,	10.138240,	0},
	{-0.246603,	0.074220,	10.141831,	0},
	{-0.250194,	0.080206,	10.117889,	0},
	{-0.256179,	0.068235,	10.131058,	0},
	{-0.258574,	0.058658,	10.110707,	0},
	{-0.244208,	0.073023,	10.137043,	0},
	{-0.260968,	0.076614,	10.117889,	0},
	{-0.245406,	0.081403,	10.119086,	0},
	{-0.243011,	0.077812,	10.135846,	0},
	{-0.256179,	0.069432,	10.131058,	0},
	{-0.245406,	0.079009,	10.121481,	0},
	{-0.250194,	0.086191,	10.129861,	0},
	{-0.245406,	0.089783,	10.132255,	0},
	{-0.241814,	0.077812,	10.147817,	0},
	{-0.244208,	0.076614,	10.133451,	0},
	{-0.263362,	0.075417,	10.096342,	0},
	{-0.250194,	0.058658,	10.134649,	0},
	{-0.231040,	0.068235,	10.117889,	0},
	{-0.250194,	0.069432,	10.144226,	0},
	{-0.263362,	0.073023,	10.117889,	0},
	{-0.241814,	0.071826,	10.133451,	0},
	{-0.240617,	0.073023,	10.131058,	0},
	{-0.237026,	0.082600,	10.116693,	0},
	{-0.239420,	0.080206,	10.138240,	0},
	{-0.259771,	0.079009,	10.139438,	0},
	{-0.266953,	0.071826,	10.140635,	0},
	{-0.251391,	0.071826,	10.107116,	0},
	{-0.258574,	0.073023,	10.132255,	0},
	{-0.243011,	0.090980,	10.132255,	0},
	{-0.234632,	0.064643,	10.129861,	0},
	{-0.250194,	0.059855,	10.134649,	0},
	{-0.238223,	0.081403,	10.140635,	0},
	{-0.243011,	0.077812,	10.131058,	0},
	{-0.247800,	0.069432,	10.143028,	0},
	{-0.247800,	0.067038,	10.135846,	0},
	{-0.243011,	0.065841,	10.128663,	0},
	{-0.253785,	0.077812,	10.129861,	0},
	{-0.244208,	0.080206,	10.107116,	0},
	{-0.244208,	0.074220,	10.143028,	0},
	{-0.253785,	0.080206,	10.119086,	0},
	{-0.247800,	0.070629,	10.139438,	0},
	{-0.243011,	0.082600,	10.125072,	0},
	{-0.257377,	0.075417,	10.150211,	0},
	{-0.263362,	0.077812,	10.152605,	0},
	{-0.263362,	0.081403,	10.135846,	0},
	{-0.250194,	0.075417,	10.139438,	0},
	{-0.248997,	0.077812,	10.131058,	0},
	{-0.247800,	0.074220,	10.127466,	0},
	{-0.243011,	0.069432,	10.122678,	0},
	{-0.251391,	0.079009,	10.133451,	0},
	{-0.252588,	0.061052,	10.126269,	0},
	{-0.265756,	0.081403,	10.128663,	0},
	{-0.244208,	0.064643,	10.122678,	0},
	{-0.256179,	0.065841,	10.123875,	0},
	{-0.263362,	0.076614,	10.125072,	0},
	{-0.252588,	0.079009,	10.126269,	0},
	{-0.252588,	0.070629,	10.115496,	0},
	{-0.254982,	0.073023,	10.115496,	0},
	{-0.234632,	0.070629,	10.123875,	0},
	{-0.237026,	0.076614,	10.121481,	0},
	{-0.256179,	0.070629,	10.134649,	0},
	{-0.268150,	0.073023,	10.129861,	0},
	{-0.244208,	0.075417,	10.121481,	0},
	{-0.253785,	0.080206,	10.126269,	0},
	{-0.259771,	0.075417,	10.120284,	0},
	{-0.263362,	0.070629,	10.115496,	0},
	{-0.247800,	0.075417,	10.126269,	0},
	{-0.243011,	0.068235,	10.152605,	0},
	{-0.247800,	0.069432,	10.125072,	0},
	{-0.257377,	0.083797,	10.129861,	0},
	{-0.247800,	0.075417,	10.129861,	0},
	{-0.247800,	0.076614,	10.115496,	0},
	{-0.247800,	0.071826,	10.131058,	0},
	{-0.258574,	0.083797,	10.125072,	0},
	{-0.250194,	0.095768,	10.132255,	0},
	{-0.266953,	0.076614,	10.123875,	0},
	{-0.256179,	0.079009,	10.152605,	0},
	{-0.251391,	0.073023,	10.126269,	0},
	{-0.248997,	0.068235,	10.128663,	0},
	{-0.243011,	0.073023,	10.134649,	0},
	{-0.258574,	0.071826,	10.137043,	0},
	{-0.253785,	0.061052,	10.119086,	0},
	{-0.250194,	0.073023,	10.138240,	0},
	{-0.241814,	0.070629,	10.113101,	0},
	{-0.250194,	0.079009,	10.141831,	0},
	{-0.237026,	0.070629,	10.128663,	0},
	{-0.240617,	0.083797,	10.120284,	0},
	{-0.259771,	0.073023,	10.144226,	0},
	{-0.232237,	0.068235,	10.122678,	0},
	{-0.246603,	0.065841,	10.133451,	0},
	{-0.258574,	0.079009,	10.109509,	0},
	{-0.245406,	0.075417,	10.131058,	0},
	{-0.240617,	0.076614,	10.127466,	0},
	{-0.246603,	0.074220,	10.115496,	0},
	{-0.247800,	0.068235,	10.129861,	0},
	{-0.252588,	0.073023,	10.145423,	0},
	{-0.252588,	0.069432,	10.132255,	0},
	{-0.248997,	0.062249,	10.110707,	0},
	{-0.257377,	0.073023,	10.146620,	0},
	{-0.247800,	0.077812,	10.133451,	0},
	{-0.233435,	0.075417,	10.123875,	0},
	{-0.259771,	0.080206,	10.117889,	0},
	{-0.252588,	0.071826,	10.131058,	0},
	{-0.257377,	0.077812,	10.128663,	0},
	{-0.244208,	0.065841,	10.138240,	0},
	{-0.245406,	0.076614,	10.132255,	0},
	{-0.259771,	0.074220,	10.134649,	0},
	{-0.251391,	0.073023,	10.133451,	0},
	{-0.238223,	0.063446,	10.127466,	0},
	{-0.246603,	0.052672,	10.128663,	0},
	{-0.260968,	0.069432,	10.125072,	0},
	{-0.251391,	0.087388,	10.104721,	0},
	{-0.243011,	0.074220,	10.120284,	0},
	{-0.259771,	0.069432,	10.149014,	0},
	{-0.252588,	0.083797,	10.139438,	0},
	{-0.252588,	0.070629,	10.134649,	0},
	{-0.244208,	0.071826,	10.134649,	0},
	{-0.244208,	0.080206,	10.122678,	0},
	{-0.263362,	0.076614,	10.126269,	0},
	{-0.243011,	0.076614,	10.113101,	0},
	{-0.250194,	0.084994,	10.133451,	0},
	{-0.247800,	0.081403,	10.151408,	0},
	{-0.247800,	0.082600,	10.123875,	0},
	{-0.240617,	0.080206,	10.133451,	0},
	{-0.254982,	0.074220,	10.135846,	0},
	{-0.260968,	0.076614,	10.123875,	0},
	{-0.251391,	0.069432,	10.127466,	0},
	{-0.251391,	0.080206,	10.140635,	0},
	{-0.248997,	0.065841,	10.129861,	0},
	{-0.245406,	0.081403,	10.137043,	0},
	{-0.248997,	0.096965,	10.128663,	0},
	{-0.264559,	0.069432,	10.149014,	0},
	{-0.254982,	0.071826,	10.114298,	0},
	{-0.257377,	0.071826,	10.140635,	0},
	{-0.254982,	0.077812,	10.128663,	0},
	{-0.256179,	0.083797,	10.126269,	0},
	{-0.254982,	0.063446,	10.143028,	0},
	{-0.247800,	0.058658,	10.133451,	0},
	{-0.251391,	0.068235,	10.137043,	0},
	{-0.245406,	0.080206,	10.102327,	0},
	{-0.243011,	0.070629,	10.129861,	0},
	{-0.253785,	0.073023,	10.111904,	0},
	{-0.251391,	0.076614,	10.145423,	0},
	{-0.247800,	0.075417,	10.133451,	0},
	{-0.248997,	0.065841,	10.139438,	0},
	{-0.248997,	0.063446,	10.125072,	0},
	{-0.252588,	0.070629,	10.102327,	0},
	{-0.246603,	0.083797,	10.113101,	0},
	{-0.237026,	0.074220,	10.116693,	0},
	{-0.240617,	0.073023,	10.138240,	0},
	{-0.235829,	0.076614,	10.116693,	0},
	{-0.247800,	0.073023,	10.141831,	0},
	{-0.258574,	0.075417,	10.134649,	0},
	{-0.253785,	0.081403,	10.126269,	0},
	{-0.250194,	0.082600,	10.121481,	0},
	{-0.250194,	0.088585,	10.149014,	0},
	{-0.253785,	0.069432,	10.126269,	0},
	{-0.252588,	0.083797,	10.128663,	0},
	{-0.245406,	0.058658,	10.133451,	0},
	{-0.258574,	0.087388,	10.119086,	0},
	{-0.253785,	0.064643,	10.131058,	0},
	{-0.248997,	0.067038,	10.128663,	0},
	{-0.248997,	0.075417,	10.155000,	0},
	{-0.251391,	0.079009,	10.132255,	0},
	{-0.253785,	0.087388,	10.131058,	0},
	{-0.240617,	0.088585,	10.113101,	0},
	{-0.247800,	0.077812,	10.134649,	0},
	{-0.247800,	0.077812,	10.122678,	0},
	{-0.263362,	0.086191,	10.131058,	0},
	{-0.243011,	0.084994,	10.129861,	0},
	{-0.243011,	0.077812,	10.113101,	0},
	{-0.252588,	0.077812,	10.125072,	0},
	{-0.248997,	0.076614,	10.096342,	0},
	{-0.241814,	0.070629,	10.158591,	0},
	{-0.257377,	0.075417,	10.117889,	0},
	{-0.250194,	0.076614,	10.131058,	0},
	{-0.250194,	0.071826,	10.135846,	0},
	{-0.253785,	0.069432,	10.115496,	0},
	{-0.248997,	0.069432,	10.144226,	0},
	{-0.246603,	0.068235,	10.110707,	0},
	{-0.260968,	0.075417,	10.151408,	0},
	{-0.246603,	0.074220,	10.113101,	0},
	{-0.254982,	0.076614,	10.122678,	0},
	{-0.250194,	0.063446,	10.116693,	0},
	{-0.233435,	0.077812,	10.134649,	0},
	{-0.245406,	0.079009,	10.135846,	0},
	{-0.250194,	0.079009,	10.119086,	0},
	{-0.264559,	0.086191,	10.109509,	0},
	{-0.252588,	0.090980,	10.126269,	0},
	{-0.250194,	0.082600,	10.147817,	0},
	{-0.238223,	0.070629,	10.125072,	0},
	{-0.245406,	0.082600,	10.139438,	0},
	{-0.239420,	0.082600,	10.131058,	0},
	{-0.251391,	0.087388,	10.147817,	0},
	{-0.257377,	0.073023,	10.128663,	0},
	{-0.251391,	0.081403,	10.144226,	0},
	{-0.254982,	0.086191,	10.120284,	0},
	{-0.253785,	0.080206,	10.146620,	0},
	{-0.256179,	0.077812,	10.149014,	0},
	{-0.248997,	0.083797,	10.128663,	0},
	{-0.251391,	0.071826,	10.125072,	0},
	{-0.244208,	0.068235,	10.113101,	0},
	{-0.252588,	0.070629,	10.132255,	0},
	{-0.258574,	0.064643,	10.116693,	0},
	{-0.246603,	0.074220,	10.135846,	0},
	{-0.247800,	0.070629,	10.123875,	0},
	{-0.239420,	0.081403,	10.144226,	0},
	{-0.247800,	0.075417,	10.121481,	0},
	{-0.259771,	0.073023,	10.103524,	0},
	{-0.248997,	0.073023,	10.129861,	0},
	{-0.241814,	0.071826,	10.134649,	0},
	{-0.235829,	0.079009,	10.127466,	0},
	{-0.244208,	0.095768,	10.122678,	0},
	{-0.227449,	0.065841,	10.147817,	0},
	{-0.251391,	0.074220,	10.135846,	0},
	{-0.251391,	0.074220,	10.137043,	0},
	{-0.253785,	0.077812,	10.125072,	0},
	{-0.259771,	0.071826,	10.135846,	0},
	{-0.227449,	0.067038,	10.122678,	0},
	{-0.235829,	0.065841,	10.127466,	0},
	{-0.251391,	0.076614,	10.128663,	0},
	{-0.238223,	0.058658,	10.128663,	0},
	{-0.238223,	0.074220,	10.126269,	0},
	{-0.246603,	0.084994,	10.140635,	0},
	{-0.258574,	0.071826,	10.132255,	0},
	{-0.252588,	0.074220,	10.122678,	0},
	{-0.245406,	0.076614,	10.121481,	0},
	{-0.244208,	0.074220,	10.134649,	0},
	{-0.248997,	0.069432,	10.122678,	0},
	{-0.246603,	0.077812,	10.127466,	0},
	{-0.256179,	0.083797,	10.133451,	0},
	{-0.247800,	0.086191,	10.135846,	0},
	{-0.248997,	0.076614,	10.144226,	0},
	{-0.253785,	0.073023,	10.120284,	0},
	{-0.256179,	0.071826,	10.140635,	0},
	{-0.254982,	0.083797,	10.123875,	0},
	{-0.247800,	0.076614,	10.131058,	0},
	{-0.259771,	0.077812,	10.117889,	0},
	{-0.243011,	0.069432,	10.132255,	0},
	{-0.250194,	0.075417,	10.120284,	0},
	{-0.247800,	0.086191,	10.128663,	0},
	{-0.241814,	0.065841,	10.150211,	0},
	{-0.250194,	0.075417,	10.128663,	0},
	{-0.234632,	0.079009,	10.103524,	0},
	{-0.266953,	0.073023,	10.127466,	0},
	{-0.237026,	0.080206,	10.119086,	0},
	{-0.254982,	0.075417,	10.151408,	0},
	{-0.248997,	0.063446,	10.129861,	0},
	{-0.254982,	0.071826,	10.135846,	0},
	{-0.246603,	0.075417,	10.125072,	0},
	{-0.237026,	0.069432,	10.126269,	0},
	{-0.243011,	0.070629,	10.146620,	0},
	{-0.244208,	0.082600,	10.137043,	0},
	{-0.263362,	0.071826,	10.138240,	0},
	{-0.250194,	0.074220,	10.149014,	0},
	{-0.250194,	0.070629,	10.137043,	0},
	{-0.253785,	0.080206,	10.122678,	0},
	{-0.247800,	0.080206,	10.131058,	0},
	{-0.237026,	0.082600,	10.134649,	0},
	{-0.243011,	0.079009,	10.129861,	0},
	{-0.246603,	0.071826,	10.117889,	0},
	{-0.256179,	0.074220,	10.135846,	0},
	{-0.250194,	0.075417,	10.128663,	0},
	{-0.247800,	0.074220,	10.120284,	0},
	{-0.251391,	0.065841,	10.141831,	0},
	{-0.248997,	0.062249,	10.115496,	0},
	{-0.260968,	0.068235,	10.141831,	0},
	{-0.248997,	0.079009,	10.141831,	0},
	{-0.247800,	0.075417,	10.156197,	0},
	{-0.246603,	0.070629,	10.132255,	0},
	{-0.252588,	0.082600,	10.116693,	0},
	{-0.252588,	0.074220,	10.122678,	0},
	{-0.262165,	0.071826,	10.123875,	0},
	{-0.251391,	0.067038,	10.121481,	0},
	{-0.239420,	0.081403,	10.113101,	0},
	{-0.247800,	0.084994,	10.132255,	0},
	{-0.252588,	0.075417,	10.138240,	0},
	{-0.246603,	0.075417,	10.125072,	0},
	{-0.246603,	0.076614,	10.109509,	0},
	{-0.253785,	0.074220,	10.125072,	0},
	{-0.251391,	0.081403,	10.139438,	0},
	{-0.243011,	0.073023,	10.114298,	0},
	{-0.253785,	0.065841,	10.107116,	0},
	{-0.243011,	0.080206,	10.121481,	0},
	{-0.253785,	0.069432,	10.129861,	0},
	{-0.256179,	0.068235,	10.121481,	0},
	{-0.246603,	0.068235,	10.121481,	0},
	{-0.254982,	0.075417,	10.121481,	0},
	{-0.241814,	0.074220,	10.120284,	0},
	{-0.258574,	0.073023,	10.127466,	0},
	{-0.235829,	0.074220,	10.128663,	0},
	{-0.247800,	0.071826,	10.120284,	0},
	{-0.258574,	0.073023,	10.119086,	0},
	{-0.256179,	0.082600,	10.125072,	0},
	{-0.243011,	0.081403,	10.128663,	0},
	{-0.241814,	0.069432,	10.132255,	0},
	{-0.252588,	0.074220,	10.135846,	0},
	{-0.235829,	0.076614,	10.138240,	0},
	{-0.252588,	0.069432,	10.133451,	0},
	{-0.257377,	0.087388,	10.129861,	0},
	{-0.252588,	0.079009,	10.120284,	0},
	{-0.245406,	0.077812,	10.132255,	0},
	{-0.244208,	0.077812,	10.105919,	0},
	{-0.252588,	0.064643,	10.128663,	0},
	{-0.257377,	0.080206,	10.122678,	0},
	{-0.227449,	0.075417,	10.122678,	0},
	{-0.256179,	0.076614,	10.139438,	0},
	{-0.250194,	0.068235,	10.134649,	0},
	{-0.244208,	0.080206,	10.145423,	0},
	{-0.244208,	0.075417,	10.117889,	0},
	{-0.245406,	0.071826,	10.137043,	0},
	{-0.251391,	0.069432,	10.132255,	0},
	{-0.252588,	0.065841,	10.127466,	0},
	{-0.252588,	0.087388,	10.135846,	0},
	{-0.250194,	0.083797,	10.140635,	0},
	{-0.265756,	0.083797,	10.127466,	0},
	{-0.251391,	0.081403,	10.116693,	0},
	{-0.243011,	0.073023,	10.131058,	0},
	{-0.256179,	0.079009,	10.132255,	0},
	{-0.256179,	0.079009,	10.135846,	0},
	{-0.259771,	0.080206,	10.139438,	0},
	{-0.248997,	0.069432,	10.134649,	0},
	{-0.247800,	0.076614,	10.109509,	0},
	{-0.251391,	0.069432,	10.140635,	0},
	{-0.248997,	0.065841,	10.129861,	0},
	{-0.256179,	0.084994,	10.119086,	0},
	{-0.253785,	0.082600,	10.111904,	0},
	{-0.251391,	0.079009,	10.134649,	0},
	{-0.258574,	0.077812,	10.125072,	0},
	{-0.254982,	0.062249,	10.108313,	0},
	{-0.272939,	0.080206,	10.151408,	0},
	{-0.260968,	0.082600,	10.113101,	0},
	{-0.244208,	0.086191,	10.123875,	0},
	{-0.247800,	0.079009,	10.116693,	0},
	{-0.247800,	0.075417,	10.141831,	0},
	{-0.259771,	0.076614,	10.120284,	0},
	{-0.239420,	0.081403,	10.134649,	0},
	{-0.253785,	0.080206,	10.121481,	0},
	{-0.262165,	0.074220,	10.119086,	0},
	{-0.253785,	0.069432,	10.127466,	0},
	{-0.262165,	0.069432,	10.104721,	0},
	{-0.252588,	0.084994,	10.120284,	0},
	{-0.251391,	0.063446,	10.113101,	0},
	{-0.263362,	0.074220,	10.121481,	0},
	{-0.259771,	0.068235,	10.135846,	0},
	{-0.250194,	0.070629,	10.138240,	0},
	{-0.258574,	0.077812,	10.132255,	0},
	{-0.252588,	0.067038,	10.135846,	0},
	{-0.251391,	0.064643,	10.128663,	0},
	{-0.243011,	0.082600,	10.134649,	0},
	{-0.238223,	0.084994,	10.144226,	0},
	{-0.260968,	0.084994,	10.123875,	0},
	{-0.254982,	0.075417,	10.137043,	0},
	{-0.259771,	0.075417,	10.111904,	0},
	{-0.251391,	0.084994,	10.143028,	0},
	{-0.245406,	0.079009,	10.117889,	0},
	{-0.252588,	0.074220,	10.149014,	0},
	{-0.254982,	0.062249,	10.132255,	0},
	{-0.241814,	0.062249,	10.116693,	0},
	{-0.247800,	0.074220,	10.151408,	0},
	{-0.240617,	0.081403,	10.115496,	0},
	{-0.247800,	0.067038,	10.139438,	0},
	{-0.250194,	0.079009,	10.126269,	0},
	{-0.237026,	0.087388,	10.150211,	0},
	{-0.238223,	0.073023,	10.134649,	0},
	{-0.241814,	0.080206,	10.140635,	0},
	{-0.248997,	0.075417,	10.122678,	0},
	{-0.254982,	0.081403,	10.123875,	0},
	{-0.257377,	0.067038,	10.138240,	0},
	{-0.247800,	0.076614,	10.128663,	0},
	{-0.256179,	0.076614,	10.145423,	0},
	{-0.241814,	0.080206,	10.132255,	0},
	{-0.238223,	0.067038,	10.137043,	0},
	{-0.257377,	0.064643,	10.119086,	0},
	{-0.243011,	0.081403,	10.129861,	0},
	{-0.248997,	0.081403,	10.115496,	0},
	{-0.258574,	0.062249,	10.133451,	0},
	{-0.247800,	0.070629,	10.119086,	0},
	{-0.252588,	0.074220,	10.129861,	0},
	{-0.246603,	0.070629,	10.133451,	0},
	{-0.245406,	0.073023,	10.102327,	0},
	{-0.252588,	0.080206,	10.139438,	0},
	{-0.247800,	0.068235,	10.113101,	0},
	{-0.254982,	0.074220,	10.126269,	0},
	{-0.251391,	0.079009,	10.120284,	0},
	{-0.251391,	0.089783,	10.137043,	0},
	{-0.252588,	0.065841,	10.127466,	0},
	{-0.251391,	0.068235,	10.120284,	0},
	{-0.257377,	0.067038,	10.127466,	0},
	{-0.241814,	0.081403,	10.128663,	0},
	{-0.241814,	0.081403,	10.135846,	0},
	{-0.247800,	0.071826,	10.135846,	0},
	{-0.250194,	0.070629,	10.138240,	0},
	{-0.252588,	0.084994,	10.131058,	0},
	{-0.245406,	0.083797,	10.139438,	0},
	{-0.244208,	0.075417,	10.123875,	0},
	{-0.259771,	0.077812,	10.137043,	0},
	{-0.248997,	0.071826,	10.123875,	0},
	{-0.246603,	0.086191,	10.152605,	0},
	{-0.241814,	0.069432,	10.132255,	0},
	{-0.243011,	0.064643,	10.129861,	0},
	{-0.245406,	0.073023,	10.129861,	0},
	{-0.251391,	0.076614,	10.116693,	0},
	{-0.264559,	0.068235,	10.139438,	0},
	{-0.247800,	0.073023,	10.105919,	0},
	{-0.244208,	0.077812,	10.145423,	0},
	{-0.250194,	0.077812,	10.137043,	0},
	{-0.252588,	0.064643,	10.126269,	0},
	{-0.252588,	0.079009,	10.125072,	0},
	{-0.239420,	0.084994,	10.126269,	0},
	{-0.246603,	0.067038,	10.137043,	0},
	{-0.252588,	0.077812,	10.114298,	0},
	{-0.266953,	0.062249,	10.131058,	0},
	{-0.264559,	0.076614,	10.114298,	0},
	{-0.250194,	0.071826,	10.135846,	0},
	{-0.250194,	0.087388,	10.134649,	0},
	{-0.246603,	0.082600,	10.147817,	0},
	{-0.245406,	0.065841,	10.131058,	0},
	{-0.258574,	0.070629,	10.139438,	0},
	{-0.251391,	0.081403,	10.111904,	0},
	{-0.246603,	0.080206,	10.132255,	0},
	{-0.235829,	0.074220,	10.117889,	0},
	{-0.243011,	0.075417,	10.123875,	0},
	{-0.241814,	0.065841,	10.139438,	0},
	{-0.241814,	0.077812,	10.119086,	0},
	{-0.247800,	0.084994,	10.153803,	0},
	{-0.266953,	0.081403,	10.116693,	0},
	{-0.243011,	0.083797,	10.137043,	0},
	{-0.257377,	0.074220,	10.109509,	0},
	{-0.252588,	0.074220,	10.126269,	0},
	{-0.247800,	0.076614,	10.127466,	0},
	{-0.243011,	0.068235,	10.111904,	0},
	{-0.259771,	0.077812,	10.132255,	0},
	{-0.253785,	0.092177,	10.103524,	0},
	{-0.243011,	0.086191,	10.123875,	0},
	{-0.232237,	0.069432,	10.134649,	0},
	{-0.233435,	0.076614,	10.129861,	0},
	{-0.257377,	0.068235,	10.114298,	0},
	{-0.250194,	0.074220,	10.127466,	0},
	{-0.245406,	0.077812,	10.131058,	0},
	{-0.251391,	0.077812,	10.123875,	0},
	{-0.245406,	0.074220,	10.123875,	0},
	{-0.245406,	0.069432,	10.122678,	0},
	{-0.254982,	0.071826,	10.119086,	0},
	{-0.257377,	0.064643,	10.116693,	0},
	{-0.256179,	0.079009,	10.128663,	0},
	{-0.241814,	0.062249,	10.098736,	0},
	{-0.248997,	0.067038,	10.144226,	0},
	{-0.237026,	0.083797,	10.145423,	0},
	{-0.253785,	0.076614,	10.120284,	0},
	{-0.251391,	0.065841,	10.113101,	0},
	{-0.248997,	0.067038,	10.104721,	0},
	{-0.244208,	0.073023,	10.134649,	0},
	{-0.259771,	0.069432,	10.134649,	0},
	{-0.244208,	0.084994,	10.141831,	0},
	{-0.257377,	0.076614,	10.126269,	0},
	{-0.246603,	0.073023,	10.137043,	0},
	{-0.247800,	0.073023,	10.111904,	0},
	{-0.243011,	0.073023,	10.144226,	0},
	{-0.251391,	0.080206,	10.129861,	0},
	{-0.244208,	0.076614,	10.126269,	0},
	{-0.246603,	0.069432,	10.135846,	0},
	{-0.250194,	0.073023,	10.131058,	0},
	{-0.250194,	0.069432,	10.122678,	0},
	{-0.238223,	0.073023,	10.133451,	0},
	{-0.229843,	0.063446,	10.121481,	0},
	{-0.235829,	0.084994,	10.115496,	0},
	{-0.243011,	0.077812,	10.122678,	0},
	{-0.238223,	0.067038,	10.116693,	0},
	{-0.245406,	0.069432,	10.137043,	0},
	{-0.258574,	0.081403,	10.122678,	0},
	{-0.239420,	0.083797,	10.149014,	0},
	{-0.240617,	0.075417,	10.123875,	0},
	{-0.251391,	0.067038,	10.153803,	0},
	{-0.240617,	0.075417,	10.145423,	0},
	{-0.231040,	0.083797,	10.129861,	0},
	{-0.247800,	0.090980,	10.155000,	0},
	{-0.247800,	0.077812,	10.125072,	0},
	{-0.253785,	0.084994,	10.131058,	0},
	{-0.257377,	0.073023,	10.108313,	0},
	{-0.248997,	0.080206,	10.123875,	0},
	{-0.244208,	0.073023,	10.113101,	0},
	{-0.237026,	0.080206,	10.121481,	0},
	{-0.248997,	0.055067,	10.127466,	0},
	{-0.256179,	0.073023,	10.137043,	0},
	{-0.260968,	0.081403,	10.131058,	0},
	{-0.251391,	0.069432,	10.125072,	0},
	{-0.252588,	0.074220,	10.115496,	0},
	{-0.250194,	0.086191,	10.122678,	0},
	{-0.235829,	0.076614,	10.119086,	0},
	{-0.258574,	0.079009,	10.127466,	0},
	{-0.247800,	0.076614,	10.139438,	0},
	{-0.247800,	0.079009,	10.126269,	0},
	{-0.237026,	0.088585,	10.134649,	0},
	{-0.240617,	0.073023,	10.120284,	0},
	{-0.244208,	0.073023,	10.125072,	0},
	{-0.243011,	0.076614,	10.115496,	0},
	{-0.238223,	0.080206,	10.122678,	0},
	{-0.239420,	0.067038,	10.122678,	0},
	{-0.253785,	0.081403,	10.119086,	0},
	{-0.246603,	0.080206,	10.125072,	0},
	{-0.251391,	0.082600,	10.126269,	0},
	{-0.238223,	0.073023,	10.132255,	0},
	{-0.252588,	0.075417,	10.133451,	0},
	{-0.254982,	0.061052,	10.140635,	0},
	{-0.253785,	0.065841,	10.117889,	0},
	{-0.235829,	0.071826,	10.143028,	0},
	{-0.245406,	0.083797,	10.122678,	0},
	{-0.256179,	0.088585,	10.129861,	0},
	{-0.259771,	0.077812,	10.121481,	0},
	{-0.238223,	0.067038,	10.125072,	0},
	{-0.247800,	0.073023,	10.140635,	0},
	{-0.248997,	0.073023,	10.111904,	0},
	{-0.245406,	0.075417,	10.145423,	0},
	{-0.268150,	0.075417,	10.102327,	0},
	{-0.246603,	0.080206,	10.129861,	0},
	{-0.251391,	0.080206,	10.126269,	0},
	{-0.251391,	0.071826,	10.134649,	0},
	{-0.262165,	0.076614,	10.143028,	0},
	{-0.247800,	0.070629,	10.121481,	0},
	{-0.238223,	0.083797,	10.135846,	0},
	{-0.251391,	0.069432,	10.111904,	0},
	{-0.256179,	0.082600,	10.139438,	0},
	{-0.262165,	0.083797,	10.128663,	0},
	{-0.251391,	0.079009,	10.122678,	0},
	{-0.245406,	0.077812,	10.125072,	0},
	{-0.239420,	0.074220,	10.125072,	0},
	{-0.258574,	0.076614,	10.127466,	0},
	{-0.256179,	0.088585,	10.126269,	0},
	{-0.246603,	0.080206,	10.111904,	0},
	{-0.241814,	0.084994,	10.133451,	0},
	{-0.235829,	0.079009,	10.141831,	0},
	{-0.263362,	0.073023,	10.138240,	0},
	{-0.251391,	0.069432,	10.134649,	0},
	{-0.245406,	0.069432,	10.127466,	0},
	{-0.250194,	0.074220,	10.133451,	0},
	{-0.251391,	0.068235,	10.131058,	0},
	{-0.254982,	0.070629,	10.128663,	0},
	{-0.240617,	0.083797,	10.111904,	0},
	{-0.245406,	0.075417,	10.122678,	0},
	{-0.245406,	0.084994,	10.119086,	0},
	{-0.248997,	0.079009,	10.098736,	0},
	{-0.240617,	0.070629,	10.127466,	0},
	{-0.244208,	0.079009,	10.145423,	0},
	{-0.264559,	0.079009,	10.120284,	0},
	{-0.244208,	0.077812,	10.119086,	0},
	{-0.237026,	0.080206,	10.107116,	0},
	{-0.235829,	0.086191,	10.128663,	0},
	{-0.245406,	0.081403,	10.133451,	0},
	{-0.247800,	0.077812,	10.138240,	0},
	{-0.251391,	0.080206,	10.125072,	0},
	{-0.257377,	0.068235,	10.147817,	0},
	{-0.263362,	0.076614,	10.121481,	0},
	{-0.268150,	0.073023,	10.116693,	0},
	{-0.247800,	0.071826,	10.122678,	0},
	{-0.260968,	0.073023,	10.134649,	0},
	{-0.254982,	0.074220,	10.116693,	0},
	{-0.246603,	0.086191,	10.131058,	0},
	{-0.248997,	0.079009,	10.125072,	0},
	{-0.252588,	0.067038,	10.132255,	0},
	{-0.254982,	0.063446,	10.123875,	0},
	{-0.256179,	0.067038,	10.116693,	0},
	{-0.259771,	0.083797,	10.125072,	0},
	{-0.264559,	0.069432,	10.131058,	0},
	{-0.243011,	0.074220,	10.143028,	0},
	{-0.254982,	0.081403,	10.128663,	0},
	{-0.253785,	0.065841,	10.143028,	0},
	{-0.260968,	0.075417,	10.131058,	0},
	{-0.265756,	0.090980,	10.128663,	0},
	{-0.244208,	0.088585,	10.146620,	0},
	{-0.246603,	0.082600,	10.114298,	0},
	{-0.256179,	0.077812,	10.133451,	0},
	{-0.250194,	0.064643,	10.117889,	0},
	{-0.254982,	0.075417,	10.117889,	0},
	{-0.266953,	0.065841,	10.113101,	0},
	{-0.253785,	0.073023,	10.128663,	0},
	{-0.259771,	0.082600,	10.138240,	0},
	{-0.247800,	0.071826,	10.145423,	0},
	{-0.243011,	0.074220,	10.122678,	0},
	{-0.257377,	0.083797,	10.140635,	0},
	{-0.232237,	0.087388,	10.117889,	0},
	{-0.244208,	0.076614,	10.125072,	0},
	{-0.248997,	0.067038,	10.128663,	0},
	{-0.256179,	0.062249,	10.115496,	0},
	{-0.263362,	0.071826,	10.141831,	0},
	{-0.246603,	0.075417,	10.107116,	0},
	{-0.244208,	0.081403,	10.137043,	0},
	{-0.254982,	0.083797,	10.123875,	0},
	{-0.243011,	0.092177,	10.132255,	0},
	{-0.260968,	0.077812,	10.131058,	0},
	{-0.256179,	0.073023,	10.119086,	0},
	{-0.239420,	0.082600,	10.132255,	0},
	{-0.251391,	0.073023,	10.117889,	0},
	{-0.254982,	0.071826,	10.134649,	0},
	{-0.259771,	0.080206,	10.120284,	0},
	{-0.246603,	0.069432,	10.133451,	0},
	{-0.250194,	0.061052,	10.126269,	0},
	{-0.256179,	0.063446,	10.109509,	0},
	{-0.251391,	0.087388,	10.120284,	0},
	{-0.246603,	0.069432,	10.132255,	0},
	{-0.244208,	0.077812,	10.133451,	0},
	{-0.257377,	0.069432,	10.126269,	0},
	{-0.247800,	0.075417,	10.133451,	0},
	{-0.246603,	0.071826,	10.117889,	0},
	{-0.245406,	0.093374,	10.135846,	0},
	{-0.254982,	0.082600,	10.105919,	0},
	{-0.247800,	0.076614,	10.143028,	0},
	{-0.246603,	0.076614,	10.126269,	0},
	{-0.243011,	0.067038,	10.127466,	0},
	{-0.253785,	0.064643,	10.119086,	0},
	{-0.248997,	0.079009,	10.127466,	0},
	{-0.248997,	0.080206,	10.141831,	0},
	{-0.244208,	0.074220,	10.133451,	0},
	{-0.240617,	0.079009,	10.135846,	0},
	{-0.232237,	0.075417,	10.115496,	0},
	{-0.254982,	0.082600,	10.139438,	0},
	{-0.258574,	0.077812,	10.119086,	0},
	{-0.246603,	0.076614,	10.109509,	0},
	{-0.248997,	0.080206,	10.125072,	0},
	{-0.256179,	0.077812,	10.128663,	0},
	{-0.235829,	0.076614,	10.126269,	0},
	{-0.253785,	0.076614,	10.128663,	0},
	{-0.254982,	0.075417,	10.147817,	0},
	{-0.246603,	0.079009,	10.145423,	0},
	{-0.243011,	0.081403,	10.146620,	0},
	{-0.237026,	0.075417,	10.134649,	0},
	{-0.258574,	0.077812,	10.149014,	0},
	{-0.262165,	0.079009,	10.141831,	0},
	{-0.245406,	0.069432,	10.140635,	0},
	{-0.240617,	0.074220,	10.120284,	0},
	{-0.252588,	0.080206,	10.143028,	0},
	{-0.254982,	0.084994,	10.135846,	0},
	{-0.248997,	0.067038,	10.131058,	0},
	{-0.234632,	0.070629,	10.133451,	0},
	{-0.246603,	0.067038,	10.132255,	0},
	{-0.246603,	0.070629,	10.143028,	0},
	{-0.245406,	0.079009,	10.135846,	0},
	{-0.253785,	0.077812,	10.144226,	0},
	{-0.248997,	0.076614,	10.127466,	0},
	{-0.227449,	0.093374,	10.119086,	0},
	{-0.257377,	0.073023,	10.125072,	0},
	{-0.254982,	0.057461,	10.133451,	0},
	{-0.247800,	0.069432,	10.122678,	0},
	{-0.252588,	0.075417,	10.125072,	0},
	{-0.262165,	0.088585,	10.125072,	0},
	{-0.253785,	0.080206,	10.127466,	0},
	{-0.252588,	0.070629,	10.137043,	0},
	{-0.254982,	0.068235,	10.113101,	0},
	{-0.244208,	0.076614,	10.132255,	0},
	{-0.244208,	0.074220,	10.129861,	0},
	{-0.244208,	0.073023,	10.141831,	0},
	{-0.239420,	0.080206,	10.108313,	0},
	{-0.241814,	0.087388,	10.122678,	0},
	{-0.253785,	0.093374,	10.122678,	0},
	{-0.252588,	0.070629,	10.133451,	0},
	{-0.244208,	0.073023,	10.147817,	0},
	{-0.245406,	0.076614,	10.122678,	0},
	{-0.254982,	0.087388,	10.132255,	0},
	{-0.241814,	0.065841,	10.125072,	0},
	{-0.231040,	0.068235,	10.123875,	0},
	{-0.238223,	0.081403,	10.117889,	0},
	{-0.241814,	0.083797,	10.139438,	0},
	{-0.240617,	0.045490,	10.119086,	0},
	{-0.262165,	0.069432,	10.125072,	0},
	{-0.259771,	0.081403,	10.126269,	0},
	{-0.248997,	0.068235,	10.129861,	0},
	{-0.238223,	0.071826,	10.131058,	0},
	{-0.237026,	0.087388,	10.117889,	0},
	{-0.253785,	0.076614,	10.123875,	0},
	{-0.260968,	0.077812,	10.120284,	0},
	{-0.246603,	0.073023,	10.126269,	0},
	{-0.256179,	0.082600,	10.119086,	0},
	{-0.252588,	0.067038,	10.139438,	0},
	{-0.260968,	0.073023,	10.127466,	0},
	{-0.235829,	0.086191,	10.121481,	0},
	{-0.244208,	0.088585,	10.131058,	0},
	{-0.245406,	0.073023,	10.143028,	0},
	{-0.243011,	0.079009,	10.139438,	0},
	{-0.253785,	0.077812,	10.120284,	0},
	{-0.252588,	0.068235,	10.123875,	0},
	{-0.246603,	0.069432,	10.132255,	0},
	{-0.237026,	0.070629,	10.139438,	0},
	{-0.244208,	0.068235,	10.120284,	0},
	{-0.247800,	0.079009,	10.134649,	0},
	{-0.256179,	0.084994,	10.150211,	0},
	{-0.246603,	0.070629,	10.126269,	0},
	{-0.246603,	0.065841,	10.131058,	0},
	{-0.262165,	0.068235,	10.126269,	0},
	{-0.244208,	0.069432,	10.125072,	0},
	{-0.245406,	0.081403,	10.114298,	0},
	{-0.257377,	0.070629,	10.133451,	0},
	{-0.247800,	0.079009,	10.109509,	0},
	{-0.245406,	0.071826,	10.125072,	0},
	{-0.237026,	0.069432,	10.139438,	0},
	{-0.244208,	0.081403,	10.145423,	0},
	{-0.246603,	0.075417,	10.129861,	0},
	{-0.262165,	0.082600,	10.128663,	0},
	{-0.246603,	0.083797,	10.147817,	0},
	{-0.243011,	0.079009,	10.128663,	0},
	{-0.251391,	0.069432,	10.133451,	0},
	{-0.253785,	0.070629,	10.122678,	0},
	{-0.248997,	0.075417,	10.139438,	0},
	{-0.256179,	0.080206,	10.104721,	0},
	{-0.263362,	0.081403,	10.127466,	0},
	{-0.247800,	0.068235,	10.140635,	0},
	{-0.251391,	0.062249,	10.138240,	0},
	{-0.245406,	0.087388,	10.133451,	0},
	{-0.254982,	0.075417,	10.122678,	0},
	{-0.240617,	0.071826,	10.135846,	0},
	{-0.258574,	0.068235,	10.114298,	0},
	{-0.250194,	0.077812,	10.137043,	0},
	{-0.238223,	0.070629,	10.121481,	0},
	{-0.244208,	0.080206,	10.126269,	0},
	{-0.246603,	0.071826,	10.119086,	0},
	{-0.258574,	0.068235,	10.147817,	0},
	{-0.252588,	0.058658,	10.121481,	0},
	{-0.258574,	0.073023,	10.122678,	0},
	{-0.244208,	0.075417,	10.144226,	0},
	{-0.241814,	0.075417,	10.120284,	0},
	{-0.257377,	0.063446,	10.129861,	0},
	{-0.260968,	0.075417,	10.091554,	0},
	{-0.260968,	0.086191,	10.149014,	0},
	{-0.243011,	0.084994,	10.095144,	0},
	{-0.246603,	0.081403,	10.141831,	0},
	{-0.243011,	0.068235,	10.138240,	0},
	{-0.252588,	0.084994,	10.131058,	0},
	{-0.257377,	0.077812,	10.141831,	0},
	{-0.247800,	0.071826,	10.113101,	0},
	{-0.258574,	0.073023,	10.151408,	0},
	{-0.256179,	0.067038,	10.119086,	0},
	{-0.264559,	0.070629,	10.131058,	0},
	{-0.266953,	0.079009,	10.107116,	0},
	{-0.245406,	0.077812,	10.137043,	0},
	{-0.256179,	0.076614,	10.128663,	0},
	{-0.252588,	0.068235,	10.135846,	0},
	{-0.257377,	0.069432,	10.133451,	0},
	{-0.258574,	0.062249,	10.133451,	0},
	{-0.268150,	0.092177,	10.128663,	0},
	{-0.257377,	0.076614,	10.139438,	0},
	{-0.240617,	0.076614,	10.115496,	0},
	{-0.248997,	0.075417,	10.129861,	0},
	{-0.251391,	0.075417,	10.135846,	0},
	{-0.263362,	0.062249,	10.092751,	0},
	{-0.245406,	0.079009,	10.135846,	0},
	{-0.248997,	0.077812,	10.114298,	0},
	{-0.245406,	0.090980,	10.143028,	0},
	{-0.246603,	0.081403,	10.125072,	0},
	{-0.243011,	0.059855,	10.127466,	0},
	{-0.248997,	0.068235,	10.145423,	0},
	{-0.245406,	0.070629,	10.132255,	0},
	{-0.240617,	0.068235,	10.139438,	0},
	{-0.241814,	0.069432,	10.115496,	0},
	{-0.250194,	0.082600,	10.137043,	0},
	{-0.250194,	0.073023,	10.128663,	0},
	{-0.241814,	0.086191,	10.144226,	0},
	{-0.254982,	0.070629,	10.121481,	0},
	{-0.244208,	0.082600,	10.131058,	0},
	{-0.244208,	0.086191,	10.126269,	0},
	{-0.251391,	0.086191,	10.138240,	0},
	{-0.256179,	0.073023,	10.123875,	0},
	{-0.247800,	0.080206,	10.127466,	0},
	{-0.239420,	0.087388,	10.145423,	0},
	{-0.247800,	0.056264,	10.145423,	0},
	{-0.239420,	0.063446,	10.143028,	0},
	{-0.259771,	0.067038,	10.111904,	0},
	{-0.245406,	0.079009,	10.135846,	0},
	{-0.254982,	0.074220,	10.121481,	0},
	{-0.257377,	0.070629,	10.141831,	0},
	{-0.243011,	0.068235,	10.141831,	0},
	{-0.254982,	0.071826,	10.140635,	0},
	{-0.231040,	0.068235,	10.126269,	0},
	{-0.240617,	0.074220,	10.119086,	0},
	{-0.244208,	0.070629,	10.123875,	0},
	{-0.248997,	0.067038,	10.132255,	0},
	{-0.252588,	0.071826,	10.135846,	0},
	{-0.250194,	0.074220,	10.108313,	0},
	{-0.252588,	0.071826,	10.137043,	0},
	{-0.253785,	0.074220,	10.117889,	0},
	{-0.246603,	0.069432,	10.123875,	0},
	{-0.250194,	0.065841,	10.132255,	0},
	{-0.240617,	0.062249,	10.153803,	0},
	{-0.250194,	0.069432,	10.122678,	0},
	{-0.248997,	0.073023,	10.114298,	0},
	{-0.251391,	0.075417,	10.131058,	0},
	{-0.239420,	0.065841,	10.134649,	0},
	{-0.244208,	0.077812,	10.146620,	0},
	{-0.253785,	0.089783,	10.102327,	0},
	{-0.248997,	0.073023,	10.123875,	0},
	{-0.252588,	0.074220,	10.109509,	0},
	{-0.248997,	0.086191,	10.144226,	0},
	{-0.240617,	0.073023,	10.135846,	0},
	{-0.245406,	0.063446,	10.111904,	0},
	{-0.253785,	0.057461,	10.120284,	0},
	{-0.257377,	0.074220,	10.120284,	0},
	{-0.262165,	0.070629,	10.153803,	0},
	{-0.260968,	0.071826,	10.128663,	0},
	{-0.251391,	0.070629,	10.138240,	0},
	{-0.246603,	0.075417,	10.119086,	0},
	{-0.247800,	0.069432,	10.120284,	0},
	{-0.268150,	0.074220,	10.134649,	0},
	{-0.241814,	0.082600,	10.143028,	0},
	{-0.245406,	0.082600,	10.143028,	0},
	{-0.259771,	0.074220,	10.125072,	0},
	{-0.263362,	0.069432,	10.132255,	0},
	{-0.248997,	0.076614,	10.111904,	0},
	{-0.254982,	0.071826,	10.128663,	0},
	{-0.238223,	0.079009,	10.101130,	0},
	{-0.246603,	0.075417,	10.149014,	0},
	{-0.262165,	0.061052,	10.116693,	0},
	{-0.245406,	0.071826,	10.135846,	0},
	{-0.241814,	0.090980,	10.120284,	0},
	{-0.247800,	0.082600,	10.133451,	0},
	{-0.260968,	0.064643,	10.149014,	0},
	{-0.241814,	0.069432,	10.127466,	0},
	{-0.246603,	0.073023,	10.128663,	0},
	{-0.259771,	0.068235,	10.083174,	0},
	{-0.254982,	0.086191,	10.129861,	0},
	{-0.251391,	0.070629,	10.111904,	0},
	{-0.250194,	0.064643,	10.128663,	0},
	{-0.244208,	0.080206,	10.114298,	0},
	{-0.234632,	0.075417,	10.128663,	0},
	{-0.247800,	0.080206,	10.132255,	0},
	{-0.247800,	0.071826,	10.135846,	0},
	{-0.240617,	0.063446,	10.133451,	0},
	{-0.253785,	0.070629,	10.128663,	0},
	{-0.251391,	0.075417,	10.131058,	0},
	{-0.252588,	0.074220,	10.116693,	0},
	{-0.248997,	0.071826,	10.129861,	0},
	{-0.251391,	0.087388,	10.108313,	0},
	{-0.248997,	0.083797,	10.137043,	0},
	{-0.257377,	0.068235,	10.132255,	0},
	{-0.256179,	0.065841,	10.141831,	0},
	{-0.239420,	0.076614,	10.132255,	0},
	{-0.251391,	0.073023,	10.127466,	0},
	{-0.252588,	0.073023,	10.138240,	0},
	{-0.253785,	0.070629,	10.119086,	0},
	{-0.247800,	0.069432,	10.119086,	0},
	{-0.246603,	0.067038,	10.123875,	0},
	{-0.246603,	0.077812,	10.146620,	0},
	{-0.246603,	0.083797,	10.123875,	0},
	{-0.246603,	0.083797,	10.143028,	0},
	{-0.241814,	0.071826,	10.110707,	0},
	{-0.248997,	0.077812,	10.134649,	0},
	{-0.251391,	0.074220,	10.143028,	0},
	{-0.243011,	0.082600,	10.133451,	0},
	{-0.251391,	0.079009,	10.111904,	0},
	{-0.251391,	0.081403,	10.122678,	0},
	{-0.247800,	0.080206,	10.144226,	0},
	{-0.247800,	0.092177,	10.114298,	0},
	{-0.244208,	0.073023,	10.134649,	0},
	{-0.245406,	0.081403,	10.126269,	0},
	{-0.250194,	0.073023,	10.144226,	0},
	{-0.243011,	0.079009,	10.133451,	0},
	{-0.260968,	0.077812,	10.122678,	0},
	{-0.252588,	0.090980,	10.122678,	0},
	{-0.268150,	0.073023,	10.128663,	0},
	{-0.256179,	0.075417,	10.123875,	0},
	{-0.248997,	0.063446,	10.104721,	0},
	{-0.245406,	0.090980,	10.128663,	0},
	{-0.253785,	0.087388,	10.115496,	0},
	{-0.239420,	0.073023,	10.138240,	0},
	{-0.238223,	0.059855,	10.119086,	0},
	{-0.248997,	0.070629,	10.125072,	0},
	{-0.250194,	0.081403,	10.131058,	0},
	{-0.248997,	0.093374,	10.132255,	0},
	{-0.253785,	0.092177,	10.128663,	0},
	{-0.251391,	0.071826,	10.134649,	0},
	{-0.233435,	0.074220,	10.129861,	0},
	{-0.241814,	0.079009,	10.103524,	0},
	{-0.253785,	0.070629,	10.153803,	0},
	{-0.260968,	0.069432,	10.144226,	0},
	{-0.250194,	0.065841,	10.123875,	0},
	{-0.262165,	0.092177,	10.125072,	0},
	{-0.252588,	0.088585,	10.151408,	0},
	{-0.253785,	0.087388,	10.132255,	0},
	{-0.244208,	0.062249,	10.137043,	0},
	{-0.256179,	0.065841,	10.110707,	0},
	{-0.244208,	0.075417,	10.117889,	0},
	{-0.240617,	0.082600,	10.132255,	0},
	{-0.248997,	0.074220,	10.115496,	0},
	{-0.250194,	0.079009,	10.141831,	0},
	{-0.246603,	0.077812,	10.119086,	0},
	{-0.252588,	0.074220,	10.117889,	0},
	{-0.257377,	0.075417,	10.120284,	0},
	{-0.250194,	0.077812,	10.117889,	0},
	{-0.239420,	0.081403,	10.143028,	0},
	{-0.237026,	0.076614,	10.137043,	0},
	{-0.240617,	0.077812,	10.149014,	0},
	{-0.270545,	0.071826,	10.131058,	0},
	{-0.262165,	0.068235,	10.122678,	0},
	{-0.259771,	0.067038,	10.114298,	0},
	{-0.246603,	0.082600,	10.121481,	0},
	{-0.254982,	0.076614,	10.127466,	0},
	{-0.244208,	0.063446,	10.122678,	0},
	{-0.246603,	0.074220,	10.121481,	0},
	{-0.253785,	0.086191,	10.127466,	0},
	{-0.253785,	0.079009,	10.131058,	0},
	{-0.245406,	0.071826,	10.132255,	0},
	{-0.248997,	0.074220,	10.132255,	0},
	{-0.260968,	0.055067,	10.121481,	0},
	{-0.243011,	0.070629,	10.122678,	0},
	{-0.252588,	0.070629,	10.132255,	0},
	{-0.243011,	0.077812,	10.143028,	0},
	{-0.246603,	0.077812,	10.132255,	0},
	{-0.253785,	0.082600,	10.131058,	0},
	{-0.256179,	0.068235,	10.137043,	0},
	{-0.243011,	0.088585,	10.121481,	0},
	{-0.239420,	0.065841,	10.133451,	0},
	{-0.252588,	0.063446,	10.122678,	0},
	{-0.252588,	0.082600,	10.141831,	0},
	{-0.238223,	0.083797,	10.122678,	0},
	{-0.251391,	0.076614,	10.140635,	0},
	{-0.265756,	0.081403,	10.135846,	0},
	{-0.252588,	0.076614,	10.141831,	0},
	{-0.246603,	0.079009,	10.131058,	0},
	{-0.250194,	0.077812,	10.126269,	0},
	{-0.240617,	0.079009,	10.146620,	0},
	{-0.247800,	0.089783,	10.132255,	0},
	{-0.259771,	0.089783,	10.111904,	0},
	{-0.266953,	0.084994,	10.141831,	0},
	{-0.244208,	0.087388,	10.147817,	0},
	{-0.235829,	0.067038,	10.127466,	0},
	{-0.245406,	0.069432,	10.129861,	0},
	{-0.250194,	0.083797,	10.108313,	0},
	{-0.240617,	0.084994,	10.146620,	0},
	{-0.256179,	0.077812,	10.121481,	0},
	{-0.250194,	0.076614,	10.151408,	0},
	{-0.248997,	0.073023,	10.128663,	0},
	{-0.252588,	0.068235,	10.140635,	0},
	{-0.252588,	0.074220,	10.147817,	0},
	{-0.253785,	0.083797,	10.139438,	0},
	{-0.243011,	0.069432,	10.114298,	0},
	{-0.235829,	0.059855,	10.122678,	0},
	{-0.253785,	0.076614,	10.145423,	0},
	{-0.245406,	0.077812,	10.115496,	0},
	{-0.252588,	0.065841,	10.139438,	0},
	{-0.248997,	0.092177,	10.132255,	0},
	{-0.256179,	0.088585,	10.150211,	0},
	{-0.250194,	0.082600,	10.134649,	0},
	{-0.244208,	0.069432,	10.137043,	0},
	{-0.254982,	0.076614,	10.127466,	0},
	{-0.253785,	0.063446,	10.135846,	0},
	{-0.258574,	0.080206,	10.145423,	0},
	{-0.232237,	0.074220,	10.126269,	0},
	{-0.241814,	0.080206,	10.131058,	0},
	{-0.240617,	0.075417,	10.116693,	0},
	{-0.253785,	0.068235,	10.132255,	0},
	{-0.241814,	0.083797,	10.139438,	0},
	{-0.245406,	0.084994,	10.129861,	0},
	{-0.245406,	0.079009,	10.165773,	0},
	{-0.238223,	0.079009,	10.101130,	0},
	{-0.247800,	0.081403,	10.138240,	0},
	{-0.244208,	0.070629,	10.126269,	0},
	{-0.253785,	0.082600,	10.149014,	0},
	{-0.235829,	0.079009,	10.115496,	0},
	{-0.239420,	0.070629,	10.114298,	0},
	{-0.251391,	0.086191,	10.128663,	0},
	{-0.241814,	0.075417,	10.119086,	0},
	{-0.241814,	0.074220,	10.165773,	0},
	{-0.233435,	0.075417,	10.101130,	0},
	{-0.254982,	0.087388,	10.135846,	0},
	{-0.232237,	0.074220,	10.129861,	0},
	{-0.233435,	0.076614,	10.123875,	0},
	{-0.258574,	0.093374,	10.137043,	0},
	{-0.243011,	0.074220,	10.137043,	0},
	{-0.244208,	0.083797,	10.145423,	0},
	{-0.252588,	0.087388,	10.137043,	0},
	{-0.251391,	0.077812,	10.120284,	0},
	{-0.235829,	0.067038,	10.117889,	0},
	{-0.240617,	0.075417,	10.125072,	0},
	{-0.253785,	0.086191,	10.127466,	0},
	{-0.256179,	0.080206,	10.126269,	0},
	{-0.254982,	0.071826,	10.132255,	0},
	{-0.235829,	0.074220,	10.128663,	0},
	{-0.252588,	0.079009,	10.117889,	0},
	{-0.245406,	0.081403,	10.123875,	0},
	{-0.246603,	0.073023,	10.127466,	0},
	{-0.252588,	0.063446,	10.159788,	0},
	{-0.247800,	0.079009,	10.147817,	0},
	{-0.258574,	0.079009,	10.131058,	0},
	{-0.269348,	0.075417,	10.134649,	0},
	{-0.248997,	0.083797,	10.107116,	0},
	{-0.244208,	0.081403,	10.139438,	0},
	{-0.259771,	0.070629,	10.133451,	0},
	{-0.257377,	0.063446,	10.128663,	0},
	{-0.254982,	0.071826,	10.121481,	0},
	{-0.252588,	0.088585,	10.137043,	0},
	{-0.251391,	0.083797,	10.135846,	0},
	{-0.253785,	0.086191,	10.134649,	0},
	{-0.252588,	0.073023,	10.115496,	0},
	{-0.254982,	0.075417,	10.145423,	0},
	{-0.250194,	0.076614,	10.137043,	0},
	{-0.248997,	0.070629,	10.135846,	0},
	{-0.259771,	0.073023,	10.137043,	0},
	{-0.245406,	0.088585,	10.120284,	0},
	{-0.254982,	0.074220,	10.151408,	0},
	{-0.252588,	0.074220,	10.103524,	0},
	{-0.258574,	0.070629,	10.146620,	0},
	{-0.251391,	0.080206,	10.121481,	0},
	{-0.241814,	0.070629,	10.131058,	0},
	{-0.246603,	0.071826,	10.116693,	0},
	{-0.248997,	0.067038,	10.135846,	0},
	{-0.251391,	0.070629,	10.132255,	0},
	{-0.250194,	0.081403,	10.132255,	0},
	{-0.254982,	0.074220,	10.134649,	0},
	{-0.243011,	0.081403,	10.131058,	0},
	{-0.237026,	0.089783,	10.128663,	0},
	{-0.243011,	0.077812,	10.125072,	0},
	{-0.244208,	0.074220,	10.131058,	0},
	{-0.243011,	0.086191,	10.121481,	0},
	{-0.250194,	0.079009,	10.135846,	0},
	{-0.247800,	0.061052,	10.132255,	0},
	{-0.258574,	0.063446,	10.122678,	0},
	{-0.245406,	0.076614,	10.114298,	0},
	{-0.238223,	0.082600,	10.101130,	0},
	{-0.264559,	0.057461,	10.119086,	0},
	{-0.248997,	0.077812,	10.126269,	0},
	{-0.237026,	0.094571,	10.127466,	0},
	{-0.256179,	0.071826,	10.116693,	0},
	{-0.248997,	0.080206,	10.135846,	0},
	{-0.259771,	0.067038,	10.128663,	0},
	{-0.246603,	0.074220,	10.134649,	0},
	{-0.244208,	0.083797,	10.131058,	0},
	{-0.233435,	0.075417,	10.129861,	0},
	{-0.241814,	0.074220,	10.128663,	0},
	{-0.238223,	0.080206,	10.105919,	0},
	{-0.241814,	0.084994,	10.131058,	0},
	{-0.254982,	0.076614,	10.129861,	0},
	{-0.258574,	0.079009,	10.117889,	0},
	{-0.251391,	0.069432,	10.135846,	0},
	{-0.243011,	0.082600,	10.135846,	0},
	{-0.243011,	0.073023,	10.121481,	0},
	{-0.250194,	0.074220,	10.140635,	0},
	{-0.251391,	0.069432,	10.119086,	0},
	{-0.258574,	0.074220,	10.117889,	0},
	{-0.260968,	0.069432,	10.138240,	0},
	{-0.260968,	0.080206,	10.133451,	0},
	{-0.238223,	0.080206,	10.140635,	0},
	{-0.248997,	0.075417,	10.103524,	0},
	{-0.259771,	0.069432,	10.144226,	0},
	{-0.252588,	0.076614,	10.095144,	0},
	{-0.254982,	0.068235,	10.146620,	0},
	{-0.256179,	0.079009,	10.143028,	0},
	{-0.246603,	0.090980,	10.139438,	0},
	{-0.251391,	0.079009,	10.131058,	0},
	{-0.253785,	0.077812,	10.119086,	0},
	{-0.256179,	0.076614,	10.157393,	0},
	{-0.246603,	0.067038,	10.121481,	0},
	{-0.237026,	0.081403,	10.159788,	0},
	{-0.250194,	0.082600,	10.125072,	0},
	{-0.248997,	0.077812,	10.117889,	0},
	{-0.237026,	0.074220,	10.121481,	0},
	{-0.237026,	0.062249,	10.138240,	0},
	{-0.247800,	0.070629,	10.126269,	0},
	{-0.245406,	0.073023,	10.138240,	0},
	{-0.245406,	0.065841,	10.134649,	0},
	{-0.240617,	0.083797,	10.137043,	0},
	{-0.244208,	0.063446,	10.137043,	0},
	{-0.260968,	0.080206,	10.123875,	0},
	{-0.245406,	0.083797,	10.137043,	0},
	{-0.237026,	0.068235,	10.122678,	0},
	{-0.250194,	0.070629,	10.137043,	0},
	{-0.248997,	0.073023,	10.128663,	0},
	{-0.239420,	0.073023,	10.127466,	0},
	{-0.256179,	0.069432,	10.123875,	0},
	{-0.244208,	0.064643,	10.141831,	0},
	{-0.246603,	0.062249,	10.114298,	0},
	{-0.260968,	0.076614,	10.108313,	0},
	{-0.257377,	0.069432,	10.135846,	0},
	{-0.265756,	0.074220,	10.123875,	0},
	{-0.254982,	0.065841,	10.145423,	0},
	{-0.248997,	0.070629,	10.123875,	0},
	{-0.241814,	0.079009,	10.137043,	0},
	{-0.251391,	0.095768,	10.141831,	0},
	{-0.244208,	0.071826,	10.111904,	0},
	{-0.243011,	0.075417,	10.132255,	0},
	{-0.246603,	0.090980,	10.131058,	0},
	{-0.252588,	0.071826,	10.135846,	0},
	{-0.248997,	0.065841,	10.120284,	0},
	{-0.248997,	0.082600,	10.116693,	0},
	{-0.263362,	0.075417,	10.138240,	0},
	{-0.247800,	0.061052,	10.129861,	0},
	{-0.250194,	0.059855,	10.132255,	0},
	{-0.251391,	0.069432,	10.152605,	0},
	{-0.247800,	0.068235,	10.129861,	0},
	{-0.240617,	0.062249,	10.138240,	0},
	{-0.264559,	0.070629,	10.120284,	0},
	{-0.253785,	0.071826,	10.151408,	0},
	{-0.246603,	0.074220,	10.125072,	0},
	{-0.256179,	0.070629,	10.160985,	0},
	{-0.247800,	0.061052,	10.131058,	0},
	{-0.246603,	0.070629,	10.125072,	0},
	{-0.258574,	0.086191,	10.135846,	0},
	{-0.253785,	0.077812,	10.120284,	0},
	{-0.235829,	0.074220,	10.133451,	0},
	{-0.239420,	0.083797,	10.122678,	0},
	{-0.258574,	0.071826,	10.139438,	0},
	{-0.259771,	0.084994,	10.110707,	0},
	{-0.243011,	0.077812,	10.131058,	0},
	{-0.240617,	0.077812,	10.134649,	0},
	{-0.244208,	0.059855,	10.128663,	0},
	{-0.239420,	0.068235,	10.122678,	0},
	{-0.258574,	0.076614,	10.119086,	0},
	{-0.258574,	0.075417,	10.147817,	0},
	{-0.248997,	0.062249,	10.117889,	0},
	{-0.248997,	0.076614,	10.135846,	0},
	{-0.241814,	0.076614,	10.109509,	0},
	{-0.257377,	0.068235,	10.144226,	0},
	{-0.264559,	0.064643,	10.096342,	0},
	{-0.241814,	0.068235,	10.139438,	0},
	{-0.250194,	0.088585,	10.114298,	0},
	{-0.259771,	0.079009,	10.159788,	0},
	{-0.247800,	0.071826,	10.138240,	0},
	{-0.245406,	0.073023,	10.117889,	0},
	{-0.246603,	0.070629,	10.137043,	0},
	{-0.248997,	0.069432,	10.108313,	0},
	{-0.254982,	0.077812,	10.144226,	0},
	{-0.254982,	0.088585,	10.108313,	0},
	{-0.245406,	0.082600,	10.135846,	0},
	{-0.245406,	0.095768,	10.125072,	0},
	{-0.232237,	0.083797,	10.133451,	0},
	{-0.243011,	0.069432,	10.089159,	0},
	{-0.237026,	0.082600,	10.152605,	0},
	{-0.241814,	0.065841,	10.116693,	0},
	{-0.262165,	0.067038,	10.138240,	0},
	{-0.262165,	0.081403,	10.150211,	0},
	{-0.257377,	0.079009,	10.109509,	0},
	{-0.257377,	0.084994,	10.131058,	0},
	{-0.238223,	0.090980,	10.107116,	0},
	{-0.231040,	0.093374,	10.151408,	0},
	{-0.250194,	0.069432,	10.108313,	0},
	{-0.244208,	0.067038,	10.166970,	0},
	{-0.244208,	0.074220,	10.105919,	0},
	{-0.247800,	0.076614,	10.145423,	0},
	{-0.237026,	0.071826,	10.122678,	0},
	{-0.244208,	0.070629,	10.127466,	0},
	{-0.243011,	0.074220,	10.119086,	0},
	{-0.246603,	0.073023,	10.121481,	0},
	{-0.245406,	0.084994,	10.129861,	0},
	{-0.237026,	0.082600,	10.128663,	0},
	{-0.229843,	0.074220,	10.127466,	0},
	{-0.250194,	0.076614,	10.116693,	0},
	{-0.240617,	0.074220,	10.138240,	0},
	{-0.240617,	0.074220,	10.117889,	0},
	{-0.245406,	0.075417,	10.126269,	0},
	{-0.241814,	0.077812,	10.129861,	0},
	{-0.251391,	0.081403,	10.139438,	0},
	{-0.227449,	0.075417,	10.127466,	0},
	{-0.239420,	0.079009,	10.119086,	0},
	{-0.238223,	0.087388,	10.120284,	0},
	{-0.243011,	0.057461,	10.122678,	0},
	{-0.250194,	0.056264,	10.145423,	0},
	{-0.233435,	0.075417,	10.119086,	0},
	{-0.237026,	0.061052,	10.137043,	0},
	{-0.240617,	0.084994,	10.123875,	0},
	{-0.245406,	0.088585,	10.151408,	0},
	{-0.234632,	0.081403,	10.128663,	0},
	{-0.240617,	0.086191,	10.123875,	0},
	{-0.237026,	0.080206,	10.119086,	0},
	{-0.234632,	0.067038,	10.134649,	0},
	{-0.241814,	0.070629,	10.138240,	0},
	{-0.248997,	0.065841,	10.134649,	0},
	{-0.238223,	0.081403,	10.143028,	0},
	{-0.243011,	0.079009,	10.121481,	0},
	{-0.240617,	0.079009,	10.128663,	0},
	{-0.251391,	0.069432,	10.131058,	0},
	{-0.244208,	0.063446,	10.138240,	0},
	{-0.240617,	0.058658,	10.117889,	0},
	{-0.239420,	0.081403,	10.145423,	0},
	{-0.245406,	0.080206,	10.114298,	0},
	{-0.240617,	0.075417,	10.127466,	0},
	{-0.243011,	0.077812,	10.127466,	0},
	{-0.250194,	0.065841,	10.119086,	0},
	{-0.232237,	0.064643,	10.120284,	0},
	{-0.239420,	0.065841,	10.131058,	0},
	{-0.251391,	0.071826,	10.143028,	0},
	{-0.246603,	0.080206,	10.125072,	0},
	{-0.238223,	0.075417,	10.123875,	0},
	{-0.245406,	0.081403,	10.132255,	0},
	{-0.241814,	0.083797,	10.117889,	0},
	{-0.251391,	0.070629,	10.135846,	0},
	{-0.262165,	0.075417,	10.120284,	0},
	{-0.251391,	0.086191,	10.145423,	0},
	{-0.239420,	0.087388,	10.131058,	0},
	{-0.246603,	0.077812,	10.126269,	0},
	{-0.246603,	0.073023,	10.135846,	0},
	{-0.264559,	0.079009,	10.120284,	0},
	{-0.264559,	0.074220,	10.125072,	0},
	{-0.229843,	0.067038,	10.127466,	0},
	{-0.231040,	0.077812,	10.131058,	0},
	{-0.245406,	0.075417,	10.128663,	0},
	{-0.240617,	0.071826,	10.116693,	0},
	{-0.234632,	0.081403,	10.128663,	0},
	{-0.228646,	0.063446,	10.132255,	0},
	{-0.227449,	0.057461,	10.139438,	0},
	{-0.251391,	0.075417,	10.120284,	0},
	{-0.231040,	0.092177,	10.122678,	0},
	{-0.240617,	0.077812,	10.137043,	0},
	{-0.252588,	0.075417,	10.132255,	0},
	{-0.248997,	0.077812,	10.120284,	0},
	{-0.248997,	0.080206,	10.117889,	0},
	{-0.252588,	0.063446,	10.113101,	0},
	{-0.247800,	0.069432,	10.133451,	0},
	{-0.246603,	0.092177,	10.108313,	0},
	{-0.240617,	0.088585,	10.134649,	0},
	{-0.239420,	0.076614,	10.125072,	0},
	{-0.248997,	0.070629,	10.128663,	0},
	{-0.243011,	0.073023,	10.128663,	0},
	{-0.243011,	0.084994,	10.115496,	0},
	{-0.243011,	0.087388,	10.141831,	0},
	{-0.237026,	0.070629,	10.144226,	0},
	{-0.247800,	0.081403,	10.113101,	0},
	{-0.234632,	0.096965,	10.133451,	0},
	{-0.258574,	0.069432,	10.132255,	0},
	{-0.258574,	0.077812,	10.116693,	0},
	{-0.243011,	0.079009,	10.135846,	0},
	{-0.253785,	0.082600,	10.102327,	0},
	{-0.240617,	0.075417,	10.144226,	0},
	{-0.247800,	0.074220,	10.123875,	0},
	{-0.256179,	0.079009,	10.120284,	0},
	{-0.254982,	0.077812,	10.141831,	0},
	{-0.257377,	0.076614,	10.143028,	0},
	{-0.250194,	0.086191,	10.137043,	0},
	{-0.238223,	0.081403,	10.116693,	0},
	{-0.238223,	0.084994,	10.139438,	0},
	{-0.247800,	0.080206,	10.126269,	0},
	{-0.263362,	0.074220,	10.131058,	0},
	{-0.260968,	0.077812,	10.123875,	0},
	{-0.238223,	0.059855,	10.128663,	0},
	{-0.245406,	0.062249,	10.134649,	0},
	{-0.257377,	0.080206,	10.131058,	0},
	{-0.244208,	0.083797,	10.131058,	0},
	{-0.232237,	0.080206,	10.134649,	0},
	{-0.244208,	0.076614,	10.119086,	0},
	{-0.241814,	0.073023,	10.141831,	0},
	{-0.257377,	0.067038,	10.138240,	0},
	{-0.241814,	0.086191,	10.133451,	0},
	{-0.246603,	0.079009,	10.133451,	0},
	{-0.248997,	0.067038,	10.125072,	0},
	{-0.239420,	0.082600,	10.122678,	0},
	{-0.244208,	0.084994,	10.129861,	0},
	{-0.233435,	0.073023,	10.147817,	0},
	{-0.250194,	0.069432,	10.133451,	0},
	{-0.254982,	0.070629,	10.146620,	0},
	{-0.231040,	0.083797,	10.117889,	0},
	{-0.245406,	0.081403,	10.119086,	0},
	{-0.256179,	0.093374,	10.131058,	0},
	{-0.241814,	0.084994,	10.138240,	0},
	{-0.252588,	0.073023,	10.137043,	0},
	{-0.251391,	0.081403,	10.126269,	0},
	{-0.235829,	0.069432,	10.137043,	0},
	{-0.247800,	0.080206,	10.132255,	0},
	{-0.238223,	0.064643,	10.144226,	0},
	{-0.234632,	0.076614,	10.127466,	0},
	{-0.245406,	0.069432,	10.137043,	0},
	{-0.241814,	0.082600,	10.116693,	0},
	{-0.233435,	0.101754,	10.132255,	0},
	{-0.240617,	0.086191,	10.132255,	0},
	{-0.235829,	0.081403,	10.120284,	0},
	{-0.239420,	0.076614,	10.128663,	0},
	{-0.251391,	0.079009,	10.117889,	0},
	{-0.256179,	0.081403,	10.149014,	0},
	{-0.238223,	0.079009,	10.105919,	0},
	{-0.234632,	0.079009,	10.125072,	0},
	{-0.254982,	0.071826,	10.115496,	0},
	{-0.263362,	0.082600,	10.151408,	0},
	{-0.243011,	0.075417,	10.109509,	0},
	{-0.222661,	0.073023,	10.129861,	0},
	{-0.246603,	0.074220,	10.133451,	0},
	{-0.248997,	0.086191,	10.129861,	0},
	{-0.252588,	0.086191,	10.149014,	0},
	{-0.238223,	0.071826,	10.104721,	0},
	{-0.237026,	0.071826,	10.135846,	0},
	{-0.243011,	0.086191,	10.111904,	0},
	{-0.244208,	0.093374,	10.141831,	0},
	{-0.253785,	0.063446,	10.123875,	0},
	{-0.244208,	0.083797,	10.134649,	0},
	{-0.244208,	0.090980,	10.128663,	0},
	{-0.258574,	0.065841,	10.134649,	0},
	{-0.256179,	0.070629,	10.128663,	0},
	{-0.243011,	0.071826,	10.137043,	0},
	{-0.225055,	0.074220,	10.134649,	0},
	{-0.245406,	0.069432,	10.116693,	0},
	{-0.237026,	0.077812,	10.133451,	0},
	{-0.245406,	0.073023,	10.104721,	0},
	{-0.253785,	0.081403,	10.159788,	0},
	{-0.245406,	0.086191,	10.113101,	0},
	{-0.243011,	0.081403,	10.126269,	0},
	{-0.241814,	0.065841,	10.108313,	0},
	{-0.240617,	0.057461,	10.131058,	0},
	{-0.241814,	0.065841,	10.144226,	0},
	{-0.237026,	0.073023,	10.128663,	0},
	{-0.250194,	0.090980,	10.145423,	0},
	{-0.254982,	0.070629,	10.119086,	0},
	{-0.244208,	0.063446,	10.131058,	0},
	{-0.235829,	0.077812,	10.121481,	0},
	{-0.248997,	0.076614,	10.137043,	0},
	{-0.262165,	0.076614,	10.123875,	0},
	{-0.250194,	0.064643,	10.119086,	0},
	{-0.239420,	0.077812,	10.116693,	0},
	{-0.245406,	0.080206,	10.128663,	0},
	{-0.243011,	0.084994,	10.123875,	0},
	{-0.244208,	0.077812,	10.125072,	0},
	{-0.237026,	0.089783,	10.122678,	0},
	{-0.235829,	0.065841,	10.137043,	0},
	{-0.245406,	0.065841,	10.150211,	0},
	{-0.252588,	0.074220,	10.111904,	0},
	{-0.241814,	0.068235,	10.146620,	0},
	{-0.229843,	0.069432,	10.120284,	0},
	{-0.240617,	0.079009,	10.131058,	0},
	{-0.240617,	0.084994,	10.095144,	0},
	{-0.239420,	0.067038,	10.133451,	0},
	{-0.247800,	0.083797,	10.128663,	0},
	{-0.252588,	0.075417,	10.135846,	0},
	{-0.252588,	0.068235,	10.131058,	0},
	{-0.243011,	0.087388,	10.102327,	0},
	{-0.247800,	0.088585,	10.132255,	0},
	{-0.243011,	0.086191,	10.127466,	0},
	{-0.229843,	0.080206,	10.123875,	0},
	{-0.245406,	0.073023,	10.134649,	0},
	{-0.233435,	0.081403,	10.132255,	0},
	{-0.245406,	0.082600,	10.126269,	0},
	{-0.233435,	0.073023,	10.137043,	0},
	{-0.235829,	0.070629,	10.140635,	0},
	{-0.241814,	0.076614,	10.121481,	0},
	{-0.244208,	0.069432,	10.123875,	0},
	{-0.252588,	0.075417,	10.140635,	0},
	{-0.253785,	0.080206,	10.133451,	0},
	{-0.237026,	0.075417,	10.121481,	0},
	{-0.227449,	0.065841,	10.129861,	0},
	{-0.245406,	0.077812,	10.131058,	0},
	{-0.229843,	0.094571,	10.129861,	0},
	{-0.237026,	0.068235,	10.105919,	0},
	{-0.260968,	0.073023,	10.120284,	0},
	{-0.241814,	0.076614,	10.131058,	0},
	{-0.250194,	0.077812,	10.126269,	0},
	{-0.254982,	0.068235,	10.135846,	0},
	{-0.240617,	0.071826,	10.108313,	0},
	{-0.258574,	0.083797,	10.125072,	0},
	{-0.254982,	0.081403,	10.132255,	0},
	{-0.251391,	0.079009,	10.135846,	0},
	{-0.245406,	0.069432,	10.121481,	0},
	{-0.232237,	0.069432,	10.122678,	0},
	{-0.234632,	0.083797,	10.131058,	0},
	{-0.234632,	0.089783,	10.129861,	0},
	{-0.238223,	0.079009,	10.127466,	0},
	{-0.246603,	0.083797,	10.121481,	0},
	{-0.247800,	0.074220,	10.121481,	0},
	{-0.247800,	0.075417,	10.117889,	0},
	{-0.235829,	0.065841,	10.129861,	0},
	{-0.241814,	0.075417,	10.111904,	0},
	{-0.239420,	0.081403,	10.129861,	0},
	{-0.247800,	0.087388,	10.128663,	0},
	{-0.243011,	0.079009,	10.126269,	0},
	{-0.245406,	0.067038,	10.137043,	0},
	{-0.257377,	0.059855,	10.122678,	0},
	{-0.250194,	0.068235,	10.147817,	0},
	{-0.243011,	0.074220,	10.129861,	0},
	{-0.237026,	0.086191,	10.129861,	0},
	{-0.246603,	0.107739,	10.131058,	0},
	{-0.241814,	0.082600,	10.141831,	0},
	{-0.245406,	0.064643,	10.119086,	0},
	{-0.258574,	0.075417,	10.129861,	0},
	{-0.237026,	0.071826,	10.123875,	0},
	{-0.243011,	0.075417,	10.101130,	0},
	{-0.253785,	0.083797,	10.125072,	0},
	{-0.241814,	0.081403,	10.119086,	0},
	{-0.234632,	0.089783,	10.137043,	0},
	{-0.245406,	0.070629,	10.132255,	0},
	{-0.251391,	0.067038,	10.131058,	0},
	{-0.250194,	0.069432,	10.139438,	0},
	{-0.237026,	0.086191,	10.123875,	0},
	{-0.235829,	0.086191,	10.147817,	0},
	{-0.248997,	0.074220,	10.123875,	0},
	{-0.251391,	0.079009,	10.114298,	0},
	{-0.246603,	0.081403,	10.122678,	0},
	{-0.235829,	0.079009,	10.119086,	0},
	{-0.240617,	0.087388,	10.127466,	0},
	{-0.239420,	0.077812,	10.133451,	0},
	{-0.247800,	0.087388,	10.108313,	0},
	{-0.245406,	0.087388,	10.111904,	0},
	{-0.237026,	0.073023,	10.147817,	0},
	{-0.241814,	0.079009,	10.135846,	0},
	{-0.241814,	0.074220,	10.121481,	0},
	{-0.258574,	0.063446,	10.146620,	0},
	{-0.243011,	0.079009,	10.123875,	0},
	{-0.225055,	0.073023,	10.122678,	0},
	{-0.234632,	0.075417,	10.119086,	0},
	{-0.246603,	0.068235,	10.134649,	0},
	{-0.235829,	0.071826,	10.141831,	0},
	{-0.234632,	0.069432,	10.137043,	0},
	{-0.244208,	0.064643,	10.126269,	0},
	{-0.239420,	0.068235,	10.125072,	0},
	{-0.246603,	0.087388,	10.131058,	0},
	{-0.241814,	0.071826,	10.128663,	0},
	{-0.241814,	0.083797,	10.140635,	0},
	{-0.252588,	0.070629,	10.119086,	0},
	{-0.243011,	0.070629,	10.117889,	0},
	{-0.265756,	0.077812,	10.125072,	0},
	{-0.248997,	0.083797,	10.129861,	0},
	{-0.248997,	0.082600,	10.122678,	0},
	{-0.247800,	0.083797,	10.133451,	0},
	{-0.260968,	0.086191,	10.141831,	0},
	{-0.244208,	0.075417,	10.132255,	0},
	{-0.232237,	0.080206,	10.135846,	0},
	{-0.244208,	0.077812,	10.131058,	0},
	{-0.239420,	0.077812,	10.143028,	0},
	{-0.238223,	0.077812,	10.127466,	0},
	{-0.235829,	0.089783,	10.140635,	0},
	{-0.239420,	0.070629,	10.111904,	0},
	{-0.253785,	0.064643,	10.129861,	0},
	{-0.250194,	0.065841,	10.127466,	0},
	{-0.251391,	0.073023,	10.110707,	0},
	{-0.240617,	0.069432,	10.098736,	0},
	{-0.246603,	0.074220,	10.122678,	0},
	{-0.243011,	0.077812,	10.141831,	0},
	{-0.243011,	0.074220,	10.131058,	0},
	{-0.247800,	0.081403,	10.125072,	0},
	{-0.256179,	0.057461,	10.134649,	0},
	{-0.243011,	0.068235,	10.144226,	0},
	{-0.228646,	0.095768,	10.125072,	0},
	{-0.250194,	0.083797,	10.135846,	0},
	{-0.246603,	0.062249,	10.122678,	0},
	{-0.245406,	0.073023,	10.119086,	0},
	{-0.246603,	0.081403,	10.122678,	0},
	{-0.246603,	0.080206,	10.129861,	0},
	{-0.231040,	0.067038,	10.116693,	0},
	{-0.228646,	0.074220,	10.129861,	0},
	{-0.235829,	0.073023,	10.134649,	0},
	{-0.246603,	0.093374,	10.123875,	0},
	{-0.252588,	0.080206,	10.127466,	0},
	{-0.233435,	0.061052,	10.133451,	0},
	{-0.243011,	0.070629,	10.137043,	0},
	{-0.250194,	0.077812,	10.108313,	0},
	{-0.235829,	0.083797,	10.121481,	0},
	{-0.247800,	0.081403,	10.141831,	0},
	{-0.252588,	0.081403,	10.131058,	0},
	{-0.243011,	0.080206,	10.126269,	0},
	{-0.235829,	0.070629,	10.109509,	0},
	{-0.237026,	0.073023,	10.135846,	0},
	{-0.237026,	0.074220,	10.123875,	0},
	{-0.253785,	0.089783,	10.117889,	0},
	{-0.248997,	0.087388,	10.123875,	0},
	{-0.228646,	0.073023,	10.128663,	0},
	{-0.233435,	0.073023,	10.137043,	0},
	{-0.247800,	0.080206,	10.123875,	0},
	{-0.254982,	0.074220,	10.132255,	0},
	{-0.234632,	0.081403,	10.113101,	0},
	{-0.241814,	0.074220,	10.149014,	0},
	{-0.244208,	0.064643,	10.119086,	0},
	{-0.235829,	0.069432,	10.121481,	0},
	{-0.237026,	0.071826,	10.123875,	0},
	{-0.241814,	0.065841,	10.134649,	0},
	{-0.237026,	0.065841,	10.153803,	0},
	{-0.239420,	0.077812,	10.135846,	0},
	{-0.244208,	0.073023,	10.125072,	0},
	{-0.246603,	0.065841,	10.117889,	0},
	{-0.237026,	0.073023,	10.129861,	0},
	{-0.254982,	0.080206,	10.111904,	0},
	{-0.241814,	0.076614,	10.140635,	0},
	{-0.243011,	0.057461,	10.123875,	0},
	{-0.241814,	0.081403,	10.139438,	0},
	{-0.246603,	0.070629,	10.131058,	0},
	{-0.251391,	0.075417,	10.147817,	0},
	{-0.251391,	0.070629,	10.120284,	0},
	{-0.234632,	0.086191,	10.137043,	0},
	{-0.235829,	0.079009,	10.119086,	0},
	{-0.235829,	0.086191,	10.119086,	0},
	{-0.234632,	0.069432,	10.121481,	0},
	{-0.246603,	0.069432,	10.126269,	0},
	{-0.245406,	0.083797,	10.145423,	0},
	{-0.245406,	0.077812,	10.116693,	0},
	{-0.240617,	0.079009,	10.144226,	0},
	{-0.237026,	0.073023,	10.134649,	0},
	{-0.238223,	0.077812,	10.140635,	0},
	{-0.227449,	0.082600,	10.127466,	0},
	{-0.233435,	0.092177,	10.122678,	0},
	{-0.246603,	0.083797,	10.140635,	0},
	{-0.229843,	0.065841,	10.134649,	0},
	{-0.227449,	0.080206,	10.138240,	0},
	{-0.243011,	0.077812,	10.138240,	0},
	{-0.240617,	0.076614,	10.119086,	0},
	{-0.241814,	0.073023,	10.125072,	0},
	{-0.240617,	0.071826,	10.123875,	0},
	{-0.250194,	0.079009,	10.117889,	0},
	{-0.243011,	0.080206,	10.145423,	0},
	{-0.252588,	0.081403,	10.119086,	0},
	{-0.240617,	0.068235,	10.132255,	0},
	{-0.244208,	0.065841,	10.114298,	0},
	{-0.235829,	0.073023,	10.125072,	0},
	{-0.248997,	0.076614,	10.117889,	0},
	{-0.250194,	0.059855,	10.121481,	0},
	{-0.239420,	0.095768,	10.147817,	0},
	{-0.262165,	0.081403,	10.116693,	0},
	{-0.253785,	0.065841,	10.149014,	0},
	{-0.244208,	0.067038,	10.115496,	0},
	{-0.238223,	0.074220,	10.122678,	0},
	{-0.235829,	0.075417,	10.149014,	0},
	{-0.243011,	0.062249,	10.144226,	0},
	{-0.244208,	0.073023,	10.123875,	0},
	{-0.239420,	0.084994,	10.132255,	0},
	{-0.238223,	0.074220,	10.120284,	0},
	{-0.256179,	0.063446,	10.137043,	0},
	{-0.243011,	0.061052,	10.117889,	0},
	{-0.235829,	0.064643,	10.119086,	0},
	{-0.235829,	0.079009,	10.133451,	0},
	{-0.237026,	0.082600,	10.119086,	0},
	{-0.238223,	0.079009,	10.139438,	0},
	{-0.247800,	0.065841,	10.117889,	0},
	{-0.243011,	0.069432,	10.158591,	0},
	{-0.246603,	0.080206,	10.122678,	0},
	{-0.256179,	0.083797,	10.141831,	0},
	{-0.235829,	0.092177,	10.108313,	0},
	{-0.237026,	0.061052,	10.132255,	0},
	{-0.237026,	0.058658,	10.156197,	0},
	{-0.244208,	0.059855,	10.117889,	0},
	{-0.237026,	0.087388,	10.144226,	0},
	{-0.257377,	0.094571,	10.110707,	0},
	{-0.256179,	0.080206,	10.132255,	0},
	{-0.243011,	0.089783,	10.133451,	0},
	{-0.238223,	0.080206,	10.133451,	0},
	{-0.240617,	0.067038,	10.114298,	0},
	{-0.246603,	0.064643,	10.133451,	0},
	{-0.245406,	0.075417,	10.128663,	0},
	{-0.240617,	0.071826,	10.122678,	0},
	{-0.229843,	0.068235,	10.126269,	0},
	{-0.240617,	0.081403,	10.123875,	0},
	{-0.244208,	0.079009,	10.138240,	0},
	{-0.237026,	0.065841,	10.145423,	0},
	{-0.239420,	0.069432,	10.133451,	0},
	{-0.253785,	0.076614,	10.127466,	0},
	{-0.256179,	0.082600,	10.125072,	0},
	{-0.232237,	0.081403,	10.113101,	0},
	{-0.239420,	0.065841,	10.139438,	0},
	{-0.241814,	0.084994,	10.128663,	0},
	{-0.252588,	0.071826,	10.122678,	0},
	{-0.243011,	0.067038,	10.157393,	0},
	{-0.251391,	0.081403,	10.134649,	0},
	{-0.251391,	0.083797,	10.127466,	0},
	{-0.265756,	0.074220,	10.115496,	0},
	{-0.245406,	0.062249,	10.150211,	0},
	{-0.241814,	0.070629,	10.117889,	0},
	{-0.257377,	0.083797,	10.120284,	0},
	{-0.239420,	0.081403,	10.121481,	0},
	{-0.247800,	0.068235,	10.135846,	0},
	{-0.243011,	0.071826,	10.129861,	0},
	{-0.235829,	0.082600,	10.128663,	0},
	{-0.247800,	0.073023,	10.145423,	0},
	{-0.258574,	0.065841,	10.123875,	0},
	{-0.233435,	0.069432,	10.122678,	0},
	{-0.245406,	0.076614,	10.120284,	0},
	{-0.247800,	0.089783,	10.131058,	0},
	{-0.244208,	0.090980,	10.114298,	0},
	{-0.247800,	0.089783,	10.143028,	0},
	{-0.229843,	0.073023,	10.119086,	0},
	{-0.240617,	0.082600,	10.134649,	0},
	{-0.244208,	0.095768,	10.125072,	0},
	{-0.241814,	0.083797,	10.145423,	0},
	{-0.250194,	0.068235,	10.139438,	0},
	{-0.248997,	0.075417,	10.113101,	0},
	{-0.250194,	0.076614,	10.128663,	0},
	{-0.247800,	0.081403,	10.114298,	0},
	{-0.247800,	0.075417,	10.123875,	0},
	{-0.248997,	0.095768,	10.145423,	0},
	{-0.245406,	0.088585,	10.143028,	0},
	{-0.238223,	0.084994,	10.113101,	0},
	{-0.240617,	0.071826,	10.126269,	0},
	{-0.240617,	0.067038,	10.140635,	0},
	{-0.245406,	0.071826,	10.138240,	0},
	{-0.254982,	0.073023,	10.128663,	0},
	{-0.245406,	0.077812,	10.145423,	0},
	{-0.250194,	0.070629,	10.127466,	0},
	{-0.243011,	0.073023,	10.137043,	0},
	{-0.245406,	0.067038,	10.117889,	0},
	{-0.243011,	0.071826,	10.151408,	0},
	{-0.252588,	0.081403,	10.128663,	0},
	{-0.233435,	0.074220,	10.110707,	0},
	{-0.243011,	0.074220,	10.126269,	0},
	{-0.239420,	0.089783,	10.143028,	0},
	{-0.237026,	0.086191,	10.123875,	0},
	{-0.243011,	0.064643,	10.129861,	0},
	{-0.234632,	0.077812,	10.133451,	0},
	{-0.250194,	0.086191,	10.133451,	0},
	{-0.241814,	0.074220,	10.125072,	0},
	{-0.243011,	0.086191,	10.122678,	0},
	{-0.234632,	0.076614,	10.121481,	0},
	{-0.251391,	0.082600,	10.135846,	0},
	{-0.251391,	0.084994,	10.133451,	0},
	{-0.245406,	0.063446,	10.117889,	0},
	{-0.253785,	0.079009,	10.122678,	0},
	{-0.243011,	0.074220,	10.129861,	0},
	{-0.233435,	0.069432,	10.127466,	0},
	{-0.251391,	0.077812,	10.126269,	0},
	{-0.245406,	0.079009,	10.120284,	0},
	{-0.247800,	0.068235,	10.128663,	0},
	{-0.244208,	0.069432,	10.133451,	0},
	{-0.238223,	0.074220,	10.146620,	0},
	{-0.241814,	0.080206,	10.120284,	0},
	{-0.248997,	0.071826,	10.107116,	0},
	{-0.240617,	0.073023,	10.123875,	0},
	{-0.239420,	0.063446,	10.135846,	0},
	{-0.245406,	0.068235,	10.117889,	0},
	{-0.248997,	0.088585,	10.105919,	0},
	{-0.248997,	0.067038,	10.138240,	0},
	{-0.247800,	0.074220,	10.128663,	0},
	{-0.237026,	0.079009,	10.138240,	0},
	{-0.243011,	0.092177,	10.140635,	0},
	{-0.235829,	0.082600,	10.128663,	0},
	{-0.240617,	0.079009,	10.116693,	0},
	{-0.248997,	0.087388,	10.114298,	0},
	{-0.238223,	0.079009,	10.120284,	0},
	{-0.241814,	0.087388,	10.128663,	0},
	{-0.250194,	0.063446,	10.129861,	0},
	{-0.245406,	0.071826,	10.128663,	0},
	{-0.251391,	0.073023,	10.123875,	0},
	{-0.258574,	0.084994,	10.137043,	0},
	{-0.246603,	0.077812,	10.140635,	0},
	{-0.244208,	0.070629,	10.111904,	0},
	{-0.252588,	0.075417,	10.143028,	0},
	{-0.248997,	0.069432,	10.117889,	0},
	{-0.243011,	0.073023,	10.129861,	0},
	{-0.238223,	0.079009,	10.143028,	0},
	{-0.238223,	0.080206,	10.114298,	0},
	{-0.241814,	0.074220,	10.132255,	0},
	{-0.240617,	0.065841,	10.132255,	0},
	{-0.247800,	0.069432,	10.134649,	0},
	{-0.251391,	0.075417,	10.132255,	0},
	{-0.238223,	0.086191,	10.115496,	0},
	{-0.245406,	0.076614,	10.139438,	0},
	{-0.240617,	0.073023,	10.123875,	0},
	{-0.238223,	0.071826,	10.137043,	0},
	{-0.245406,	0.076614,	10.135846,	0},
	{-0.251391,	0.081403,	10.133451,	0},
	{-0.251391,	0.086191,	10.134649,	0},
	{-0.248997,	0.079009,	10.115496,	0},
	{-0.256179,	0.067038,	10.133451,	0},
	{-0.246603,	0.068235,	10.121481,	0},
	{-0.244208,	0.082600,	10.135846,	0},
	{-0.250194,	0.079009,	10.122678,	0},
	{-0.252588,	0.079009,	10.120284,	0},
	{-0.243011,	0.083797,	10.127466,	0},
	{-0.243011,	0.071826,	10.119086,	0},
	{-0.251391,	0.081403,	10.128663,	0},
	{-0.252588,	0.065841,	10.122678,	0},
	{-0.240617,	0.079009,	10.131058,	0},
	{-0.253785,	0.082600,	10.121481,	0},
	{-0.256179,	0.071826,	10.140635,	0},
	{-0.263362,	0.070629,	10.123875,	0},
	{-0.248997,	0.074220,	10.123875,	0},
	{-0.235829,	0.064643,	10.125072,	0},
	{-0.238223,	0.082600,	10.125072,	0},
	{-0.238223,	0.077812,	10.108313,	0},
	{-0.231040,	0.071826,	10.117889,	0},
	{-0.250194,	0.093374,	10.122678,	0},
	{-0.241814,	0.080206,	10.123875,	0},
	{-0.258574,	0.073023,	10.117889,	0},
	{-0.248997,	0.071826,	10.127466,	0},
	{-0.246603,	0.067038,	10.146620,	0},
	{-0.248997,	0.074220,	10.126269,	0},
	{-0.248997,	0.071826,	10.133451,	0},
	{-0.247800,	0.080206,	10.133451,	0},
	{-0.239420,	0.076614,	10.138240,	0},
	{-0.248997,	0.081403,	10.127466,	0},
	{-0.248997,	0.076614,	10.137043,	0},
	{-0.248997,	0.080206,	10.123875,	0},
	{-0.239420,	0.067038,	10.141831,	0},
	{-0.235829,	0.083797,	10.119086,	0},
	{-0.247800,	0.069432,	10.134649,	0},
	{-0.237026,	0.087388,	10.137043,	0},
	{-0.246603,	0.073023,	10.131058,	0},
	{-0.251391,	0.083797,	10.135846,	0},
	{-0.247800,	0.071826,	10.121481,	0},
	{-0.246603,	0.076614,	10.128663,	0},
	{-0.251391,	0.082600,	10.114298,	0},
	{-0.254982,	0.082600,	10.134649,	0},
	{-0.237026,	0.084994,	10.117889,	0},
	{-0.229843,	0.077812,	10.119086,	0},
	{-0.246603,	0.070629,	10.125072,	0},
	{-0.235829,	0.076614,	10.140635,	0},
	{-0.245406,	0.061052,	10.122678,	0},
	{-0.240617,	0.076614,	10.119086,	0},
	{-0.259771,	0.088585,	10.126269,	0},
	{-0.241814,	0.077812,	10.139438,	0},
	{-0.244208,	0.075417,	10.116693,	0},
	{-0.239420,	0.067038,	10.109509,	0},
	{-0.241814,	0.083797,	10.134649,	0},
	{-0.244208,	0.067038,	10.125072,	0},
	{-0.244208,	0.073023,	10.149014,	0},
	{-0.243011,	0.084994,	10.116693,	0},
	{-0.231040,	0.076614,	10.123875,	0},
	{-0.247800,	0.089783,	10.120284,	0},
	{-0.246603,	0.077812,	10.122678,	0},
	{-0.262165,	0.077812,	10.120284,	0},
	{-0.231040,	0.070629,	10.115496,	0},
	{-0.243011,	0.077812,	10.149014,	0},
	{-0.248997,	0.090980,	10.119086,	0},
	{-0.250194,	0.090980,	10.132255,	0},
	{-0.238223,	0.074220,	10.120284,	0},
	{-0.228646,	0.080206,	10.140635,	0},
	{-0.245406,	0.075417,	10.113101,	0},
	{-0.233435,	0.089783,	10.131058,	0},
	{-0.244208,	0.081403,	10.117889,	0},
	{-0.246603,	0.063446,	10.141831,	0},
	{-0.235829,	0.090980,	10.143028,	0},
	{-0.233435,	0.081403,	10.125072,	0},
	{-0.251391,	0.077812,	10.127466,	0},
	{-0.238223,	0.081403,	10.125072,	0},
	{-0.235829,	0.074220,	10.132255,	0},
	{-0.244208,	0.064643,	10.119086,	0},
	{-0.256179,	0.071826,	10.143028,	0},
	{-0.240617,	0.082600,	10.110707,	0},
	{-0.248997,	0.071826,	10.137043,	0},
	{-0.251391,	0.076614,	10.125072,	0},
	{-0.228646,	0.082600,	10.134649,	0},
	{-0.233435,	0.082600,	10.111904,	0},
	{-0.246603,	0.068235,	10.119086,	0},
	{-0.235829,	0.067038,	10.143028,	0},
	{-0.241814,	0.079009,	10.126269,	0},
	{-0.238223,	0.095768,	10.125072,	0},
	{-0.243011,	0.065841,	10.105919,	0},
	{-0.256179,	0.081403,	10.132255,	0},
	{-0.256179,	0.073023,	10.110707,	0},
	{-0.246603,	0.079009,	10.145423,	0},
	{-0.231040,	0.069432,	10.122678,	0},
	{-0.234632,	0.065841,	10.139438,	0},
	{-0.232237,	0.094571,	10.126269,	0},
	{-0.243011,	0.081403,	10.149014,	0},
	{-0.256179,	0.083797,	10.132255,	0},
	{-0.246603,	0.073023,	10.127466,	0},
	{-0.244208,	0.067038,	10.131058,	0},
	{-0.244208,	0.082600,	10.133451,	0},
	{-0.239420,	0.088585,	10.137043,	0},
	{-0.234632,	0.069432,	10.123875,	0},
	{-0.241814,	0.069432,	10.137043,	0},
	{-0.241814,	0.083797,	10.120284,	0},
	{-0.243011,	0.075417,	10.134649,	0},
	{-0.250194,	0.075417,	10.132255,	0},
	{-0.240617,	0.076614,	10.126269,	0},
	{-0.265756,	0.083797,	10.137043,	0},
	{-0.258574,	0.079009,	10.116693,	0},
	{-0.237026,	0.069432,	10.122678,	0},
	{-0.248997,	0.073023,	10.121481,	0},
	{-0.256179,	0.080206,	10.123875,	0},
	{-0.248997,	0.067038,	10.122678,	0},
	{-0.237026,	0.083797,	10.143028,	0},
	{-0.238223,	0.080206,	10.114298,	0},
	{-0.253785,	0.074220,	10.129861,	0},
	{-0.250194,	0.075417,	10.129861,	0},
	{-0.254982,	0.081403,	10.151408,	0},
	{-0.250194,	0.070629,	10.135846,	0},
	{-0.247800,	0.075417,	10.120284,	0},
	{-0.241814,	0.064643,	10.139438,	0},
	{-0.246603,	0.071826,	10.138240,	0},
	{-0.243011,	0.079009,	10.152605,	0},
	{-0.241814,	0.080206,	10.127466,	0},
	{-0.251391,	0.070629,	10.129861,	0},
	{-0.243011,	0.081403,	10.139438,	0},
	{-0.251391,	0.070629,	10.129861,	0},
	{-0.251391,	0.076614,	10.122678,	0},
	{-0.252588,	0.079009,	10.133451,	0},
	{-0.254982,	0.073023,	10.128663,	0},
	{-0.232237,	0.067038,	10.113101,	0},
	{-0.239420,	0.088585,	10.120284,	0},
	{-0.245406,	0.080206,	10.113101,	0},
	{-0.238223,	0.075417,	10.131058,	0},
	{-0.244208,	0.065841,	10.109509,	0},
	{-0.235829,	0.068235,	10.141831,	0},
	{-0.251391,	0.081403,	10.121481,	0},
	{-0.250194,	0.077812,	10.119086,	0},
	{-0.241814,	0.071826,	10.126269,	0},
	{-0.233435,	0.069432,	10.135846,	0},
	{-0.239420,	0.076614,	10.131058,	0},
	{-0.239420,	0.088585,	10.107116,	0},
	{-0.234632,	0.084994,	10.126269,	0},
	{-0.247800,	0.077812,	10.128663,	0},
	{-0.246603,	0.083797,	10.137043,	0},
	{-0.240617,	0.087388,	10.127466,	0},
	{-0.256179,	0.070629,	10.117889,	0},
	{-0.243011,	0.077812,	10.121481,	0},
	{-0.243011,	0.083797,	10.133451,	0},
	{-0.252588,	0.087388,	10.125072,	0},
	{-0.256179,	0.073023,	10.127466,	0},
	{-0.239420,	0.057461,	10.128663,	0},
	{-0.243011,	0.070629,	10.117889,	0},
	{-0.252588,	0.074220,	10.138240,	0},
	{-0.243011,	0.073023,	10.127466,	0},
	{-0.238223,	0.082600,	10.133451,	0},
	{-0.235829,	0.074220,	10.143028,	0},
	{-0.248997,	0.065841,	10.153803,	0},
	{-0.240617,	0.081403,	10.107116,	0},
	{-0.241814,	0.087388,	10.123875,	0},
	{-0.241814,	0.070629,	10.141831,	0},
	{-0.238223,	0.074220,	10.113101,	0},
	{-0.251391,	0.079009,	10.129861,	0},
	{-0.253785,	0.082600,	10.108313,	0},
	{-0.254982,	0.075417,	10.121481,	0},
	{-0.247800,	0.057461,	10.133451,	0},
	{-0.243011,	0.058658,	10.128663,	0},
	{-0.244208,	0.080206,	10.120284,	0},
	{-0.231040,	0.079009,	10.109509,	0},
	{-0.256179,	0.070629,	10.120284,	0},
	{-0.251391,	0.082600,	10.143028,	0},
	{-0.233435,	0.068235,	10.128663,	0},
	{-0.241814,	0.068235,	10.129861,	0},
	{-0.235829,	0.083797,	10.111904,	0},
	{-0.238223,	0.067038,	10.139438,	0},
	{-0.260968,	0.063446,	10.128663,	0},
	{-0.231040,	0.084994,	10.140635,	0},
	{-0.237026,	0.082600,	10.134649,	0},
	{-0.246603,	0.070629,	10.144226,	0},
	{-0.246603,	0.080206,	10.125072,	0},
	{-0.244208,	0.087388,	10.122678,	0},
	{-0.234632,	0.069432,	10.111904,	0},
	{-0.252588,	0.065841,	10.121481,	0},
	{-0.245406,	0.071826,	10.128663,	0},
	{-0.243011,	0.075417,	10.129861,	0},
	{-0.238223,	0.068235,	10.139438,	0},
	{-0.256179,	0.076614,	10.126269,	0},
	{-0.246603,	0.083797,	10.131058,	0},
	{-0.248997,	0.080206,	10.116693,	0},
	{-0.241814,	0.082600,	10.123875,	0},
	{-0.262165,	0.075417,	10.113101,	0},
	{-0.240617,	0.079009,	10.134649,	0},
	{-0.244208,	0.077812,	10.121481,	0},
	{-0.246603,	0.068235,	10.141831,	0},
	{-0.252588,	0.075417,	10.120284,	0},
	{-0.247800,	0.084994,	10.104721,	0},
	{-0.241814,	0.086191,	10.126269,	0},
	{-0.237026,	0.082600,	10.117889,	0},
	{-0.243011,	0.070629,	10.117889,	0},
	{-0.239420,	0.070629,	10.135846,	0},
	{-0.237026,	0.065841,	10.120284,	0},
	{-0.237026,	0.061052,	10.125072,	0},
	{-0.235829,	0.061052,	10.114298,	0},
	{-0.252588,	0.074220,	10.137043,	0},
	{-0.253785,	0.086191,	10.119086,	0},
	{-0.252588,	0.089783,	10.129861,	0},
	{-0.245406,	0.084994,	10.126269,	0},
	{-0.232237,	0.076614,	10.120284,	0},
	{-0.252588,	0.082600,	10.119086,	0},
	{-0.251391,	0.064643,	10.132255,	0},
	{-0.227449,	0.076614,	10.149014,	0},
	{-0.259771,	0.083797,	10.131058,	0},
	{-0.248997,	0.075417,	10.127466,	0},
	{-0.244208,	0.071826,	10.133451,	0},
	{-0.243011,	0.070629,	10.132255,	0},
	{-0.228646,	0.076614,	10.128663,	0},
	{-0.241814,	0.089783,	10.138240,	0},
	{-0.252588,	0.086191,	10.122678,	0},
	{-0.254982,	0.068235,	10.133451,	0},
	{-0.250194,	0.071826,	10.150211,	0},
	{-0.235829,	0.084994,	10.140635,	0},
	{-0.234632,	0.087388,	10.139438,	0},
	{-0.245406,	0.077812,	10.105919,	0},
	{-0.250194,	0.080206,	10.107116,	0},
	{-0.240617,	0.092177,	10.132255,	0},
	{-0.243011,	0.077812,	10.133451,	0},
	{-0.248997,	0.062249,	10.128663,	0},
	{-0.245406,	0.068235,	10.125072,	0},
	{-0.250194,	0.064643,	10.129861,	0},
	{-0.248997,	0.082600,	10.126269,	0},
	{-0.252588,	0.073023,	10.141831,	0},
	{-0.250194,	0.076614,	10.127466,	0},
	{-0.251391,	0.077812,	10.121481,	0},
	{-0.250194,	0.069432,	10.134649,	0},
	{-0.232237,	0.065841,	10.131058,	0},
	{-0.233435,	0.081403,	10.131058,	0},
	{-0.241814,	0.074220,	10.111904,	0},
	{-0.248997,	0.064643,	10.135846,	0},
	{-0.239420,	0.081403,	10.143028,	0},
	{-0.239420,	0.077812,	10.138240,	0},
	{-0.237026,	0.074220,	10.110707,	0},
	{-0.235829,	0.081403,	10.121481,	0},
	{-0.247800,	0.063446,	10.129861,	0},
	{-0.235829,	0.068235,	10.121481,	0},
	{-0.238223,	0.064643,	10.123875,	0},
	{-0.246603,	0.070629,	10.132255,	0},
	{-0.264559,	0.073023,	10.145423,	0},
	{-0.247800,	0.065841,	10.116693,	0},
	{-0.247800,	0.084994,	10.125072,	0},
	{-0.225055,	0.080206,	10.115496,	0},
	{-0.233435,	0.064643,	10.135846,	0},
	{-0.247800,	0.069432,	10.131058,	0},
	{-0.234632,	0.081403,	10.125072,	0},
	{-0.246603,	0.081403,	10.128663,	0},
	{-0.235829,	0.086191,	10.117889,	0},
	{-0.233435,	0.077812,	10.122678,	0},
	{-0.256179,	0.049081,	10.128663,	0},
	{-0.243011,	0.083797,	10.138240,	0},
	{-0.239420,	0.087388,	10.129861,	0},
	{-0.238223,	0.068235,	10.131058,	0},
	{-0.234632,	0.068235,	10.129861,	0},
	{-0.250194,	0.080206,	10.135846,	0},
	{-0.246603,	0.062249,	10.131058,	0},
	{-0.243011,	0.076614,	10.134649,	0},
	{-0.246603,	0.093374,	10.128663,	0},
	{-0.251391,	0.065841,	10.126269,	0},
	{-0.235829,	0.069432,	10.135846,	0},
	{-0.243011,	0.081403,	10.120284,	0},
	{-0.245406,	0.086191,	10.129861,	0},
	{-0.234632,	0.073023,	10.110707,	0},
	{-0.244208,	0.083797,	10.140635,	0},
	{-0.247800,	0.069432,	10.141831,	0},
	{-0.240617,	0.076614,	10.149014,	0},
	{-0.243011,	0.081403,	10.122678,	0},
	{-0.237026,	0.071826,	10.120284,	0},
	{-0.234632,	0.073023,	10.120284,	0},
	{-0.237026,	0.077812,	10.131058,	0},
	{-0.244208,	0.080206,	10.152605,	0},
	{-0.250194,	0.076614,	10.135846,	0},
	{-0.253785,	0.069432,	10.131058,	0},
	{-0.260968,	0.073023,	10.141831,	0},
	{-0.247800,	0.070629,	10.134649,	0},
	{-0.257377,	0.068235,	10.125072,	0},
	{-0.243011,	0.073023,	10.121481,	0},
	{-0.235829,	0.082600,	10.127466,	0},
	{-0.237026,	0.070629,	10.139438,	0},
	{-0.227449,	0.081403,	10.127466,	0},
	{-0.239420,	0.080206,	10.141831,	0},
	{-0.251391,	0.069432,	10.129861,	0},
	{-0.238223,	0.069432,	10.121481,	0},
	{-0.237026,	0.069432,	10.126269,	0},
	{-0.250194,	0.077812,	10.114298,	0},
	{-0.237026,	0.094571,	10.116693,	0},
	{-0.253785,	0.084994,	10.143028,	0},
	{-0.263362,	0.071826,	10.123875,	0},
	{-0.246603,	0.064643,	10.126269,	0},
	{-0.240617,	0.059855,	10.131058,	0},
	{-0.247800,	0.070629,	10.139438,	0},
	{-0.240617,	0.082600,	10.132255,	0},
	{-0.234632,	0.073023,	10.111904,	0},
	{-0.240617,	0.062249,	10.131058,	0},
	{-0.238223,	0.080206,	10.129861,	0},
	{-0.243011,	0.076614,	10.123875,	0},
	{-0.246603,	0.080206,	10.125072,	0},
	{-0.235829,	0.079009,	10.127466,	0},
	{-0.243011,	0.076614,	10.110707,	0},
	{-0.246603,	0.065841,	10.128663,	0},
	{-0.246603,	0.076614,	10.133451,	0},
	{-0.253785,	0.080206,	10.123875,	0},
	{-0.241814,	0.073023,	10.119086,	0},
	{-0.250194,	0.075417,	10.120284,	0},
	{-0.235829,	0.079009,	10.143028,	0},
	{-0.241814,	0.071826,	10.135846,	0},
	{-0.254982,	0.077812,	10.125072,	0},
	{-0.238223,	0.077812,	10.122678,	0},
	{-0.235829,	0.071826,	10.132255,	0},
	{-0.238223,	0.084994,	10.120284,	0},
	{-0.253785,	0.075417,	10.146620,	0},
	{-0.254982,	0.069432,	10.141831,	0},
	{-0.240617,	0.087388,	10.126269,	0},
	{-0.251391,	0.088585,	10.115496,	0},
	{-0.256179,	0.065841,	10.129861,	0},
	{-0.243011,	0.069432,	10.127466,	0},
	{-0.246603,	0.063446,	10.134649,	0},
	{-0.246603,	0.073023,	10.128663,	0},
	{-0.240617,	0.068235,	10.119086,	0},
	{-0.257377,	0.069432,	10.143028,	0},
	{-0.245406,	0.081403,	10.128663,	0},
	{-0.252588,	0.075417,	10.120284,	0},
	{-0.241814,	0.068235,	10.111904,	0},
	{-0.238223,	0.075417,	10.141831,	0},
	{-0.240617,	0.071826,	10.111904,	0},
	{-0.247800,	0.067038,	10.126269,	0},
	{-0.247800,	0.068235,	10.134649,	0},
	{-0.238223,	0.084994,	10.139438,	0},
	{-0.237026,	0.090980,	10.141831,	0},
	{-0.245406,	0.068235,	10.109509,	0},
	{-0.256179,	0.076614,	10.143028,	0},
	{-0.237026,	0.080206,	10.116693,	0},
	{-0.228646,	0.079009,	10.134649,	0},
	{-0.247800,	0.071826,	10.121481,	0},
	{-0.241814,	0.075417,	10.129861,	0},
	{-0.228646,	0.076614,	10.152605,	0},
	{-0.238223,	0.087388,	10.125072,	0},
	{-0.239420,	0.075417,	10.128663,	0},
	{-0.247800,	0.074220,	10.114298,	0},
	{-0.219069,	0.080206,	10.126269,	0},
	{-0.234632,	0.082600,	10.109509,	0},
	{-0.244208,	0.063446,	10.127466,	0},
	{-0.247800,	0.068235,	10.134649,	0},
	{-0.245406,	0.069432,	10.139438,	0},
	{-0.251391,	0.086191,	10.128663,	0},
	{-0.244208,	0.065841,	10.127466,	0},
	{-0.246603,	0.070629,	10.125072,	0},
	{-0.240617,	0.081403,	10.125072,	0},
	{-0.232237,	0.063446,	10.141831,	0},
	{-0.247800,	0.065841,	10.126269,	0},
	{-0.235829,	0.086191,	10.133451,	0},
	{-0.245406,	0.096965,	10.121481,	0},
	{-0.239420,	0.090980,	10.121481,	0},
	{-0.248997,	0.077812,	10.125072,	0},
	{-0.231040,	0.067038,	10.126269,	0},
	{-0.245406,	0.081403,	10.125072,	0},
	{-0.231040,	0.074220,	10.145423,	0},
	{-0.253785,	0.067038,	10.115496,	0},
	{-0.246603,	0.065841,	10.110707,	0},
	{-0.245406,	0.069432,	10.131058,	0},
	{-0.232237,	0.076614,	10.113101,	0},
	{-0.243011,	0.075417,	10.121481,	0},
	{-0.243011,	0.079009,	10.132255,	0},
	{-0.238223,	0.079009,	10.123875,	0},
	{-0.245406,	0.069432,	10.122678,	0},
	{-0.247800,	0.075417,	10.126269,	0},
	{-0.239420,	0.079009,	10.139438,	0},
	{-0.244208,	0.083797,	10.105919,	0},
	{-0.245406,	0.071826,	10.109509,	0},
	{-0.233435,	0.076614,	10.128663,	0},
	{-0.243011,	0.088585,	10.131058,	0},
	{-0.252588,	0.069432,	10.117889,	0},
	{-0.248997,	0.090980,	10.119086,	0},
	{-0.241814,	0.074220,	10.129861,	0},
	{-0.253785,	0.068235,	10.135846,	0},
	{-0.240617,	0.074220,	10.125072,	0},
	{-0.246603,	0.076614,	10.131058,	0},
	{-0.238223,	0.081403,	10.117889,	0},
	{-0.246603,	0.074220,	10.127466,	0},
	{-0.250194,	0.070629,	10.133451,	0},
	{-0.248997,	0.073023,	10.132255,	0},
	{-0.250194,	0.077812,	10.122678,	0},
	{-0.259771,	0.077812,	10.123875,	0},
	{-0.234632,	0.079009,	10.123875,	0},
	{-0.241814,	0.073023,	10.120284,	0},
	{-0.251391,	0.063446,	10.146620,	0},
	{-0.250194,	0.074220,	10.113101,	0},
	{-0.256179,	0.082600,	10.119086,	0},
	{-0.257377,	0.080206,	10.132255,	0},
	{-0.245406,	0.090980,	10.127466,	0},
	{-0.243011,	0.075417,	10.133451,	0},
	{-0.239420,	0.088585,	10.125072,	0},
	{-0.241814,	0.079009,	10.127466,	0},
	{-0.251391,	0.070629,	10.137043,	0},
	{-0.235829,	0.081403,	10.110707,	0},
	{-0.248997,	0.075417,	10.141831,	0},
	{-0.231040,	0.087388,	10.125072,	0},
	{-0.247800,	0.068235,	10.127466,	0},
	{-0.252588,	0.086191,	10.119086,	0},
	{-0.240617,	0.071826,	10.127466,	0},
	{-0.243011,	0.081403,	10.144226,	0},
	{-0.243011,	0.083797,	10.126269,	0},
	{-0.251391,	0.074220,	10.127466,	0},
	{-0.239420,	0.084994,	10.125072,	0},
	{-0.231040,	0.069432,	10.113101,	0},
	{-0.246603,	0.069432,	10.138240,	0},
	{-0.243011,	0.075417,	10.132255,	0},
	{-0.243011,	0.084994,	10.113101,	0},
	{-0.253785,	0.082600,	10.120284,	0},
	{-0.247800,	0.070629,	10.125072,	0},
	{-0.244208,	0.079009,	10.113101,	0},
	{-0.260968,	0.073023,	10.127466,	0},
	{-0.239420,	0.063446,	10.128663,	0},
	{-0.234632,	0.082600,	10.122678,	0},
	{-0.240617,	0.079009,	10.132255,	0},
	{-0.251391,	0.069432,	10.133451,	0},
	{-0.252588,	0.073023,	10.131058,	0},
	{-0.239420,	0.059855,	10.121481,	0},
	{-0.238223,	0.079009,	10.122678,	0},
	{-0.229843,	0.070629,	10.115496,	0},
	{-0.246603,	0.074220,	10.128663,	0},
	{-0.235829,	0.079009,	10.121481,	0},
	{-0.237026,	0.076614,	10.146620,	0},
	{-0.244208,	0.077812,	10.117889,	0},
	{-0.258574,	0.070629,	10.133451,	0},
	{-0.259771,	0.077812,	10.119086,	0},
	{-0.246603,	0.083797,	10.133451,	0},
	{-0.241814,	0.076614,	10.127466,	0},
	{-0.253785,	0.077812,	10.116693,	0},
	{-0.256179,	0.075417,	10.123875,	0},
	{-0.254982,	0.074220,	10.120284,	0},
	{-0.252588,	0.070629,	10.114298,	0},
	{-0.256179,	0.074220,	10.128663,	0},
	{-0.237026,	0.071826,	10.139438,	0},
	{-0.235829,	0.069432,	10.108313,	0},
	{-0.250194,	0.074220,	10.116693,	0},
	{-0.241814,	0.073023,	10.131058,	0},
	{-0.234632,	0.075417,	10.147817,	0},
	{-0.238223,	0.067038,	10.111904,	0},
	{-0.251391,	0.071826,	10.128663,	0},
	{-0.239420,	0.087388,	10.134649,	0},
	{-0.237026,	0.082600,	10.128663,	0},
	{-0.240617,	0.089783,	10.133451,	0},
	{-0.245406,	0.081403,	10.119086,	0},
	{-0.241814,	0.080206,	10.128663,	0},
	{-0.235829,	0.062249,	10.140635,	0},
	{-0.235829,	0.065841,	10.128663,	0},
	{-0.237026,	0.092177,	10.128663,	0},
	{-0.244208,	0.082600,	10.122678,	0},
	{-0.247800,	0.065841,	10.127466,	0},
	{-0.243011,	0.070629,	10.113101,	0},
	{-0.238223,	0.068235,	10.123875,	0},
	{-0.241814,	0.077812,	10.107116,	0},
	{-0.238223,	0.088585,	10.132255,	0},
	{-0.234632,	0.067038,	10.127466,	0},
	{-0.243011,	0.075417,	10.117889,	0},
	{-0.240617,	0.077812,	10.132255,	0},
	{-0.240617,	0.079009,	10.120284,	0},
	{-0.239420,	0.074220,	10.125072,	0},
	{-0.233435,	0.071826,	10.132255,	0},
	{-0.241814,	0.083797,	10.126269,	0},
	{-0.258574,	0.089783,	10.127466,	0},
	{-0.234632,	0.081403,	10.131058,	0},
	{-0.252588,	0.071826,	10.137043,	0},
	{-0.240617,	0.064643,	10.127466,	0},
	{-0.248997,	0.070629,	10.133451,	0},
	{-0.246603,	0.087388,	10.132255,	0},
	{-0.250194,	0.075417,	10.132255,	0},
	{-0.244208,	0.073023,	10.126269,	0},
	{-0.241814,	0.079009,	10.120284,	0},
	{-0.251391,	0.083797,	10.128663,	0},
	{-0.234632,	0.080206,	10.145423,	0},
	{-0.250194,	0.074220,	10.140635,	0},
	{-0.247800,	0.062249,	10.116693,	0},
	{-0.243011,	0.077812,	10.125072,	0},
	{-0.247800,	0.064643,	10.126269,	0},
	{-0.244208,	0.071826,	10.145423,	0},
	{-0.253785,	0.070629,	10.123875,	0},
	{-0.237026,	0.077812,	10.133451,	0},
	{-0.246603,	0.082600,	10.117889,	0},
	{-0.245406,	0.086191,	10.121481,	0},
	{-0.235829,	0.073023,	10.117889,	0},
	{-0.243011,	0.075417,	10.134649,	0},
	{-0.239420,	0.087388,	10.139438,	0},
	{-0.227449,	0.084994,	10.135846,	0},
	{-0.240617,	0.083797,	10.133451,	0},
	{-0.243011,	0.073023,	10.117889,	0},
	{-0.228646,	0.082600,	10.144226,	0},
	{-0.240617,	0.068235,	10.104721,	0},
	{-0.241814,	0.059855,	10.127466,	0},
	{-0.243011,	0.081403,	10.116693,	0},
	{-0.238223,	0.080206,	10.147817,	0},
	{-0.244208,	0.076614,	10.119086,	0},
	{-0.241814,	0.073023,	10.119086,	0},
	{-0.251391,	0.075417,	10.131058,	0},
	{-0.244208,	0.071826,	10.127466,	0},
	{-0.233435,	0.082600,	10.146620,	0},
	{-0.250194,	0.070629,	10.120284,	0},
	{-0.248997,	0.067038,	10.135846,	0},
	{-0.233435,	0.077812,	10.109509,	0},
	{-0.243011,	0.083797,	10.133451,	0},
	{-0.251391,	0.069432,	10.111904,	0},
	{-0.234632,	0.076614,	10.138240,	0},
	{-0.241814,	0.086191,	10.120284,	0},
	{-0.239420,	0.068235,	10.128663,	0},
	{-0.229843,	0.071826,	10.140635,	0},
	{-0.245406,	0.082600,	10.115496,	0},
	{-0.234632,	0.076614,	10.143028,	0},
	{-0.246603,	0.068235,	10.119086,	0},
	{-0.250194,	0.064643,	10.132255,	0},
	{-0.237026,	0.082600,	10.129861,	0},
	{-0.256179,	0.089783,	10.138240,	0},
	{-0.239420,	0.076614,	10.121481,	0},
	{-0.238223,	0.069432,	10.133451,	0},
	{-0.247800,	0.067038,	10.135846,	0},
	{-0.250194,	0.070629,	10.131058,	0},
	{-0.243011,	0.080206,	10.141831,	0},
	{-0.244208,	0.064643,	10.122678,	0},
	{-0.238223,	0.070629,	10.134649,	0},
	{-0.229843,	0.070629,	10.113101,	0},
	{-0.254982,	0.087388,	10.137043,	0},
	{-0.259771,	0.081403,	10.128663,	0},
	{-0.241814,	0.074220,	10.129861,	0},
	{-0.247800,	0.065841,	10.126269,	0},
	{-0.253785,	0.063446,	10.122678,	0},
	{-0.256179,	0.076614,	10.129861,	0},
	{-0.250194,	0.083797,	10.123875,	0},
	{-0.239420,	0.073023,	10.129861,	0},
	{-0.253785,	0.084994,	10.109509,	0},
	{-0.238223,	0.071826,	10.151408,	0},
	{-0.245406,	0.068235,	10.110707,	0},
	{-0.246603,	0.064643,	10.127466,	0},
	{-0.232237,	0.077812,	10.113101,	0},
	{-0.247800,	0.064643,	10.132255,	0},
	{-0.254982,	0.080206,	10.137043,	0},
	{-0.248997,	0.080206,	10.138240,	0},
	{-0.243011,	0.081403,	10.123875,	0},
	{-0.237026,	0.087388,	10.127466,	0},
	{-0.234632,	0.070629,	10.129861,	0},
	{-0.235829,	0.073023,	10.121481,	0},
	{-0.244208,	0.073023,	10.127466,	0},
	{-0.237026,	0.067038,	10.138240,	0},
	{-0.248997,	0.067038,	10.119086,	0},
	{-0.253785,	0.079009,	10.129861,	0},
	{-0.239420,	0.068235,	10.129861,	0},
	{-0.252588,	0.071826,	10.122678,	0},
	{-0.243011,	0.076614,	10.134649,	0},
	{-0.234632,	0.075417,	10.117889,	0},
	{-0.235829,	0.070629,	10.115496,	0},
	{-0.247800,	0.083797,	10.123875,	0},
	{-0.241814,	0.089783,	10.123875,	0},
	{-0.234632,	0.087388,	10.133451,	0},
	{-0.239420,	0.073023,	10.116693,	0},
	{-0.241814,	0.087388,	10.122678,	0},
	{-0.243011,	0.077812,	10.126269,	0},
	{-0.247800,	0.076614,	10.129861,	0},
	{-0.244208,	0.082600,	10.140635,	0},
	{-0.241814,	0.079009,	10.150211,	0},
	{-0.237026,	0.065841,	10.144226,	0},
	{-0.234632,	0.081403,	10.133451,	0},
	{-0.231040,	0.081403,	10.121481,	0},
	{-0.248997,	0.071826,	10.143028,	0},
	{-0.257377,	0.063446,	10.119086,	0},
	{-0.245406,	0.087388,	10.141831,	0},
	{-0.246603,	0.082600,	10.137043,	0},
	{-0.227449,	0.080206,	10.128663,	0},
	{-0.244208,	0.082600,	10.120284,	0},
	{-0.245406,	0.087388,	10.139438,	0},
	{-0.237026,	0.061052,	10.137043,	0},
	{-0.240617,	0.061052,	10.132255,	0},
	{-0.239420,	0.076614,	10.132255,	0},
	{-0.244208,	0.083797,	10.131058,	0},
	{-0.227449,	0.077812,	10.137043,	0},
	{-0.240617,	0.089783,	10.144226,	0},
	{-0.238223,	0.083797,	10.121481,	0},
	{-0.260968,	0.068235,	10.119086,	0},
	{-0.243011,	0.070629,	10.155000,	0},
	{-0.248997,	0.079009,	10.117889,	0},
	{-0.252588,	0.076614,	10.111904,	0},
	{-0.237026,	0.084994,	10.134649,	0},
	{-0.248997,	0.069432,	10.128663,	0},
	{-0.235829,	0.082600,	10.126269,	0},
	{-0.245406,	0.069432,	10.150211,	0},
	{-0.253785,	0.090980,	10.125072,	0},
	{-0.247800,	0.077812,	10.119086,	0},
	{-0.248997,	0.074220,	10.117889,	0},
	{-0.239420,	0.080206,	10.122678,	0},
	{-0.239420,	0.087388,	10.127466,	0},
	{-0.244208,	0.074220,	10.128663,	0},
	{-0.229843,	0.068235,	10.123875,	0},
	{-0.247800,	0.080206,	10.127466,	0},
	{-0.241814,	0.071826,	10.119086,	0},
	{-0.235829,	0.086191,	10.121481,	0},
	{-0.234632,	0.084994,	10.127466,	0},
	{-0.237026,	0.073023,	10.131058,	0},
	{-0.243011,	0.074220,	10.123875,	0},
	{-0.259771,	0.084994,	10.146620,	0},
	{-0.241814,	0.071826,	10.122678,	0},
	{-0.232237,	0.077812,	10.132255,	0},
	{-0.239420,	0.076614,	10.133451,	0},
	{-0.244208,	0.076614,	10.128663,	0},
	{-0.241814,	0.081403,	10.153803,	0},
	{-0.246603,	0.069432,	10.114298,	0},
	{-0.247800,	0.067038,	10.128663,	0},
	{-0.239420,	0.077812,	10.132255,	0},
	{-0.248997,	0.064643,	10.133451,	0},
	{-0.231040,	0.075417,	10.120284,	0},
	{-0.235829,	0.070629,	10.109509,	0},
	{-0.248997,	0.079009,	10.121481,	0},
	{-0.239420,	0.094571,	10.128663,	0},
	{-0.254982,	0.083797,	10.134649,	0},
	{-0.240617,	0.079009,	10.117889,	0},
	{-0.244208,	0.065841,	10.122678,	0},
	{-0.238223,	0.070629,	10.116693,	0},
	{-0.244208,	0.081403,	10.131058,	0},
	{-0.239420,	0.071826,	10.135846,	0},
	{-0.231040,	0.070629,	10.139438,	0},
	{-0.240617,	0.070629,	10.125072,	0},
	{-0.235829,	0.079009,	10.127466,	0},
	{-0.235829,	0.077812,	10.126269,	0},
	{-0.241814,	0.071826,	10.127466,	0},
	{-0.243011,	0.068235,	10.131058,	0},
	{-0.240617,	0.076614,	10.129861,	0},
	{-0.231040,	0.070629,	10.127466,	0},
	{-0.229843,	0.076614,	10.129861,	0},
	{-0.235829,	0.071826,	10.128663,	0},
	{-0.235829,	0.068235,	10.131058,	0},
	{-0.246603,	0.074220,	10.122678,	0},
	{-0.232237,	0.075417,	10.126269,	0},
	{-0.233435,	0.075417,	10.116693,	0},
	{-0.227449,	0.069432,	10.131058,	0},
	{-0.233435,	0.069432,	10.133451,	0},
	{-0.243011,	0.076614,	10.125072,	0},
	{-0.243011,	0.079009,	10.111904,	0},
	{-0.245406,	0.080206,	10.137043,	0},
	{-0.244208,	0.083797,	10.133451,	0},
	{-0.247800,	0.071826,	10.131058,	0},
	{-0.239420,	0.063446,	10.114298,	0},
	{-0.234632,	0.070629,	10.119086,	0},
	{-0.238223,	0.070629,	10.151408,	0},
	{-0.247800,	0.075417,	10.134649,	0},
	{-0.241814,	0.075417,	10.137043,	0},
	{-0.240617,	0.067038,	10.121481,	0},
	{-0.243011,	0.063446,	10.137043,	0},
	{-0.229843,	0.068235,	10.132255,	0},
	{-0.241814,	0.075417,	10.122678,	0},
	{-0.246603,	0.086191,	10.119086,	0},
	{-0.235829,	0.081403,	10.126269,	0},
	{-0.229843,	0.081403,	10.138240,	0},
	{-0.234632,	0.075417,	10.120284,	0},
	{-0.237026,	0.080206,	10.133451,	0},
	{-0.232237,	0.074220,	10.114298,	0},
	{-0.245406,	0.069432,	10.128663,	0},
	{-0.241814,	0.064643,	10.134649,	0},
	{-0.239420,	0.086191,	10.133451,	0},
	{-0.238223,	0.086191,	10.144226,	0},
	{-0.248997,	0.063446,	10.131058,	0},
	{-0.229843,	0.065841,	10.137043,	0},
	{-0.239420,	0.084994,	10.110707,	0},
	{-0.231040,	0.083797,	10.141831,	0},
	{-0.245406,	0.073023,	10.128663,	0},
	{-0.245406,	0.071826,	10.129861,	0},
	{-0.238223,	0.071826,	10.120284,	0},
	{-0.247800,	0.081403,	10.137043,	0},
	{-0.264559,	0.069432,	10.135846,	0},
	{-0.247800,	0.070629,	10.131058,	0},
	{-0.240617,	0.082600,	10.134649,	0},
	{-0.246603,	0.075417,	10.126269,	0},
	{-0.238223,	0.071826,	10.152605,	0},
	{-0.235829,	0.063446,	10.132255,	0},
	{-0.251391,	0.065841,	10.120284,	0},
	{-0.243011,	0.068235,	10.131058,	0},
	{-0.222661,	0.067038,	10.134649,	0},
	{-0.239420,	0.081403,	10.128663,	0},
	{-0.240617,	0.083797,	10.138240,	0},
	{-0.223858,	0.068235,	10.122678,	0},
	{-0.238223,	0.065841,	10.140635,	0},
	{-0.237026,	0.081403,	10.134649,	0},
	{-0.240617,	0.079009,	10.123875,	0},
	{-0.238223,	0.073023,	10.133451,	0},
	{-0.246603,	0.067038,	10.117889,	0},
	{-0.243011,	0.061052,	10.135846,	0},
	{-0.239420,	0.075417,	10.116693,	0},
	{-0.260968,	0.065841,	10.123875,	0},
	{-0.247800,	0.064643,	10.117889,	0},
	{-0.248997,	0.093374,	10.140635,	0},
	{-0.244208,	0.080206,	10.144226,	0},
	{-0.258574,	0.077812,	10.113101,	0},
	{-0.250194,	0.069432,	10.126269,	0},
	{-0.238223,	0.073023,	10.102327,	0},
	{-0.240617,	0.070629,	10.135846,	0},
	{-0.247800,	0.063446,	10.121481,	0},
	{-0.268150,	0.088585,	10.135846,	0},
	{-0.246603,	0.075417,	10.119086,	0},
	{-0.233435,	0.071826,	10.131058,	0},
	{-0.245406,	0.071826,	10.128663,	0},
	{-0.244208,	0.094571,	10.128663,	0},
	{-0.234632,	0.080206,	10.123875,	0},
	{-0.240617,	0.081403,	10.109509,	0},
	{-0.240617,	0.069432,	10.128663,	0},
	{-0.237026,	0.069432,	10.122678,	0},
	{-0.234632,	0.071826,	10.137043,	0},
	{-0.239420,	0.076614,	10.139438,	0},
	{-0.244208,	0.088585,	10.117889,	0},
	{-0.259771,	0.087388,	10.134649,	0},
	{-0.252588,	0.077812,	10.134649,	0},
	{-0.241814,	0.073023,	10.117889,	0},
	{-0.243011,	0.080206,	10.128663,	0},
	{-0.241814,	0.086191,	10.119086,	0},
	{-0.244208,	0.073023,	10.115496,	0},
	{-0.239420,	0.080206,	10.123875,	0},
	{-0.248997,	0.070629,	10.137043,	0},
	{-0.240617,	0.076614,	10.119086,	0},
	{-0.233435,	0.070629,	10.128663,	0},
	{-0.235829,	0.075417,	10.121481,	0},
	{-0.240617,	0.090980,	10.127466,	0},
	{-0.252588,	0.067038,	10.114298,	0},
	{-0.229843,	0.077812,	10.123875,	0},
	{-0.248997,	0.084994,	10.137043,	0},
	{-0.245406,	0.070629,	10.110707,	0},
	{-0.239420,	0.061052,	10.131058,	0},
	{-0.241814,	0.077812,	10.132255,	0},
	{-0.239420,	0.081403,	10.126269,	0},
	{-0.235829,	0.069432,	10.127466,	0},
	{-0.243011,	0.076614,	10.134649,	0},
	{-0.252588,	0.077812,	10.132255,	0},
	{-0.237026,	0.077812,	10.138240,	0},
	{-0.246603,	0.073023,	10.127466,	0},
	{-0.241814,	0.063446,	10.129861,	0},
	{-0.234632,	0.071826,	10.126269,	0},
	{-0.248997,	0.081403,	10.113101,	0},
	{-0.244208,	0.084994,	10.114298,	0},
	{-0.232237,	0.077812,	10.132255,	0},
	{-0.234632,	0.084994,	10.128663,	0},
	{-0.244208,	0.088585,	10.108313,	0},
	{-0.253785,	0.070629,	10.141831,	0},
	{-0.247800,	0.071826,	10.121481,	0},
	{-0.244208,	0.070629,	10.128663,	0},
	{-0.244208,	0.079009,	10.116693,	0},
	{-0.239420,	0.074220,	10.113101,	0},
	{-0.239420,	0.079009,	10.127466,	0},
	{-0.251391,	0.071826,	10.133451,	0},
	{-0.247800,	0.076614,	10.133451,	0},
	{-0.254982,	0.088585,	10.137043,	0},
	{-0.250194,	0.081403,	10.137043,	0},
	{-0.257377,	0.077812,	10.117889,	0},
	{-0.237026,	0.079009,	10.123875,	0},
	{-0.235829,	0.073023,	10.121481,	0},
	{-0.262165,	0.082600,	10.123875,	0},
	{-0.248997,	0.073023,	10.113101,	0},
	{-0.241814,	0.076614,	10.114298,	0},
	{-0.251391,	0.073023,	10.131058,	0},
	{-0.248997,	0.075417,	10.141831,	0},
	{-0.237026,	0.074220,	10.132255,	0},
	{-0.253785,	0.084994,	10.122678,	0},
	{-0.247800,	0.079009,	10.133451,	0},
	{-0.246603,	0.082600,	10.109509,	0},
	{-0.252588,	0.094571,	10.122678,	0},
	{-0.246603,	0.073023,	10.125072,	0},
	{-0.250194,	0.057461,	10.115496,	0},
	{-0.250194,	0.071826,	10.122678,	0},
	{-0.251391,	0.076614,	10.127466,	0},
	{-0.240617,	0.079009,	10.126269,	0},
	{-0.259771,	0.073023,	10.115496,	0},
	{-0.246603,	0.074220,	10.135846,	0},
	{-0.253785,	0.077812,	10.119086,	0},
	{-0.244208,	0.077812,	10.128663,	0},
	{-0.241814,	0.069432,	10.128663,	0},
	{-0.244208,	0.081403,	10.126269,	0},
	{-0.246603,	0.086191,	10.128663,	0},
	{-0.252588,	0.084994,	10.132255,	0},
	{-0.247800,	0.076614,	10.128663,	0},
	{-0.240617,	0.063446,	10.126269,	0},
	{-0.235829,	0.069432,	10.127466,	0},
	{-0.240617,	0.087388,	10.129861,	0},
	{-0.251391,	0.063446,	10.128663,	0},
	{-0.252588,	0.077812,	10.135846,	0},
	{-0.254982,	0.082600,	10.138240,	0},
	{-0.244208,	0.081403,	10.128663,	0},
	{-0.241814,	0.086191,	10.117889,	0},
	{-0.254982,	0.069432,	10.149014,	0},
	{-0.248997,	0.068235,	10.131058,	0},
	{-0.252588,	0.063446,	10.122678,	0},
	{-0.240617,	0.079009,	10.152605,	0},
	{-0.240617,	0.088585,	10.107116,	0},
	{-0.248997,	0.076614,	10.138240,	0},
	{-0.251391,	0.075417,	10.119086,	0},
	{-0.225055,	0.079009,	10.138240,	0},
	{-0.239420,	0.077812,	10.150211,	0},
	{-0.250194,	0.055067,	10.137043,	0},
	{-0.257377,	0.082600,	10.125072,	0},
	{-0.243011,	0.075417,	10.119086,	0},
	{-0.244208,	0.064643,	10.119086,	0},
	{-0.246603,	0.080206,	10.117889,	0},
	{-0.232237,	0.079009,	10.158591,	0},
	{-0.247800,	0.071826,	10.120284,	0},
	{-0.245406,	0.075417,	10.137043,	0},
	{-0.240617,	0.069432,	10.117889,	0},
	{-0.246603,	0.080206,	10.134649,	0},
	{-0.248997,	0.087388,	10.109509,	0},
	{-0.252588,	0.081403,	10.132255,	0},
	{-0.250194,	0.069432,	10.123875,	0},
	{-0.257377,	0.073023,	10.131058,	0},
	{-0.241814,	0.068235,	10.109509,	0},
	{-0.243011,	0.080206,	10.108313,	0},
	{-0.238223,	0.074220,	10.139438,	0},
	{-0.245406,	0.075417,	10.122678,	0},
	{-0.250194,	0.069432,	10.137043,	0},
	{-0.245406,	0.069432,	10.116693,	0},
	{-0.235829,	0.070629,	10.158591,	0},
	{-0.247800,	0.082600,	10.117889,	0},
	{-0.247800,	0.077812,	10.137043,	0},
	{-0.243011,	0.080206,	10.134649,	0},
	{-0.263362,	0.081403,	10.110707,	0},
	{-0.247800,	0.079009,	10.127466,	0},
	{-0.248997,	0.071826,	10.131058,	0},
	{-0.248997,	0.075417,	10.144226,	0},
	{-0.239420,	0.077812,	10.117889,	0},
	{-0.248997,	0.071826,	10.139438,	0},
	{-0.254982,	0.083797,	10.120284,	0},
	{-0.238223,	0.075417,	10.131058,	0},
	{-0.235829,	0.084994,	10.105919,	0},
	{-0.245406,	0.080206,	10.133451,	0},
	{-0.247800,	0.075417,	10.131058,	0},
	{-0.235829,	0.079009,	10.120284,	0},
	{-0.247800,	0.070629,	10.133451,	0},
	{-0.253785,	0.064643,	10.110707,	0},
	{-0.240617,	0.071826,	10.120284,	0},
	{-0.248997,	0.079009,	10.101130,	0},
	{-0.243011,	0.079009,	10.141831,	0},
	{-0.244208,	0.077812,	10.134649,	0},
	{-0.245406,	0.081403,	10.140635,	0},
	{-0.253785,	0.070629,	10.110707,	0},
	{-0.254982,	0.058658,	10.129861,	0},
	{-0.239420,	0.083797,	10.137043,	0},
	{-0.232237,	0.081403,	10.125072,	0},
	{-0.243011,	0.068235,	10.139438,	0},
	{-0.243011,	0.063446,	10.123875,	0},
	{-0.232237,	0.074220,	10.140635,	0},
	{-0.241814,	0.077812,	10.116693,	0},
	{-0.247800,	0.074220,	10.139438,	0},
	{-0.245406,	0.077812,	10.127466,	0},
	{-0.233435,	0.073023,	10.132255,	0},
	{-0.243011,	0.074220,	10.121481,	0},
	{-0.246603,	0.059855,	10.125072,	0},
	{-0.246603,	0.070629,	10.120284,	0},
	{-0.241814,	0.087388,	10.133451,	0},
	{-0.245406,	0.061052,	10.128663,	0},
	{-0.248997,	0.079009,	10.111904,	0},
	{-0.237026,	0.077812,	10.135846,	0},
	{-0.240617,	0.083797,	10.108313,	0},
	{-0.237026,	0.075417,	10.141831,	0},
	{-0.243011,	0.061052,	10.132255,	0},
	{-0.234632,	0.073023,	10.133451,	0},
	{-0.251391,	0.073023,	10.137043,	0},
	{-0.237026,	0.083797,	10.135846,	0},
	{-0.231040,	0.077812,	10.117889,	0},
	{-0.237026,	0.061052,	10.140635,	0},
	{-0.243011,	0.071826,	10.127466,	0},
	{-0.235829,	0.081403,	10.131058,	0},
	{-0.241814,	0.076614,	10.123875,	0},
	{-0.258574,	0.081403,	10.127466,	0},
	{-0.241814,	0.063446,	10.127466,	0},
	{-0.254982,	0.071826,	10.139438,	0},
	{-0.244208,	0.077812,	10.117889,	0},
	{-0.240617,	0.077812,	10.134649,	0},
	{-0.258574,	0.075417,	10.128663,	0},
	{-0.245406,	0.069432,	10.131058,	0},
	{-0.245406,	0.074220,	10.126269,	0},
	{-0.248997,	0.075417,	10.137043,	0},
	{-0.248997,	0.082600,	10.137043,	0},
	{-0.245406,	0.084994,	10.115496,	0},
	{-0.244208,	0.073023,	10.126269,	0},
	{-0.234632,	0.067038,	10.126269,	0},
	{-0.238223,	0.064643,	10.127466,	0},
	{-0.263362,	0.065841,	10.123875,	0},
	{-0.257377,	0.081403,	10.126269,	0},
	{-0.237026,	0.082600,	10.105919,	0},
	{-0.253785,	0.083797,	10.119086,	0},
	{-0.234632,	0.073023,	10.125072,	0},
	{-0.243011,	0.062249,	10.122678,	0},
	{-0.251391,	0.076614,	10.119086,	0},
	{-0.258574,	0.071826,	10.139438,	0},
	{-0.250194,	0.071826,	10.140635,	0},
	{-0.251391,	0.086191,	10.140635,	0},
	{-0.248997,	0.077812,	10.121481,	0},
	{-0.244208,	0.083797,	10.126269,	0},
	{-0.241814,	0.083797,	10.133451,	0},
	{-0.246603,	0.070629,	10.119086,	0},
	{-0.241814,	0.067038,	10.146620,	0},
	{-0.247800,	0.079009,	10.109509,	0},
	{-0.256179,	0.069432,	10.146620,	0},
	{-0.247800,	0.073023,	10.126269,	0},
	{-0.245406,	0.070629,	10.113101,	0},
	{-0.234632,	0.084994,	10.126269,	0},
	{-0.228646,	0.068235,	10.129861,	0},
	{-0.246603,	0.062249,	10.143028,	0},
	{-0.245406,	0.084994,	10.122678,	0},
	{-0.244208,	0.067038,	10.143028,	0},
	{-0.241814,	0.080206,	10.138240,	0},
	{-0.243011,	0.083797,	10.135846,	0},
	{-0.238223,	0.069432,	10.139438,	0},
	{-0.235829,	0.081403,	10.121481,	0},
	{-0.241814,	0.081403,	10.119086,	0},
	{-0.241814,	0.068235,	10.146620,	0},
	{-0.246603,	0.093374,	10.107116,	0},
	{-0.247800,	0.088585,	10.135846,	0},
	{-0.258574,	0.069432,	10.101130,	0},
	{-0.252588,	0.074220,	10.135846,	0},
	{-0.240617,	0.058658,	10.127466,	0},
	{-0.263362,	0.073023,	10.138240,	0},
	{-0.244208,	0.081403,	10.135846,	0},
	{-0.248997,	0.086191,	10.127466,	0},
	{-0.251391,	0.074220,	10.133451,	0},
	{-0.241814,	0.068235,	10.129861,	0},
	{-0.247800,	0.075417,	10.144226,	0},
	{-0.248997,	0.086191,	10.113101,	0},
	{-0.239420,	0.080206,	10.153803,	0},
	{-0.239420,	0.059855,	10.117889,	0},
	{-0.244208,	0.073023,	10.139438,	0},
	{-0.245406,	0.082600,	10.120284,	0},
	{-0.238223,	0.086191,	10.133451,	0},
	{-0.246603,	0.079009,	10.123875,	0},
	{-0.247800,	0.074220,	10.131058,	0},
	{-0.252588,	0.084994,	10.120284,	0},
	{-0.245406,	0.075417,	10.125072,	0},
	{-0.240617,	0.069432,	10.135846,	0},
	{-0.245406,	0.076614,	10.121481,	0},
	{-0.231040,	0.068235,	10.132255,	0},
	{-0.233435,	0.076614,	10.134649,	0},
	{-0.239420,	0.082600,	10.127466,	0},
	{-0.253785,	0.076614,	10.104721,	0},
	{-0.247800,	0.089783,	10.133451,	0},
	{-0.238223,	0.076614,	10.134649,	0},
	{-0.240617,	0.073023,	10.105919,	0},
	{-0.243011,	0.067038,	10.146620,	0},
	{-0.246603,	0.067038,	10.135846,	0},
	{-0.250194,	0.080206,	10.146620,	0},
	{-0.252588,	0.062249,	10.125072,	0},
	{-0.234632,	0.074220,	10.127466,	0},
	{-0.239420,	0.069432,	10.149014,	0},
	{-0.243011,	0.069432,	10.126269,	0},
	{-0.240617,	0.071826,	10.109509,	0},
	{-0.258574,	0.067038,	10.121481,	0},
	{-0.258574,	0.079009,	10.137043,	0},
	{-0.248997,	0.083797,	10.114298,	0},
	{-0.228646,	0.077812,	10.123875,	0},
	{-0.248997,	0.061052,	10.128663,	0},
	{-0.253785,	0.080206,	10.140635,	0},
	{-0.250194,	0.077812,	10.119086,	0},
	{-0.250194,	0.080206,	10.134649,	0},
	{-0.254982,	0.079009,	10.104721,	0},
	{-0.251391,	0.076614,	10.125072,	0},
	{-0.244208,	0.069432,	10.109509,	0},
	{-0.251391,	0.075417,	10.131058,	0},
	{-0.246603,	0.074220,	10.135846,	0},
	{-0.247800,	0.077812,	10.133451,	0},
	{-0.243011,	0.095768,	10.119086,	0},
	{-0.252588,	0.079009,	10.103524,	0},
	{-0.248997,	0.080206,	10.119086,	0},
	{-0.250194,	0.087388,	10.122678,	0},
	{-0.244208,	0.071826,	10.143028,	0},
	{-0.228646,	0.079009,	10.104721,	0},
	{-0.235829,	0.087388,	10.125072,	0},
	{-0.241814,	0.070629,	10.105919,	0},
	{-0.251391,	0.081403,	10.140635,	0},
	{-0.235829,	0.074220,	10.117889,	0},
	{-0.244208,	0.076614,	10.134649,	0},
	{-0.248997,	0.074220,	10.108313,	0},
	{-0.240617,	0.089783,	10.123875,	0},
	{-0.254982,	0.074220,	10.146620,	0},
	{-0.252588,	0.079009,	10.120284,	0},
	{-0.246603,	0.087388,	10.133451,	0},
	{-0.246603,	0.074220,	10.116693,	0},
	{-0.235829,	0.074220,	10.138240,	0},
	{-0.239420,	0.076614,	10.111904,	0},
	{-0.253785,	0.065841,	10.132255,	0},
	{-0.246603,	0.074220,	10.117889,	0},
	{-0.251391,	0.084994,	10.121481,	0},
	{-0.260968,	0.087388,	10.131058,	0},
	{-0.246603,	0.084994,	10.123875,	0},
	{-0.247800,	0.087388,	10.119086,	0},
	{-0.238223,	0.070629,	10.125072,	0},
	{-0.248997,	0.075417,	10.137043,	0},
	{-0.240617,	0.081403,	10.126269,	0},
	{-0.225055,	0.075417,	10.117889,	0},
	{-0.245406,	0.061052,	10.099933,	0},
	{-0.229843,	0.071826,	10.133451,	0},
	{-0.239420,	0.088585,	10.158591,	0},
	{-0.251391,	0.079009,	10.111904,	0},
	{-0.234632,	0.070629,	10.151408,	0},
	{-0.232237,	0.068235,	10.127466,	0},
	{-0.238223,	0.083797,	10.125072,	0},
	{-0.240617,	0.083797,	10.104721,	0},
	{-0.234632,	0.084994,	10.127466,	0},
	{-0.243011,	0.068235,	10.098736,	0},
	{-0.251391,	0.075417,	10.146620,	0},
	{-0.257377,	0.082600,	10.117889,	0},
	{-0.234632,	0.076614,	10.119086,	0},
	{-0.244208,	0.080206,	10.132255,	0},
	{-0.232237,	0.080206,	10.139438,	0},
	{-0.235829,	0.083797,	10.134649,	0},
	{-0.240617,	0.083797,	10.107116,	0},
	{-0.239420,	0.087388,	10.134649,	0},
	{-0.248997,	0.074220,	10.125072,	0},
	{-0.247800,	0.064643,	10.150211,	0},
	{-0.243011,	0.076614,	10.111904,	0},
	{-0.247800,	0.069432,	10.139438,	0},
	{-0.240617,	0.076614,	10.132255,	0},
	{-0.240617,	0.076614,	10.129861,	0},
	{-0.235829,	0.065841,	10.105919,	0},
	{-0.252588,	0.080206,	10.113101,	0},
	{-0.251391,	0.077812,	10.149014,	0},
	{-0.241814,	0.082600,	10.056837,	0},
	{-0.243011,	0.084994,	10.199292,	0},
	{-0.253785,	0.077812,	10.098736,	0},
	{-0.229843,	0.063446,	10.103524,	0},
	{-0.250194,	0.069432,	10.183730,	0},
	{-0.240617,	0.086191,	10.067612,	0},
	{-0.246603,	0.070629,	10.201687,	0},
	{-0.263362,	0.067038,	10.071202,	0},
	{-0.245406,	0.059855,	10.166970,	0},
	{-0.239420,	0.065841,	10.092751,	0},
	{-0.238223,	0.068235,	10.139438,	0},
	{-0.243011,	0.074220,	10.116693,	0},
	{-0.240617,	0.081403,	10.122678,	0},
	{-0.251391,	0.067038,	10.119086,	0},
	{-0.240617,	0.075417,	10.113101,	0},
	{-0.250194,	0.059855,	10.137043,	0},
	{-0.244208,	0.062249,	10.129861,	0},
	{-0.229843,	0.083797,	10.117889,	0},
	{-0.246603,	0.076614,	10.123875,	0},
	{-0.234632,	0.087388,	10.140635,	0},
	{-0.254982,	0.079009,	10.119086,	0},
	{-0.237026,	0.074220,	10.157393,	0},
	{-0.247800,	0.088585,	10.115496,	0},
	{-0.251391,	0.087388,	10.144226,	0},
	{-0.238223,	0.071826,	10.116693,	0},
	{-0.233435,	0.069432,	10.137043,	0},
	{-0.231040,	0.081403,	10.119086,	0},
	{-0.244208,	0.079009,	10.116693,	0},
	{-0.245406,	0.073023,	10.147817,	0},
	{-0.250194,	0.071826,	10.113101,	0},
	{-0.238223,	0.077812,	10.135846,	0},
	{-0.240617,	0.077812,	10.105919,	0},
	{-0.239420,	0.076614,	10.145423,	0},
	{-0.232237,	0.070629,	10.102327,	0},
	{-0.241814,	0.080206,	10.119086,	0},
	{-0.237026,	0.068235,	10.111904,	0},
	{-0.260968,	0.082600,	10.137043,	0},
	{-0.240617,	0.089783,	10.139438,	0},
	{-0.238223,	0.077812,	10.128663,	0},
	{-0.240617,	0.075417,	10.138240,	0},
	{-0.247800,	0.075417,	10.129861,	0},
	{-0.251391,	0.075417,	10.143028,	0},
	{-0.254982,	0.076614,	10.128663,	0},
	{-0.251391,	0.070629,	10.157393,	0},
	{-0.253785,	0.086191,	10.134649,	0},
	{-0.248997,	0.079009,	10.126269,	0},
	{-0.244208,	0.087388,	10.117889,	0},
	{-0.254982,	0.080206,	10.125072,	0},
	{-0.244208,	0.071826,	10.122678,	0},
	{-0.248997,	0.087388,	10.111904,	0},
	{-0.246603,	0.075417,	10.133451,	0},
	{-0.252588,	0.071826,	10.099933,	0},
	{-0.245406,	0.082600,	10.132255,	0},
	{-0.246603,	0.086191,	10.129861,	0},
	{-0.227449,	0.067038,	10.151408,	0},
	{-0.235829,	0.079009,	10.109509,	0},
	{-0.239420,	0.080206,	10.137043,	0},
	{-0.241814,	0.084994,	10.121481,	0},
	{-0.251391,	0.081403,	10.116693,	0},
	{-0.260968,	0.073023,	10.141831,	0},
	{-0.245406,	0.073023,	10.122678,	0},
	{-0.252588,	0.083797,	10.139438,	0},
	{-0.243011,	0.080206,	10.122678,	0},
	{-0.239420,	0.077812,	10.138240,	0},
	{-0.241814,	0.068235,	10.113101,	0},
	{-0.244208,	0.074220,	10.133451,	0},
	{-0.257377,	0.079009,	10.128663,	0},
	{-0.253785,	0.074220,	10.125072,	0},
	{-0.238223,	0.062249,	10.132255,	0},
	{-0.243011,	0.068235,	10.119086,	0},
	{-0.240617,	0.074220,	10.132255,	0},
	{-0.272939,	0.076614,	10.116693,	0},
	{-0.234632,	0.075417,	10.138240,	0},
	{-0.241814,	0.073023,	10.085567,	0},
	{-0.246603,	0.075417,	10.163380,	0},
	{-0.248997,	0.058658,	10.093947,	0},
	{-0.243011,	0.070629,	10.146620,	0},
	{-0.238223,	0.074220,	10.110707,	0},
	{-0.252588,	0.065841,	10.141831,	0},
	{-0.229843,	0.074220,	10.137043,	0},
	{-0.248997,	0.076614,	10.099933,	0},
	{-0.229843,	0.081403,	10.157393,	0},
	{-0.243011,	0.082600,	10.074794,	0},
	{-0.250194,	0.071826,	10.164577,	0},
	{-0.263362,	0.076614,	10.103524,	0},
	{-0.260968,	0.094571,	10.138240,	0},
	{-0.240617,	0.077812,	10.116693,	0},
	{-0.239420,	0.081403,	10.109509,	0},
	{-0.253785,	0.086191,	10.135846,	0},
	{-0.247800,	0.076614,	10.093947,	0},
	{-0.256179,	0.068235,	10.158591,	0},
	{-0.253785,	0.079009,	10.090356,	0},
	{-0.239420,	0.076614,	10.151408,	0},
	{-0.244208,	0.082600,	10.115496,	0},
	{-0.244208,	0.081403,	10.134649,	0},
	{-0.254982,	0.088585,	10.122678,	0},
	{-0.252588,	0.069432,	10.120284,	0},
	{-0.247800,	0.077812,	10.137043,	0},
	{-0.250194,	0.076614,	10.117889,	0},
	{-0.238223,	0.077812,	10.121481,	0},
	{-0.245406,	0.065841,	10.186124,	0},
	{-0.233435,	0.065841,	10.046063,	0},
	{-0.237026,	0.094571,	10.243585,	0},
	{-0.231040,	0.093374,	10.014939,	0},
	{-0.243011,	0.084994,	10.223234,	0},
	{-0.256179,	0.064643,	9.987406,	0},
	{-0.250194,	0.098162,	10.247176,	0},
	{-0.229843,	0.073023,	9.891638,	0},
	{-0.268150,	0.062249,	10.406390,	0},
	{-0.247800,	0.073023,	9.883258,	0},
	{-0.237026,	0.076614,	10.360901,	0},
	{-0.247800,	0.081403,	9.975434,	0},
	{-0.225055,	0.080206,	10.178942,	0},
	{-0.263362,	0.071826,	10.163380,	0},
	{-0.237026,	0.076614,	10.062823,	0},
	{-0.265756,	0.075417,	10.214854,	0},
	{-0.234632,	0.083797,	10.053246,	0},
	{-0.254982,	0.071826,	10.210066,	0},
	{-0.241814,	0.076614,	10.001771,	0},
	{-0.221464,	0.117316,	10.239994,	0},
	{-0.269348,	0.076614,	10.064020,	0},
	{-0.220266,	0.092177,	10.166970,	0},
	{-0.252588,	0.075417,	10.111904,	0},
	{-0.232237,	0.068235,	10.122678,	0},
	{-0.259771,	0.075417,	10.110707,	0},
	{-0.246603,	0.095768,	10.137043,	0},
	{-0.235829,	0.076614,	10.138240,	0},
	{-0.256179,	0.071826,	10.102327,	0},
	{-0.229843,	0.089783,	10.175350,	0},
	{-0.260968,	0.082600,	10.089159,	0},
	{-0.225055,	0.086191,	10.169365,	0},
	{-0.262165,	0.087388,	10.103524,	0},
	{-0.234632,	0.077812,	10.149014,	0},
	{-0.241814,	0.070629,	10.079582,	0},
	{-0.256179,	0.077812,	10.163380,	0},
	{-0.226252,	0.068235,	10.096342,	0},
	{-0.253785,	0.080206,	10.117889,	0},
	{-0.244208,	0.077812,	10.163380,	0},
	{-0.269348,	0.076614,	10.097539,	0},
	{-0.238223,	0.069432,	10.169365,	0},
	{-0.254982,	0.068235,	10.096342,	0},
	{-0.231040,	0.061052,	10.159788,	0},
	{-0.248997,	0.075417,	10.079582,	0},
	{-0.258574,	0.071826,	10.162182,	0},
	{-0.232237,	0.079009,	10.102327,	0},
	{-0.256179,	0.100556,	10.138240,	0},
	{-0.232237,	0.084994,	10.116693,	0},
	{-0.235829,	0.080206,	10.110707,	0},
	{-0.225055,	0.065841,	10.129861,	0},
	{-0.217872,	0.082600,	10.090356,	0},
	{-0.244208,	0.081403,	10.157393,	0},
};

const size_t kBodyDetectOnOffTestDataLength =
	ARRAY_SIZE(kBodyDetectOnOffTestData);
