/*
    User Interface functions for the GNUbik Cube
    Copyright (C) 1998  John Darrington

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
*/

#ifndef UI_H
#define UI_H

#include <GL/gl.h>

#include "gnubik.h"
#include "move-queue.h"

extern int frameQty;

#ifdef WIDGET_SET_athena
#include <X11/keysym.h>
typedef KeySym t_keysym;
#define GNUBIK_Left  XK_Left
#define GNUBIK_Right XK_Right
#define GNUBIK_Up    XK_Up
#define GNUBIK_Down  XK_Down


/* 
    typedef void (*XtTimerCallbackProc)(XtPointer, XtIntervalId *);
            XtPointer client_data;
            XtIntervalId *id;

   Inputs
     client_data
               Specifies the data that was registered with this procedure.

     id        Specifies the ID returned when this procedure was
               registered
*/

#define add_timeout(interval,proc,data) XtAppAddTimeOut(app, interval, proc, (XtPointer) data)

#define TIMEOUT_CALLBACK(X) void X(XtPointer data, XtIntervalId *id)


#elif defined WIDGET_SET_gtk
#include <gdk/gdkkeysyms.h>
typedef guint t_keysym;
#define GNUBIK_Left GDK_Left
#define GNUBIK_Right GDK_Right
#define GNUBIK_Up GDK_Up
#define GNUBIK_Down GDK_Down

#define add_timeout(interval,proc,data) gtk_timeout_add(interval,proc,data)

#define TIMEOUT_CALLBACK(X) gboolean X(gpointer data)



#endif

void abort_animation(void);

void selection_func();
void arrows (t_keysym keysym, int shifted);
void mouse(int button);
void turn_indicator(int axis, int dir);
int vector2axis(GLfloat *vector);
void drawCube(void);

void request_stop (void);
void request_play (void);
void request_forward (void);
void request_back (void);
void request_truncate_move_queue (void);
void request_delayed_rotation (Move_Data *data);
void request_mark_move_queue (void);
void request_queue_rewind (void);
void request_fast_forward (void);

void request_rotation( Move_Data *data) ;

/* Rotate the cube about the axis (screen relative) in direction dir */
void rotate_cube(int axis, int dir) ;


#endif





