/*
  This file is part of GNU Taler
  Copyright (C) 2012-2025 Taler Systems SA

  GNU Taler is free software: you can redistribute it and/or modify it
  under the terms of the GNU Lesser General Public License as published
  by the Free Software Foundation, either version 3 of the License,
  or (at your option) any later version.

  GNU Taler is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.

  SPDX-License-Identifier: LGPL3.0-or-later

  Note: the LGPL does not apply to all components of GNU Taler,
  but it does apply to this file.
 */

/**
 * Imports.
 */

export const TalerFormAttributes = {
    /**
     * Description: Suppress flagging this account when it creates a hit on a sanctions list, this is a false-positive.
     *
     * GANA Type: Boolean
     */
    SANCTION_LIST_SUPPRESS: "SANCTION_LIST_SUPPRESS" as const,
    /**
     * Description: Date for the signature.
     *
     * GANA Type: AbsoluteDateTime
     */
    SIGN_DATE: "SIGN_DATE" as const,
    /**
     * Description: Name of the contracting party for the purpose of signing.
     *
     * GANA Type: String
     */
    SIGNATURE: "SIGNATURE" as const,
    /**
     * Description: Basic customer type classification to distinguish which basic info is relevant.
     *
     * GANA Type: 'NATURAL_PERSON' | 'LEGAL_ENTITY'
     */
    CUSTOMER_TYPE: "CUSTOMER_TYPE" as const,
    /**
     * Description: Date of birth for natural persons. It should be in the past and less than 120 years.
     *
     * GANA Type: ISO Date
     */
    DATE_OF_BIRTH: "DATE_OF_BIRTH" as const,
    /**
     * Description: If the customer is a natural person.
     *
     * GANA Type: File
     */
    PERSONAL_IDENTIFICATION_DOCUMENT_COPY: "PERSONAL_IDENTIFICATION_DOCUMENT_COPY" as const,
    /**
     * Description: Is the customer a sole proprietor?
     *
     * GANA Type: Boolean
     */
    CUSTOMER_IS_SOLE_PROPRIETOR: "CUSTOMER_IS_SOLE_PROPRIETOR" as const,
    /**
     * Description: If the customer is a natural person.
     *
     * GANA Type: String
     */
    COMPANY_NAME: "COMPANY_NAME" as const,
    /**
     * Description: 
     *
     * GANA Type: String
     */
    REGISTERED_OFFICE_ADDRESS: "REGISTERED_OFFICE_ADDRESS" as const,
    /**
     * Description: Digital copy of the identification document for a legal entity.
     *
     * GANA Type: FileUpload
     */
    LEGAL_ENTITY_IDENTIFICATION_DOCUMENT_COPY: "LEGAL_ENTITY_IDENTIFICATION_DOCUMENT_COPY" as const,
    /**
     * Description: Full name of the contact person.
     *
     * GANA Type: String
     */
    CONTACT_PERSON_NAME: "CONTACT_PERSON_NAME" as const,
    /**
     * Description: Free-form description.
     *
     * GANA Type: String
     */
    DESCRIPTION: "DESCRIPTION" as const,
    /**
     * Description: 
     *
     * GANA Type: FileUpload[]
     */
    FILE: "FILE" as const,
    /**
     * Description: List of founder with the fields below.
     *
     * GANA Type: Form<VQF_902_1_founder>[]
     */
    ESTABLISHER_LIST: "ESTABLISHER_LIST" as const,
    /**
     * Description: Full name of a natural person.
     *
     * GANA Type: String
     */
    FULL_NAME: "FULL_NAME" as const,
    /**
     * Description: Domicile address. A domicile is a place where you live, an address is just a place where you receive mail. A residential address is somewhere you live but not necessarily your primary place.
     *
     * GANA Type: ResidentialAddress
     */
    DOMICILE_ADDRESS: "DOMICILE_ADDRESS" as const,
    /**
     * Description: Nationality, expressed as a country code.
     *
     * GANA Type: CountryCode
     */
    NATIONALITY: "NATIONALITY" as const,
    /**
     * Description: Signatory of representation (single, collective two, ...)
     *
     * GANA Type: String
     */
    SIGNING_AUTHORITY_TYPE: "SIGNING_AUTHORITY_TYPE" as const,
    /**
     * Description: Signatory of representation (other type)
     *
     * GANA Type: String
     */
    SIGNING_AUTHORITY_TYPE_OTHER: "SIGNING_AUTHORITY_TYPE_OTHER" as const,
    /**
     * Description: 
     *
     * GANA Type: 'CR' | 'MANDATE' | 'OTHER' 
     */
    SIGNING_AUTHORITY_EVIDENCE: "SIGNING_AUTHORITY_EVIDENCE" as const,
    /**
     * Description: 
     *
     * GANA Type: String 
     */
    SIGNING_AUTHORITY_EVIDENCE_OTHER: "SIGNING_AUTHORITY_EVIDENCE_OTHER" as const,
    /**
     * Description: 
     *
     * GANA Type: File 
     */
    SIGNING_AUTHORITY_EVIDENCE_DOCUMENT_COPY: "SIGNING_AUTHORITY_EVIDENCE_DOCUMENT_COPY" as const,
    /**
     * Description: Conclusion of the conract
     *
     * GANA Type: AbsoluteDate
     */
    ACCEPTANCE_DATE: "ACCEPTANCE_DATE" as const,
    /**
     * Description: 
     *
     * GANA Type: 'FACE_TO_FACE' | 'AUTHENTICATED_COPY' | 'RESIDENTIAL_ADDRESS_VALIDATED'
     */
    ACCEPTANCE_METHOD: "ACCEPTANCE_METHOD" as const,
    /**
     * Description: Correspondence language of the customer.
     *
     * GANA Type: LangCode
     */
    CORRESPONDENCE_LANGUAGE: "CORRESPONDENCE_LANGUAGE" as const,
    /**
     * Description: Further information on the acceptance of a customer.
     *
     * GANA Type: String
     */
    ACCEPTANCE_FURTHER_INFO: "ACCEPTANCE_FURTHER_INFO" as const,
    /**
     * Description: Customer type under the VQF classification. Establishment of the beneficial owner of the assets and/or controlling person
     *
     * GANA Type: 'NATURAL_PERSON' | 'OPERATIONAL' | 'FOUNDATION' | 'TRUST' | 'LIFE_INSURANCE' | 'OTHER'
     */
    CUSTOMER_TYPE_VQF: "CUSTOMER_TYPE_VQF" as const,
    /**
     * Description: Verification whether the customer, beneficial owners of the assets, controlling persons, authorised representatives or other involved persons are listed on an embargo-/terrorism list (date of verification/result)
     *
     * GANA Type: Paragraph
     */
    EMBARGO_TERRORISM_INFO: "EMBARGO_TERRORISM_INFO" as const,
    /**
     * Description: Verification date in the sancations lists. It should be in the past and less than 120 years.
     *
     * GANA Type: Date
     */
    EMBARGO_TERRORISM_CHECK_DATE: "EMBARGO_TERRORISM_CHECK_DATE" as const,
    /**
     * Description: Verification date.
     *
     * GANA Type: 'NOT_LISTED' | 'LISTED'
     */
    EMBARGO_TERRORISM_CHECK_RESULT: "EMBARGO_TERRORISM_CHECK_RESULT" as const,
    /**
     * Description: True if the person is a PEP defined by 'Art 7 lit. g numeral 1'
     *
     * GANA Type: Boolean
     */
    PEP_FOREIGN: "PEP_FOREIGN" as const,
    /**
     * Description: True if the person is a PEP defined by 'Art 7 lit. g numeral 2'
     *
     * GANA Type: Boolean
     */
    PEP_DOMESTIC: "PEP_DOMESTIC" as const,
    /**
     * Description: True if the person is a PEP defined by 'Art 7 lit. g numeral 3'
     *
     * GANA Type: Boolean
     */
    PEP_INTERNATIONAL_ORGANIZATION: "PEP_INTERNATIONAL_ORGANIZATION" as const,
    /**
     * Description: The decision of the Senior executive body on the acceptance of a business relationsip was obtained on ___. It should be in the past and less than 120 years.
     *
     * GANA Type: AbsoluteDateTime
     */
    PEP_ACCEPTANCE_DATE: "PEP_ACCEPTANCE_DATE" as const,
    /**
     * Description: True if the person is in a country for which FATF requires increased dilegence.
     *
     * GANA Type: Boolean
     */
    HIGH_RISK_COUNTRY: "HIGH_RISK_COUNTRY" as const,
    /**
     * Description: The decision of the Senior executive body on the acceptance of a business relationsip was obtained on ___. It should be in the past and less than 120 years.
     *
     * GANA Type: AbsoluteDateTime
     */
    HIGH_RISK_ACCEPTANCE_DATE: "HIGH_RISK_ACCEPTANCE_DATE" as const,
    /**
     * Description: 
     *
     * GANA Type: 'NATIONALITY_CUSTOMER' | 'NATIONALITY_OWNER' | 'DOMICILE_CUSTOMER' | 'DOMICILE_OWNER' | 'DOMICILE_CONTROLLING'
     */
    COUNTRY_RISK_NATIONALITY_TYPE: "COUNTRY_RISK_NATIONALITY_TYPE" as const,
    /**
     * Description: Based on 902.4.1 country list
     *
     * GANA Type: 'LOW' | 'MEDIUM' | 'HIGH'
     */
    COUNTRY_RISK_NATIONALITY_LEVEL: "COUNTRY_RISK_NATIONALITY_LEVEL" as const,
    /**
     * Description: 
     *
     * GANA Type: 'CUSTOMER' | 'OWNER'
     */
    COUNTRY_RISK_BUSINESS_TYPE: "COUNTRY_RISK_BUSINESS_TYPE" as const,
    /**
     * Description: Based on 902.4.1 country list
     *
     * GANA Type: 'LOW' | 'MEDIUM' | 'HIGH'
     */
    COUNTRY_RISK_BUSINESS_LEVEL: "COUNTRY_RISK_BUSINESS_LEVEL" as const,
    /**
     * Description: 
     *
     * GANA Type: 'CUSTOMER' | 'OWNER'
     */
    INDUSTRY_RISK_TYPE: "INDUSTRY_RISK_TYPE" as const,
    /**
     * Description: 
     *
     * GANA Type: 'TRANSPARENT' | 'HIGH_CASH_TRANSACTION' | 'NOT_WELL_KNOWN' | 'HIGH_RISK_TRADE' | 'UNKNOWN_INDUSTRY'
     */
    INDUSTRY_RISK_LEVEL: "INDUSTRY_RISK_LEVEL" as const,
    /**
     * Description: Based on 902.4.1 country list
     *
     * GANA Type: 'LOW' | 'MEDIUM' | 'HIGH'
     */
    CONTACT_RISK_LEVEL: "CONTACT_RISK_LEVEL" as const,
    /**
     * Description: 
     *
     * GANA Type: 'EASY' | 'SOPHISTICATED' | 'OFFSHORE' | 'COMPLEX_STRUCTURE' | 'LARGE_NUMBER_OF_ACCOUNTS' | 'COMPLEX_SERVICE' | 'FREQ_TRANS_WITH_HIGH_RISK'
     */
    PRODUCT_RISK_LEVEL: "PRODUCT_RISK_LEVEL" as const,
    /**
     * Description: 
     *
     * GANA Type: 'HIGH_RISK' | 'NO_HIGH_RISK'
     */
    RISK_CLASSIFICATION_LEVEL: "RISK_CLASSIFICATION_LEVEL" as const,
    /**
     * Description: Justification for differing risk assessment
     *
     * GANA Type: Paragraph
     */
    RISK_RATIONALE: "RISK_RATIONALE" as const,
    /**
     * Description: The decision of the Senior executive body on the acceptance of a business relationsip was obtained on ___. It should be in the past and less than 120 years.
     *
     * GANA Type: AbsoluteDateTime
     */
    RISK_ACCEPTANCE_DATE: "RISK_ACCEPTANCE_DATE" as const,
    /**
     * Description: Profession, business activities, etc. (former, current, potentially planned)
     *
     * GANA Type: String
     */
    BIZREL_PROFESSION: "BIZREL_PROFESSION" as const,
    /**
     * Description: Income and assets, liabilities (estimated)
     *
     * GANA Type: String
     */
    BIZREL_INCOME: "BIZREL_INCOME" as const,
    /**
     * Description: Does the customer have assets that will be deposited?
     *
     * GANA Type: Boolean
     */
    BIZREL_HAVE_ASSETS: "BIZREL_HAVE_ASSETS" as const,
    /**
     * Description: Nature of the involved assets (amount, currency, ...).
     *
     * GANA Type: String
     */
    BIZREL_ORIGIN_NATURE: "BIZREL_ORIGIN_NATURE" as const,
    /**
     * Description: 
     *
     * GANA Type: 'SAVINGS' | 'OWN_BUSINESS' | 'INHERITANCE' | 'OTHER'
     */
    BIZREL_ORIGIN_CATEGORY: "BIZREL_ORIGIN_CATEGORY" as const,
    /**
     * Description: 
     *
     * GANA Type: String
     */
    BIZREL_ORIGIN_CATEGORY_OTHER: "BIZREL_ORIGIN_CATEGORY_OTHER" as const,
    /**
     * Description: Detailed description of the origins.
     *
     * GANA Type: Paragraph
     */
    BIZREL_ORIGIN_DETAIL: "BIZREL_ORIGIN_DETAIL" as const,
    /**
     * Description: Purpose of the business relationship.
     *
     * GANA Type: String
     */
    BIZREL_PURPOSE: "BIZREL_PURPOSE" as const,
    /**
     * Description: Information on the planned development of the business relationship and the assets.
     *
     * GANA Type: String
     */
    BIZREL_DEVELOPMENT: "BIZREL_DEVELOPMENT" as const,
    /**
     * Description: In the case of cash or money and asset transfer transacction with regular customer
     *
     * GANA Type: String
     */
    BIZREL_FINANCIAL_VOLUME: "BIZREL_FINANCIAL_VOLUME" as const,
    /**
     * Description: Relation of the customer to the beneficial owner, controlling persons, authorised signatories and other persons involved in the business relationship.
     *
     * GANA Type: String
     */
    BIZREL_THIRDPARTY_RELATIONSHIP: "BIZREL_THIRDPARTY_RELATIONSHIP" as const,
    /**
     * Description: Relation to other AMLA-files.
     *
     * GANA Type: String
     */
    BIZREL_THIRDPARTY_AMLA_FILES: "BIZREL_THIRDPARTY_AMLA_FILES" as const,
    /**
     * Description: Introducer / agents / references.
     *
     * GANA Type: String
     */
    BIZREL_THIRDPARTY_REFERENCES: "BIZREL_THIRDPARTY_REFERENCES" as const,
    /**
     * Description: Other relevant information.
     *
     * GANA Type: String
     */
    BIZREL_FURTHER_INFO: "BIZREL_FURTHER_INFO" as const,
    /**
     * Description: 
     *
     * GANA Type: Paragraph
     */
    IDENTITY_CONTRACTING_PARTNER: "IDENTITY_CONTRACTING_PARTNER" as const,
    /**
     * Description: 
     *
     * GANA Type: File
     */
    ATTACHMENT_SIGNED_DOCUMENT: "ATTACHMENT_SIGNED_DOCUMENT" as const,
    /**
     * Description: The beneficial owners of the assets involved in the business relationship.
     *
     * GANA Type: Form<VQF_902_9_identity>[]
     */
    IDENTITY_LIST: "IDENTITY_LIST" as const,
    /**
     * Description: Party that is filling out the form.
     *
     * GANA Type: 'AML_OFFICER' | 'CUSTOMER'
     */
    SUBMITTED_BY: "SUBMITTED_BY" as const,
    /**
     * Description: 
     *
     * GANA Type: 'HAS_25_MORE_RIGHTS' | 'OTHER_WAY' | 'DIRECTOR'
     */
    CONTROL_REASON: "CONTROL_REASON" as const,
    /**
     * Description: Is a third person the beneficial owner of the assets?
     *
     * GANA Type: Boolean
     */
    THIRD_PARTY_OWNERSHIP: "THIRD_PARTY_OWNERSHIP" as const,
    /**
     * Description: Description of the circumstances/transactions, which triggered the special clarifications
     *
     * GANA Type: String
     */
    INCRISK_REASON: "INCRISK_REASON" as const,
    /**
     * Description: 
     *
     * GANA Type: 'GATHERING' | 'CONSULTATION' | 'ENQUIRIES' | 'OTHER'
     */
    INCRISK_MEANS: "INCRISK_MEANS" as const,
    /**
     * Description: 
     *
     * GANA Type: String 
     */
    INCRISK_MEANS_OTHER: "INCRISK_MEANS_OTHER" as const,
    /**
     * Description: 
     *
     * GANA Type: Paragraph
     */
    INCRISK_SUMMARY: "INCRISK_SUMMARY" as const,
    /**
     * Description: Gathered or consulted documents
     *
     * GANA Type: Paragraph
     */
    INCRISK_DOCUMENTS: "INCRISK_DOCUMENTS" as const,
    /**
     * Description: 
     *
     * GANA Type: 'NO_SUSPICION' | 'REASONABLE_SUSPICION' | 'SIMPLE_SUSPICION' | 'OTHER'
     */
    INCRISK_RESULT: "INCRISK_RESULT" as const,
    /**
     * Description: 
     *
     * GANA Type: String 
     */
    INCRISK_RESULT_OTHER: "INCRISK_RESULT_OTHER" as const,
    /**
     * Description: First name(s) as on the identity document.
     *
     * GANA Type: String
     */
    PERSON_FIRST_NAMES: "PERSON_FIRST_NAMES" as const,
    /**
     * Description: Last name of an individual as on the identity document.
     *
     * GANA Type: String
     */
    PERSON_LAST_NAME: "PERSON_LAST_NAME" as const,
    /**
     * Description: Identification number or string of national identity card.
     *
     * GANA Type: String
     */
    PERSON_NATIONAL_ID: "PERSON_NATIONAL_ID" as const,
    /**
     * Description: Scan of a recognized national identity card of an individual.
     *
     * GANA Type: File
     */
    PERSON_NATIONAL_ID_SCAN: "PERSON_NATIONAL_ID_SCAN" as const,
    /**
     * Description: Nationality of an individual. Format is 2-letter ISO country-code.
     *
     * GANA Type: CountryCode
     */
    PERSON_NATIONALITY: "PERSON_NATIONALITY" as const,
    /**
     * Description: Confirmation that the wallet user is a private customer, not a business.
     *
     * GANA Type: Boolean
     */
    WALLET_USER_IS_PRIVATE_CUSTOMER: "WALLET_USER_IS_PRIVATE_CUSTOMER" as const,
    /**
     * Description: Name of the company or business.
     *
     * GANA Type: String
     */
    BUSINESS_DISPLAY_NAME: "BUSINESS_DISPLAY_NAME" as const,
    /**
     * Description: Type of company form or business (selection from fixed list).
     *
     * GANA Type: String 
     */
    BUSINESS_TYPE: "BUSINESS_TYPE" as const,
    /**
     * Description: Type of company form or business (free-form entry for OTHER).
     *
     * GANA Type: String 
     */
    BUSINESS_TYPE_OTHER: "BUSINESS_TYPE_OTHER" as const,
    /**
     * Description: Registration id on legal entity of the company or business.
     *
     * GANA Type: String
     */
    COMMERCIAL_REGISTER_NUMBER: "COMMERCIAL_REGISTER_NUMBER" as const,
    /**
     * Description: City or location where the company or business is registered.
     *
     * GANA Type: String
     */
    REGISTER_COURT_LOCATION: "REGISTER_COURT_LOCATION" as const,
    /**
     * Description: Registration founding date of the company or business. It should be in the past and less than 120 years.
     *
     * GANA Type: AbsoluteDate
     */
    FOUNDING_DATE: "FOUNDING_DATE" as const,
    /**
     * Description: True if the company or business is a non-profit.
     *
     * GANA Type: Boolean
     */
    BUSINESS_IS_NON_PROFIT: "BUSINESS_IS_NON_PROFIT" as const,
    /**
     * Description: Industry in which the company or business mainly operate.
     *
     * GANA Type: String
     */
    BUSINESS_INDUSTRY: "BUSINESS_INDUSTRY" as const,
    /**
     * Description: Free-form industry, when BUSINESS_INDUSTRY is OTHER.
     *
     * GANA Type: String
     */
    BUSINESS_INDUSTRY_OTHER: "BUSINESS_INDUSTRY_OTHER" as const,
    /**
     * Description: List of natural persons that are legal representatives or shareholders.
     *
     * GANA Type: GLS_BusinessRepresentative[]
     */
    BUSINESS_PERSONS: "BUSINESS_PERSONS" as const,
    /**
     * Description: List of natural persons that are legal representatives or shareholders.
     *
     * GANA Type: LEGAL_REPRESENTATIVE | SHAREHOLDER_GT_25_PERCENT | AUTHORIZED_EMPLOYEE
     */
    REPRESENTATIVE_TYPE: "REPRESENTATIVE_TYPE" as const,
    /**
     * Description: DNS domain name owned by the individual or business.
     *
     * GANA Type: Hostname
     */
    CONTACT_DNS_DOMAIN: "CONTACT_DNS_DOMAIN" as const,
    /**
     * Description: Web site owned by the individual or business.
     *
     * GANA Type: HttpHostnamePath
     */
    CONTACT_WEBSITE: "CONTACT_WEBSITE" as const,
    /**
     * Description: E-mail address to contact the individual or business. Can be validated via E-mail with TAN.
     *
     * GANA Type: Email
     */
    CONTACT_EMAIL: "CONTACT_EMAIL" as const,
    /**
     * Description: Phone number to contact the individual or business. Can be validated via SMS-TAN or phone call.
     *
     * GANA Type: Phone
     */
    CONTACT_PHONE: "CONTACT_PHONE" as const,
    /**
     * Description: Natural person full-name or name of the business to contact.
     *
     * GANA Type: String
     */
    CONTACT_NAME: "CONTACT_NAME" as const,
    /**
     * Description: Country where the individual or business resides. Format is 2-letter ISO country-code.
     *
     * GANA Type: CountryCode
     */
    ADDRESS_COUNTRY: "ADDRESS_COUNTRY" as const,
    /**
     * Description: Street address name of the individual or business.
     *
     * GANA Type: String
     */
    ADDRESS_STREET_NAME: "ADDRESS_STREET_NAME" as const,
    /**
     * Description: Street address number of the individual or business.
     *
     * GANA Type: String
     */
    ADDRESS_STREET_NUMBER: "ADDRESS_STREET_NUMBER" as const,
    /**
     * Description: Additional address information of the individual or business.
     *
     * GANA Type: String
     */
    ADDRESS_LINES: "ADDRESS_LINES" as const,
    /**
     * Description: Building name of the of the individual or business.
     *
     * GANA Type: String
     */
    ADDRESS_BUILDING_NAME: "ADDRESS_BUILDING_NAME" as const,
    /**
     * Description: Building number of the individual or business.
     *
     * GANA Type: String
     */
    ADDRESS_BUILDING_NUMBER: "ADDRESS_BUILDING_NUMBER" as const,
    /**
     * Description: Postal code of the city where the individual or business resides.
     *
     * GANA Type: String
     */
    ADDRESS_ZIPCODE: "ADDRESS_ZIPCODE" as const,
    /**
     * Description: Town location of the individual or business.
     *
     * GANA Type: String
     */
    ADDRESS_TOWN_LOCATION: "ADDRESS_TOWN_LOCATION" as const,
    /**
     * Description: Town district of the individual or business.
     *
     * GANA Type: String
     */
    ADDRESS_TOWN_DISTRICT: "ADDRESS_TOWN_DISTRICT" as const,
    /**
     * Description: Country subdivision of the individual or business.
     *
     * GANA Type: String
     */
    ADDRESS_COUNTRY_SUBDIVISION: "ADDRESS_COUNTRY_SUBDIVISION" as const,
    /**
     * Description: Country name of of the individual or business.
     *
     * GANA Type: CountryCode
     */
    TAX_COUNTRY: "TAX_COUNTRY" as const,
    /**
     * Description: Tax identifier of the individual or business.
     *
     * GANA Type: String
     */
    TAX_ID: "TAX_ID" as const,
    /**
     * Description: Is business founded or under USA law.
     *
     * GANA Type: Boolean
     */
    TAX_IS_USA_LAW: "TAX_IS_USA_LAW" as const,
    /**
     * Description: Is the individual or business economically active or passive.
     *
     * GANA Type: Boolean
     */
    TAX_IS_ACTIVE: "TAX_IS_ACTIVE" as const,
    /**
     * Description: Is the business entitled to deduct input tax.
     *
     * GANA Type: Boolean
     */
    TAX_IS_DEDUCTED: "TAX_IS_DEDUCTED" as const,
    /**
     * Description: Wirtschafts-Identifikationsnummer / Steuernummer.
     *
     * GANA Type: Boolean
     */
    DE_BUSINESS_OR_TAX_ID: "DE_BUSINESS_OR_TAX_ID" as const,
    /**
     * Description: Name of the version of the terms of service accepted by the customer.
     *
     * GANA Type: Boolean
     */
    ACCEPTED_TERMS_OF_SERVICE: "ACCEPTED_TERMS_OF_SERVICE" as const,
    /**
     * Description: True if the customer read or downloaded the terms of service. It should be set automatically.
     *
     * GANA Type: Boolean
     */
    DOWNLOADED_TERMS_OF_SERVICE: "DOWNLOADED_TERMS_OF_SERVICE" as const,
    /**
     * Description: Name of the form completed by the user.
     *
     * GANA Type: String
     */
    FORM_ID: "FORM_ID" as const,
    /**
     * Description: Version of the form completed by the user.
     *
     * GANA Type: Number
     */
    FORM_VERSION: "FORM_VERSION" as const,
    /**
     * Description: High entropy value used in forms where hash is going to be stored in plain text.
     *
     * GANA Type: String
     */
    FORM_SALT: "FORM_SALT" as const,
    /**
     * Description: List of supplemental file attachments.
     *
     * GANA Type: List of records, usually the file upload and a description.
     */
    SUPPLEMENTAL_FILES_LIST: "SUPPLEMENTAL_FILES_LIST" as const,
    /**
     * Description: Generic note description
     *
     * GANA Type: String
     */
    NOTE_TEXT: "NOTE_TEXT" as const,
    /**
     * Description: Context for form submitted by the user.
     *
     * GANA Type: JSON
     */
    FORM_CONTEXT: "FORM_CONTEXT" as const,
    /**
     * Description: Map of uploaded files.
     *
     * GANA Type: MapStrFile
     */
    FILE_MAP: "FILE_MAP" as const,


}
