/*
 This file is part of GNU Taler
 (C) 2022 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 *
 * @author Sebastian Javier Marchano (sebasjm)
 */

import {
  ExchangeEntryStatus,
  ExchangeTosStatus,
  ExchangeUpdateStatus,
  ScopeType,
} from "@gnu-taler/taler-util";
import { WalletApiOperation } from "@gnu-taler/taler-wallet-core";
import * as tests from "@gnu-taler/web-util/testing";
import { expect } from "chai";
import { nullFunction } from "../../mui/handlers.js";
import { createWalletApiMock } from "../../test-utils.js";
import { Props } from "./index.js";
import { useComponentState } from "./state.js";
const props: Props = {
  onBack: nullFunction,
  noDebounce: true,
};

describe("AddExchange states", () => {
  it("should start in 'verify' state", async () => {
    const { handler, TestingContext } = createWalletApiMock();

    handler.addWalletCallResponse(
      WalletApiOperation.ListExchanges,
      {},
      {
        exchanges: [
          {
            directDepositsDisabled: true,
            exchangeBaseUrl: "http://exchange.local/",
            ageRestrictionOptions: [],
            scopeInfo: {
              currency: "ARS",
              type: ScopeType.Exchange,
              url: "http://exchange.local/",
            },
            masterPub: "123qwe123",
            currency: "ARS",
            exchangeEntryStatus: ExchangeEntryStatus.Ephemeral,
            tosStatus: ExchangeTosStatus.Pending,
            exchangeUpdateStatus: ExchangeUpdateStatus.UnavailableUpdate,
            paytoUris: [],
            lastUpdateTimestamp: undefined,
            noFees: false,
            peerPaymentsDisabled: false,
          },
        ],
      },
    );

    const hookBehavior = await tests.hookBehaveLikeThis(
      useComponentState,
      props,
      [
        (state) => {
          expect(state.status).equal("verify");
          if (state.status !== "verify") return;
          expect(state.url.value).eq("");
          expect(state.expectedCurrency).is.undefined;
          expect(state.result).is.undefined;
        },
        (state) => {
          expect(state.status).equal("verify");
          if (state.status !== "verify") return;
          expect(state.url.value).eq("");
          expect(state.expectedCurrency).is.undefined;
          expect(state.result).is.undefined;
        },
      ],
      TestingContext,
    );

    expect(hookBehavior).deep.equal({ result: "ok" });
    expect(handler.getCallingQueueState()).eq("empty");
  });

  // it("should not be able to add a known exchange", async () => {
  //   const { handler, TestingContext } = createWalletApiMock();

  //   handler.addWalletCallResponse(
  //     WalletApiOperation.ListExchanges,
  //     {},
  //     {
  //       exchanges: [
  //         {
  //           exchangeBaseUrl: "http://exchange.local/",
  //           ageRestrictionOptions: [],
  //           scopeInfo: undefined,
  //           currency: "ARS",
  //           exchangeEntryStatus: ExchangeEntryStatus.Used,
  //           tosStatus: ExchangeTosStatus.Pending,
  //           exchangeUpdateStatus: ExchangeUpdateStatus.Ready,
  //           paytoUris: [],
  //         },
  //       ],
  //     },
  //   );

  //   const hookBehavior = await tests.hookBehaveLikeThis(
  //     useComponentState,
  //     props,
  //     [
  //       (state) => {
  //         expect(state.status).equal("verify");
  //         if (state.status !== "verify") return;
  //         expect(state.url.value).eq("");
  //         expect(state.expectedCurrency).is.undefined;
  //         expect(state.result).is.undefined;
  //       },
  //       (state) => {
  //         expect(state.status).equal("verify");
  //         if (state.status !== "verify") return;
  //         expect(state.url.value).eq("");
  //         expect(state.expectedCurrency).is.undefined;
  //         expect(state.result).is.undefined;
  //         expect(state.error).is.undefined;
  //         expect(state.url.onInput).is.not.undefined;
  //         if (!state.url.onInput) return;
  //         state.url.onInput("http://exchange.local/");
  //       },
  //       (state) => {
  //         expect(state.status).equal("verify");
  //         if (state.status !== "verify") return;
  //         expect(state.url.value).eq("");
  //         expect(state.expectedCurrency).is.undefined;
  //         expect(state.result).is.undefined;
  //         expect(state.url.error).eq("This exchange is already active");
  //         expect(state.url.onInput).is.not.undefined;
  //       },
  //     ],
  //     TestingContext,
  //   );

  //   expect(hookBehavior).deep.equal({ result: "ok" });
  //   expect(handler.getCallingQueueState()).eq("empty");
  // });

  // it("should be able to add a preset exchange", async () => {
  //   const { handler, TestingContext } = createWalletApiMock();

  //   handler.addWalletCallResponse(
  //     WalletApiOperation.ListExchanges,
  //     {},
  //     {
  //       exchanges: [
  //         {
  //           exchangeBaseUrl: "http://exchange.local/",
  //           ageRestrictionOptions: [],
  //           scopeInfo: undefined,
  //           currency: "ARS",
  //           exchangeEntryStatus: ExchangeEntryStatus.Preset,
  //           tosStatus: ExchangeTosStatus.Pending,
  //           exchangeUpdateStatus: ExchangeUpdateStatus.Ready,
  //           paytoUris: [],
  //         },
  //       ],
  //     },
  //   );

  //   const hookBehavior = await tests.hookBehaveLikeThis(
  //     useComponentState,
  //     props,
  //     [
  //       (state) => {
  //         expect(state.status).equal("verify");
  //         if (state.status !== "verify") return;
  //         expect(state.url.value).eq("");
  //         expect(state.expectedCurrency).is.undefined;
  //         expect(state.result).is.undefined;
  //       },
  //       (state) => {
  //         expect(state.status).equal("verify");
  //         if (state.status !== "verify") return;
  //         expect(state.url.value).eq("");
  //         expect(state.expectedCurrency).is.undefined;
  //         expect(state.result).is.undefined;
  //         expect(state.error).is.undefined;
  //         expect(state.url.onInput).is.not.undefined;
  //         if (!state.url.onInput) return;
  //         state.url.onInput("http://exchange.local/");
  //       },
  //     ],
  //     TestingContext,
  //   );

  //   expect(hookBehavior).deep.equal({ result: "ok" });
  //   expect(handler.getCallingQueueState()).eq("empty");
  // });
});
