/*
   This file is part of TALER
   Copyright (C) 2025 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file exchangedb/pg_get_refresh.h
 * @brief implementation of the get_refresh function for Postgres
 * @author Özgür Kesim
 */
#ifndef PG_GET_REFRESH_H
#define PG_GET_REFRESH_H

#include "taler_util.h"
#include "taler_json_lib.h"
#include "taler_exchangedb_plugin.h"
/**
 * Lookup refresh refresh commitment data under the given @a rc.
 *
 * @param cls the `struct PostgresClosure` with the plugin-specific state
 * @param rc commitment hash to use to locate the operation
 * @param[out] refresh where to store the result; note that
 *             refresh->session.coin.denom_sig will be set to NULL
 *             and is not fetched by this routine (as it is not needed by the client)
 * @return transaction status
 */
enum GNUNET_DB_QueryStatus
TEH_PG_get_refresh (void *cls,
                    const struct TALER_RefreshCommitmentP *rc,
                    struct TALER_EXCHANGEDB_Refresh_v27 *refresh);

#endif
