/*  gnutrition - a nutrition and diet analysis program.
 *  Copyright (C) 2000 Edgar Denny (e.denny@ic.ac.uk)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

typedef struct Nutrition_s {
    gfloat total[NO_NUTR];
    gfloat pcnt_goal[NO_NUTR];
    gfloat goal[NO_NUTR];
} Nutrition_t;

typedef struct Recipe_s {
	gchar *name;
	gchar *no_serv;
	gint no_ingredients;
	gint selected_row;
	GtkCList* ingredient_clist;
	Nutrition_t *nutr;
	gchar *file_name;
} Recipe_t;

gboolean 
gnutr_read_recipe( gchar *, Recipe_t **, GList *);

gboolean 
gnutr_write_recipe( gchar *, Recipe_t *);

Recipe_t *
gnutr_ret_recipe( void);
