#!/usr/bin/env python

from gnuradio import gr, eng_notation
from gnuradio import audio
from gnuradio import usrp
from gnuradio import blks
from gnuradio.eng_option import eng_option
from optparse import OptionParser
import sys
import math

from gnuradio.wxgui import stdgui, fftsink
import wx


class wfm_rx_graph (stdgui.gui_flow_graph):
    def __init__(self,frame,panel,vbox,argv):
        stdgui.gui_flow_graph.__init__ (self,frame,panel,vbox,argv)

        IF_freq = parseargs(argv[1:])
        adc_rate = 64e6

        decim = 250
        quad_rate = adc_rate / decim               # 256 kHz
        audio_decimation = 8
        audio_rate = quad_rate / audio_decimation  # 32 kHz
        
        # usrp is data source
        src = usrp.source_c (0, decim)
        src.set_rx_freq (0, IF_freq)
        src.set_pga(0,20)

        guts = blks.wfm_rcv (self, quad_rate, audio_decimation)
        
        # sound card as final sink
        audio_sink = audio.sink (int (audio_rate))
        
        # now wire it all together
        self.connect (src, guts)
        self.connect (guts, (audio_sink, 0))

        if 1:
            pre_demod, fft_win1 = \
                       fftsink.make_fft_sink_c (self, panel, "Pre-Demodulation",
                                                512, quad_rate)
            self.connect (src, pre_demod)
            vbox.Add (fft_win1, 1, wx.EXPAND)

        if 1:
            post_deemph, fft_win3 = \
                         fftsink.make_fft_sink_f (self, panel, "With Deemph",
                                                  512, quad_rate, -60, 20)
            self.connect (guts.deemph, post_deemph)
            vbox.Add (fft_win3, 1, wx.EXPAND)

        if 1:
            post_filt, fft_win4 = \
                       fftsink.make_fft_sink_f (self, panel, "Post Filter", 
                                                512, audio_rate, -60, 20)
            self.connect (guts.audio_filter, post_filt)
            vbox.Add (fft_win4, 1, wx.EXPAND)


def parseargs (args):
    nargs = len (args)
    if nargs == 1:
        freq1 = float (args[0]) * 1e6
    else:
        sys.stderr.write ('usage: wfm_rcv freq1\n')
        sys.exit (1)

    return freq1 - 128e6

if __name__ == '__main__':
    app = stdgui.stdapp (wfm_rx_graph, "WFM RX")
    app.MainLoop ()

    # connect to RF front end
    #rf_front_end = gr.microtune_4937_eval_board ()
    #if not rf_front_end.board_present_p ():
    #    raise IOError, 'RF front end not found'

    # set front end gain
    #rf_front_end.set_AGC (300)
    # rf_front_end.get_output_freq ()
    #IF_freq = 5.75e6

    #rf_front_end.set_RF_freq (freq1)

    #fg = build_graph (IF_freq)


    #fg.start ()        # fork thread(s) and return
    #raw_input ('Press Enter to quit: ')
    #fg.stop ()

