/* -*- c++ -*- */
/*
 * Copyright 2004 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef HAVE_CONFIG_H
#include "config.h"
#endif

#include <gr_simple_framer.h>
#include <gr_simple_framer_sync.h>
#include <gr_io_signature.h>
#include <assert.h>
#include <stdexcept>


static const int BITS_PER_BYTE = 8;
static const int OVERHEAD = 6 + 10;	    // 4 bytes sync, 1 byte seqno, 1 byte cmd + 10

gr_simple_framer_sptr
gr_make_simple_framer (int payload_bytesize)
{
  return gr_simple_framer_sptr (new gr_simple_framer (payload_bytesize));
}

gr_simple_framer::gr_simple_framer (int payload_bytesize)
  : gr_block ("simple_framer",
	      gr_make_io_signature (1, 1, sizeof (unsigned char)),
	      gr_make_io_signature (1, 1, sizeof (unsigned char))),
    d_seqno (0), d_payload_bytesize (payload_bytesize),
    d_input_block_size (payload_bytesize),
    d_output_block_size (payload_bytesize + OVERHEAD)
{
  set_output_multiple (d_output_block_size);
}

int
gr_simple_framer::general_work (int noutput_items,
				gr_vector_int &ninput_items,
				gr_vector_const_void_star &input_items,
				gr_vector_void_star &output_items)
{
  const unsigned char *in = (const unsigned char *) input_items[0];
  unsigned char *out = (unsigned char *) output_items[0];

  assert (noutput_items % d_output_block_size == 0);

  int n = 0;
  int nblocks = 0;

  memset (out, 0, noutput_items);

  while (n < noutput_items){
    out[0] = (GRSF_SYNC >> 24) & 0xff;
    out[1] = (GRSF_SYNC >> 16) & 0xff;
    out[2] = (GRSF_SYNC >>  8) & 0xff;
    out[3] = (GRSF_SYNC >>  0) & 0xff;
    out[4] = d_seqno++;
    out[5] = 0;

    memcpy (&out[6], in, d_input_block_size);
    in += d_input_block_size;
    out += d_output_block_size;
    n += d_output_block_size;
    nblocks++;
  }

  assert (n == noutput_items);

  consume_each (nblocks * d_input_block_size);
  return n;
}
