/* -*- Mode: c++ -*- */
/*
 * Copyright 2001 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
/*
 *  Copyright 1997 Massachusetts Institute of Technology
 * 
 *  Permission to use, copy, modify, distribute, and sell this software and its
 *  documentation for any purpose is hereby granted without fee, provided that
 *  the above copyright notice appear in all copies and that both that
 *  copyright notice and this permission notice appear in supporting
 *  documentation, and that the name of M.I.T. not be used in advertising or
 *  publicity pertaining to distribution of the software without specific,
 *  written prior permission.  M.I.T. makes no representations about the
 *  suitability of this software for any purpose.  It is provided "as is"
 *  without express or implied warranty.
 * 
 */


#ifndef _VRDECIMATINGSIGPROC_H_
#define _VRDECIMATINGSIGPROC_H_

#include <VrHistoryProc.h>

template<class iType, class oType> 
class VrDecimatingSigProc : public VrHistoryProc<iType,oType> {
protected:
  int decimation;
public: 
  VrDecimatingSigProc() : decimation(1) {}
  VrDecimatingSigProc(int outputs) : VrHistoryProc<iType, oType>(outputs), decimation(1) {}
  VrDecimatingSigProc(int outputs, int dec) : VrHistoryProc<iType, oType>(outputs), decimation(dec) {}

  virtual void pre_initialize ();
  
  virtual int forecast(VrSampleRange output,
		       VrSampleRange inputs[]);

  virtual float averageInputUse(int n) {
    if(decimation>(int) history) return (float)history/(float)decimation;
    else return 1.0;
  }

  virtual unsigned int mapSizeUp(int i, unsigned int size);

  virtual int checkOutputSamplingFrequency(float sf) {
    if (fabs (sf - getUpstreamModuleN(0)->getSamplingFrequency()/decimation)
	> 0.001 * getUpstreamModuleN(0)->getSamplingFrequency()/decimation){
      cerr << "sf: " << sf
	   << " gsf/dec: "
	   << getUpstreamModuleN(0)->getSamplingFrequency()/decimation << endl;
      return -1;
    }
    else
      return 0;
  }

#if 0	// BAD IDEA: See below
  int work(VrSampleRange output, void *ao[], VrSampleRange inputs[], void *ai[]);
#endif

  virtual ~VrDecimatingSigProc() {}
};

template<class iType,class oType> int
VrDecimatingSigProc<iType,oType>::forecast(VrSampleRange output,
					   VrSampleRange inputs[]) {
  /* dec:1 ratio with history */
  for(unsigned int i=0;i<numberInputs;i++) {
    inputs[i].index=output.index*decimation; /* ! do not subtract history ! */
    inputs[i].size=output.size*decimation + history-1;
  }
  return 0;
}  

template<class iType,class oType> unsigned int
VrDecimatingSigProc<iType,oType>::mapSizeUp(int i, unsigned int size) {
  if(size==1) return history;
  else return size * decimation+history-1;
}

template<class iType,class oType> void 
VrDecimatingSigProc<iType,oType>::pre_initialize (){
  assert (decimation >= 1);
#if 0
  if (decimation == 1){
    fprintf (stderr, "### Warning: decimation == 1 in pre_initialize of %s.  Are you sure?\n",
	     name ());
  }
#endif
  if (getSamplingFrequency () == 0.0)
    setSamplingFrequency (getInputSamplingFrequencyN (0) / decimation);
}

#if 0
// This is now disabled, because in general, it's not possible
// to cast from iType to oType in the assignment in the body of the loop.
// The specific example that chokes some compilers is:
//   iType = float, oType = atsc_soft_data_segment
//
// This gets triggered in GrAtscFieldSyncDemux.  It's not clear to me whether
// this is a bug, or just a different interpretation of how to instantiate
// templates. 

template<class iType,class oType> int
VrDecimatingSigProc<iType,oType>::work(VrSampleRange output, void *ao[],
                                VrSampleRange inputs[], void *ai[])
{
  iType **i = (iType **)ai;
  oType **o = (oType **)ao;
  int size = output.size;

  for(int insamp=0; insamp < size*decimation; insamp += decimation)
    {
          *o[0]++ = (oType) i[0][insamp];
    }
  return output.size;
}
#endif

#endif
