#!/usr/bin/env python

import sys
import gtk
import gtk.glade

from thread import *

sys.path.append ('.')
sys.path.append ('/usr/local/gnuradio/python')
import GnuRadio

def gtk_main_quit(*args):
    m.stop()
    gtk.main_quit()

def clear_all(*args):
    txbutton.set_active(0)
    mutebutton.set_active(0)
    gainbutton.set_active(0)
    spinbutton.set_value(0)

def toggle_tx(*args):
    dds.set_tx(txbutton.get_active())

def toggle_mute(*args):
    dds.set_mute(mutebutton.get_active())

def toggle_gain(*args):
    dds.set_gain(gainbutton.get_active())

def toggle_extern(*args):
    print args

def spin_vc(*args):
    dds.set_freq(spinbutton.get_value())

dds=GnuRadio.sdr_1000()
xml = gtk.glade.XML("sdr1k_panel.glade")
xml.signal_autoconnect(locals())

window = xml.get_widget("mainwin")
txbutton = xml.get_widget("txtoggle")
mutebutton = xml.get_widget("mutebutton")
gainbutton = xml.get_widget("gainbutton")
spinbutton = xml.get_widget("spinbutton1")

m = None
mainloop = None
source = None
sink = None
magblock = None

def StartUp(repeat=0):
    global m, source, sink, mainloop
    print ("Python GnuRadio StartUp called!")
    m = GnuRadio.VrMultiTask()
    print ("Made VrMultiTask", m)
    mainloop = GnuRadio.mainloop ()
    print ("Made mainloop", mainloop)
#    source = GnuRadio.VrFileSource_char(8000, "file_in.dat", repeat)
    source = GnuRadio.GrAudioSourceC(48000, 1,1, "/dev/dsp1")
    print ("Made VrFileSource", source)
#    sink = GnuRadio.VrFileSink_char("file_out.dat")
    sink = GnuRadio.GrAudioSinkF(1,"/dev/dsp")
    print ("Made VrFileSink", sink)

    magblock = GnuRadio.GrMagnitudeCF()

    m.add(sink)
    print ("Added sink to m")
#    sink.connect_proc(source, 0)
    sink.connect_proc(magblock, 0)
    magblock.connect_proc(source, 0)
    print ("Connected source to sink")
    m.start()
    print ("Started m")
    print ("Processing m...")
    mainloop.loop (m);
    print ("Stopped m")

#start_new_thread(StartUp,(0,))
start_new_thread(gtk.main,())
#gtk.main()
StartUp()
