/* -*- Mode: c++ -*- */
/*
 * Copyright 2001 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#ifndef _GRMULTIPLY_H_
#define _GRMULTIPLY_H_

#include <VrSigProc.h>

template<class iType,class oType> 
class GrMultiply : public VrSigProc {
public: 
  virtual const char *name() { return "GrMultiply"; }
  virtual int work(VrSampleRange output, void *o[],
		   VrSampleRange inputs[], void *i[]);
  virtual void initialize() {
#if 0
    //work on 8-units blocks
    setHistory(8);
    setOutputSize(8);
#endif
  };
  GrMultiply();
};

template<class iType,class oType> int
GrMultiply<iType,oType>::work(VrSampleRange output, void *ao[],
			      VrSampleRange inputs[], void *ai[])
{
  iType **i = (iType **)ai;
  oType **o = (oType **)ao;
  int size = output.size;
  int ni = getNumberInputs();
  oType temp;

  while(size-- > 0) {
    {
        temp = *i[0]++;
        int j=1;
        while(j < ni)
          temp *= *i[j++]++;
        *o[0]++ = temp;
    }
  }
  return output.size;
}

template<class iType,class oType> 
GrMultiply<iType,oType>::GrMultiply()
  : VrSigProc(1, sizeof(iType), sizeof(oType))
{
}
#endif
