/* -*- c++ -*- */
/*
 * Copyright 2002 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _GRCOMPLEXVCOMIXER_H_
#define _GRCOMPLEXVCOMIXER_H_

#include <VrSigProc.h>

template<class iType,class oType> 
class GrComplexVCOMixer : public VrSigProc {
protected:
  double sensitivity;
  double freq;
  double arg;
  double argInc;
  void evaluate(int n);
  virtual void initialize();
public: 
  virtual const char *name() { return "GrComplexVCOMixer"; }
  virtual int work(VrSampleRange output, void *ao[],
		   VrSampleRange inputs[], void *ai[]);
  GrComplexVCOMixer(double f,double s) :VrSigProc(2,sizeof(iType),sizeof(oType)),sensitivity(s),freq(f),arg(0) { }
};

template<class iType,class oType> int
GrComplexVCOMixer<iType,oType>::work(VrSampleRange output, void *ao[],
		VrSampleRange inputs[], void *ai[])
{
  iType **i = (iType**)ai;
  oType **o = (iType**)ao;
  int size = output.size;
  while(size -- > 0) {
    *o[0]++ = (oType) (*i[0] * cos(arg));
    *o[1]++ = (oType) (*i[0]++ * sin(arg));
    arg += argInc;
    argInc =  2*M_PI*(freq + sensitivity * *i[1]++)*(1 / (double)getInputSamplingFrequencyN(0));
  }
  return output.size;
}

template<class iType,class oType> void
GrComplexVCOMixer<iType,oType>::initialize()  
{
  argInc = 2*M_PI*freq*(1 / (double)getInputSamplingFrequencyN(0));
}
#endif
