/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.ref.WeakReference;

class HighlightLine
extends Highlight {
    protected final Point2D start;
    protected final Point2D end;
    protected final Point2D center;
    protected final boolean thickLine;
    protected final WeakReference<WindowFrame> onlyThis;

    HighlightLine(Cell c, Point2D s, Point2D e, Point2D cen, boolean thick, Color col, boolean isError, WindowFrame onlyThis) {
        super(c, col, isError);
        this.start = s;
        this.end = e;
        this.center = cen;
        this.thickLine = thick;
        this.onlyThis = onlyThis != null ? new WeakReference<WindowFrame>(onlyThis) : null;
    }

    @Override
    public void showInternalHighlight(EditWindow wnd, Graphics g, int highOffX, int highOffY, boolean onlyHighlight) {
        if (this.onlyThis != null && this.onlyThis.get() != wnd.getWindowFrame()) {
            return;
        }
        Color oldColor = null;
        if (this.color != null) {
            oldColor = g.getColor();
            g.setColor(this.color);
        }
        Point2D[] points = new Point2D.Double[]{new Point2D.Double(this.start.getX(), this.start.getY()), new Point2D.Double(this.end.getX(), this.end.getY())};
        HighlightLine.drawOutlineFromPoints(wnd, g, points, highOffX, highOffY, false, this.thickLine);
        if (oldColor != null) {
            g.setColor(oldColor);
        }
    }

    @Override
    Rectangle2D getHighlightedArea(EditWindow wnd) {
        double cX = Math.min(this.start.getX(), this.end.getX());
        double cY = Math.min(this.start.getY(), this.end.getY());
        double sX = Math.abs(this.start.getX() - this.end.getX());
        double sY = Math.abs(this.start.getY() - this.end.getY());
        return new Rectangle2D.Double(cX, cY, sX, sY);
    }

    @Override
    public String getInfo() {
        String description = "Line from (" + this.start.getX() + "," + this.start.getY() + ") to (" + this.end.getX() + "," + this.end.getY() + ")";
        return description;
    }
}

