/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.project;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.project.Project;
import com.sun.electric.tool.project.ProjectCell;
import com.sun.electric.tool.project.ProjectDB;
import com.sun.electric.tool.project.ProjectLibrary;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.util.TextUtils;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class HistoryDialog
extends EDialog {
    private ProjectDB pdb = Project.projectDB;
    private Cell cell;
    private TableModel dataModel;
    private JTable table;

    public static void examineThisHistory() {
        UserInterface ui = Job.getUserInterface();
        Cell cell = ui.needCurrentCell();
        if (cell == null) {
            return;
        }
        if (Project.ensureRepository()) {
            return;
        }
        HistoryDialog.examineHistory(cell);
    }

    public static void examineHistory(Cell cell) {
        Project.pmActive = true;
        new HistoryDialog(cell);
    }

    HistoryDialog(Cell cell) {
        super((Frame)null, true);
        this.cell = cell;
        this.initComponents();
        this.setVisible(true);
    }

    @Override
    protected void escapePressed() {
        this.doButton(false);
    }

    private void doButton(boolean retrieve) {
        if (retrieve) {
            Cell exists2;
            int index = this.table.getSelectedRow();
            int version = TextUtils.atoi((String)this.dataModel.getValueAt(index, 0));
            Library lib = this.cell.getLibrary();
            ProjectLibrary pl = this.pdb.findProjectLibrary(lib);
            String cellName = this.cell.getName() + ";" + version;
            if (this.cell.getView() != View.UNKNOWN) {
                cellName = cellName + this.cell.getView().getAbbreviationExtension();
            }
            if ((exists2 = this.cell.getLibrary().findNodeProto(cellName)) != null) {
                Job.getUserInterface().showErrorMessage("Version " + version + " of cell " + this.cell.getName() + " is already in your library", "Version Retrieval Error");
                return;
            }
            ProjectCell foundPC = pl.findProjectCellByNameViewVersion(this.cell.getName(), this.cell.getView(), version);
            if (foundPC == null) {
                Job.getUserInterface().showErrorMessage("Can't find that version in the repository!", "Version Retrieval Error");
                return;
            }
            new GetOldVersionJob(this.pdb, this.cell, version);
        } else {
            this.dispose();
        }
    }

    private void initComponents() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Examine the History of " + this.cell);
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                HistoryDialog.this.doButton(false);
            }
        });
        ProjectLibrary pl = this.pdb.findProjectLibrary(this.cell.getLibrary());
        ArrayList<ProjectCell> versions = new ArrayList<ProjectCell>();
        Iterator<ProjectCell> it = pl.getProjectCells();
        while (it.hasNext()) {
            ProjectCell pc = it.next();
            if (!pc.getCellName().equals(this.cell.getName()) || pc.getView() != this.cell.getView()) continue;
            pc.setCheckInDate("Not In Repository Yet");
            versions.add(pc);
        }
        String dirName = pl.getProjectDirectory() + File.separator + this.cell.getName();
        File dir = new File(dirName);
        File[] filesInDir = dir.listFiles();
        for (int i = 0; i < filesInDir.length; ++i) {
            File subFile = filesInDir[i];
            Date modDate = new Date(subFile.lastModified());
            int version = TextUtils.atoi(subFile.getName());
            boolean found = false;
            for (ProjectCell pc : versions) {
                if (pc.getVersion() != version) continue;
                pc.setCheckInDate(TextUtils.formatDate(modDate));
                found = true;
                break;
            }
            if (found) continue;
            ProjectCell pc = new ProjectCell(null, pl);
            pc.setCheckInDate(TextUtils.formatDate(modDate));
            pc.setCellName(this.cell.getName());
            pc.setVersion(version);
            versions.add(pc);
        }
        Collections.sort(versions, new ProjectCellByVersion());
        int numVersions = versions.size();
        Object[][] data2 = new Object[numVersions][4];
        int index = 0;
        for (ProjectCell pc : versions) {
            data2[index][0] = Integer.toString(pc.getVersion());
            data2[index][1] = pc.getCheckInDate();
            data2[index][2] = pc.getLastOwner();
            if (pc.getOwner().length() > 0) {
                data2[index][2] = pc.getOwner();
            }
            data2[index][3] = pc.getComment() != null ? pc.getComment() : "";
            ++index;
        }
        this.dataModel = new HistoryTableModel(data2);
        this.table = new JTable(this.dataModel);
        TableColumn versCol = this.table.getColumnModel().getColumn(0);
        TableColumn dateCol = this.table.getColumnModel().getColumn(1);
        TableColumn userCol = this.table.getColumnModel().getColumn(2);
        TableColumn commentCol = this.table.getColumnModel().getColumn(3);
        versCol.setPreferredWidth(10);
        dateCol.setPreferredWidth(30);
        userCol.setPreferredWidth(20);
        commentCol.setPreferredWidth(40);
        JScrollPane tableScrollPane = new JScrollPane(this.table);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)tableScrollPane, gbc);
        JButton ok = new JButton("Retrieve");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 10;
        gbc.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)ok, gbc);
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryDialog.this.doButton(true);
            }
        });
        JButton cancel = new JButton("Done");
        this.getRootPane().setDefaultButton(cancel);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 10;
        gbc.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)cancel, gbc);
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryDialog.this.doButton(false);
            }
        });
        this.pack();
    }

    private static class ProjectCellByVersion
    implements Comparator<ProjectCell> {
        private ProjectCellByVersion() {
        }

        @Override
        public int compare(ProjectCell pc1, ProjectCell pc2) {
            return pc2.getVersion() - pc1.getVersion();
        }
    }

    private static class GetOldVersionJob
    extends Job {
        private ProjectDB pdb;
        private Cell cell;
        private int version;

        private GetOldVersionJob(ProjectDB pdb, Cell cell, int version) {
            super("Update " + cell, Project.getProjectTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.pdb = pdb;
            this.cell = cell;
            this.version = version;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            EditingPreferences ep = this.getEditingPreferences();
            Project.setChangeStatus(true);
            Library lib = this.cell.getLibrary();
            ProjectLibrary pl = this.pdb.findProjectLibrary(lib);
            ProjectCell foundPC = pl.findProjectCellByNameViewVersion(this.cell.getName(), this.cell.getView(), this.version);
            Project.getCellFromRepository(this.pdb, foundPC, lib, false, false, ep);
            if (foundPC.getCell() == null) {
                Project.setChangeStatus(false);
                throw new JobException("Error retrieving old version of cell");
            }
            Project.markLocked(foundPC.getCell(), false, ep);
            Project.setChangeStatus(false);
            System.out.println("Cell " + foundPC.getCell().describe(true) + " is now in this library");
            this.fieldVariableChanged("pdb");
            return true;
        }

        @Override
        public void terminateOK() {
            Project.projectDB = this.pdb;
            WindowFrame.wantToRedoLibraryTree();
        }
    }

    class HistoryTableModel
    extends AbstractTableModel {
        private String[] columnNames;
        private Object[][] data;

        HistoryTableModel(Object[][] data2) {
            this.data = data2;
            this.columnNames = new String[]{"Version", "Date", "Who", "Comments"};
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }

        @Override
        public Class<?> getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }
    }
}

