# Examples in C

This directory contains simple examples of Bison grammar files in C.

Some of them come from the documentation, which should be installed together
with Bison.  The URLs are provided for convenience.

## rpcalc - Reverse Polish Notation Calculator
The first example is that of a simple double-precision Reverse Polish
Notation calculator (a calculator using postfix operators). This example
provides a good starting point, since operator precedence is not an issue.

Extracted from the documentation: "Reverse Polish Notation Calculator"
https://www.gnu.org/software/bison/manual/html_node/RPN-Calc.html

## calc - Simple Calculator
This example is slightly more complex than rpcalc: it features infix
operators (`1 + 2`, instead of `1 2 +` in rpcalc), but it does so using a
unambiguous grammar of the arithmetic instead of using precedence
directives (%left, etc.).

## mfcalc - Multi-Function Calculator
A more complete C example: a multi-function calculator.  More complex than
the previous example.  Using precedence directives to support infix
operators.

Extracted from the documentation: "Multi-Function Calculator: mfcalc".
https://www.gnu.org/software/bison/manual/html_node/Multi_002dfunction-Calc.html

## lexcalc - calculator with Flex and Bison
The calculator, redux.  This time using a scanner generated by Flex.

## reccalc - recursive calculator with Flex and Bison
The example builds on top of the previous one to provide a reentrant parser.
Such parsers can be called concurrently in different threads, or even
recursively.  To demonstrate this feature, expressions in parentheses are
tokenized as strings, and then recursively parsed from the parser.  So
`(((1)+(2))*((3)+(4)))` uses eight parsers, with a depth of four.


<!---

Local Variables:
fill-column: 76
ispell-dictionary: "american"
End:

Copyright (C) 2018-2020 Free Software Foundation, Inc.

Permission is granted to copy, distribute and/or modify this document
under the terms of the GNU Free Documentation License, Version 1.3 or
any later version published by the Free Software Foundation; with no
Invariant Sections, with no Front-Cover Texts, and with no Back-Cover
Texts.  A copy of the license is included in the "GNU Free
Documentation License" file as part of this distribution.

# LocalWords:  mfcalc calc parsers yy rpcalc lexcalc redux reccalc ispell
# LocalWords:  reentrant tokenized american postfix
--->
