#include <stdio.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk/gdkkeysyms.h>
#include <glib.h>
#include <string.h>
#include "gtkcombobox.h"
#include "gtkbordercombo.h"
#include "gtkcolorcombo.h"
#include "gtksheet.h"
#include "gtksheetentry.h"

#define DEFAULT_PRESICION 3
#define DEFAULT_SPACE 8

GtkWidget *window;
GtkWidget *main_vbox;
GtkWidget *notebook;
GtkWidget **sheets;
GtkWidget *show_hide_box;
GtkWidget *status_box;
GtkWidget *location;
GtkWidget *entry;
GtkWidget *fgcolorcombo;
GtkWidget *bgcolorcombo;
GtkWidget *bordercombo;
GdkPixmap *pixmap;
GdkBitmap *mask;
GtkWidget *bg_pixmap;
GtkWidget *fg_pixmap;
GtkWidget *toolbar;
GtkWidget *left_button;
GtkWidget *center_button;
GtkWidget *right_button;
GtkWidget *tpixmap;


void
quit ()
{
  gtk_main_quit();
}

static void
popup_activated(GtkWidget *widget, gpointer data)
{
 GtkSheet *sheet;
 gint cur_page;
 gchar *item;

 cur_page = gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook));
 sheet=GTK_SHEET(sheets[cur_page]);

 item = (gchar *)data;

 if(strcmp(item,"Add Column")==0)
   gtk_sheet_add_column(sheet,1);

 if(strcmp(item,"Add Row")==0)
   gtk_sheet_add_row(sheet,1);

 if(strcmp(item,"Insert Row")==0){
   if(sheet->state==GTK_SHEET_ROW_SELECTED)
     gtk_sheet_insert_rows(sheet,sheet->range.row0,                       
                               sheet->range.rowi-sheet->range.row0+1);
 }

 if(strcmp(item,"Insert Column")==0){
   if(sheet->state==GTK_SHEET_COLUMN_SELECTED)
     gtk_sheet_insert_columns(sheet,sheet->range.col0,                       
                              sheet->range.coli-sheet->range.col0+1);

 } 

 if(strcmp(item,"Delete Row")==0){
   if(sheet->state==GTK_SHEET_ROW_SELECTED)
     gtk_sheet_delete_rows(sheet,sheet->range.row0,
                              sheet->range.rowi-sheet->range.row0+1);
 }

 if(strcmp(item,"Delete Column")==0){
   if(sheet->state==GTK_SHEET_COLUMN_SELECTED)
     gtk_sheet_delete_columns(sheet,sheet->range.col0,
                              sheet->range.coli-sheet->range.col0+1);   
 } 

 if(strcmp(item,"Clear Cells")==0){
   if(sheet->state!=GTK_SHEET_NORMAL)
     gtk_sheet_range_clear(sheet, &sheet->range);
 } 

}

static GtkWidget *
build_menu(GtkWidget *sheet)
{
	static char *items[]={
		"Add Column",
		"Add Row",
		"Insert Row",
		"Insert Column",
		"Delete Row",
                "Delete Column",
                "Clear Cells"
	};
	GtkWidget *menu;
	GtkWidget *item;
	int i;

	menu=gtk_menu_new();

	for (i=0; i < (sizeof(items)/sizeof(items[0])) ; i++){
	 	item=gtk_menu_item_new_with_label(items[i]);
	 	gtk_signal_connect(GTK_OBJECT(item),"activate",
				   (GtkSignalFunc) popup_activated,
				   items[i]);
                GTK_WIDGET_SET_FLAGS (item, GTK_SENSITIVE | GTK_CAN_FOCUS);
                switch(i){
                  case 2:
                    if(GTK_SHEET(sheet)->state!=GTK_SHEET_ROW_SELECTED)
                     GTK_WIDGET_UNSET_FLAGS (item, 
                                            GTK_SENSITIVE | GTK_CAN_FOCUS);
                    break;
                  case 3:
                    if(GTK_SHEET(sheet)->state!=GTK_SHEET_COLUMN_SELECTED)
                     GTK_WIDGET_UNSET_FLAGS (item, 
                                            GTK_SENSITIVE | GTK_CAN_FOCUS);
                    break;
                  case 4:
                    if(GTK_SHEET(sheet)->state!=GTK_SHEET_ROW_SELECTED)
                     GTK_WIDGET_UNSET_FLAGS (item, 
                                            GTK_SENSITIVE | GTK_CAN_FOCUS);
                    break;
                  case 5:
                    if(GTK_SHEET(sheet)->state!=GTK_SHEET_COLUMN_SELECTED)
                     GTK_WIDGET_UNSET_FLAGS (item, 
                                            GTK_SENSITIVE | GTK_CAN_FOCUS);
                    break;
                } 

		gtk_widget_show(item);
	    	gtk_menu_append(GTK_MENU(menu),item);
	}

	return menu;
}

void
do_popup(GtkWidget *widget, GdkEventButton *event, gpointer data)
{
   static GtkWidget *popup;
   GdkModifierType mods;
   GtkWidget *sheet;

   sheet=GTK_WIDGET(widget);

   gdk_window_get_pointer (sheet->window, NULL, NULL, &mods);
   if(mods&GDK_BUTTON3_MASK){ 

    if(popup)
       g_free(popup);

    popup=build_menu(sheet);

    gtk_menu_popup(GTK_MENU(popup), NULL, NULL, NULL, NULL,
		   event->button, event->time);
   }
}

void
format_text (GtkSheet *sheet, int *justification, gchar *text, char *label)
{
  double auxval;
  int digspace=0;
  int cell_width, char_width;
  double val;
  int format;
  double space;
  int intspace;
  int nonzero=FALSE;
  int ipos;
  char nchar;
  enum {EMPTY, TEXT, NUMERIC};

  cell_width=sheet->column[sheet->active_cell.col].width;
  char_width = gdk_char_width (GTK_WIDGET(sheet)->style->font,(gchar)'X');
  space= (double)cell_width/(double)char_width;

  intspace=MIN(space, DEFAULT_SPACE);

  format=EMPTY;
  if(strlen(text) != 0)
  { 
        for(ipos=0; ipos<strlen(text); ipos++){

          switch(nchar=text[ipos]){
           case '.':
           case ' ': case ',':
           case '-': case '+':
           case 'd': case 'D':
           case 'E': case 'e':
           case '1': case '2': case '3': case '4': case '5': case '6':
           case '7': case '8': case '9':
            nonzero=TRUE;
            break;
           case '0':
            break;
           default:
            format=TEXT;
          }
          if(format != EMPTY) break;
        }
        val=atof(text);
        if(format!=EMPTY || (val==0. && nonzero))
             format = TEXT;
        else
             format = NUMERIC;
  }

  switch(format){
    case TEXT:
    case EMPTY:
      strcpy(label, text);
      return;
    case NUMERIC:
      val=atof(text);
      *justification = GTK_JUSTIFY_RIGHT;
  }

  auxval= val < 0 ? -val : val;

  while(auxval<1 && auxval != 0.){
   auxval=auxval*10.;
   digspace+=1;
  }

  if(digspace+DEFAULT_PRESICION+1>intspace || digspace > DEFAULT_PRESICION){
    sprintf (label, "%*.*E", intspace, DEFAULT_PRESICION, val);
  }
  else
    {
    intspace=MIN(intspace, strlen(text)-digspace-1);
    sprintf (label, "%*.*f", intspace, DEFAULT_PRESICION, val);
    if(strlen(label) > space)
      sprintf (label, "%*.*E", intspace, DEFAULT_PRESICION, val);
  }
}

void
parse_numbers(GtkWidget *widget, gpointer data)
{
 GtkSheet *sheet;
 char label[400];
 int justification;

 sheet=GTK_SHEET(widget);

 justification = GTK_SHENTRY(sheet->sheet_entry)->justification;
 format_text(sheet, &justification,
	     gtk_entry_get_text(GTK_ENTRY(sheet->sheet_entry)), label);

 gtk_sheet_set_cell(sheet, sheet->active_cell.row,
			   sheet->active_cell.col,
                           justification, label); 

}

void
clipboard_handler(GtkWidget *widget, GdkEventKey *key)
{
  GtkSheet *sheet;

  sheet = GTK_SHEET(widget);

  if(key->state & GDK_CONTROL_MASK || key->keyval==GDK_Control_L ||
     key->keyval==GDK_Control_R){
    if((key->keyval=='c' || key->keyval == 'C') && sheet->state != GTK_STATE_NORMAL){
            if(GTK_SHEET_IN_CLIP(sheet)) gtk_sheet_unclip_range(sheet);
            gtk_sheet_clip_range(sheet, sheet->range);
    }
    if(key->keyval=='x' || key->keyval == 'X')
            gtk_sheet_unclip_range(sheet);    
  }
}

void 
resize_handler(GtkWidget *widget, GtkSheetRange *old_range, 
                                  GtkSheetRange *new_range, 
                                  gpointer data)
{
  printf("OLD SELECTION: %d %d %d %d\n",old_range->row0, old_range->col0,
                                    old_range->rowi, old_range->coli);
  printf("NEW SELECTION: %d %d %d %d\n",new_range->row0, new_range->col0,
                                    new_range->rowi, new_range->coli);


}

void 
move_handler(GtkWidget *widget, GtkSheetRange *old_range, 
                                  GtkSheetRange *new_range, 
                                  gpointer data)
{
  printf("OLD SELECTION: %d %d %d %d\n",old_range->row0, old_range->col0,
                                    old_range->rowi, old_range->coli);
  printf("NEW SELECTION: %d %d %d %d\n",new_range->row0, new_range->col0,
                                    new_range->rowi, new_range->coli);


}

void alarm_change(GtkWidget *widget, gint row, gint col, gpointer data)
{
 printf("CHANGE CELL: %d %d\n",row,col);
}
void alarm_activate(GtkWidget *widget, gint row, gint col, gpointer data)
{
 printf("ACTIVATE CELL: %d %d\n",row,col);
}
void alarm_deactivate(GtkWidget *widget, gint row, gint col, gpointer data)
{
 printf("DEACTIVATE CELL: %d %d\n",row,col);
}
gint alarm_traverse(GtkWidget *widget, gint row, gint col, gint new_row, gint new_col,
gpointer data)
{
 printf("TRAVERSE: %d %d %d %d\n",row,col,new_row,new_col);
 return TRUE;
}

void
build_example1(GtkWidget *widget)
{
 GtkSheet *sheet;
 GtkSheetRange range;
 GdkColor color;
 GdkFont *font;
 gchar font_name1[]="-bitstream-charter-bold-r-normal--36-360-72-72-p-0-iso8859-1";
 gchar font_name2[]="-bitstream-charter-bold-r-normal--28-280-72-72-p-0-iso8859-1";
 gchar font_name3[]="-bitstream-charter-bold-r-normal--20-200-72-72-p-0-iso8859-1";
 gchar font_name4[]="-bitstream-charter-bold-r-normal--20-200-72-72-p-0-iso8859-1";

 gchar name[10];
 gint i;

 sheet=GTK_SHEET(widget);

 for(i=0; i<=sheet->maxcol; i++){
   name[0]='A'+i;
   name[1]='\0';
   gtk_sheet_column_button_add_label(sheet, i, name);
   gtk_sheet_set_column_title(sheet, i, name);
 }

 range.row0=1;
 range.rowi=2;
 range.col0=1;
 range.coli=3;

 gtk_sheet_clip_range(sheet, range);

 font=gdk_font_load(font_name2);
 if(!font)
   g_warning ("Couldn't load %s", font_name2);
 else
   gtk_sheet_range_set_font(sheet, range, font);

 gdk_color_parse("red", &color);
 gdk_color_alloc(gtk_widget_get_colormap(widget), &color);
 gtk_sheet_range_set_foreground(sheet, range, &color);

 gtk_sheet_set_cell(sheet, 1,2, GTK_JUSTIFY_CENTER,
                    "Welcome to");

 range.row0=2;

 font=gdk_font_load(font_name1);
 if(!font)
   g_warning ("Couldn't load %s", font_name1);
 else
   gtk_sheet_range_set_font(sheet, range, font);

 gdk_color_parse("blue", &color);
 gdk_color_alloc(gtk_widget_get_colormap(widget), &color);
 gtk_sheet_range_set_foreground(sheet, range, &color);

 gtk_sheet_set_cell(sheet, 2,2, GTK_JUSTIFY_CENTER,
                    "GtkSheet");

 range.row0=3;
 range.rowi=3;
 range.col0=0;
 range.coli=4;
 gdk_color_parse("dark gray", &color);
 gdk_color_alloc(gtk_widget_get_colormap(widget), &color);
 gtk_sheet_range_set_background(sheet, range, &color);
 gdk_color_parse("green", &color);
 gdk_color_alloc(gtk_widget_get_colormap(widget), &color);
 gtk_sheet_range_set_foreground(sheet, range, &color);

 font=gdk_font_load(font_name3);
 if(!font)
   g_warning ("Couldn't load %s", font_name3);
 else
   gtk_sheet_range_set_font(sheet, range, font);
 
 gtk_sheet_set_cell(sheet,3,2,GTK_JUSTIFY_CENTER,
      "a Matrix widget for Gtk+");

 range.row0=4;
 range.rowi=11;
 range.col0=0;
 range.coli=10;

 font=gdk_font_load(font_name4);
 if(!font)
   g_warning ("Couldn't load %s", font_name4);
 else
   gtk_sheet_range_set_font(sheet, range, font);

 gtk_sheet_set_cell(sheet,4,0,GTK_JUSTIFY_LEFT,
"GtkSheet is a matrix where you can allocate cells of text.");
 gtk_sheet_set_cell(sheet,5,0,GTK_JUSTIFY_LEFT,
"Cell contents can be edited interactively with an specially designed entry");
 gtk_sheet_set_cell(sheet,6,0,GTK_JUSTIFY_LEFT,
"You can change width, height, background color, foreground color, border");
 gtk_sheet_set_cell(sheet,7,0,GTK_JUSTIFY_LEFT,
"color, border style, and many other attributes.");
 gtk_sheet_set_cell(sheet, 8,0, GTK_JUSTIFY_LEFT,
                    "You can drag & drop the selection");
 gtk_sheet_set_cell(sheet, 9,0, GTK_JUSTIFY_LEFT,
                    "and resize it clicking the right-bottom corner");
 gtk_sheet_set_cell(sheet, 10,0, GTK_JUSTIFY_LEFT,
                    "Store the selection on the clipboard pressing Ctrl-C");
 gtk_sheet_set_cell(sheet, 11,0, GTK_JUSTIFY_LEFT,
                    "(The selection handler has not been implemented yet)");



 gtk_signal_connect(GTK_OBJECT(sheet),
                    "key_press_event",
                    (GtkSignalFunc) clipboard_handler, 
                    NULL);

 gtk_signal_connect(GTK_OBJECT(sheet),
                    "resize_range",
                    (GtkSignalFunc) resize_handler, 
                    NULL);

 gtk_signal_connect(GTK_OBJECT(sheet),
                    "move_range",
                    (GtkSignalFunc) move_handler, 
                    NULL);
/*
 gtk_signal_connect(GTK_OBJECT(sheet),
                    "changed",
                    (GtkSignalFunc) alarm_change, 
                    NULL);
 gtk_signal_connect(GTK_OBJECT(sheet),
                    "activate_cell",
                    (GtkSignalFunc) alarm_activate, 
                    NULL);
 gtk_signal_connect(GTK_OBJECT(sheet),
                    "deactivate_cell",
                    (GtkSignalFunc) alarm_deactivate, 
                    NULL);
*/
 gtk_signal_connect(GTK_OBJECT(sheet),
                    "traverse",
                    (GtkSignalFunc) alarm_traverse, 
                    NULL);

/*
 gtk_sheet_change_entry(sheet, gtk_combo_get_type()); 
*/
}


void
build_example2(GtkWidget *widget)
{
 GtkSheet *sheet;
 GtkSheetRange range;
 GdkColor color;
 
 sheet=GTK_SHEET(widget);

 range.row0=0;
 range.rowi=2;
 range.col0=0;
 range.coli=sheet->maxcol;
 gtk_sheet_range_set_editable(sheet, range, FALSE);
 gdk_color_parse("light gray", &color);
 gdk_color_alloc(gtk_widget_get_colormap(widget), &color);
 gtk_sheet_range_set_background(sheet, range, &color);
 gdk_color_parse("blue", &color);
 gdk_color_alloc(gtk_widget_get_colormap(widget), &color);
 gtk_sheet_range_set_foreground(sheet, range, &color);
 range.row0=1;
 gdk_color_parse("red", &color);
 gdk_color_alloc(gtk_widget_get_colormap(widget), &color);
 gtk_sheet_range_set_foreground(sheet, range, &color);
 range.row0=2;
 gdk_color_parse("black", &color);
 gdk_color_alloc(gtk_widget_get_colormap(widget), &color);
 gtk_sheet_range_set_foreground(sheet, range, &color);

 gtk_sheet_row_set_sensitivity(sheet, 0, FALSE);
 gtk_sheet_row_set_sensitivity(sheet, 1, FALSE);
 gtk_sheet_row_set_sensitivity(sheet, 2, FALSE);
 gtk_sheet_set_cell(sheet, 0,2, GTK_JUSTIFY_CENTER,
                    "Click the right mouse button to display a popup");
 gtk_sheet_set_cell(sheet, 1,2, GTK_JUSTIFY_CENTER,
                    "You can connect a parser to the 'set cell' signal");
 gtk_sheet_set_cell(sheet, 2,2, GTK_JUSTIFY_CENTER,
                    "(Try typing numbers)");
 gtk_sheet_set_active_cell(sheet, 3, 0);

 gtk_sheet_set_update_policy(sheet, GTK_UPDATE_CONTINUOUS, GTK_UPDATE_CONTINUOUS);
 gtk_signal_connect(GTK_OBJECT(sheet),
                    "button_press_event",
                    (GtkSignalFunc) do_popup, 
                    NULL);

 gtk_signal_connect(GTK_OBJECT(sheet),
	            "set_cell",
		    (GtkSignalFunc) parse_numbers,
                    NULL);                   
}

void
build_example3(GtkWidget *widget)
{
 GtkSheet *sheet;
 GtkSheetRange range;
 GdkColor color;
 
 sheet=GTK_SHEET(widget);

 range.row0=0;
 range.rowi=10;
 range.col0=0;
 range.coli=6;
 gdk_color_parse("orange", &color);
 gdk_color_alloc(gtk_widget_get_colormap(widget), &color);
 gtk_sheet_range_set_background(sheet, range, &color);
 gdk_color_parse("violet", &color);
 gdk_color_alloc(gtk_widget_get_colormap(widget), &color);
 gtk_sheet_range_set_foreground(sheet, range, &color);
 range.row0=1;
 gdk_color_parse("blue", &color);
 gdk_color_alloc(gtk_widget_get_colormap(widget), &color);
 gtk_sheet_range_set_background(sheet, range, &color);
 range.coli=0;
 gdk_color_parse("dark green", &color);
 gdk_color_alloc(gtk_widget_get_colormap(widget), &color);
 gtk_sheet_range_set_background(sheet, range, &color);

 range.row0=0; 
 gdk_color_parse("dark blue", &color);
 gdk_color_alloc(gtk_widget_get_colormap(widget), &color);
 gtk_sheet_range_set_border_color(sheet, range, &color);
 gtk_sheet_range_set_border(sheet, range, GTK_SHEET_RIGHT_BORDER, 4, 1);
 range.coli=0;
 range.col0=0;
 range.rowi=0;
 gdk_color_parse("red", &color);
 gdk_color_alloc(gtk_widget_get_colormap(widget), &color);
 gtk_sheet_range_set_background(sheet, range, &color);
 gtk_sheet_range_set_border(sheet, range, GTK_SHEET_RIGHT_BORDER|
                                          GTK_SHEET_BOTTOM_BORDER, 4, 0);
 range.rowi=0;
 range.col0=1;
 range.coli=6;
 gdk_color_parse("dark blue", &color);
 gdk_color_alloc(gtk_widget_get_colormap(widget), &color);
 gtk_sheet_range_set_border_color(sheet, range, &color);
 gtk_sheet_range_set_border(sheet, range, GTK_SHEET_BOTTOM_BORDER, 4, 1);

 GTK_SHEET_SET_FLAGS(sheet, GTK_SHEET_AUTORESIZE);

 gtk_sheet_change_entry(sheet, gtk_combo_get_type());

}

void
set_cell(GtkWidget *widget, gchar *insert, gint text_legth, gint position, 
         gpointer data)
{
  char *text;
  GtkEntry *sheet_entry;

  sheet_entry = GTK_ENTRY(gtk_sheet_get_entry(GTK_SHEET(widget)));

  if((text = gtk_entry_get_text (sheet_entry))) {
                          gtk_entry_set_text(GTK_ENTRY(entry), text);
  }
  GTK_WIDGET_UNSET_FLAGS(entry, GTK_HAS_FOCUS);
  GTK_WIDGET_SET_FLAGS(GTK_SHEET(widget)->sheet_entry, GTK_HAS_FOCUS);
} 

void
show_sheet_entry(GtkWidget *widget, gpointer data)
{
 char *text;
 GtkSheet *sheet;
 GtkEntry *sheet_entry;

 if(!GTK_WIDGET_HAS_FOCUS(widget)) return;

 sheet = GTK_SHEET(GTK_NOTEBOOK(notebook)->cur_page->child);
 sheet_entry = GTK_ENTRY(gtk_sheet_get_entry(sheet));

 if((text=gtk_entry_get_text (GTK_ENTRY(entry)))){
   gtk_entry_set_text(sheet_entry, text);
 }
}

void 
activate_sheet_entry(GtkWidget *widget, gpointer data)
{
  GtkSheet *sheet;
  GtkEntry *sheet_entry;
  gint row, col;
  gint justification=GTK_JUSTIFY_LEFT;
  

  sheet=GTK_SHEET(GTK_NOTEBOOK(notebook)->cur_page->child);
  row=sheet->active_cell.row; col=sheet->active_cell.col;

  sheet_entry = GTK_ENTRY(gtk_sheet_get_entry(sheet));

  if(GTK_IS_SHENTRY(sheet_entry))
         justification = GTK_SHENTRY(sheet_entry)->justification;

  gtk_sheet_set_cell(sheet, row, col,
		     justification,
		     gtk_entry_get_text (sheet_entry));

}

void 
show_entry(GtkWidget *widget, gpointer data)
{
 char *text; 
 GtkSheet *sheet;
 GtkWidget * sheet_entry;

 if(!GTK_WIDGET_HAS_FOCUS(widget)) return;

 sheet = GTK_SHEET(GTK_NOTEBOOK(notebook)->cur_page->child);
 sheet_entry = gtk_sheet_get_entry(sheet);

 if((text=gtk_entry_get_text (GTK_ENTRY(sheet_entry))))
			  gtk_entry_set_text(GTK_ENTRY(entry), text);

}

void 
justify_left(GtkWidget *widget)
{
  GtkSheet *current;
  gint cur_page;

  cur_page=gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook));
  current=GTK_SHEET(sheets[cur_page]);

  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(left_button),
  GTK_STATE_ACTIVE);
  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(right_button),
  GTK_STATE_NORMAL);
  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(center_button),
  GTK_STATE_NORMAL);

  gtk_sheet_range_set_justification(current, current->range,
  GTK_JUSTIFY_LEFT);
}

void 
justify_center(GtkWidget *widget) 
{
  GtkSheet *current;
  gint cur_page;

  cur_page=gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook));
  current=GTK_SHEET(sheets[cur_page]);

  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(center_button),
  GTK_STATE_ACTIVE);
  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(right_button),
  GTK_STATE_NORMAL);
  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(left_button),
  GTK_STATE_NORMAL);

  gtk_sheet_range_set_justification(current, current->range,
  GTK_JUSTIFY_CENTER);
}

void 
justify_right(GtkWidget *widget) 
{
  GtkSheet *current;
  gint cur_page;

  cur_page=gtk_notebook_current_page(GTK_NOTEBOOK(notebook));
  current=GTK_SHEET(sheets[cur_page]);

  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(right_button),
  GTK_STATE_ACTIVE);
  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(left_button),
  GTK_STATE_NORMAL);
  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(center_button),
  GTK_STATE_NORMAL);

  gtk_sheet_range_set_justification(current, current->range,
  GTK_JUSTIFY_RIGHT);
}

void
activate_sheet_cell(GtkWidget *widget, gint row, gint column, gpointer data) 
{
  GtkSheet *sheet;
  GtkEntry *sheet_entry;
  char cell[100];
  char *text;
  GtkSheetCellAttr attributes;

  sheet=GTK_SHEET(widget);
  sheet_entry = GTK_ENTRY(gtk_sheet_get_entry(sheet));

  if(GTK_SHEET(widget)->column[column].name)
   sprintf(cell,"  %s:%d  ",GTK_SHEET(widget)->column[column].name, row);
  else
   sprintf(cell, " ROW: %d COLUMN: %d ", row, column);

  gtk_label_set(GTK_LABEL(location), cell);

  gtk_entry_set_max_length(GTK_ENTRY(entry),
	GTK_ENTRY(sheet_entry)->text_max_length);

  if((text=gtk_entry_get_text(GTK_ENTRY(gtk_sheet_get_entry(sheet)))))
			  gtk_entry_set_text(GTK_ENTRY(entry), text);
  else
			  gtk_entry_set_text(GTK_ENTRY(entry), "");

  gtk_sheet_get_attributes(sheet,sheet->active_cell.row,
				sheet->active_cell.col, &attributes);

  gtk_entry_set_editable(GTK_ENTRY(entry), attributes.is_editable);

  switch (attributes.justification){
    case GTK_JUSTIFY_LEFT:
         justify_left(NULL);
	 break;
    case GTK_JUSTIFY_CENTER:
         justify_center(NULL);
	 break;
    case GTK_JUSTIFY_RIGHT:
         justify_right(NULL);
	 break;
    default:
         justify_left(NULL);
	 break;
  }
}

void 
change_border (GtkWidget *widget, gint border)
{
   GtkSheet *current;
   gint cur_page;
   GtkSheetRange range, auxrange;
   gint border_mask, border_width=3;
   gint auxcol, auxrow;
   gint i,j;

   cur_page=gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook));
   current=GTK_SHEET(sheets[cur_page]);

   range=current->range;

   gtk_sheet_range_set_border(current, range, 0, 0, 0);

   switch(border){
     case 0:
       break;
     case 1:
       border_mask = GTK_SHEET_TOP_BORDER;
       range.rowi = range.row0;
       gtk_sheet_range_set_border(current, range, border_mask, border_width, 0);
       break;
     case 2:
       border_mask = GTK_SHEET_BOTTOM_BORDER;
       range.row0 = range.rowi;
       gtk_sheet_range_set_border(current, range, border_mask, border_width, 0);
       break;
     case 3:
       border_mask = GTK_SHEET_RIGHT_BORDER;
       range.col0 = range.coli;
       gtk_sheet_range_set_border(current, range, border_mask, border_width, 0);
       break;
     case 4:
       border_mask = GTK_SHEET_LEFT_BORDER;
       range.coli = range.col0;
       gtk_sheet_range_set_border(current, range, border_mask, border_width, 0);
       break;
     case 5:
       if(range.col0 == range.coli){
	   border_mask = GTK_SHEET_LEFT_BORDER | GTK_SHEET_RIGHT_BORDER;
	   gtk_sheet_range_set_border(current, range, border_mask, border_width, 0);
           break;
	}
       border_mask = GTK_SHEET_LEFT_BORDER;
       auxcol=range.coli;
       range.coli = range.col0;
       gtk_sheet_range_set_border(current, range, border_mask, border_width, 0);
       border_mask = GTK_SHEET_RIGHT_BORDER;
       range.col0 = range.coli=auxcol; 
       gtk_sheet_range_set_border(current,range, border_mask, border_width, 0);
       break;
     case 6:
       if(range.row0 == range.rowi){
	   border_mask = GTK_SHEET_TOP_BORDER | GTK_SHEET_BOTTOM_BORDER;
	   gtk_sheet_range_set_border(current, range, border_mask, border_width, 0);
           break;
	}
       border_mask = GTK_SHEET_TOP_BORDER;
       auxrow=range.rowi;
       range.rowi = range.row0;
       gtk_sheet_range_set_border(current, range, border_mask, border_width, 0);
       border_mask = GTK_SHEET_BOTTOM_BORDER;
       range.row0=range.rowi=auxrow; 
       gtk_sheet_range_set_border(current, range, border_mask, border_width, 0);
       break;
     case 7:
       border_mask = GTK_SHEET_RIGHT_BORDER | GTK_SHEET_LEFT_BORDER;
       gtk_sheet_range_set_border(current, range, border_mask, border_width, 0);
       break;
     case 8:
       border_mask = GTK_SHEET_BOTTOM_BORDER | GTK_SHEET_TOP_BORDER;
       gtk_sheet_range_set_border(current, range, border_mask, border_width, 0);
       break;
     case 9:
       gtk_sheet_range_set_border(current, range, 15, border_width, 0);
       for(i=range.row0; i<=range.rowi; i++)
        for(j=range.col0; j<=range.coli; j++){
          border_mask = 15;
          auxrange.row0 = i;
          auxrange.rowi = i;
          auxrange.col0 = j;
          auxrange.coli = j;
          if(i == range.rowi) border_mask ^= GTK_SHEET_BOTTOM_BORDER;
          if(i == range.row0) border_mask ^= GTK_SHEET_TOP_BORDER;
          if(j == range.coli) border_mask ^= GTK_SHEET_RIGHT_BORDER;
          if(j == range.col0) border_mask ^= GTK_SHEET_LEFT_BORDER;
          if(border_mask != 15)
            gtk_sheet_range_set_border(current, auxrange, border_mask, 
                                       border_width, 0);
       }

       break;
     case 10:
       for(i=range.row0; i<=range.rowi; i++)
        for(j=range.col0; j<=range.coli; j++){
          border_mask = 0;
          auxrange.row0 = i;
          auxrange.rowi = i;
          auxrange.col0 = j;
          auxrange.coli = j;
          if(i == range.rowi) border_mask |= GTK_SHEET_BOTTOM_BORDER;
          if(i == range.row0) border_mask |= GTK_SHEET_TOP_BORDER;
          if(j == range.coli) border_mask |= GTK_SHEET_RIGHT_BORDER;
          if(j == range.col0) border_mask |= GTK_SHEET_LEFT_BORDER;
          if(border_mask != 0)
            gtk_sheet_range_set_border(current, auxrange, border_mask, 
                                       border_width, 0);
       }

       break;
     case 11:
       border_mask = 15;
       gtk_sheet_range_set_border(current, range, border_mask, border_width, 0);
       break;


   }

}


void 
change_fg(GtkWidget *widget, gint i, gchar *color_name)
{
   GtkSheet *current;
   GdkColor color;
   gint cur_page;
   GdkGC *tmp_gc;

   cur_page=gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook));
   current=GTK_SHEET(sheets[cur_page]);

   gdk_color_parse(color_name, &color);
   gdk_color_alloc(gtk_widget_get_colormap(widget), &color);
   gtk_sheet_range_set_foreground(current, current->range, &color);

   tmp_gc=gdk_gc_new(window->window);
   gdk_gc_set_foreground(tmp_gc,&color);
   gdk_draw_rectangle(GTK_PIXMAP(fg_pixmap)->pixmap,
		      tmp_gc, TRUE, 5,20,16,4);
   gtk_widget_queue_draw(fg_pixmap); gdk_gc_unref(tmp_gc);
}

void 
change_bg(GtkWidget *widget, gint i, gchar *color_name)
{
   GtkSheet *current;
   GdkColor color;
   gint cur_page;
   GdkGC *tmp_gc;

   cur_page=gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook));
   current=GTK_SHEET(sheets[cur_page]);

   gdk_color_parse(color_name, &color);
   gdk_color_alloc(gtk_widget_get_colormap(widget), &color);
   gtk_sheet_range_set_background(current, current->range, &color);

   tmp_gc=gdk_gc_new(window->window);
   gdk_gc_set_foreground(tmp_gc,&color);
   gdk_draw_rectangle(GTK_PIXMAP(bg_pixmap)->pixmap,
		      tmp_gc, TRUE, 5,21,18,4);
   gtk_widget_queue_draw(bg_pixmap); gdk_gc_unref(tmp_gc);

}

void 
do_hide_row_titles(GtkWidget *widget) 
{
  GtkSheet *current;
  gint cur_page;

  cur_page=gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook));
  current=GTK_SHEET(sheets[cur_page]);

  gtk_sheet_hide_row_titles(current);
}

void 
do_hide_column_titles(GtkWidget *widget) 
{
  GtkSheet *current; 
  gint cur_page;

  cur_page=gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook));
  current=GTK_SHEET(sheets[cur_page]);

  gtk_sheet_hide_column_titles(current);
}

void 
do_show_row_titles(GtkWidget *widget) 
{
  GtkSheet *current; 
  gint cur_page;

  cur_page=gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook));
  current=GTK_SHEET(sheets[cur_page]);

  gtk_sheet_show_row_titles(current);
}

void 
do_show_column_titles(GtkWidget *widget) 
{
  GtkSheet *current; 
  gint cur_page;

  cur_page=gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook));
  current=GTK_SHEET(sheets[cur_page]);

  gtk_sheet_show_column_titles(current);
}


int main(int argc, char *argv[]) 
{
  GtkWidget *label; 
  GtkRequisition request; 
  GtkWidget *hide_row_titles;
  GtkWidget *hide_column_titles; 
  GtkWidget *show_row_titles; 
  GtkWidget *show_column_titles;
  gint i;

  char *title[]= {"Example 1",
		  "Example 2", 
                  "Example 3"};
  char *folder[]= {"Folder 1",
		   "Folder 2", 
                   "Folder 3"};

  gtk_init(&argc, &argv);

  window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(window), "GtkSheet Demo");
  gtk_widget_set_usize(GTK_WIDGET(window), 800, 500);

  gtk_signal_connect (GTK_OBJECT (window), "destroy",
		      GTK_SIGNAL_FUNC (quit), NULL);

  main_vbox=gtk_vbox_new(FALSE,1);
  gtk_container_border_width(GTK_CONTAINER(main_vbox),0); 
  gtk_container_add(GTK_CONTAINER(window), main_vbox);
  gtk_widget_show(main_vbox);

  show_hide_box = gtk_hbox_new(FALSE, 1); 
  hide_row_titles = gtk_button_new_with_label("Hide Row Titles"); 
  hide_column_titles = gtk_button_new_with_label("Hide Column Titles"); 
  show_row_titles = gtk_button_new_with_label("Show Row Titles"); 
  show_column_titles = gtk_button_new_with_label("Show Column Titles");

  gtk_box_pack_start(GTK_BOX(show_hide_box), hide_row_titles, TRUE, TRUE, 0); 
  gtk_box_pack_start(GTK_BOX(show_hide_box), hide_column_titles, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(show_hide_box), show_row_titles, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(show_hide_box), show_column_titles, TRUE, TRUE, 0);

  gtk_widget_show(hide_row_titles); 
  gtk_widget_show(hide_column_titles);
  gtk_widget_show(show_row_titles); 
  gtk_widget_show(show_column_titles);

  gtk_signal_connect(GTK_OBJECT(hide_row_titles), "clicked",
		     (GtkSignalFunc) do_hide_row_titles, NULL);

  gtk_signal_connect(GTK_OBJECT(hide_column_titles), "clicked",
		     (GtkSignalFunc) do_hide_column_titles, NULL);

  gtk_signal_connect(GTK_OBJECT(show_row_titles), "clicked",
		     (GtkSignalFunc) do_show_row_titles, NULL);

  gtk_signal_connect(GTK_OBJECT(show_column_titles), "clicked",
		     (GtkSignalFunc) do_show_column_titles, NULL);


  gtk_box_pack_start(GTK_BOX(main_vbox), show_hide_box, FALSE, TRUE, 0);
  gtk_widget_show(show_hide_box);

  toolbar=gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_CHILD_WIDGET);

  left_button = gtk_toggle_button_new();
  gtk_toolbar_append_widget(GTK_TOOLBAR(toolbar),
			    left_button, "justify left", "justify left");
  gtk_widget_show(left_button);
  gtk_signal_connect(GTK_OBJECT(left_button),"released",
		     (GtkSignalFunc) justify_left, NULL);

  center_button = gtk_toggle_button_new();
  gtk_toolbar_append_widget(GTK_TOOLBAR(toolbar),
			    center_button, "justify center", "justify center");
  gtk_widget_show(center_button);
  gtk_signal_connect(GTK_OBJECT(center_button), "released",
		     (GtkSignalFunc) justify_center, NULL);

  right_button = gtk_toggle_button_new();
  gtk_toolbar_append_widget(GTK_TOOLBAR(toolbar),
			    right_button, "justify right", "justify right");
  gtk_widget_show(right_button);
  gtk_signal_connect(GTK_OBJECT(right_button), "released",
		     (GtkSignalFunc) justify_right, NULL);

  gtk_toolbar_append_space(GTK_TOOLBAR(toolbar));

  bordercombo=gtk_border_combo_new();
  gtk_toolbar_append_widget(GTK_TOOLBAR(toolbar),
			    bordercombo, "border", "border");
  gtk_widget_show(bordercombo);
  gtk_widget_set_usize(GTK_COMBO_BOX(bordercombo)->button, 32, 32);
  gtk_signal_connect(GTK_OBJECT(bordercombo),
		     "changed", (GtkSignalFunc)change_border, NULL);

  gtk_toolbar_append_space(GTK_TOOLBAR(toolbar));

  fgcolorcombo=gtk_color_combo_new();
  gtk_toolbar_append_widget(GTK_TOOLBAR(toolbar),
			    fgcolorcombo, "font color", "font color");
  gtk_widget_show(fgcolorcombo);
  gtk_signal_connect(GTK_OBJECT(fgcolorcombo),
		     "changed", (GtkSignalFunc)change_fg, NULL);

  gtk_toolbar_append_space(GTK_TOOLBAR(toolbar));

  bgcolorcombo=gtk_color_combo_new();
  gtk_toolbar_append_widget(GTK_TOOLBAR(toolbar),
			    bgcolorcombo, "background color", "background
			    color");
  gtk_widget_show(bgcolorcombo);
  gtk_signal_connect(GTK_OBJECT(bgcolorcombo),
		     "changed", (GtkSignalFunc)change_bg, NULL);

  gtk_toolbar_append_space(GTK_TOOLBAR(toolbar));

  gtk_box_pack_start(GTK_BOX(main_vbox), toolbar, FALSE, TRUE, 0);
  gtk_widget_show(toolbar);

  status_box=gtk_hbox_new(FALSE, 1);
  gtk_container_border_width(GTK_CONTAINER(status_box),0);
  gtk_box_pack_start(GTK_BOX(main_vbox), status_box, FALSE, TRUE, 0);
  gtk_widget_show(status_box);

  location=gtk_label_new(""); gtk_widget_size_request(location,
  &request); gtk_widget_set_usize(location, 160, request.height);
  gtk_box_pack_start(GTK_BOX(status_box), location, FALSE, TRUE, 0);
  gtk_widget_show(location);

  entry=gtk_entry_new(); gtk_box_pack_start(GTK_BOX(status_box), entry,
  TRUE, TRUE, 0); gtk_widget_show(entry);

  notebook=gtk_notebook_new();
  gtk_notebook_set_tab_pos(GTK_NOTEBOOK(notebook), GTK_POS_BOTTOM);
  gtk_box_pack_start(GTK_BOX(main_vbox), notebook, TRUE, TRUE, 0);
  gtk_widget_show(notebook);

  for(i=0; i<3; i++){
   sheets=(GtkWidget **)realloc(sheets, sizeof(GtkWidget *));
   sheets[i]=gtk_sheet_new(1000,26,title[i]);

   gtk_widget_show_all(sheets[i]); label=gtk_label_new(folder[i]);
   gtk_notebook_append_page(GTK_NOTEBOOK(notebook), GTK_WIDGET(sheets[i]),
   label);

   gtk_signal_connect(GTK_OBJECT(gtk_sheet_get_entry(GTK_SHEET(sheets[i]))),
		      "changed", (GtkSignalFunc)show_entry, NULL);

   gtk_signal_connect(GTK_OBJECT(sheets[i]),
		      "activate_cell", (GtkSignalFunc)activate_sheet_cell,
		      NULL);

  }

  gtk_signal_connect(GTK_OBJECT(entry),
		      "changed", (GtkSignalFunc)show_sheet_entry, NULL);

  gtk_signal_connect(GTK_OBJECT(entry),
		      "activate", (GtkSignalFunc)activate_sheet_entry,
		      NULL);


  build_example1(sheets[0]); 
  build_example2(sheets[1]);
  build_example3(sheets[2]);

  gtk_signal_connect(GTK_OBJECT(gtk_sheet_get_entry(GTK_SHEET(sheets[2]))),
		     "changed", (GtkSignalFunc)show_entry, NULL);

  gtk_widget_show(window);

  pixmap=gdk_pixmap_create_from_xpm(window->window, &mask,
				    &window->style->bg[GTK_STATE_NORMAL],
				    "left.xpm");
  tpixmap = gtk_pixmap_new(pixmap, mask);
  gtk_container_add(GTK_CONTAINER(left_button), tpixmap);
  gtk_widget_show(tpixmap);

  pixmap=gdk_pixmap_create_from_xpm(window->window, &mask,
				    &window->style->bg[GTK_STATE_NORMAL],
				    "center.xpm");
  tpixmap = gtk_pixmap_new(pixmap, mask);
  gtk_container_add(GTK_CONTAINER(center_button), tpixmap);
  gtk_widget_show(tpixmap);

  pixmap=gdk_pixmap_create_from_xpm(window->window, &mask,
				    &window->style->bg[GTK_STATE_NORMAL],
				    "right.xpm");
  tpixmap = gtk_pixmap_new(pixmap, mask);
  gtk_container_add(GTK_CONTAINER(right_button), tpixmap);
  gtk_widget_show(tpixmap);

  pixmap=gdk_pixmap_create_from_xpm(window->window, &mask,
				    &window->style->bg[GTK_STATE_NORMAL],
				    "paint.xpm");

  bg_pixmap=gtk_pixmap_new(pixmap, mask);
  gtk_container_add(GTK_CONTAINER(GTK_COMBO_BOX(bgcolorcombo)->button),
		    bg_pixmap);

  gtk_widget_show(bg_pixmap);

  pixmap=gdk_pixmap_create_from_xpm(window->window, &mask,
				    &window->style->bg[GTK_STATE_NORMAL],
				    "font.xpm");


  fg_pixmap=gtk_pixmap_new(pixmap, mask);
  gtk_container_add(GTK_CONTAINER(GTK_COMBO_BOX(fgcolorcombo)->button),
		    fg_pixmap);

  gtk_widget_show(fg_pixmap);

  gtk_main();

  return(0);
}


