/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-1997 Peter Mattis and Spencer Kimball
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef __GIMP_FEATURES_H__
#define __GIMP_FEATURES_H__


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define GIMP_MAJOR_VERSION				(1)
#define GIMP_MINOR_VERSION				(1)
#define GIMP_MICRO_VERSION				(23)
#define GIMP_VERSION					"1.1.23"
#define GIMP_CHECK_VERSION(major, minor, micro)	\
    (GIMP_MAJOR_VERSION > (major) || \
     (GIMP_MAJOR_VERSION == (major) && GIMP_MINOR_VERSION > (minor)) || \
     (GIMP_MAJOR_VERSION == (major) && GIMP_MINOR_VERSION == (minor) && \
      GIMP_MICRO_VERSION >= (micro)))

#define GIMP_HAVE_PROCEDURAL_DB_GET_DATA_SIZE		1-1-0
#define GIMP_HAVE_PARASITES				1-1-0
#define GIMP_HAVE_RESOLUTION_INFO			1-1-0
#define GIMP_HAVE_DESTROY_PARAMDEFS			1-1-0

#define GIMP_HAVE_FEATURES_1_1_5			1-1-5

#define GIMP_HAVE_DEFAULT_DISPLAY			1-1-5
#define GIMP_HAVE_PIXEL_RGNS_REGISTER2			1-1-5

#define GIMP_HAVE_NEW_ENUMS				1-1-10

#define GIMP_HAVE_EXPORT                                1-1-10

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GIMP_FEATURES_H__ */
