---
myst:
  html_meta:
    keywords: LaTeX, langages de programmation, mise en forme de code, coloration syntaxique, formater un programme,formater du code, verbatim, insérer du code-source, listing informatique, listings, listing, tcolorbox"
---
# Comment présenter du code informatique avec le package <ctanpkg:tcolorbox> ?

<ctanpkg:tcolorbox> est un package très puissant dédié à l'encadrement du texte. Il
dispose notamment de deux bibliothèques (« *library* » dans la documentation) utiles pour
présenter du code informatique. Ces deux bibliothèques `listings` et `minted` utilisent
les packages des mêmes noms et permettent de faire des mises en page élaborées simplement.

## Bibliothèque `listings`
:::{admonition} Info
:class: tip
Pour bien comprendre cette partie, il est conseillé de lire
[](/4_domaines_specialises/sciences/informatique/inserer_du_code_source_informatique_listings).
:::
:::{note}
- Cette bibliothèque est conseillée si on compile en `pdflatex`
- L’utilisation de cette bibliothèque charge automatiquement <ctanpkg:listings>
:::

<ctanpkg:tcolorbox> perment de définir (généralement dans le préambule) une boîte de type
`tcblisting` utilisant <ctanpkg:listings> pour afficher le code. Le style de cette boîte,
les paramètres optionnels de <ctanpkg:listings> et le nom de la boîte sont alors définis
pour l’ensemble du document.

(listings-premiere-box)=
### Une première boîte

Dans l’exemple ci-dessous, on reconnaît les options de <ctanpkg:listings>.

:::{attention}
Le réglage pour les accents ne semble pas pouvoir être indiqué dans la définition de la
boîte. Il faut le faire via `\lstset{}`.
:::

```
\documentclass[french]{article}
\usepackage[T1]{fontenc}
\usepackage{xcolor}
\usepackage{babel}
\usepackage{tcolorbox}
\tcbuselibrary{listings}
% Création de ma boîte
\newtcblisting{boxPython}{
  colback=black!5!white, 
  title= Extrait de code Python,
  listing only,
  listing options={
	language=python,
	keywordstyle = \color{green!60!black},
	keywordstyle = {[2]\color{orange}},
	commentstyle = \color{gray}\itshape,
	stringstyle  = \color{blue},
	showstringspaces=false,
	numbers = left,
	numberstyle = \tiny,
	stepnumber=1,
	numbersep = 25pt
  },
}
% réglage de listings pour les accents
\lstset{
	literate=
		{é}{{\'e}}1
		{è}{{\`{e}}}1
		{ê}{{\^{e}}}1
		{ë}{{\¨{e}}}1
		{É}{{\'{E}}}1
		{Ê}{{\^{E}}}1
		{û}{{\^{u}}}1
		{ù}{{\`{u}}}1
		{â}{{\^{a}}}1
		{à}{{\`{a}}}1
		{Â}{{\^{A}}}1
		{ç}{{\c{c}}}1
		{Ç}{{\c{C}}}1
		{ô}{{\^{o}}}1
		{Ô}{{\^{O}}}1
		{î}{{\^{i}}}1
		{Î}{{\^{I}}}1,
}
\begin{document}
\begin{boxPython}
# Une première boucle
for i in range(0,5): 
    print(i)
# Une autre boucle 
while i != "4": 
    print("Et on est reparti pour un 
	tour de plus !!!")
\end{boxPython}
\end{document}
```

### Une boîte un peu plus élaborée

:::{admonition} Info
:class: tip
- Pour la boîte ci-dessous, on utilise un package supplémentaire,  <ctanpkg:fontawesome5> ,
pour le symbole de `Python`.
- On utilise également la bibliothèque `skins` qui permet de passer l’option `enhanced`
à la boîte et ainsi de pouvoir régler l’aspect du titre.
:::

```
\documentclass[french]{article}
\usepackage[T1]{fontenc}
\usepackage{xcolor}
\usepackage{fontawesome5}
\usepackage{babel}
\usepackage{tcolorbox}
\tcbuselibrary{skins, listings}
\newtcblisting{boxPython}{
  enhanced, 
  colback=black!3!white, 
  toprule=1pt, 
  bottomrule=1pt,
  leftrule=0pt, 
  rightrule=0pt, 
  arc=0mm, 
  attach boxed title to top left={yshift=-9pt, xshift=4pt},
  title =  \textcolor{blue!80!black}{\faPython}, 
  coltitle= black, 
  boxed title style={colback=white},
  listing only,
  listing options={
	language=python,
	breaklines,
	keywordstyle = \color{green!60!black},
	keywordstyle = {[2]\color{orange}},
	commentstyle = \color{gray}\itshape,
	stringstyle  = \color{blue},
	showstringspaces=false,
	numbers = left,
	numberstyle = \tiny,
	stepnumber=1,
	numbersep = 20pt
  },
}
% pour les accents
\lstset{
	literate=
		{é}{{\'e}}1
		{è}{{\`{e}}}1
		{ê}{{\^{e}}}1
		{ë}{{\¨{e}}}1
		{É}{{\'{E}}}1
		{Ê}{{\^{E}}}1
		{û}{{\^{u}}}1
		{ù}{{\`{u}}}1
		{â}{{\^{a}}}1
		{à}{{\`{a}}}1
		{Â}{{\^{A}}}1
		{ç}{{\c{c}}}1
		{Ç}{{\c{C}}}1
		{ô}{{\^{o}}}1
		{Ô}{{\^{O}}}1
		{î}{{\^{i}}}1
		{Î}{{\^{I}}}1,
}
\begin{document}
\begin{boxPython}
# Une première boucle
for i in range(0,5): 
    print(i)
# Une autre boucle 
while i != 4:
    print("Et on est reparti pour un tour de plus !!!")
\end{boxPython}
\end{document}
```

:::{tip} 
On remarque que lorsque le retour à la ligne se fait manuellement, comme dans
[](listings-premiere-box), il compte pour une ligne supplémentaire, ne correspondant pas
nécessairemente au code voulu.

Pour pallier ce problème, on a passé `breaklines` en paramètre optionnel de la boîte.
:::

### Bibliothèque minted
On procède de manière très similaire à ce qui à été vu ci-dessus, mais on peut constater
que moins d’options sont nécessaires.

:::{admonition} Info
:class: tip
Pour bien comprendre cette partie, il est conseillé de lire
[](/4_domaines_specialises/sciences/informatique/inserer_du_code_source_informatique_minted).
:::

```{noedit}
\documentclass[french]{article}
\usepackage[T1]{fontenc}
\usepackage{xcolor}
\usepackage{fontawesome5}
\usepackage{babel}
\usepackage{tcolorbox}
\tcbuselibrary{minted, skins}
% Création de ma box
\newtcblisting{boxPython}{
  enhanced, 
  colback=black!3!white, 
  toprule=1pt, 
  bottomrule=1pt,
  leftrule=0pt, 
  rightrule=0pt, 
  arc=0mm, 
  attach boxed title to top left={yshift=-9pt, xshift=4pt},
  title =  \textcolor{blue!80!black}{\faPython}, 
  coltitle= black, 
  boxed title style={colback=white},
  listing engine=minted,
  listing only,
  minted language=python,
  minted options={breaklines, autogobble, linenos, numbersep=8mm},
}
\begin{document}
\begin{boxPython}
# Une première boucle
for i in range(0,5): 
    print(i)
# Une autre boucle 
while i != "4": 
print("Encore ? Eh bien oui, on est reparti pour un  tour de plus !!!")
\end{boxPython}
\end{document}
```

La compilation du code donne :

![](/_static/images/minted_tcolorbox.png)
