/* -*- c-basic-offset: 4 indent-tabs-mode: nil -*- vi:set ts=8 sts=4 sw=4: */

/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.
    Copyright 2000-2025 the Rosegarden development team.

    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef RG_CONTROL_MOUSE_EVENT_H
#define RG_CONTROL_MOUSE_EVENT_H

#include "ControlItem.h"

#include <Qt>


namespace Rosegarden
{


class ControlMouseEvent
{
public:
    ControlItemVector itemList; // list of items under the cursor, if any

//    timeT time; // un-snapped and un-cropped
//    float value;
    float x;
    float y;

    float snappedXLeft;
    float snappedXRight;

    Qt::KeyboardModifiers modifiers;
    Qt::MouseButtons buttons;

    ControlMouseEvent() :
        itemList(),
        x(0), y(0), snappedXLeft(0), snappedXRight(0),
        modifiers(Qt::KeyboardModifiers()),
        buttons(Qt::MouseButtons()) { }

        explicit ControlMouseEvent(const ControlMouseEvent *e) :
        itemList(e->itemList),
        x(e->x), y(e->y),
        snappedXLeft(e->snappedXLeft), snappedXRight(e->snappedXRight),
        modifiers(e->modifiers), buttons(e->buttons) { }
};


}

#endif
