# Copyright (c) 2011, Willow Garage, Inc.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#     * Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer.
#     * Redistributions in binary form must reproduce the above copyright
#       notice, this list of conditions and the following disclaimer in the
#       documentation and/or other materials provided with the distribution.
#     * Neither the name of the Willow Garage, Inc. nor the names of its
#       contributors may be used to endorse or promote products derived from
#       this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.

try:
    from unittest.mock import Mock
except ImportError:
    from mock import Mock


def test_RosdepLoader():
    # tripwire tests
    from rosdep2.loader import RosdepLoader
    loader = RosdepLoader()
    try:
        loader.load_view('foo', Mock())
        assert False, 'should have raised NotImplemented'
    except NotImplementedError:
        pass
    try:
        loader.get_loadable_resources()
        assert False, 'should have raised NotImplementedError'
    except NotImplementedError:
        pass
    try:
        loader.get_loadable_views()
        assert False, 'should have raised NotImplementedError'
    except NotImplementedError:
        pass
    try:
        loader.get_view_key('foo')
        assert False, 'should have raised NotImplementedError'
    except NotImplementedError:
        pass
    try:
        loader.get_rosdeps('foo', implicit=False)
        assert False, 'should have raised NotImplementedError'
    except NotImplementedError:
        pass
