% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count.R
\name{str_count}
\alias{str_count}
\title{Count number of matches}
\usage{
str_count(string, pattern = "")
}
\arguments{
\item{string}{Input vector. Either a character vector, or something
coercible to one.}

\item{pattern}{Pattern to look for.

The default interpretation is a regular expression, as described in
\code{vignette("regular-expressions")}. Use \code{\link[=regex]{regex()}} for finer control of the
matching behaviour.

Match a fixed string (i.e. by comparing only bytes), using
\code{\link[=fixed]{fixed()}}. This is fast, but approximate. Generally,
for matching human text, you'll want \code{\link[=coll]{coll()}} which
respects character matching rules for the specified locale.

Match character, word, line and sentence boundaries with
\code{\link[=boundary]{boundary()}}. The empty string, \verb{""``, is equivalent to }boundary("character")`.}
}
\value{
An integer vector the same length as \code{string}/\code{pattern}.
}
\description{
Counts the number of times \code{pattern} is found within each element
of \code{string.}
}
\examples{
fruit <- c("apple", "banana", "pear", "pineapple")
str_count(fruit, "a")
str_count(fruit, "p")
str_count(fruit, "e")
str_count(fruit, c("a", "b", "p", "p"))

str_count(c("a.", "...", ".a.a"), ".")
str_count(c("a.", "...", ".a.a"), fixed("."))
}
\seealso{
\code{\link[stringi:stri_count]{stringi::stri_count()}} which this function wraps.

\code{\link[=str_locate]{str_locate()}}/\code{\link[=str_locate_all]{str_locate_all()}} to locate position
of matches
}
