% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TargetingModels.R
\name{createTargetingMatrix}
\alias{createTargetingMatrix}
\title{Calculates a targeting rate matrix}
\usage{
createTargetingMatrix(substitutionModel, mutabilityModel)
}
\arguments{
\item{substitutionModel}{matrix of 5-mers substitution rates built by 
\link{createSubstitutionMatrix} or 
\link{extendSubstitutionMatrix}.}

\item{mutabilityModel}{vector of 5-mers mutability rates built by 
\link{createMutabilityMatrix} or 
\link{extendMutabilityMatrix}.}
}
\value{
A \code{TargetingMatrix} with the same dimensions as the input \code{substitutionModel} 
          containing normalized targeting probabilities for each 5-mer motif with 
          row names defining the center nucleotide and column names defining the 
          5-mer nucleotide sequence. 
          
          If the input \code{mutabilityModel} is of class \code{MutabilityModel}, then the output 
          \code{TargetingMatrix} will carry over the input \code{numMutS} and \code{numMutR} slots.
}
\description{
\code{createTargetingMatrix} calculates the targeting model matrix as the
combined probability of mutability and substitution.
}
\details{
Targeting rates are calculated by multiplying the normalized mutability rate by the 
normalized substitution rates for each individual 5-mer.
}
\examples{
\donttest{
# Subset example data to one isotype and sample as a demo
data(ExampleDb, package="alakazam")
db <- subset(ExampleDb, c_call == "IGHA" & sample_id == "-1h")

# Create 4x1024 models using only silent mutations
sub_model <- createSubstitutionMatrix(db, model="s", sequenceColumn="sequence_alignment",
                                      germlineColumn="germline_alignment_d_mask",
                                      vCallColumn="v_call")
mut_model <- createMutabilityMatrix(db, sub_model, model="s",
                                    sequenceColumn="sequence_alignment",
                                    germlineColumn="germline_alignment_d_mask",
                                    vCallColumn="v_call")

# Extend substitution and mutability to including Ns (5x3125 model)
sub_model <- extendSubstitutionMatrix(sub_model)
mut_model <- extendMutabilityMatrix(mut_model)

# Create targeting model from substitution and mutability
tar_model <- createTargetingMatrix(sub_model, mut_model)
}

}
\references{
\enumerate{
  \item  Yaari G, et al. Models of somatic hypermutation targeting and substitution based
           on synonymous mutations from high-throughput immunoglobulin sequencing data.
           Front Immunol. 2013 4(November):358.
 }
}
\seealso{
\link{createSubstitutionMatrix}, \link{extendSubstitutionMatrix}, 
          \link{createMutabilityMatrix}, \link{extendMutabilityMatrix}, 
          \link{TargetingMatrix}, \link{createTargetingModel}
}
